/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.IntegrationTest;
import com.google.cloud.spanner.IntegrationTestWithClosedSessionsEnv;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionNotFoundException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import com.google.common.truth.Truth;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={IntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITClosedSessionTest {
    private static final int RUNS_PER_TEST_CASE = 2;
    @ClassRule
    public static IntegrationTestWithClosedSessionsEnv env = new IntegrationTestWithClosedSessionsEnv();
    private static Database db;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static IntegrationTestWithClosedSessionsEnv.DatabaseClientWithClosedSessionImpl client;

    @BeforeClass
    public static void setUpDatabase() {
        db = env.getTestHelper().createTestDatabase(new String[0]);
        client = (IntegrationTestWithClosedSessionsEnv.DatabaseClientWithClosedSessionImpl)env.getTestHelper().getDatabaseClient(db);
    }

    @Before
    public void setup() {
        client.setAllowSessionReplacing(true);
    }

    @Test
    public void testSingleUse() {
        client.invalidateNextSession();
        for (int run = 0; run < 2; ++run) {
            try (ResultSet rs = Statement.of((String)"SELECT 1").executeQuery(client.singleUse(), new Options.QueryOption[0]);){
                Truth.assertThat((Boolean)rs.next()).isTrue();
                Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
                Truth.assertThat((Boolean)rs.next()).isFalse();
                continue;
            }
        }
    }

    @Test
    public void testSingleUseNoRecreation() {
        client.setAllowSessionReplacing(false);
        client.invalidateNextSession();
        this.expectedException.expect(SessionNotFoundException.class);
        try (ResultSet rs = Statement.of((String)"SELECT 1").executeQuery(client.singleUse(), new Options.QueryOption[0]);){
            rs.next();
        }
    }

    @Test
    public void testSingleUseBound() {
        client.invalidateNextSession();
        for (int run = 0; run < 2; ++run) {
            try (ResultSet rs = Statement.of((String)"SELECT 1").executeQuery(client.singleUse(TimestampBound.ofExactStaleness((long)10L, (TimeUnit)TimeUnit.SECONDS)), new Options.QueryOption[0]);){
                Truth.assertThat((Boolean)rs.next()).isTrue();
                Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
                Truth.assertThat((Boolean)rs.next()).isFalse();
                continue;
            }
        }
    }

    @Test
    public void testSingleUseReadOnlyTransaction() {
        client.invalidateNextSession();
        for (int run = 0; run < 2; ++run) {
            try (ReadOnlyTransaction txn = client.singleUseReadOnlyTransaction();){
                try (ResultSet rs = txn.executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);){
                    Truth.assertThat((Boolean)rs.next()).isTrue();
                    Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
                    Truth.assertThat((Boolean)rs.next()).isFalse();
                }
                Truth.assertThat((Comparable)txn.getReadTimestamp()).isNotNull();
                continue;
            }
        }
    }

    @Test
    public void testSingleUseReadOnlyTransactionBound() {
        client.invalidateNextSession();
        for (int run = 0; run < 2; ++run) {
            try (ReadOnlyTransaction txn = client.singleUseReadOnlyTransaction(TimestampBound.ofMaxStaleness((long)10L, (TimeUnit)TimeUnit.SECONDS));){
                try (ResultSet rs = txn.executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);){
                    Truth.assertThat((Boolean)rs.next()).isTrue();
                    Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
                    Truth.assertThat((Boolean)rs.next()).isFalse();
                }
                Truth.assertThat((Comparable)txn.getReadTimestamp()).isNotNull();
                continue;
            }
        }
    }

    @Test
    public void testReadOnlyTransaction() {
        client.invalidateNextSession();
        for (int run = 0; run < 2; ++run) {
            try (ReadOnlyTransaction txn = client.readOnlyTransaction();){
                for (int i = 0; i < 2; ++i) {
                    try (ResultSet rs = txn.executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);){
                        Truth.assertThat((Boolean)rs.next()).isTrue();
                        Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
                        Truth.assertThat((Boolean)rs.next()).isFalse();
                        continue;
                    }
                }
                Truth.assertThat((Comparable)txn.getReadTimestamp()).isNotNull();
                continue;
            }
        }
    }

    @Test
    public void testReadOnlyTransactionNoRecreation() {
        client.setAllowSessionReplacing(false);
        client.invalidateNextSession();
        this.expectedException.expect(SessionNotFoundException.class);
        try (ReadOnlyTransaction txn = client.readOnlyTransaction();
             ResultSet rs = txn.executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);){
            rs.next();
        }
    }

    @Test
    public void testReadOnlyTransactionBound() {
        client.invalidateNextSession();
        for (int run = 0; run < 2; ++run) {
            try (ReadOnlyTransaction txn = client.readOnlyTransaction(TimestampBound.ofExactStaleness((long)10L, (TimeUnit)TimeUnit.SECONDS));){
                for (int i = 0; i < 2; ++i) {
                    try (ResultSet rs = txn.executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);){
                        Truth.assertThat((Boolean)rs.next()).isTrue();
                        Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
                        Truth.assertThat((Boolean)rs.next()).isFalse();
                        continue;
                    }
                }
                Truth.assertThat((Comparable)txn.getReadTimestamp()).isNotNull();
                continue;
            }
        }
    }

    @Test
    public void testReadWriteTransaction() {
        client.invalidateNextSession();
        for (int run = 0; run < 2; ++run) {
            TransactionRunner txn = client.readWriteTransaction();
            txn.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Void>(){

                public Void run(TransactionContext transaction) throws Exception {
                    for (int i = 0; i < 2; ++i) {
                        try (ResultSet rs = transaction.executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);){
                            Truth.assertThat((Boolean)rs.next()).isTrue();
                            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
                            Truth.assertThat((Boolean)rs.next()).isFalse();
                            continue;
                        }
                    }
                    return null;
                }
            });
        }
    }

    @Test
    public void testReadWriteTransactionNoRecreation() {
        client.setAllowSessionReplacing(false);
        client.invalidateNextSession();
        this.expectedException.expect(SessionNotFoundException.class);
        TransactionRunner txn = client.readWriteTransaction();
        txn.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Void>(){

            public Void run(TransactionContext transaction) throws Exception {
                try (ResultSet rs = transaction.executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);){
                    rs.next();
                }
                return null;
            }
        });
    }

    @Test
    public void testTransactionManager() throws InterruptedException {
        client.invalidateNextSession();
        block20: for (int run = 0; run < 2; ++run) {
            try (TransactionManager manager = client.transactionManager();){
                TransactionContext txn = manager.begin();
                while (true) {
                    for (int i = 0; i < 2; ++i) {
                        try (ResultSet rs = txn.executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);){
                            Truth.assertThat((Boolean)rs.next()).isTrue();
                            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
                            Truth.assertThat((Boolean)rs.next()).isFalse();
                            continue;
                        }
                    }
                    try {
                        manager.commit();
                        continue block20;
                    }
                    catch (AbortedException e) {
                        Thread.sleep(e.getRetryDelayInMillis() / 1000L);
                        txn = manager.resetForRetry();
                        continue;
                    }
                    break;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testTransactionManagerNoRecreation() throws InterruptedException {
        ITClosedSessionTest.client.setAllowSessionReplacing(false);
        ITClosedSessionTest.client.invalidateNextSession();
        this.expectedException.expect(SessionNotFoundException.class);
        manager = ITClosedSessionTest.client.transactionManager();
        var2_2 = null;
        try {
            try {
                txn = manager.begin();
                while (true) lbl-1000:
                // 3 sources

                {
                    rs = txn.executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);
                    var5_6 = null;
                    try {
                        rs.next();
                    }
                    catch (Throwable var6_8) {
                        var5_6 = var6_8;
                        throw var6_8;
                    }
                    finally {
                        if (rs == null) continue;
                        if (var5_6 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable var6_7) {
                                var5_6.addSuppressed(var6_7);
                            }
                            continue;
                        }
                        rs.close();
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable var3_4) {
                var2_2 = var3_4;
                throw var3_4;
            }
            ** GOTO lbl-1000
        }
        catch (Throwable var9_11) {
            if (manager != null) {
                if (var2_2 != null) {
                    try {
                        manager.close();
                    }
                    catch (Throwable var10_12) {
                        var2_2.addSuppressed(var10_12);
                    }
                } else {
                    manager.close();
                }
            }
            throw var9_11;
        }
    }
}

