/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.InstanceAdminClient;
import com.google.cloud.spanner.IntegrationTest;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={IntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITSpannerOptionsTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static Database db;
    private static final int NUMBER_OF_TEST_RUNS = 2;
    private static final int DEFAULT_NUM_CHANNELS = 4;
    private static final int NUM_THREADS_PER_CHANNEL = 4;
    private static final String SPANNER_THREAD_NAME = "Cloud-Spanner-TransportChannel";
    private static final String THREAD_PATTERN = "%s-[0-9]+";

    @Before
    public void setUp() throws Exception {
        db = env.getTestHelper().createTestDatabase(new String[0]);
    }

    @After
    public void tearDown() throws Exception {
        db.drop();
    }

    @Test
    public void testCloseAllThreadsWhenClosingSpanner() throws InterruptedException {
        int baseThreadCount = this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME);
        for (int i = 0; i < 2; ++i) {
            int i2;
            Assert.assertThat((Object)this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)baseThreadCount)));
            SpannerOptions options = env.getTestHelper().getOptions().toBuilder().build();
            Spanner spanner = (Spanner)options.getService();
            DatabaseClient client = spanner.getDatabaseClient(db.getId());
            ArrayList<ResultSet> resultSets = new ArrayList<ResultSet>();
            for (i2 = 0; i2 < options.getSessionPoolOptions().getMaxSessions(); ++i2) {
                ResultSet rs = client.singleUse().executeQuery(Statement.of((String)"SELECT 1 AS COL1 UNION ALL SELECT 2 AS COL2"), new Options.QueryOption[0]);
                rs.next();
                resultSets.add(rs);
                if (this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME) == 16 + baseThreadCount) break;
            }
            for (ResultSet rs : resultSets) {
                rs.close();
            }
            Assert.assertThat((Object)this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)(16 + baseThreadCount))));
            for (i2 = 0; i2 < 8; ++i2) {
                InstanceAdminClient instanceAdminClient = spanner.getInstanceAdminClient();
                instanceAdminClient.listInstances(new Options.ListOption[0]);
            }
            Assert.assertThat((Object)this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)(32 + baseThreadCount))));
            for (i2 = 0; i2 < 8; ++i2) {
                DatabaseAdminClient databaseAdminClient = spanner.getDatabaseAdminClient();
                databaseAdminClient.listDatabases(db.getId().getInstanceId().getInstance(), new Options.ListOption[0]);
            }
            Assert.assertThat((Object)this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)(48 + baseThreadCount))));
            spanner.close();
            Thread.sleep(200L);
            Assert.assertThat((Object)this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)baseThreadCount)));
        }
    }

    @Test
    public void testMultipleSpannersFromSameSpannerOptions() throws InterruptedException {
        int baseThreadCount = this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME);
        SpannerOptions options = env.getTestHelper().getOptions().toBuilder().build();
        try (Spanner spanner1 = (Spanner)options.getService();){
            Spanner spanner2 = (Spanner)options.getService();
            Assert.assertThat((Object)(spanner1 == spanner2 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
            DatabaseClient client1 = spanner1.getDatabaseClient(db.getId());
            DatabaseClient client2 = spanner2.getDatabaseClient(db.getId());
            Assert.assertThat((Object)(client1 == client2 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
            try (ResultSet rs1 = client1.singleUse().executeQuery(Statement.of((String)"SELECT 1 AS COL1 UNION ALL SELECT 2 AS COL2"), new Options.QueryOption[0]);
                 ResultSet rs2 = client2.singleUse().executeQuery(Statement.of((String)"SELECT 1 AS COL1 UNION ALL SELECT 2 AS COL2"), new Options.QueryOption[0]);){
                while (rs1.next() && rs2.next()) {
                }
            }
        }
        Thread.sleep(200L);
        Assert.assertThat((Object)this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)baseThreadCount)));
    }

    private int getNumberOfThreadsWithName(String serviceName) {
        Pattern pattern = Pattern.compile(String.format(THREAD_PATTERN, serviceName));
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        while (group.getParent() != null) {
            group = group.getParent();
        }
        Thread[] threads = new Thread[200];
        int numberOfThreads = group.enumerate(threads);
        int res = 0;
        for (int i = 0; i < numberOfThreads; ++i) {
            if (!pattern.matcher(threads[i].getName()).matches()) continue;
            ++res;
        }
        return res;
    }
}

