/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.BatchReadOnlyTransaction;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.IntegrationTest;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.PartitionOptions;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunner;
import com.google.common.collect.Sets;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={IntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITTransactionTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static Database db;
    private static DatabaseClient client;
    private static int seq;

    @BeforeClass
    public static void setUpDatabase() {
        db = env.getTestHelper().createTestDatabase(new String[]{"CREATE TABLE T (  K    STRING(MAX) NOT NULL,  V    INT64,) PRIMARY KEY (K)"});
        client = env.getTestHelper().getDatabaseClient(db);
    }

    private static String uniqueKey() {
        return "k" + seq++;
    }

    private void doBasicsTest(final ReadStrategy strategy) throws InterruptedException {
        final String key = ITTransactionTest.uniqueKey();
        client.write(Arrays.asList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("K").to(key)).set("V").to(0L)).build()));
        int numThreads = 3;
        final CountDownLatch commitBarrier = new CountDownLatch(3);
        CountDownLatch complete = new CountDownLatch(3);
        TransactionRunner.TransactionCallable<Long> callable = new TransactionRunner.TransactionCallable<Long>(){

            public Long run(TransactionContext transaction) throws SpannerException {
                Struct row = strategy.read((ReadContext)transaction, key);
                long newValue = row.getLong(0) + 1L;
                transaction.buffer(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newUpdateBuilder((String)"T").set("K").to(key)).set("V").to(newValue)).build());
                commitBarrier.countDown();
                Uninterruptibles.awaitUninterruptibly((CountDownLatch)commitBarrier);
                return newValue;
            }
        };
        Vector results = new Vector();
        Vector commitTimestamps = new Vector();
        for (int i = 0; i < 3; ++i) {
            class TxnThread
            extends Thread {
                final /* synthetic */ TransactionRunner.TransactionCallable val$callable;
                final /* synthetic */ Vector val$results;
                final /* synthetic */ Vector val$commitTimestamps;
                final /* synthetic */ CountDownLatch val$complete;

                TxnThread() {
                    this.val$callable = transactionCallable;
                    this.val$results = vector;
                    this.val$commitTimestamps = vector2;
                    this.val$complete = countDownLatch;
                }

                @Override
                public void run() {
                    TransactionRunner runner = client.readWriteTransaction();
                    Long result = (Long)runner.run(this.val$callable);
                    this.val$results.add(result);
                    this.val$commitTimestamps.add(runner.getCommitTimestamp());
                    this.val$complete.countDown();
                }
            }
            new TxnThread().start();
        }
        complete.await();
        Truth.assertThat(results).hasSize(3);
        ArrayList<Long> expectedResults = new ArrayList<Long>();
        for (int i = 0; i < 3; ++i) {
            expectedResults.add((long)i + 1L);
        }
        Truth.assertThat(results).containsAtLeastElementsIn(expectedResults);
        Truth.assertThat((Iterable)Sets.newHashSet(commitTimestamps)).hasSize(3);
        Truth.assertThat((Long)client.singleUse(TimestampBound.strong()).readRow("T", Key.of((Object[])new Object[]{key}), Arrays.asList("V")).getLong(0)).isEqualTo((Object)3L);
    }

    @Test
    public void basicsUsingRead() throws InterruptedException {
        this.doBasicsTest(new ReadStrategy(){

            @Override
            public Struct read(ReadContext ctx, String key) {
                return ctx.readRow("T", Key.of((Object[])new Object[]{key}), Arrays.asList("V"));
            }
        });
    }

    @Test
    public void basicsUsingQuery() throws InterruptedException {
        this.doBasicsTest(new ReadStrategy(){

            @Override
            public Struct read(ReadContext ctx, String key) {
                ResultSet resultSet = ctx.executeQuery(((Statement.Builder)Statement.newBuilder((String)"SELECT V FROM T WHERE K = @key").bind("key").to(key)).build(), new Options.QueryOption[0]);
                Truth.assertThat((Boolean)resultSet.next()).isTrue();
                Struct row = resultSet.getCurrentRowAsStruct();
                Truth.assertThat((Boolean)resultSet.next()).isFalse();
                return row;
            }
        });
    }

    @Test
    public void userExceptionPreventsCommit() {
        final String key = ITTransactionTest.uniqueKey();
        TransactionRunner.TransactionCallable<Void> callable = new TransactionRunner.TransactionCallable<Void>(){

            public Void run(TransactionContext transaction) throws UserException {
                transaction.buffer(((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"T").set("K").to(key)).build());
                class UserException
                extends Exception {
                    UserException(String message) {
                        super(message);
                    }
                }
                throw new UserException("User failure");
            }
        };
        try {
            client.readWriteTransaction().run((TransactionRunner.TransactionCallable)callable);
            Assert.fail((String)"Expected user exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.UNKNOWN);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"User failure");
            Truth.assertThat((Throwable)e.getCause()).isInstanceOf(UserException.class);
        }
        Struct row = client.singleUse(TimestampBound.strong()).readRow("T", Key.of((Object[])new Object[]{key}), Arrays.asList("K"));
        Truth.assertThat((Object)row).isNull();
    }

    @Test
    public void userExceptionIsSpannerException() {
        final String key = ITTransactionTest.uniqueKey();
        TransactionRunner.TransactionCallable<Void> callable = new TransactionRunner.TransactionCallable<Void>(){

            public Void run(TransactionContext transaction) {
                transaction.buffer(((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"T").set("K").to(key)).build());
                throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.OUT_OF_RANGE, (String)"User failure");
            }
        };
        try {
            client.readWriteTransaction().run((TransactionRunner.TransactionCallable)callable);
            Assert.fail((String)"Expected user exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.OUT_OF_RANGE);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"User failure");
        }
        Struct row = client.singleUse(TimestampBound.strong()).readRow("T", Key.of((Object[])new Object[]{key}), Arrays.asList("K"));
        Truth.assertThat((Object)row).isNull();
    }

    @Test
    public void readAbort() throws InterruptedException {
        final String key1 = ITTransactionTest.uniqueKey();
        final String key2 = ITTransactionTest.uniqueKey();
        client.write(Arrays.asList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("K").to(key1)).set("V").to(0L)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("K").to(key2)).set("V").to(1L)).build()));
        final CountDownLatch t1Started = new CountDownLatch(1);
        final CountDownLatch t1Done = new CountDownLatch(1);
        final CountDownLatch t2Running = new CountDownLatch(1);
        final CountDownLatch t2Done = new CountDownLatch(1);
        Thread t1 = new Thread(){

            @Override
            public void run() {
                client.readWriteTransaction().run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Void>(){

                    public Void run(TransactionContext transaction) throws SpannerException {
                        try {
                            Struct row = transaction.readRow("T", Key.of((Object[])new Object[]{key1}), Arrays.asList("V"));
                            t1Started.countDown();
                            Uninterruptibles.awaitUninterruptibly((CountDownLatch)t2Running);
                            transaction.buffer(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newUpdateBuilder((String)"T").set("K").to(key1)).set("V").to(row.getLong(0) + 1L)).build());
                            return null;
                        }
                        catch (SpannerException e) {
                            if (e.getErrorCode() == ErrorCode.ABORTED) {
                                Truth.assertThat((Throwable)e).isInstanceOf(AbortedException.class);
                                Truth.assertThat((Long)((AbortedException)((Object)e)).getRetryDelayInMillis()).isNotEqualTo((Object)-1L);
                            }
                            throw new RuntimeException("Swallowed exception: " + e.getMessage());
                        }
                    }
                });
                t1Done.countDown();
            }
        };
        Thread t2 = new Thread(){

            @Override
            public void run() {
                client.readWriteTransaction().run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Void>(){

                    public Void run(TransactionContext transaction) throws SpannerException {
                        try {
                            Struct r1 = transaction.readRow("T", Key.of((Object[])new Object[]{key1}), Arrays.asList("V"));
                            t2Running.countDown();
                            Uninterruptibles.awaitUninterruptibly((CountDownLatch)t1Done);
                            Struct r2 = transaction.readRow("T", Key.of((Object[])new Object[]{key2}), Arrays.asList("V"));
                            transaction.buffer(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newUpdateBuilder((String)"T").set("K").to(key2)).set("V").to(r1.getLong(0) + r2.getLong(0))).build());
                            return null;
                        }
                        catch (SpannerException e) {
                            if (e.getErrorCode() == ErrorCode.ABORTED) {
                                Truth.assertThat((Throwable)e).isInstanceOf(AbortedException.class);
                                Truth.assertThat((Long)((AbortedException)((Object)e)).getRetryDelayInMillis()).isNotEqualTo((Object)-1L);
                            }
                            throw new RuntimeException("Swallowed exception: " + e.getMessage());
                        }
                    }
                });
                t2Done.countDown();
            }
        };
        t1.start();
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)t1Started);
        t2.start();
        Truth.assertThat((Boolean)t2Done.await(1L, TimeUnit.MINUTES)).isTrue();
        Truth.assertThat((Long)client.singleUse(TimestampBound.strong()).readRow("T", Key.of((Object[])new Object[]{key1}), Arrays.asList("V")).getLong(0)).isEqualTo((Object)1);
        Truth.assertThat((Long)client.singleUse(TimestampBound.strong()).readRow("T", Key.of((Object[])new Object[]{key2}), Arrays.asList("V")).getLong(0)).isEqualTo((Object)2);
    }

    private void doNestedRwTransaction() {
        client.readWriteTransaction().run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Void>(){

            public Void run(TransactionContext transaction) throws SpannerException {
                client.readWriteTransaction().run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Void>(){

                    public Void run(TransactionContext transaction) throws Exception {
                        return null;
                    }
                });
                return null;
            }
        });
    }

    @Test
    public void nestedReadWriteTxnThrows() {
        try {
            this.doNestedRwTransaction();
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INTERNAL);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"not supported");
        }
    }

    @Test
    public void nestedReadOnlyTxnThrows() {
        try {
            client.readWriteTransaction().run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Void>(){

                public Void run(TransactionContext transaction) throws SpannerException {
                    client.readOnlyTransaction().getReadTimestamp();
                    return null;
                }
            });
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INTERNAL);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"not supported");
        }
    }

    @Test
    public void nestedBatchTxnThrows() {
        try {
            client.readWriteTransaction().run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Void>(){

                public Void run(TransactionContext transaction) throws SpannerException {
                    BatchClient batchClient = env.getTestHelper().getBatchClient(db);
                    BatchReadOnlyTransaction batchTxn = batchClient.batchReadOnlyTransaction(TimestampBound.strong());
                    batchTxn.partitionReadUsingIndex(PartitionOptions.getDefaultInstance(), "Test", "Index", KeySet.all(), Arrays.asList("Fingerprint"), new Options.ReadOption[0]);
                    return null;
                }
            });
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INTERNAL);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"not supported");
        }
    }

    @Test
    public void nestedSingleUseReadTxnThrows() {
        try {
            client.readWriteTransaction().run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Void>(){

                public Void run(TransactionContext transaction) throws SpannerException {
                    client.singleUseReadOnlyTransaction();
                    return null;
                }
            });
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INTERNAL);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"not supported");
        }
    }

    @Test
    public void nestedTxnSucceedsWhenAllowed() {
        client.readWriteTransaction().allowNestedTransaction().run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Void>(){

            public Void run(TransactionContext transaction) throws SpannerException {
                client.singleUseReadOnlyTransaction();
                return null;
            }
        });
    }

    private static interface ReadStrategy {
        public Struct read(ReadContext var1, String var2);
    }
}

