/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.spi.v1;

import com.google.api.core.ApiFunction;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.InstanceAdminClient;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.admin.database.v1.MockDatabaseAdminImpl;
import com.google.cloud.spanner.admin.instance.v1.MockInstanceAdminImpl;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.admin.database.v1.Database;
import com.google.spanner.admin.database.v1.DatabaseName;
import com.google.spanner.admin.instance.v1.Instance;
import com.google.spanner.admin.instance.v1.InstanceConfigName;
import com.google.spanner.admin.instance.v1.InstanceName;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import io.grpc.BindableService;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Server;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GapicSpannerRpcTest {
    private static final Statement SELECT1AND2 = Statement.of((String)"SELECT 1 AS COL1 UNION ALL SELECT 2 AS COL1");
    private static final ResultSetMetadata SELECT1AND2_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("COL1").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
    private static final com.google.spanner.v1.ResultSet SELECT1_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("2").build()).build()).setMetadata(SELECT1AND2_METADATA).build();
    private MockSpannerServiceImpl mockSpanner;
    private MockInstanceAdminImpl mockInstanceAdmin;
    private MockDatabaseAdminImpl mockDatabaseAdmin;
    private Server server;
    private InetSocketAddress address;
    private static final int NUMBER_OF_TEST_RUNS = 2;
    private static final int NUM_THREADS_PER_CHANNEL = 4;
    private static final String SPANNER_THREAD_NAME = "Cloud-Spanner-TransportChannel";
    private static final String THREAD_PATTERN = "%s-[0-9]+";

    @Before
    public void startServer() throws IOException {
        this.mockSpanner = new MockSpannerServiceImpl();
        this.mockSpanner.setAbortProbability(0.0);
        this.mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT1AND2, SELECT1_RESULTSET));
        this.mockInstanceAdmin = new MockInstanceAdminImpl();
        this.mockDatabaseAdmin = new MockDatabaseAdminImpl();
        this.address = new InetSocketAddress("localhost", 0);
        this.server = ((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)this.address).addService((BindableService)this.mockSpanner)).addService((BindableService)this.mockInstanceAdmin)).addService((BindableService)this.mockDatabaseAdmin)).build().start();
    }

    @After
    public void stopServer() {
        this.server.shutdown();
    }

    @Test
    public void testCloseAllThreadsWhenClosingSpanner() throws InterruptedException {
        for (int i = 0; i < 2; ++i) {
            int i2;
            Assert.assertThat((Object)this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)));
            SpannerOptions options = this.createSpannerOptions();
            Spanner spanner = (Spanner)options.getService();
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            ArrayList<ResultSet> resultSets = new ArrayList<ResultSet>();
            for (i2 = 0; i2 < options.getSessionPoolOptions().getMaxSessions(); ++i2) {
                ResultSet rs = client.singleUse().executeQuery(SELECT1AND2, new Options.QueryOption[0]);
                rs.next();
                resultSets.add(rs);
                if (this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME) == options.getNumChannels() * 4) break;
            }
            for (ResultSet rs : resultSets) {
                rs.close();
            }
            for (i2 = 0; i2 < options.getNumChannels() * 2; ++i2) {
                this.mockGetInstanceResponse();
                InstanceAdminClient instanceAdminClient = spanner.getInstanceAdminClient();
                instanceAdminClient.getInstance("projects/[PROJECT]/instances/[INSTANCE]");
            }
            for (i2 = 0; i2 < options.getNumChannels() * 2; ++i2) {
                this.mockGetDatabaseResponse();
                DatabaseAdminClient databaseAdminClient = spanner.getDatabaseAdminClient();
                databaseAdminClient.getDatabase("projects/[PROJECT]/instances/[INSTANCE]", "[DATABASE]");
            }
            spanner.close();
            int totalWaits = 0;
            while (true) {
                Thread.sleep(100L);
                if (this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME) == 0 || totalWaits > 20) break;
                ++totalWaits;
            }
            Assert.assertThat((Object)this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)));
        }
    }

    @Test
    public void testMultipleOpenSpanners() throws InterruptedException {
        ArrayList<Spanner> spanners = new ArrayList<Spanner>();
        Assert.assertThat((Object)this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)));
        for (int openSpanners = 1; openSpanners <= 3; ++openSpanners) {
            SpannerOptions options = this.createSpannerOptions();
            Spanner spanner = (Spanner)options.getService();
            spanners.add(spanner);
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            ArrayList<ResultSet> resultSets = new ArrayList<ResultSet>();
            for (int sessionCount = 0; sessionCount < options.getSessionPoolOptions().getMaxSessions() && this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME) < options.getNumChannels() * 4 * openSpanners; ++sessionCount) {
                ResultSet rs = client.singleUse().executeQuery(SELECT1AND2, new Options.QueryOption[0]);
                rs.next();
                resultSets.add(rs);
            }
            for (ResultSet rs : resultSets) {
                rs.close();
            }
        }
        for (Spanner spanner : spanners) {
            spanner.close();
        }
        Thread.sleep(500L);
        Assert.assertThat((Object)this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)));
    }

    private SpannerOptions createSpannerOptions() {
        String endpoint = this.address.getHostString() + ":" + this.server.getPort();
        return ((SpannerOptions.Builder)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelConfigurator((ApiFunction)new ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder>(){

            public ManagedChannelBuilder apply(ManagedChannelBuilder input) {
                input.usePlaintext();
                return input;
            }
        }).setHost("http://" + endpoint)).setCredentials((Credentials)NoCredentials.getInstance())).build();
    }

    private int getNumberOfThreadsWithName(String serviceName) {
        Pattern pattern = Pattern.compile(String.format(THREAD_PATTERN, serviceName));
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        while (group.getParent() != null) {
            group = group.getParent();
        }
        Thread[] threads = new Thread[200];
        int numberOfThreads = group.enumerate(threads);
        int res = 0;
        for (int i = 0; i < numberOfThreads; ++i) {
            if (!pattern.matcher(threads[i].getName()).matches()) continue;
            ++res;
        }
        return res;
    }

    private void mockGetInstanceResponse() {
        InstanceName name2 = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        InstanceConfigName config = InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]");
        String displayName = "displayName1615086568";
        int nodeCount = 1539922066;
        Instance expectedResponse = Instance.newBuilder().setName(name2.toString()).setConfig(config.toString()).setDisplayName(displayName).setNodeCount(nodeCount).build();
        this.mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
    }

    private void mockGetDatabaseResponse() {
        DatabaseName name2 = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        Database expectedResponse = Database.newBuilder().setName(name2.toString()).build();
        this.mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
    }
}

