/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.grpc.testing.MockStreamObserver;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.spanner.v1.MockSpanner;
import com.google.cloud.spanner.v1.SpannerClient;
import com.google.cloud.spanner.v1.SpannerSettings;
import com.google.common.collect.Lists;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.CommitResponse;
import com.google.spanner.v1.CreateSessionRequest;
import com.google.spanner.v1.DatabaseName;
import com.google.spanner.v1.DeleteSessionRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.GetSessionRequest;
import com.google.spanner.v1.KeySet;
import com.google.spanner.v1.ListSessionsRequest;
import com.google.spanner.v1.ListSessionsResponse;
import com.google.spanner.v1.PartialResultSet;
import com.google.spanner.v1.ReadRequest;
import com.google.spanner.v1.RollbackRequest;
import com.google.spanner.v1.Session;
import com.google.spanner.v1.SessionName;
import com.google.spanner.v1.Transaction;
import com.google.spanner.v1.TransactionOptions;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SpannerClientTest {
    private static MockSpanner mockSpanner;
    private static MockServiceHelper serviceHelper;
    private SpannerClient client;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockSpanner = new MockSpanner();
        serviceHelper = new MockServiceHelper("in-process-1", Arrays.asList(mockSpanner));
        serviceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        serviceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        serviceHelper.reset();
        this.channelProvider = serviceHelper.createChannelProvider();
        SpannerSettings settings = ((SpannerSettings.Builder)((SpannerSettings.Builder)SpannerSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = SpannerClient.create((SpannerSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createSessionTest() {
        SessionName name = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
        Session expectedResponse = Session.newBuilder().setName(name.toString()).build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        Session actualResponse = this.client.createSession(database);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSessionRequest actualRequest = (CreateSessionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)database, (Object)DatabaseName.parse((String)actualRequest.getDatabase()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSessionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
            this.client.createSession(database);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSessionTest() {
        SessionName name2 = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
        Session expectedResponse = Session.newBuilder().setName(name2.toString()).build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        SessionName name = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
        Session actualResponse = this.client.getSession(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSessionRequest actualRequest = (GetSessionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)SessionName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSessionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            SessionName name = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
            this.client.getSession(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSessionsTest() {
        String nextPageToken = "";
        Session sessionsElement = Session.newBuilder().build();
        List<Session> sessions = Arrays.asList(sessionsElement);
        ListSessionsResponse expectedResponse = ListSessionsResponse.newBuilder().setNextPageToken(nextPageToken).addAllSessions(sessions).build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        String formattedDatabase = DatabaseName.format((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        SpannerClient.ListSessionsPagedResponse pagedListResponse = this.client.listSessions(formattedDatabase);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSessionsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSessionsRequest actualRequest = (ListSessionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedDatabase, (Object)actualRequest.getDatabase());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSessionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            String formattedDatabase = DatabaseName.format((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
            this.client.listSessions(formattedDatabase);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSessionTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        SessionName name = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
        this.client.deleteSession(name);
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteSessionRequest actualRequest = (DeleteSessionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)SessionName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteSessionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            SessionName name = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
            this.client.deleteSession(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void executeStreamingSqlTest() throws Exception {
        boolean chunkedValue = true;
        ByteString resumeToken = ByteString.copyFromUtf8((String)"103");
        PartialResultSet expectedResponse = PartialResultSet.newBuilder().setChunkedValue(chunkedValue).setResumeToken(resumeToken).build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        SessionName session = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
        String sql = "sql114126";
        ExecuteSqlRequest request = ExecuteSqlRequest.newBuilder().setSession(session.toString()).setSql(sql).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.executeStreamingSqlCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        List actualResponses = (List)responseObserver.future().get();
        Assert.assertEquals((long)1L, (long)actualResponses.size());
        Assert.assertEquals((Object)expectedResponse, actualResponses.get(0));
    }

    @Test
    public void executeStreamingSqlExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        SessionName session = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
        String sql = "sql114126";
        ExecuteSqlRequest request = ExecuteSqlRequest.newBuilder().setSession(session.toString()).setSql(sql).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.executeStreamingSqlCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        try {
            List actualResponses = (List)responseObserver.future().get();
            Assert.fail((String)"No exception thrown");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidArgumentException));
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void streamingReadTest() throws Exception {
        boolean chunkedValue = true;
        ByteString resumeToken = ByteString.copyFromUtf8((String)"103");
        PartialResultSet expectedResponse = PartialResultSet.newBuilder().setChunkedValue(chunkedValue).setResumeToken(resumeToken).build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        SessionName session = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
        String table = "table110115790";
        ArrayList columns = new ArrayList();
        KeySet keySet = KeySet.newBuilder().build();
        ReadRequest request = ReadRequest.newBuilder().setSession(session.toString()).setTable(table).addAllColumns(columns).setKeySet(keySet).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.streamingReadCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        List actualResponses = (List)responseObserver.future().get();
        Assert.assertEquals((long)1L, (long)actualResponses.size());
        Assert.assertEquals((Object)expectedResponse, actualResponses.get(0));
    }

    @Test
    public void streamingReadExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        SessionName session = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
        String table = "table110115790";
        ArrayList columns = new ArrayList();
        KeySet keySet = KeySet.newBuilder().build();
        ReadRequest request = ReadRequest.newBuilder().setSession(session.toString()).setTable(table).addAllColumns(columns).setKeySet(keySet).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.streamingReadCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        try {
            List actualResponses = (List)responseObserver.future().get();
            Assert.fail((String)"No exception thrown");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidArgumentException));
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void beginTransactionTest() {
        ByteString id = ByteString.copyFromUtf8((String)"27");
        Transaction expectedResponse = Transaction.newBuilder().setId(id).build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        SessionName session = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
        TransactionOptions options = TransactionOptions.newBuilder().build();
        Transaction actualResponse = this.client.beginTransaction(session, options);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BeginTransactionRequest actualRequest = (BeginTransactionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)session, (Object)SessionName.parse((String)actualRequest.getSession()));
        Assert.assertEquals((Object)options, (Object)actualRequest.getOptions());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void beginTransactionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            SessionName session = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
            TransactionOptions options = TransactionOptions.newBuilder().build();
            this.client.beginTransaction(session, options);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void commitTest() {
        CommitResponse expectedResponse = CommitResponse.newBuilder().build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        SessionName session = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
        ByteString transactionId = ByteString.copyFromUtf8((String)"28");
        ArrayList mutations = new ArrayList();
        CommitResponse actualResponse = this.client.commit(session, transactionId, mutations);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CommitRequest actualRequest = (CommitRequest)actualRequests.get(0);
        Assert.assertEquals((Object)session, (Object)SessionName.parse((String)actualRequest.getSession()));
        Assert.assertEquals((Object)transactionId, (Object)actualRequest.getTransactionId());
        Assert.assertEquals(mutations, (Object)actualRequest.getMutationsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void commitExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            SessionName session = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
            ByteString transactionId = ByteString.copyFromUtf8((String)"28");
            ArrayList mutations = new ArrayList();
            this.client.commit(session, transactionId, mutations);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void commitTest2() {
        CommitResponse expectedResponse = CommitResponse.newBuilder().build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        SessionName session = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
        TransactionOptions singleUseTransaction = TransactionOptions.newBuilder().build();
        ArrayList mutations = new ArrayList();
        CommitResponse actualResponse = this.client.commit(session, singleUseTransaction, mutations);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CommitRequest actualRequest = (CommitRequest)actualRequests.get(0);
        Assert.assertEquals((Object)session, (Object)SessionName.parse((String)actualRequest.getSession()));
        Assert.assertEquals((Object)singleUseTransaction, (Object)actualRequest.getSingleUseTransaction());
        Assert.assertEquals(mutations, (Object)actualRequest.getMutationsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void commitExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            SessionName session = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
            TransactionOptions singleUseTransaction = TransactionOptions.newBuilder().build();
            ArrayList mutations = new ArrayList();
            this.client.commit(session, singleUseTransaction, mutations);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void rollbackTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        SessionName session = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
        ByteString transactionId = ByteString.copyFromUtf8((String)"28");
        this.client.rollback(session, transactionId);
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RollbackRequest actualRequest = (RollbackRequest)actualRequests.get(0);
        Assert.assertEquals((Object)session, (Object)SessionName.parse((String)actualRequest.getSession()));
        Assert.assertEquals((Object)transactionId, (Object)actualRequest.getTransactionId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void rollbackExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            SessionName session = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
            ByteString transactionId = ByteString.copyFromUtf8((String)"28");
            this.client.rollback(session, transactionId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

