/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.Session;
import com.google.cloud.spanner.SessionNotFoundException;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TraceUtil;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.util.concurrent.ListenableFuture;
import io.opencensus.common.Scope;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;

class DatabaseClientImpl
implements DatabaseClient {
    private static final String READ_WRITE_TRANSACTION = "CloudSpanner.ReadWriteTransaction";
    private static final String READ_ONLY_TRANSACTION = "CloudSpanner.ReadOnlyTransaction";
    private static final String PARTITION_DML_TRANSACTION = "CloudSpanner.PartitionDMLTransaction";
    private static final Tracer tracer = Tracing.getTracer();
    @VisibleForTesting
    final String clientId;
    @VisibleForTesting
    final SessionPool pool;

    @VisibleForTesting
    DatabaseClientImpl(SessionPool pool) {
        this("", pool);
    }

    DatabaseClientImpl(String clientId, SessionPool pool) {
        this.clientId = clientId;
        this.pool = pool;
    }

    @VisibleForTesting
    SessionPool.PooledSession getReadSession() {
        return this.pool.getReadSession();
    }

    @VisibleForTesting
    SessionPool.PooledSession getReadWriteSession() {
        return this.pool.getReadWriteSession();
    }

    /*
     * Exception decompiling
     */
    @Override
    public Timestamp write(Iterable<Mutation> mutations) throws SpannerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public Timestamp writeAtLeastOnce(Iterable<Mutation> mutations) throws SpannerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ReadContext singleUse() {
        Span span = tracer.spanBuilder(READ_ONLY_TRANSACTION).startSpan();
        try (Scope s = tracer.withSpan(span);){
            ReadContext readContext = this.getReadSession().singleUse();
            return readContext;
        }
        catch (RuntimeException e) {
            TraceUtil.endSpanWithFailure(span, e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ReadContext singleUse(TimestampBound bound) {
        Span span = tracer.spanBuilder(READ_ONLY_TRANSACTION).startSpan();
        try (Scope s = tracer.withSpan(span);){
            ReadContext readContext = this.getReadSession().singleUse(bound);
            return readContext;
        }
        catch (RuntimeException e) {
            TraceUtil.endSpanWithFailure(span, e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ReadOnlyTransaction singleUseReadOnlyTransaction() {
        Span span = tracer.spanBuilder(READ_ONLY_TRANSACTION).startSpan();
        try (Scope s = tracer.withSpan(span);){
            ReadOnlyTransaction readOnlyTransaction = this.getReadSession().singleUseReadOnlyTransaction();
            return readOnlyTransaction;
        }
        catch (RuntimeException e) {
            TraceUtil.endSpanWithFailure(span, e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ReadOnlyTransaction singleUseReadOnlyTransaction(TimestampBound bound) {
        Span span = tracer.spanBuilder(READ_ONLY_TRANSACTION).startSpan();
        try (Scope s = tracer.withSpan(span);){
            ReadOnlyTransaction readOnlyTransaction = this.getReadSession().singleUseReadOnlyTransaction(bound);
            return readOnlyTransaction;
        }
        catch (RuntimeException e) {
            TraceUtil.endSpanWithFailure(span, e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ReadOnlyTransaction readOnlyTransaction() {
        Span span = tracer.spanBuilder(READ_ONLY_TRANSACTION).startSpan();
        try (Scope s = tracer.withSpan(span);){
            ReadOnlyTransaction readOnlyTransaction = this.getReadSession().readOnlyTransaction();
            return readOnlyTransaction;
        }
        catch (RuntimeException e) {
            TraceUtil.endSpanWithFailure(span, e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ReadOnlyTransaction readOnlyTransaction(TimestampBound bound) {
        Span span = tracer.spanBuilder(READ_ONLY_TRANSACTION).startSpan();
        try (Scope s = tracer.withSpan(span);){
            ReadOnlyTransaction readOnlyTransaction = this.getReadSession().readOnlyTransaction(bound);
            return readOnlyTransaction;
        }
        catch (RuntimeException e) {
            TraceUtil.endSpanWithFailure(span, e);
            throw e;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public TransactionRunner readWriteTransaction() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TransactionManager transactionManager() {
        Span span = tracer.spanBuilder(READ_WRITE_TRANSACTION).startSpan();
        try (Scope s = tracer.withSpan(span);){
            TransactionManager transactionManager = this.getReadWriteSession().transactionManager();
            return transactionManager;
        }
        catch (RuntimeException e) {
            TraceUtil.endSpanWithFailure(span, e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long executePartitionedUpdate(final Statement stmt) {
        Span span = tracer.spanBuilder(PARTITION_DML_TRANSACTION).startSpan();
        try (Scope s = tracer.withSpan(span);){
            long l = this.runWithSessionRetry(SessionMode.READ, new Function<Session, Long>(){

                public Long apply(Session session) {
                    return session.executePartitionedUpdate(stmt);
                }
            });
            return l;
        }
        catch (RuntimeException e) {
            TraceUtil.endSpanWithFailure(span, e);
            throw e;
        }
    }

    private <T> T runWithSessionRetry(SessionMode mode, Function<Session, T> callable) {
        SessionPool.PooledSession session = mode == SessionMode.READ_WRITE ? this.getReadWriteSession() : this.getReadSession();
        while (true) {
            try {
                return (T)callable.apply((Object)session);
            }
            catch (SessionNotFoundException e) {
                session = mode == SessionMode.READ_WRITE ? this.pool.replaceReadWriteSession(e, session) : this.pool.replaceReadSession(e, session);
                continue;
            }
            break;
        }
    }

    ListenableFuture<Void> closeAsync(SpannerImpl.ClosedException closedException) {
        return this.pool.closeAsync(closedException);
    }

    private static enum SessionMode {
        READ,
        READ_WRITE;

    }
}

