/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerRetryHelper;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import com.google.protobuf.Struct;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.ResultSet;
import com.google.spanner.v1.Transaction;
import com.google.spanner.v1.TransactionOptions;
import com.google.spanner.v1.TransactionSelector;
import java.util.Map;
import java.util.concurrent.Callable;

class PartitionedDMLTransaction
implements SessionImpl.SessionTransaction {
    private final SessionImpl session;
    private final SpannerRpc rpc;
    private volatile boolean isValid = true;

    PartitionedDMLTransaction(SessionImpl session, SpannerRpc rpc) {
        this.session = session;
        this.rpc = rpc;
    }

    private ByteString initTransaction() {
        BeginTransactionRequest request = BeginTransactionRequest.newBuilder().setSession(this.session.getName()).setOptions(TransactionOptions.newBuilder().setPartitionedDml(TransactionOptions.PartitionedDml.getDefaultInstance())).build();
        Transaction txn = this.rpc.beginTransaction(request, this.session.getOptions());
        if (txn.getId().isEmpty()) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Failed to init transaction, missing transaction id\n" + this.session.getName());
        }
        return txn.getId();
    }

    long executePartitionedUpdate(final Statement statement) {
        Preconditions.checkState((boolean)this.isValid, (Object)"Partitioned DML has been invalidated by a new operation on the session");
        Callable<ResultSet> callable = new Callable<ResultSet>(){

            @Override
            public ResultSet call() throws Exception {
                ByteString transactionId = PartitionedDMLTransaction.this.initTransaction();
                ExecuteSqlRequest.Builder builder = ExecuteSqlRequest.newBuilder().setSql(statement.getSql()).setQueryMode(ExecuteSqlRequest.QueryMode.NORMAL).setSession(PartitionedDMLTransaction.this.session.getName()).setTransaction(TransactionSelector.newBuilder().setId(transactionId).build());
                Map<String, Value> stmtParameters = statement.getParameters();
                if (!stmtParameters.isEmpty()) {
                    Struct.Builder paramsBuilder = builder.getParamsBuilder();
                    for (Map.Entry<String, Value> param : stmtParameters.entrySet()) {
                        paramsBuilder.putFields(param.getKey(), param.getValue().toProto());
                        builder.putParamTypes(param.getKey(), param.getValue().getType().toProto());
                    }
                }
                return PartitionedDMLTransaction.this.rpc.executePartitionedDml(builder.build(), PartitionedDMLTransaction.this.session.getOptions());
            }
        };
        ResultSet resultSet = SpannerRetryHelper.runTxWithRetriesOnAborted(callable, this.rpc.getPartitionedDmlRetrySettings());
        if (!resultSet.hasStats()) {
            throw new IllegalArgumentException("Partitioned DML response missing stats possibly due to non-DML statement as input");
        }
        return resultSet.getStats().getRowCountLowerBound();
    }

    @Override
    public void invalidate() {
        this.isValid = false;
    }
}

