/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.ResultSets;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.connection.ConnectionPreconditions;
import com.google.cloud.spanner.connection.StatementResult;
import java.util.Arrays;

class StatementResultImpl
implements StatementResult {
    private final StatementResult.ResultType type;
    private final StatementResult.ClientSideStatementType clientSideStatementType;
    private final ResultSet resultSet;
    private final Long updateCount;

    static StatementResult of(ResultSet resultSet) {
        return new StatementResultImpl(resultSet, null);
    }

    static StatementResult of(ResultSet resultSet, StatementResult.ClientSideStatementType clientSideStatementType) {
        return new StatementResultImpl(resultSet, clientSideStatementType);
    }

    static StatementResult of(Long updateCount) {
        return new StatementResultImpl(updateCount);
    }

    static StatementResult resultSet(String name, Boolean value, StatementResult.ClientSideStatementType clientSideStatementType) {
        return StatementResultImpl.of(ResultSets.forRows(Type.struct(Type.StructField.of(name, Type.bool())), Arrays.asList(Struct.newBuilder().set(name).to(value).build())), clientSideStatementType);
    }

    static StatementResult resultSet(String name, Long value, StatementResult.ClientSideStatementType clientSideStatementType) {
        return StatementResultImpl.of(ResultSets.forRows(Type.struct(Type.StructField.of(name, Type.int64())), Arrays.asList(Struct.newBuilder().set(name).to(value).build())), clientSideStatementType);
    }

    static StatementResult resultSet(String name, long[] values, StatementResult.ClientSideStatementType clientSideStatementType) {
        return StatementResultImpl.of(ResultSets.forRows(Type.struct(Type.StructField.of(name, Type.array(Type.int64()))), Arrays.asList(Struct.newBuilder().set(name).toInt64Array(values).build())), clientSideStatementType);
    }

    static StatementResult resultSet(String name, String value, StatementResult.ClientSideStatementType clientSideStatementType) {
        return StatementResultImpl.of(ResultSets.forRows(Type.struct(Type.StructField.of(name, Type.string())), Arrays.asList(Struct.newBuilder().set(name).to(value).build())), clientSideStatementType);
    }

    static StatementResult resultSet(String name, Enum<?> value, StatementResult.ClientSideStatementType clientSideStatementType) {
        return StatementResultImpl.of(ResultSets.forRows(Type.struct(Type.StructField.of(name, Type.string())), Arrays.asList(Struct.newBuilder().set(name).to(value.toString()).build())), clientSideStatementType);
    }

    static StatementResult resultSet(String name, Timestamp value, StatementResult.ClientSideStatementType clientSideStatementType) {
        return StatementResultImpl.of(ResultSets.forRows(Type.struct(Type.StructField.of(name, Type.timestamp())), Arrays.asList(Struct.newBuilder().set(name).to(value).build())), clientSideStatementType);
    }

    static StatementResult noResult() {
        return new StatementResultImpl((StatementResult.ClientSideStatementType)null);
    }

    static StatementResult noResult(StatementResult.ClientSideStatementType clientSideStatementType) {
        return new StatementResultImpl(clientSideStatementType);
    }

    private StatementResultImpl(ResultSet resultSet, StatementResult.ClientSideStatementType clientSideStatementType) {
        this.type = StatementResult.ResultType.RESULT_SET;
        this.clientSideStatementType = clientSideStatementType;
        this.resultSet = resultSet;
        this.updateCount = null;
    }

    private StatementResultImpl(Long updateCount) {
        this.type = StatementResult.ResultType.UPDATE_COUNT;
        this.clientSideStatementType = null;
        this.resultSet = null;
        this.updateCount = updateCount;
    }

    private StatementResultImpl(StatementResult.ClientSideStatementType clientSideStatementType) {
        this.type = StatementResult.ResultType.NO_RESULT;
        this.clientSideStatementType = clientSideStatementType;
        this.resultSet = null;
        this.updateCount = null;
    }

    @Override
    public StatementResult.ResultType getResultType() {
        return this.type;
    }

    @Override
    public StatementResult.ClientSideStatementType getClientSideStatementType() {
        return this.clientSideStatementType;
    }

    @Override
    public ResultSet getResultSet() {
        ConnectionPreconditions.checkState(this.resultSet != null, "This result does not contain a ResultSet");
        return this.resultSet;
    }

    @Override
    public Long getUpdateCount() {
        ConnectionPreconditions.checkState(this.updateCount != null, "This result does not contain an update count");
        return this.updateCount;
    }
}

