/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbstractStructReader;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.StructReader;
import com.google.cloud.spanner.Type;
import com.google.common.base.Throwables;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Truth;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class AbstractStructReaderTypesTest {
    private static List<String> NON_VALUE_GETTERS = Arrays.asList("getType", "getColumnCount", "getColumnIndex", "getColumnType");
    @Parameterized.Parameter(value=0)
    public Type type;
    @Parameterized.Parameter(value=1)
    public String implMethodName;
    @Parameterized.Parameter(value=2)
    public Object value;
    @Parameterized.Parameter(value=3)
    public String getterMethodName;
    @Parameterized.Parameter(value=4)
    @Nullable
    public List<String> otherAllowedGetters;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private TestStructReader reader;

    @Parameterized.Parameters(name="{index}: {0}: {3}()={4}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({Type.bool(), "getBooleanInternal", false, "getBoolean", null}, {Type.int64(), "getLongInternal", 123L, "getLong", null}, {Type.float64(), "getDoubleInternal", 2.0, "getDouble", null}, {Type.string(), "getStringInternal", "a", "getString", null}, {Type.bytes(), "getBytesInternal", ByteArray.copyFrom((byte[])new byte[]{0}), "getBytes", null}, {Type.timestamp(), "getTimestampInternal", Timestamp.parseTimestamp((String)"2015-09-15T00:00:00Z"), "getTimestamp", null}, {Type.date(), "getDateInternal", Date.parseDate((String)"2015-09-15"), "getDate", null}, {Type.array((Type)Type.bool()), "getBooleanArrayInternal", new boolean[]{true, false}, "getBooleanArray", Arrays.asList("getBooleanList")}, {Type.array((Type)Type.bool()), "getBooleanListInternal", Arrays.asList(false, true), "getBooleanList", Arrays.asList("getBooleanArray")}, {Type.array((Type)Type.int64()), "getLongArrayInternal", new long[]{1L, 2L}, "getLongArray", Arrays.asList("getLongList")}, {Type.array((Type)Type.int64()), "getLongListInternal", Arrays.asList(3L, 4L), "getLongList", Arrays.asList("getLongArray")}, {Type.array((Type)Type.float64()), "getDoubleArrayInternal", new double[]{1.0, 2.0}, "getDoubleArray", Arrays.asList("getDoubleList")}, {Type.array((Type)Type.float64()), "getDoubleListInternal", Arrays.asList(2.0, 4.0), "getDoubleList", Arrays.asList("getDoubleArray")}, {Type.array((Type)Type.string()), "getStringListInternal", Arrays.asList("a", "b", "c"), "getStringList", null}, {Type.array((Type)Type.bytes()), "getBytesListInternal", Arrays.asList(ByteArray.copyFrom((String)"a"), ByteArray.copyFrom((String)"b"), ByteArray.copyFrom((String)"c")), "getBytesList", null}, {Type.array((Type)Type.timestamp()), "getTimestampListInternal", Arrays.asList(Timestamp.parseTimestamp((String)"2015-09-15T00:00:00Z"), Timestamp.parseTimestamp((String)"2015-09-14T00:00:00Z")), "getTimestampList", null}, {Type.array((Type)Type.date()), "getDateListInternal", Arrays.asList(Date.parseDate((String)"2015-09-15"), Date.parseDate((String)"2015-09-14")), "getDateList", null}, {Type.array((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f1", (Type)Type.int64())})), "getStructListInternal", Arrays.asList(((Struct.Builder)Struct.newBuilder().set("f1").to(1L)).build(), ((Struct.Builder)Struct.newBuilder().set("f1").to(2L)).build(), ((Struct.Builder)Struct.newBuilder().set("f1").to(3L)).build()), "getStructList", null});
    }

    @Before
    public void setUp() {
        this.reader = (TestStructReader)((Object)Mockito.spy((Object)((Object)new TestStructReader())));
    }

    private Object getterByIndex(int columnIndex) {
        return this.getterByIndex(this.getterMethodName, columnIndex);
    }

    private Object getterByIndex(String methodName, int columnIndex) {
        try {
            return ((Object)((Object)this.reader)).getClass().getMethod(methodName, Integer.TYPE).invoke((Object)this.reader, columnIndex);
        }
        catch (InvocationTargetException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private Object getterByName(String columnName) {
        return this.getterByName(this.getterMethodName, columnName);
    }

    private Object getterByName(String methodName, String columnName) {
        try {
            return ((Object)((Object)this.reader)).getClass().getMethod(methodName, String.class).invoke((Object)this.reader, columnName);
        }
        catch (InvocationTargetException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void getter() throws Exception {
        Mockito.when((Object)this.reader.getType()).thenReturn((Object)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"F0", (Type)Type.int64()), Type.StructField.of((String)"F1", (Type)this.type)}));
        int columnIndex = 1;
        Mockito.when((Object)this.reader.isNull(columnIndex)).thenReturn((Object)false);
        Mockito.when((Object)((Object)((Object)this.reader)).getClass().getDeclaredMethod(this.implMethodName, Integer.TYPE).invoke((Object)this.reader, columnIndex)).thenReturn(this.value);
        Truth.assertThat((Object)this.getterByIndex(columnIndex)).isEqualTo(this.value);
        Truth.assertThat((Object)this.getterByName("F1")).isEqualTo(this.value);
    }

    @Test
    public void getterForIncorrectType() throws Exception {
        Mockito.when((Object)this.reader.getType()).thenReturn((Object)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"F1", (Type)this.type)}));
        int columnIndex = 0;
        Mockito.when((Object)this.reader.isNull(columnIndex)).thenReturn((Object)false);
        for (Method method : StructReader.class.getMethods()) {
            if (NON_VALUE_GETTERS.contains(method.getName()) || !method.getName().startsWith("get") || method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != Integer.TYPE || method.getName().equals(this.getterMethodName) || this.otherAllowedGetters != null && this.otherAllowedGetters.contains(method.getName())) continue;
            try {
                this.getterByIndex(method.getName(), columnIndex);
                Assert.fail((String)("Expected ISE for " + method));
            }
            catch (IllegalStateException e) {
                ((StringSubject)Truth.assertThat((String)e.getMessage()).named("Exception for " + method, new Object[0])).contains((CharSequence)("was " + this.type));
                ((StringSubject)Truth.assertThat((String)e.getMessage()).named("Exception for " + method, new Object[0])).contains((CharSequence)("Column " + columnIndex));
            }
            try {
                this.getterByName(method.getName(), "F1");
                Assert.fail((String)("Expected ISE for " + method));
            }
            catch (IllegalStateException e) {
                ((StringSubject)Truth.assertThat((String)e.getMessage()).named("Exception for " + method, new Object[0])).contains((CharSequence)("was " + this.type));
                ((StringSubject)Truth.assertThat((String)e.getMessage()).named("Exception for " + method, new Object[0])).contains((CharSequence)"Column F1");
            }
        }
    }

    @Test
    public void getterWhenNull() throws Exception {
        Mockito.when((Object)this.reader.getType()).thenReturn((Object)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"F1", (Type)this.type)}));
        Mockito.when((Object)this.reader.isNull(0)).thenReturn((Object)true);
        this.expectedException.expect(NullPointerException.class);
        this.getterByIndex(0);
    }

    @Test
    public void getterByNameWhenNull() throws Exception {
        Mockito.when((Object)this.reader.getType()).thenReturn((Object)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"F1", (Type)this.type)}));
        Mockito.when((Object)this.reader.isNull(0)).thenReturn((Object)true);
        this.expectedException.expect(NullPointerException.class);
        this.getterByName("F1");
    }

    private static class TestStructReader
    extends AbstractStructReader {
        private TestStructReader() {
        }

        protected boolean getBooleanInternal(int columnIndex) {
            return false;
        }

        protected long getLongInternal(int columnIndex) {
            return 0L;
        }

        protected double getDoubleInternal(int columnIndex) {
            return 0.0;
        }

        protected String getStringInternal(int columnIndex) {
            return null;
        }

        protected ByteArray getBytesInternal(int columnIndex) {
            return null;
        }

        protected Timestamp getTimestampInternal(int columnIndex) {
            return null;
        }

        protected Date getDateInternal(int columnIndex) {
            return null;
        }

        protected boolean[] getBooleanArrayInternal(int columnIndex) {
            return null;
        }

        protected List<Boolean> getBooleanListInternal(int columnIndex) {
            return null;
        }

        protected long[] getLongArrayInternal(int columnIndex) {
            return null;
        }

        protected List<Long> getLongListInternal(int columnIndex) {
            return null;
        }

        protected double[] getDoubleArrayInternal(int columnIndex) {
            return null;
        }

        protected List<Double> getDoubleListInternal(int columnIndex) {
            return null;
        }

        protected List<String> getStringListInternal(int columnIndex) {
            return null;
        }

        protected List<ByteArray> getBytesListInternal(int columnIndex) {
            return null;
        }

        protected List<Timestamp> getTimestampListInternal(int columnIndex) {
            return null;
        }

        protected List<Date> getDateListInternal(int columnIndex) {
            return null;
        }

        protected List<Struct> getStructListInternal(int columnIndex) {
            return null;
        }

        public Type getType() {
            return null;
        }

        public boolean isNull(int columnIndex) {
            return false;
        }
    }
}

