/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseInfo;
import com.google.cloud.spanner.OperationFutureUtil;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.spanner.admin.database.v1.CreateDatabaseMetadata;
import com.google.spanner.admin.database.v1.Database;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import java.util.ArrayList;
import java.util.Collections;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class DatabaseAdminClientImplTest {
    private static final String PROJECT_ID = "my-project";
    private static final String INSTANCE_ID = "my-instance";
    private static final String INSTANCE_NAME = "projects/my-project/instances/my-instance";
    private static final String DB_ID = "my-db";
    private static final String DB_NAME = "projects/my-project/instances/my-instance/databases/my-db";
    private static final String DB_NAME2 = "projects/my-project/instances/my-instance/databases/my-db2";
    @Mock
    SpannerRpc rpc;
    SpannerImpl.DatabaseAdminClientImpl client;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.client = new SpannerImpl.DatabaseAdminClientImpl(PROJECT_ID, this.rpc);
    }

    private com.google.spanner.admin.database.v1.Database getDatabaseProto() {
        return com.google.spanner.admin.database.v1.Database.newBuilder().setName(DB_NAME).setState(Database.State.READY).build();
    }

    private com.google.spanner.admin.database.v1.Database getAnotherDatabaseProto() {
        return com.google.spanner.admin.database.v1.Database.newBuilder().setName(DB_NAME2).setState(Database.State.READY).build();
    }

    static Any toAny(Message message) {
        return Any.newBuilder().setTypeUrl("type.googleapis.com/" + message.getDescriptorForType().getFullName()).setValue(message.toByteString()).build();
    }

    @Test
    public void getDatabase() {
        Mockito.when((Object)this.rpc.getDatabase(DB_NAME)).thenReturn((Object)this.getDatabaseProto());
        Database db = this.client.getDatabase(INSTANCE_ID, DB_ID);
        Truth.assertThat((String)db.getId().getName()).isEqualTo((Object)DB_NAME);
        Truth.assertThat((Comparable)db.getState()).isEqualTo((Object)DatabaseInfo.State.READY);
    }

    @Test
    public void createDatabase() throws Exception {
        OperationFuture<com.google.spanner.admin.database.v1.Database, CreateDatabaseMetadata> rawOperationFuture = OperationFutureUtil.immediateOperationFuture("createDatabase", this.getDatabaseProto(), CreateDatabaseMetadata.getDefaultInstance());
        Mockito.when((Object)this.rpc.createDatabase(INSTANCE_NAME, "CREATE DATABASE `my-db`", Collections.emptyList())).thenReturn(rawOperationFuture);
        OperationFuture op = this.client.createDatabase(INSTANCE_ID, DB_ID, Collections.emptyList());
        Truth.assertThat((Boolean)op.isDone()).isTrue();
        Truth.assertThat((String)((Database)op.get()).getId().getName()).isEqualTo((Object)DB_NAME);
    }

    @Test
    public void updateDatabaseDdl() throws Exception {
        String opName = "projects/my-project/instances/my-instance/databases/my-db/operations/myop";
        String opId = "myop";
        ImmutableList ddl = ImmutableList.of();
        OperationFuture<Empty, UpdateDatabaseDdlMetadata> rawOperationFuture = OperationFutureUtil.immediateOperationFuture(opName, Empty.getDefaultInstance(), UpdateDatabaseDdlMetadata.getDefaultInstance());
        Mockito.when((Object)this.rpc.updateDatabaseDdl(DB_NAME, (Iterable)ddl, opId)).thenReturn(rawOperationFuture);
        OperationFuture op = this.client.updateDatabaseDdl(INSTANCE_ID, DB_ID, (Iterable)ddl, opId);
        Truth.assertThat((Boolean)op.isDone()).isTrue();
        Truth.assertThat((String)op.getName()).isEqualTo((Object)opName);
    }

    @Test
    public void updateDatabaseDdlOpAlreadyExists() throws Exception {
        String originalOpName = "projects/my-project/instances/my-instance/databases/my-db/operations/originalop";
        ImmutableList ddl = ImmutableList.of();
        OperationFuture<Empty, UpdateDatabaseDdlMetadata> originalOp = OperationFutureUtil.immediateOperationFuture(originalOpName, Empty.getDefaultInstance(), UpdateDatabaseDdlMetadata.getDefaultInstance());
        String newOpName = "projects/my-project/instances/my-instance/databases/my-db/operations/newop";
        String newOpId = "newop";
        OperationFuture<Empty, UpdateDatabaseDdlMetadata> newop = OperationFutureUtil.immediateOperationFuture(newOpName, Empty.getDefaultInstance(), UpdateDatabaseDdlMetadata.getDefaultInstance());
        Mockito.when((Object)this.rpc.updateDatabaseDdl(DB_NAME, (Iterable)ddl, newOpId)).thenReturn(originalOp);
        OperationFuture op = this.client.updateDatabaseDdl(INSTANCE_ID, DB_ID, (Iterable)ddl, newOpId);
        Truth.assertThat((String)op.getName()).isEqualTo((Object)originalOpName);
    }

    @Test
    public void dropDatabase() {
        this.client.dropDatabase(INSTANCE_ID, DB_ID);
        ((SpannerRpc)Mockito.verify((Object)this.rpc)).dropDatabase(DB_NAME);
    }

    @Test
    public void getDatabaseDdl() {
        ImmutableList ddl = ImmutableList.of((Object)"CREATE TABLE mytable()");
        Mockito.when((Object)this.rpc.getDatabaseDdl(DB_NAME)).thenReturn((Object)ddl);
        Truth.assertThat((Iterable)this.client.getDatabaseDdl(INSTANCE_ID, DB_ID)).isEqualTo((Object)ddl);
    }

    @Test
    public void listDatabases() {
        String pageToken = "token";
        Mockito.when((Object)this.rpc.listDatabases(INSTANCE_NAME, 1, null)).thenReturn((Object)new SpannerRpc.Paginated((Iterable)ImmutableList.of((Object)this.getDatabaseProto()), pageToken));
        Mockito.when((Object)this.rpc.listDatabases(INSTANCE_NAME, 1, pageToken)).thenReturn((Object)new SpannerRpc.Paginated((Iterable)ImmutableList.of((Object)this.getAnotherDatabaseProto()), ""));
        ArrayList dbs = Lists.newArrayList((Iterable)this.client.listDatabases(INSTANCE_ID, new Options.ListOption[]{Options.pageSize((int)1)}).iterateAll());
        Truth.assertThat((String)((Database)dbs.get(0)).getId().getName()).isEqualTo((Object)DB_NAME);
        Truth.assertThat((String)((Database)dbs.get(1)).getId().getName()).isEqualTo((Object)DB_NAME2);
        Truth.assertThat((Integer)dbs.size()).isEqualTo((Object)2);
    }
}

