/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.grpc.GrpcInterceptorProvider;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.TestEnvConfig;
import com.google.cloud.spanner.spi.v1.SpannerInterceptorProvider;
import com.google.common.base.Preconditions;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;

public class GceTestEnvConfig
implements TestEnvConfig {
    public static final String GCE_PROJECT_ID = "spanner.gce.config.project_id";
    public static final String GCE_SERVER_URL = "spanner.gce.config.server_url";
    public static final String GCE_STREAM_BROKEN_PROBABILITY = "spanner.gce.config.stream_broken_probability";
    private final SpannerOptions options;

    public GceTestEnvConfig() {
        String projectId = System.getProperty(GCE_PROJECT_ID, "");
        String serverUrl = System.getProperty(GCE_SERVER_URL, "");
        double errorProbability = Double.parseDouble(System.getProperty(GCE_STREAM_BROKEN_PROBABILITY, "0.0"));
        Preconditions.checkState((errorProbability <= 1.0 ? 1 : 0) != 0);
        SpannerOptions.Builder builder = SpannerOptions.newBuilder();
        if (!projectId.isEmpty()) {
            builder.setProjectId(projectId);
        }
        if (!serverUrl.isEmpty()) {
            builder.setHost(serverUrl);
        }
        this.options = builder.setInterceptorProvider((GrpcInterceptorProvider)SpannerInterceptorProvider.createDefault().with((ClientInterceptor)new GrpcErrorInjector(errorProbability))).build();
    }

    @Override
    public SpannerOptions spannerOptions() {
        return this.options;
    }

    @Override
    public void setUp() {
    }

    @Override
    public void tearDown() {
    }

    private static class GrpcErrorInjector
    implements ClientInterceptor {
        private final double errorProbability;
        private final Random random = new Random();

        GrpcErrorInjector(double errorProbability) {
            this.errorProbability = errorProbability;
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            if (!method.getFullMethodName().startsWith("google.spanner.v1.Spanner")) {
                return next.newCall(method, callOptions);
            }
            final AtomicBoolean errorInjected = new AtomicBoolean();
            final ClientCall clientCall = next.newCall(method, callOptions);
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(clientCall){

                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        public void onMessage(RespT message) {
                            super.onMessage(message);
                            if (GrpcErrorInjector.this.mayInjectError()) {
                                errorInjected.set(true);
                                clientCall.cancel("Cancelling call for injected error", null);
                            }
                        }

                        public void onClose(Status status, Metadata metadata) {
                            if (errorInjected.get()) {
                                status = Status.UNAVAILABLE.augmentDescription("INJECTED BY TEST");
                            }
                            super.onClose(status, metadata);
                        }
                    }, headers);
                }
            };
        }

        private boolean mayInjectError() {
            return this.random.nextDouble() < this.errorProbability;
        }
    }
}

