/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.InstanceId;
import com.google.common.truth.Truth;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class InstanceIdTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void basic() {
        String name = "projects/test-project/instances/test-instance";
        InstanceId instance = InstanceId.of((String)name);
        Truth.assertThat((String)instance.getProject()).isEqualTo((Object)"test-project");
        Truth.assertThat((String)instance.getInstance()).isEqualTo((Object)"test-instance");
        Truth.assertThat((String)instance.getName()).isEqualTo((Object)name);
        Truth.assertThat((Object)InstanceId.of((String)name)).isEqualTo((Object)instance);
        Truth.assertThat((Object)InstanceId.of((String)"test-project", (String)"test-instance")).isEqualTo((Object)instance);
        Truth.assertThat((Integer)InstanceId.of((String)name).hashCode()).isEqualTo((Object)instance.hashCode());
    }

    @Test
    public void badName() {
        this.expectedException.expect(IllegalArgumentException.class);
        InstanceId.of((String)"bad name");
    }
}

