/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerMatchers;
import com.google.common.truth.Truth;
import io.grpc.Context;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class SpannerImplRetryTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    StringCallable callable;

    @Before
    public void setUp() {
        this.callable = (StringCallable)Mockito.mock(StringCallable.class);
    }

    @Test
    public void ok() {
        Mockito.when((Object)this.callable.call()).thenReturn((Object)"r");
        Truth.assertThat((String)((String)SpannerImpl.runWithRetries((Callable)this.callable))).isEqualTo((Object)"r");
    }

    @Test
    public void nonRetryableFailure() {
        Mockito.when((Object)this.callable.call()).thenThrow(new Throwable[]{new NonRetryableException(ErrorCode.FAILED_PRECONDITION, "Failed by test")});
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.FAILED_PRECONDITION));
        SpannerImpl.runWithRetries((Callable)this.callable);
    }

    @Test
    public void retryableFailure() {
        Mockito.when((Object)this.callable.call()).thenThrow(new Throwable[]{new RetryableException(ErrorCode.UNAVAILABLE, "Failure #1")}).thenThrow(new Throwable[]{new RetryableException(ErrorCode.UNAVAILABLE, "Failure #2")}).thenThrow(new Throwable[]{new RetryableException(ErrorCode.UNAVAILABLE, "Failure #3")}).thenReturn((Object)"r");
        Truth.assertThat((String)((String)SpannerImpl.runWithRetries((Callable)this.callable))).isEqualTo((Object)"r");
    }

    @Test
    public void retryableFailureFollowedByPermanentFailure() {
        Mockito.when((Object)this.callable.call()).thenThrow(new Throwable[]{new RetryableException(ErrorCode.UNAVAILABLE, "Failure #1")}).thenThrow(new Throwable[]{new RetryableException(ErrorCode.UNAVAILABLE, "Failure #2")}).thenThrow(new Throwable[]{new RetryableException(ErrorCode.UNAVAILABLE, "Failure #3")}).thenThrow(new Throwable[]{new NonRetryableException(ErrorCode.FAILED_PRECONDITION, "Failed by test")});
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.FAILED_PRECONDITION));
        SpannerImpl.runWithRetries((Callable)this.callable);
    }

    @Test
    public void contextCancelled() {
        Mockito.when((Object)this.callable.call()).thenThrow(new Throwable[]{new RetryableException(ErrorCode.UNAVAILABLE, "Failure #1")});
        Context.CancellableContext context = Context.current().withCancellation();
        Runnable work = context.wrap(new Runnable(){

            @Override
            public void run() {
                SpannerImpl.runWithRetries((Callable)SpannerImplRetryTest.this.callable);
            }
        });
        context.cancel((Throwable)new RuntimeException("Cancelled by test"));
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.CANCELLED));
        work.run();
    }

    @Test
    public void contextDeadlineExceeded() {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        Context.CancellableContext context = Context.current().withDeadlineAfter(10L, TimeUnit.NANOSECONDS, executor);
        Mockito.when((Object)this.callable.call()).thenThrow(new Throwable[]{new RetryableException(ErrorCode.UNAVAILABLE, "Failure #1")});
        Runnable work = context.wrap(new Runnable(){

            @Override
            public void run() {
                SpannerImpl.runWithRetries((Callable)SpannerImplRetryTest.this.callable);
            }
        });
        this.expectedException.expect(SpannerMatchers.isSpannerException(ErrorCode.DEADLINE_EXCEEDED));
        work.run();
    }

    static class NonRetryableException
    extends SpannerException {
        NonRetryableException(ErrorCode code, @Nullable String message) {
            super(SpannerException.DoNotConstructDirectly.ALLOWED, code, false, message, null);
        }
    }

    static class RetryableException
    extends SpannerException {
        RetryableException(ErrorCode code, @Nullable String message) {
            super(SpannerException.DoNotConstructDirectly.ALLOWED, code, true, message, null);
        }
    }

    static interface StringCallable
    extends Callable<String> {
        @Override
        public String call();
    }
}

