/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.TransportOptions;
import com.google.cloud.spanner.SpannerOptions;
import com.google.common.truth.Truth;
import java.util.HashMap;
import java.util.Map;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class SpannerOptionsTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void defaultBuilder() {
        SpannerOptions options = ((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("test-project")).build();
        Truth.assertThat((String)options.getHost()).isEqualTo((Object)"https://spanner.googleapis.com");
        Truth.assertThat((Integer)options.getPrefetchChunks()).isEqualTo((Object)4);
        Truth.assertThat((Map)options.getSessionLabels()).isNull();
    }

    @Test
    public void builder() {
        String host = "http://localhost:8000/";
        String projectId = "test-project";
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("env", "dev");
        SpannerOptions options = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setHost(host)).setProjectId(projectId)).setPrefetchChunks(2).setSessionLabels(labels).build();
        Truth.assertThat((String)options.getHost()).isEqualTo((Object)host);
        Truth.assertThat((String)options.getProjectId()).isEqualTo((Object)projectId);
        Truth.assertThat((Integer)options.getPrefetchChunks()).isEqualTo((Object)2);
        Truth.assertThat((Map)options.getSessionLabels()).containsExactlyEntriesIn(labels);
    }

    @Test
    public void testInvalidTransport() {
        this.thrown.expect(IllegalArgumentException.class);
        SpannerOptions.newBuilder().setTransportOptions((TransportOptions)Mockito.mock(TransportOptions.class));
    }

    @Test
    public void testInvalidSessionLabels() {
        this.thrown.expect(NullPointerException.class);
        HashMap<String, Object> labels = new HashMap<String, Object>();
        labels.put("env", null);
        SpannerOptions.newBuilder().setSessionLabels(labels);
    }

    @Test
    public void testNullSessionLabels() {
        this.thrown.expect(NullPointerException.class);
        SpannerOptions.newBuilder().setSessionLabels(null);
    }
}

