/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.ValueBinder;
import com.google.common.collect.ImmutableMap;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.util.Map;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class StatementTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void basic() {
        String sql = "SELECT 1";
        Statement stmt = Statement.of((String)sql);
        Truth.assertThat((String)stmt.getSql()).isEqualTo((Object)sql);
        Truth.assertThat((Map)stmt.getParameters()).isEmpty();
        Truth.assertThat((String)stmt.toString()).isEqualTo((Object)sql);
        SerializableTester.reserializeAndAssert((Object)stmt);
    }

    @Test
    public void serialization() throws Exception {
        Statement stmt = ((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"SELECT * FROM table WHERE ").append("bool_field = @bool_field ").bind("bool_field").to(true)).append("long_field = @long_field ").bind("long_field").to(1L)).append("float_field = @float_field ").bind("float_field").to(1.0)).append("string_field = @string_field ").bind("string_field").to("abc")).append("bytes_field = @bytes_field ").bind("bytes_field").to(ByteArray.fromBase64((String)"abcd"))).build();
        SerializableTester.reserializeAndAssert((Object)stmt);
    }

    @Test
    public void append() {
        Statement stmt = ((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"SELECT Name FROM Users").append(" WHERE Id = @id").bind("id").to(1234L)).append(" AND Status = @status").bind("status").to("ACTIVE")).build();
        String expectedSql = "SELECT Name FROM Users WHERE Id = @id AND Status = @status";
        Truth.assertThat((String)stmt.getSql()).isEqualTo((Object)expectedSql);
        Truth.assertThat((Boolean)stmt.hasBinding("id")).isTrue();
        Truth.assertThat((Boolean)stmt.hasBinding("status")).isTrue();
        Truth.assertThat((Map)stmt.getParameters()).containsExactlyEntriesIn((Map)ImmutableMap.of((Object)"id", (Object)Value.int64((long)1234L), (Object)"status", (Object)Value.string((String)"ACTIVE")));
        Truth.assertThat((String)stmt.toString()).startsWith(expectedSql);
        Truth.assertThat((String)stmt.toString()).contains((CharSequence)"id: 1234");
        Truth.assertThat((String)stmt.toString()).contains((CharSequence)"status: ACTIVE");
    }

    @Test
    public void bindReplacement() {
        String sql = "SELECT Name FROM Users WHERE Id = @id";
        Statement stmt = ((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)sql).bind("id").to(1L)).bind("id").to(2L)).build();
        Truth.assertThat((Boolean)stmt.hasBinding("id")).isTrue();
        Truth.assertThat((String)stmt.getSql()).isEqualTo((Object)sql);
        Truth.assertThat((Map)stmt.getParameters()).isEqualTo((Object)ImmutableMap.of((Object)"id", (Object)Value.int64((long)2L)));
        Truth.assertThat((String)stmt.toString()).isEqualTo((Object)(sql + " {id: 2}"));
    }

    @Test
    public void incompleteBinding() {
        Statement.Builder builder = Statement.newBuilder((String)"SELECT @v");
        builder.bind("v");
        this.expectedException.expect(IllegalStateException.class);
        builder.build();
    }

    @Test
    public void bindingInProgress() {
        Statement.Builder builder = Statement.newBuilder((String)"SELECT @v");
        builder.bind("v");
        this.expectedException.expect(IllegalStateException.class);
        builder.bind("y");
    }

    @Test
    public void alreadyBound() {
        ValueBinder binder = Statement.newBuilder((String)"SELECT @v").bind("v");
        binder.to("abc");
        this.expectedException.expect(IllegalStateException.class);
        binder.to("xyz");
    }

    @Test
    public void bindCommitTimestampFails() {
        ValueBinder binder = Statement.newBuilder((String)"SELECT @v").bind("v");
        this.expectedException.expect(IllegalArgumentException.class);
        binder.to(Value.COMMIT_TIMESTAMP);
    }

    @Test
    public void gettersAreSnapshot() {
        Statement stmt = ((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"SELECT Name FROM Users WHERE Id = @id").append(" AND Status = @status").bind("status").to("ACTIVE")).bind("id").to(1234L)).bind("status").to("ACTIVE")).build();
        Truth.assertThat((String)stmt.getSql()).isEqualTo((Object)"SELECT Name FROM Users WHERE Id = @id AND Status = @status");
        Truth.assertThat((Map)stmt.getParameters()).isEqualTo((Object)ImmutableMap.of((Object)"id", (Object)Value.int64((long)1234L), (Object)"status", (Object)Value.string((String)"ACTIVE")));
    }

    @Test
    public void equalsAndHashCode() {
        EqualsTester tester = new EqualsTester();
        tester.addEqualityGroup(new Object[]{Statement.of((String)"SELECT 1"), Statement.of((String)"SELECT 1"), Statement.newBuilder((String)"SELECT ").append("1").build()});
        tester.addEqualityGroup(new Object[]{Statement.of((String)"SELECT 2")});
        tester.addEqualityGroup(new Object[]{((Statement.Builder)Statement.newBuilder((String)"SELECT @x, @y").bind("x").to(1L)).build(), ((Statement.Builder)Statement.newBuilder((String)"SELECT @x, @y").bind("x").to(1L)).build()});
        tester.addEqualityGroup(new Object[]{((Statement.Builder)Statement.newBuilder((String)"SELECT @x, @y").bind("x").to("1")).build()});
        tester.addEqualityGroup(new Object[]{((Statement.Builder)Statement.newBuilder((String)"SELECT @x, @y").bind("x").to(2L)).build()});
        tester.addEqualityGroup(new Object[]{((Statement.Builder)Statement.newBuilder((String)"SELECT @x, @y").bind("y").to(2L)).build()});
        tester.addEqualityGroup(new Object[]{((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"SELECT @x, @y").bind("x").to(1L)).bind("y").to(2L)).build()});
        tester.testEquals();
    }
}

