/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionManagerImpl;
import com.google.common.truth.Truth;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class TransactionManagerImplTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    @Mock
    private SpannerImpl.SessionImpl session;
    @Mock
    SpannerImpl.TransactionContextImpl txn;
    private TransactionManagerImpl manager;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.manager = new TransactionManagerImpl(this.session);
    }

    @Test
    public void beginCalledTwiceFails() {
        Mockito.when((Object)this.session.newTransaction()).thenReturn((Object)this.txn);
        Truth.assertThat((Object)this.manager.begin()).isEqualTo((Object)this.txn);
        Truth.assertThat((Comparable)this.manager.getState()).isEqualTo((Object)TransactionManager.TransactionState.STARTED);
        this.exception.expect(IllegalStateException.class);
        this.manager.begin();
    }

    @Test
    public void commitBeforeBeginFails() {
        this.exception.expect(IllegalStateException.class);
        this.manager.commit();
    }

    @Test
    public void rollbackBeforeBeginFails() {
        this.exception.expect(IllegalStateException.class);
        this.manager.rollback();
    }

    @Test
    public void resetBeforeBeginFails() {
        this.exception.expect(IllegalStateException.class);
        this.manager.resetForRetry();
    }

    @Test
    public void transactionRolledBackOnClose() {
        Mockito.when((Object)this.session.newTransaction()).thenReturn((Object)this.txn);
        Mockito.when((Object)this.txn.isAborted()).thenReturn((Object)false);
        this.manager.begin();
        this.manager.close();
        ((SpannerImpl.TransactionContextImpl)Mockito.verify((Object)this.txn)).rollback();
    }

    @Test
    public void commitSucceeds() {
        Mockito.when((Object)this.session.newTransaction()).thenReturn((Object)this.txn);
        Timestamp commitTimestamp = Timestamp.ofTimeMicroseconds((long)1L);
        Mockito.when((Object)this.txn.commitTimestamp()).thenReturn((Object)commitTimestamp);
        this.manager.begin();
        this.manager.commit();
        Truth.assertThat((Comparable)this.manager.getState()).isEqualTo((Object)TransactionManager.TransactionState.COMMITTED);
        Truth.assertThat((Comparable)this.manager.getCommitTimestamp()).isEqualTo((Object)commitTimestamp);
    }

    @Test
    public void resetAfterSuccessfulCommitFails() {
        Mockito.when((Object)this.session.newTransaction()).thenReturn((Object)this.txn);
        this.manager.begin();
        this.manager.commit();
        this.exception.expect(IllegalStateException.class);
        this.manager.resetForRetry();
    }

    @Test
    public void resetAfterAbortSucceeds() {
        Mockito.when((Object)this.session.newTransaction()).thenReturn((Object)this.txn);
        this.manager.begin();
        ((SpannerImpl.TransactionContextImpl)Mockito.doThrow((Throwable)SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.ABORTED, (String)"")).when((Object)this.txn)).commit();
        try {
            this.manager.commit();
            Assert.fail((String)"Expected AbortedException");
        }
        catch (AbortedException e) {
            Truth.assertThat((Comparable)this.manager.getState()).isEqualTo((Object)TransactionManager.TransactionState.ABORTED);
        }
        this.txn = (SpannerImpl.TransactionContextImpl)Mockito.mock(SpannerImpl.TransactionContextImpl.class);
        Mockito.when((Object)this.session.newTransaction()).thenReturn((Object)this.txn);
        Truth.assertThat((Object)this.manager.resetForRetry()).isEqualTo((Object)this.txn);
        Truth.assertThat((Comparable)this.manager.getState()).isEqualTo((Object)TransactionManager.TransactionState.STARTED);
    }

    @Test
    public void resetAfterErrorFails() {
        Mockito.when((Object)this.session.newTransaction()).thenReturn((Object)this.txn);
        this.manager.begin();
        ((SpannerImpl.TransactionContextImpl)Mockito.doThrow((Throwable)SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.UNKNOWN, (String)"")).when((Object)this.txn)).commit();
        try {
            this.manager.commit();
            Assert.fail((String)"Expected AbortedException");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.UNKNOWN);
        }
        this.exception.expect(IllegalStateException.class);
        this.manager.resetForRetry();
    }

    @Test
    public void rollbackAfterCommitFails() {
        Mockito.when((Object)this.session.newTransaction()).thenReturn((Object)this.txn);
        this.manager.begin();
        this.manager.commit();
        this.exception.expect(IllegalStateException.class);
        this.manager.rollback();
    }

    @Test
    public void commitAfterRollbackFails() {
        Mockito.when((Object)this.session.newTransaction()).thenReturn((Object)this.txn);
        this.manager.begin();
        this.manager.rollback();
        this.exception.expect(IllegalStateException.class);
        this.manager.commit();
    }
}

