/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.client.util.BackOff;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.truth.Truth;
import io.grpc.Context;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class TransactionRunnerImplTest {
    @Mock
    private SpannerRpc rpc;
    @Mock
    private SpannerImpl.SessionImpl session;
    @Mock
    private SpannerImpl.TransactionRunnerImpl.Sleeper sleeper;
    @Mock
    private SpannerImpl.TransactionContextImpl txn;
    private SpannerImpl.TransactionRunnerImpl transactionRunner;
    private boolean firstRun;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.firstRun = true;
        Mockito.when((Object)this.session.newTransaction()).thenReturn((Object)this.txn);
        this.transactionRunner = new SpannerImpl.TransactionRunnerImpl(this.session, this.rpc, this.sleeper, 1);
    }

    @Test
    public void commitSucceeds() {
        final AtomicInteger numCalls = new AtomicInteger(0);
        this.transactionRunner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Void>(){

            public Void run(TransactionContext transaction) throws Exception {
                numCalls.incrementAndGet();
                return null;
            }
        });
        Truth.assertThat((Integer)numCalls.get()).isEqualTo((Object)1);
        ((SpannerImpl.TransactionContextImpl)Mockito.verify((Object)this.txn)).ensureTxn();
        ((SpannerImpl.TransactionContextImpl)Mockito.verify((Object)this.txn)).commit();
    }

    @Test
    public void runAbort() {
        Mockito.when((Object)this.txn.isAborted()).thenReturn((Object)true);
        long backoffMillis = 100L;
        Mockito.when((Object)this.txn.getRetryDelayInMillis((BackOff)Mockito.any(BackOff.class))).thenReturn((Object)backoffMillis);
        this.runTransaction((Exception)((Object)SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.ABORTED, (String)"")));
        ((SpannerImpl.TransactionRunnerImpl.Sleeper)Mockito.verify((Object)this.sleeper, (VerificationMode)Mockito.times((int)1))).backoffSleep((Context)Mockito.any(Context.class), Mockito.eq((long)backoffMillis));
    }

    @Test
    public void commitAbort() {
        SpannerException error = SpannerExceptionFactory.newSpannerException((Throwable)SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.ABORTED, (String)""));
        ((SpannerImpl.TransactionContextImpl)Mockito.doThrow((Throwable)error).doNothing().when((Object)this.txn)).commit();
        long backoffMillis = 100L;
        Mockito.when((Object)this.txn.getRetryDelayInMillis((BackOff)Mockito.any(BackOff.class))).thenReturn((Object)backoffMillis);
        final AtomicInteger numCalls = new AtomicInteger(0);
        this.transactionRunner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Void>(){

            public Void run(TransactionContext transaction) throws Exception {
                numCalls.incrementAndGet();
                return null;
            }
        });
        Truth.assertThat((Integer)numCalls.get()).isEqualTo((Object)2);
        ((SpannerImpl.TransactionRunnerImpl.Sleeper)Mockito.verify((Object)this.sleeper, (VerificationMode)Mockito.times((int)1))).backoffSleep((Context)Mockito.any(Context.class), Mockito.eq((long)backoffMillis));
        ((SpannerImpl.TransactionContextImpl)Mockito.verify((Object)this.txn, (VerificationMode)Mockito.times((int)2))).ensureTxn();
    }

    @Test
    public void commitFailsWithNonAbort() {
        SpannerException error = SpannerExceptionFactory.newSpannerException((Throwable)SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.UNKNOWN, (String)""));
        ((SpannerImpl.TransactionContextImpl)Mockito.doThrow((Throwable)error).when((Object)this.txn)).commit();
        final AtomicInteger numCalls = new AtomicInteger(0);
        try {
            this.transactionRunner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Void>(){

                public Void run(TransactionContext transaction) throws Exception {
                    numCalls.incrementAndGet();
                    return null;
                }
            });
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.UNKNOWN);
        }
        Truth.assertThat((Integer)numCalls.get()).isEqualTo((Object)1);
        ((SpannerImpl.TransactionContextImpl)Mockito.verify((Object)this.txn, (VerificationMode)Mockito.times((int)1))).ensureTxn();
        ((SpannerImpl.TransactionContextImpl)Mockito.verify((Object)this.txn, (VerificationMode)Mockito.times((int)1))).commit();
    }

    @Test
    public void runResourceExhaustedNoRetry() throws Exception {
        try {
            this.runTransaction((Exception)new StatusRuntimeException(Status.fromCodeValue((int)Status.Code.RESOURCE_EXHAUSTED.value())));
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException spannerException) {
            // empty catch block
        }
        ((SpannerImpl.TransactionContextImpl)Mockito.verify((Object)this.txn)).rollback();
    }

    private void runTransaction(final Exception exception) {
        this.transactionRunner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Void>(){

            public Void run(TransactionContext transaction) throws Exception {
                if (TransactionRunnerImplTest.this.firstRun) {
                    TransactionRunnerImplTest.this.firstRun = false;
                    throw SpannerExceptionFactory.newSpannerException((Throwable)exception);
                }
                return null;
            }
        });
    }
}

