/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.IntegrationTest;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.common.truth.Truth;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={IntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITTransactionManagerTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static Database db;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static DatabaseClient client;

    @BeforeClass
    public static void setUpDatabase() {
        db = env.getTestHelper().createTestDatabase(new String[]{"CREATE TABLE T (  K                   STRING(MAX) NOT NULL,  BoolValue           BOOL,) PRIMARY KEY (K)"});
        client = env.getTestHelper().getDatabaseClient(db);
    }

    @Test
    public void simpleInsert() {
        TransactionManager manager = client.transactionManager();
        TransactionContext txn = manager.begin();
        Truth.assertThat((Comparable)manager.getState()).isEqualTo((Object)TransactionManager.TransactionState.STARTED);
        txn.buffer(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("K").to("Key1")).set("BoolValue").to(true)).build());
        manager.commit();
        Truth.assertThat((Comparable)manager.getState()).isEqualTo((Object)TransactionManager.TransactionState.COMMITTED);
        Struct row = client.singleUse().readRow("T", Key.of((Object[])new Object[]{"Key1"}), Arrays.asList("K", "BoolValue"));
        Truth.assertThat((String)row.getString(0)).isEqualTo((Object)"Key1");
        Truth.assertThat((Boolean)row.getBoolean(1)).isTrue();
    }

    @Test
    public void invalidInsert() {
        TransactionManager manager = client.transactionManager();
        TransactionContext txn = manager.begin();
        txn.buffer(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"InvalidTable").set("K").to("Key1")).set("BoolValue").to(true)).build());
        try {
            manager.commit();
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException spannerException) {
            // empty catch block
        }
        Truth.assertThat((Comparable)manager.getState()).isEqualTo((Object)TransactionManager.TransactionState.COMMIT_FAILED);
        this.expectedException.expect(IllegalStateException.class);
        manager.resetForRetry();
    }

    @Test
    public void rollback() {
        TransactionManager manager = client.transactionManager();
        TransactionContext txn = manager.begin();
        txn.buffer(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("K").to("Key2")).set("BoolValue").to(true)).build());
        manager.rollback();
        Truth.assertThat((Comparable)manager.getState()).isEqualTo((Object)TransactionManager.TransactionState.ROLLED_BACK);
        Truth.assertThat((Object)client.singleUse().readRow("T", Key.of((Object[])new Object[]{"Key2"}), Arrays.asList("K", "BoolValue"))).isNull();
    }

    @Test
    public void abortAndRetry() {
        client.write(Arrays.asList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("K").to("Key3")).set("BoolValue").to(true)).build()));
        TransactionManager manager1 = client.transactionManager();
        TransactionContext txn1 = manager1.begin();
        txn1.readRow("T", Key.of((Object[])new Object[]{"Key3"}), Arrays.asList("K", "BoolValue"));
        TransactionManager manager2 = client.transactionManager();
        TransactionContext txn2 = manager2.begin();
        txn2.readRow("T", Key.of((Object[])new Object[]{"Key3"}), Arrays.asList("K", "BoolValue"));
        txn1.buffer(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newUpdateBuilder((String)"T").set("K").to("Key3")).set("BoolValue").to(false)).build());
        manager1.commit();
        try {
            manager2.commit();
            Assert.fail((String)"Expected to abort");
        }
        catch (AbortedException e) {
            Truth.assertThat((Comparable)manager2.getState()).isEqualTo((Object)TransactionManager.TransactionState.ABORTED);
            txn2 = manager2.resetForRetry();
        }
        txn2.buffer(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newUpdateBuilder((String)"T").set("K").to("Key3")).set("BoolValue").to(true)).build());
        manager2.commit();
        Struct row = client.singleUse().readRow("T", Key.of((Object[])new Object[]{"Key3"}), Arrays.asList("K", "BoolValue"));
        Truth.assertThat((String)row.getString(0)).isEqualTo((Object)"Key3");
        Truth.assertThat((Boolean)row.getBoolean(1)).isTrue();
    }
}

