/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.core.ExecutorProvider;
import com.google.cloud.spanner.AbstractReadContext;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.truth.Truth;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.TransactionSelector;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class AbstractReadContextTest {
    @Parameterized.Parameter(value=0)
    public ExecuteSqlRequest.QueryOptions defaultQueryOptions;
    private TestReadContext context;

    @Parameterized.Parameters(name="SpannerOptions.DefaultQueryOptions = {0}")
    public static Collection<Object[]> parameters() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{ExecuteSqlRequest.QueryOptions.getDefaultInstance()});
        params.add(new Object[]{ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("some-version").build()});
        return params;
    }

    @Before
    public void setup() {
        SessionImpl session = (SessionImpl)Mockito.mock(SessionImpl.class);
        Mockito.when((Object)session.getName()).thenReturn((Object)"session-1");
        TestReadContextBuilder builder = new TestReadContextBuilder();
        this.context = ((TestReadContextBuilder)((TestReadContextBuilder)((TestReadContextBuilder)((TestReadContextBuilder)builder.setSession(session)).setRpc((SpannerRpc)Mockito.mock(SpannerRpc.class))).setDefaultQueryOptions(this.defaultQueryOptions)).setExecutorProvider((ExecutorProvider)Mockito.mock(ExecutorProvider.class))).build();
    }

    @Test
    public void executeSqlRequestBuilderWithoutQueryOptions() {
        ExecuteSqlRequest request = this.context.getExecuteSqlRequestBuilder(Statement.of((String)"SELECT FOO FROM BAR"), ExecuteSqlRequest.QueryMode.NORMAL, Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[0]), true).build();
        Truth.assertThat((String)request.getSql()).isEqualTo((Object)"SELECT FOO FROM BAR");
        Truth.assertThat((Object)request.getQueryOptions()).isEqualTo((Object)this.defaultQueryOptions);
    }

    @Test
    public void executeSqlRequestBuilderWithQueryOptions() {
        ExecuteSqlRequest request = this.context.getExecuteSqlRequestBuilder(Statement.newBuilder((String)"SELECT FOO FROM BAR").withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("2.0").build()).build(), ExecuteSqlRequest.QueryMode.NORMAL, Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[0]), true).build();
        Truth.assertThat((String)request.getSql()).isEqualTo((Object)"SELECT FOO FROM BAR");
        Truth.assertThat((String)request.getQueryOptions().getOptimizerVersion()).isEqualTo((Object)"2.0");
    }

    private final class TestReadContext
    extends AbstractReadContext {
        TestReadContext(TestReadContextBuilder builder) {
            super((AbstractReadContext.Builder)builder);
        }

        TransactionSelector getTransactionSelector() {
            return TransactionSelector.getDefaultInstance();
        }
    }

    class TestReadContextBuilder
    extends AbstractReadContext.Builder<TestReadContextBuilder, TestReadContext> {
        TestReadContextBuilder() {
        }

        TestReadContext build() {
            return new TestReadContext(this);
        }
    }
}

