/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.spanner.AsyncRunner;
import com.google.cloud.spanner.AsyncRunnerImpl;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.TransactionRunnerImpl;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Matchers;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class AsyncRunnerImplTest {
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();

    @AfterClass
    public static void teardown() {
        executor.shutdown();
    }

    @Test
    public void testAsyncRunReturnsResultAndCommitResponse() {
        final Object expectedResult = new Object();
        CommitResponse expectedCommitResponse = (CommitResponse)Mockito.mock(CommitResponse.class);
        TransactionRunnerImpl delegate = (TransactionRunnerImpl)Mockito.mock(TransactionRunnerImpl.class);
        Mockito.when((Object)delegate.run((TransactionRunner.TransactionCallable)Matchers.any(TransactionRunner.TransactionCallable.class))).thenReturn(expectedResult);
        Mockito.when((Object)delegate.getCommitResponse()).thenReturn((Object)expectedCommitResponse);
        AsyncRunnerImpl runner = new AsyncRunnerImpl(delegate);
        ApiFuture result = runner.runAsync((AsyncRunner.AsyncWork)new AsyncRunner.AsyncWork<Object>(){

            public ApiFuture<Object> doWorkAsync(TransactionContext txn) {
                return ApiFutures.immediateFuture((Object)expectedResult);
            }
        }, (Executor)executor);
        Assert.assertSame((Object)expectedResult, (Object)SpannerApiFutures.get((ApiFuture)result));
        Assert.assertSame((Object)expectedCommitResponse, (Object)SpannerApiFutures.get((ApiFuture)runner.getCommitResponse()));
        Assert.assertEquals((Object)((CommitResponse)SpannerApiFutures.get((ApiFuture)runner.getCommitResponse())).getCommitTimestamp(), (Object)SpannerApiFutures.get((ApiFuture)runner.getCommitTimestamp()));
    }

    @Test
    public void testGetCommitTimestampReturnsErrorBeforeRun() {
        TransactionRunnerImpl delegate = (TransactionRunnerImpl)Mockito.mock(TransactionRunnerImpl.class);
        AsyncRunnerImpl runner = new AsyncRunnerImpl(delegate);
        try {
            runner.getCommitTimestamp();
            Assert.fail((String)"missing expected exception");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("runAsync() has not yet been called"));
        }
    }

    @Test
    public void testGetCommitResponseReturnsErrorBeforeRun() {
        TransactionRunnerImpl delegate = (TransactionRunnerImpl)Mockito.mock(TransactionRunnerImpl.class);
        AsyncRunnerImpl runner = new AsyncRunnerImpl(delegate);
        try {
            runner.getCommitResponse();
            Assert.fail((String)"missing expected exception");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("runAsync() has not yet been called"));
        }
    }

    @Test
    public void testGetCommitResponseReturnsErrorIfRunFails() {
        final SpannerException expectedException = SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.ALREADY_EXISTS, (String)"Row already exists");
        TransactionRunnerImpl delegate = (TransactionRunnerImpl)Mockito.mock(TransactionRunnerImpl.class);
        Mockito.when((Object)delegate.getCommitResponse()).thenThrow(new Throwable[]{expectedException});
        AsyncRunnerImpl runner = new AsyncRunnerImpl(delegate);
        runner.runAsync((AsyncRunner.AsyncWork)new AsyncRunner.AsyncWork<Void>(){

            public ApiFuture<Void> doWorkAsync(TransactionContext txn) {
                return ApiFutures.immediateFailedFuture((Throwable)expectedException);
            }
        }, (Executor)executor);
        try {
            SpannerApiFutures.get((ApiFuture)runner.getCommitResponse());
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerException e) {
            Assert.assertSame((Object)((Object)expectedException), (Object)((Object)e));
        }
    }

    @Test
    public void testRunAyncFailsIfCalledMultipleTimes() {
        final Object result = new Object();
        TransactionRunnerImpl delegate = (TransactionRunnerImpl)Mockito.mock(TransactionRunnerImpl.class);
        Mockito.when((Object)delegate.run((TransactionRunner.TransactionCallable)Matchers.any(TransactionRunner.TransactionCallable.class))).thenReturn(result);
        AsyncRunnerImpl runner = new AsyncRunnerImpl(delegate);
        runner.runAsync((AsyncRunner.AsyncWork)new AsyncRunner.AsyncWork<Object>(){

            public ApiFuture<Object> doWorkAsync(TransactionContext txn) {
                return ApiFutures.immediateFuture((Object)result);
            }
        }, (Executor)executor);
        try {
            runner.runAsync((AsyncRunner.AsyncWork)new AsyncRunner.AsyncWork<Object>(){

                public ApiFuture<Object> doWorkAsync(TransactionContext txn) {
                    return ApiFutures.immediateFuture(null);
                }
            }, (Executor)executor);
            Assert.fail((String)"missing expected exception");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("runAsync() can only be called once"));
        }
    }
}

