/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFutures;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SessionPool;
import com.google.protobuf.Empty;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.mockito.Mockito;
import org.threeten.bp.Instant;

abstract class BaseSessionPoolTest {
    ScheduledExecutorService mockExecutor;
    int sessionIndex;

    BaseSessionPoolTest() {
    }

    SessionImpl mockSession() {
        SessionImpl session = (SessionImpl)Mockito.mock(SessionImpl.class);
        Mockito.when((Object)session.getName()).thenReturn((Object)("projects/dummy/instances/dummy/database/dummy/sessions/session" + this.sessionIndex));
        Mockito.when((Object)session.asyncClose()).thenReturn((Object)ApiFutures.immediateFuture((Object)Empty.getDefaultInstance()));
        Mockito.when((Object)session.writeWithOptions((Iterable)Mockito.any(Iterable.class), new Options.TransactionOption[0])).thenReturn((Object)new CommitResponse(com.google.spanner.v1.CommitResponse.getDefaultInstance()));
        Mockito.when((Object)session.writeAtLeastOnceWithOptions((Iterable)Mockito.any(Iterable.class), new Options.TransactionOption[0])).thenReturn((Object)new CommitResponse(com.google.spanner.v1.CommitResponse.getDefaultInstance()));
        ++this.sessionIndex;
        return session;
    }

    void runMaintainanceLoop(FakeClock clock, SessionPool pool, long numCycles) {
        int i = 0;
        while ((long)i < numCycles) {
            pool.poolMaintainer.maintainPool();
            clock.currentTimeMillis += pool.poolMaintainer.loopFrequency;
            ++i;
        }
    }

    static class FakeClock
    extends SessionPool.Clock {
        volatile long currentTimeMillis;

        FakeClock() {
        }

        public Instant instant() {
            return Instant.ofEpochMilli((long)this.currentTimeMillis);
        }
    }

    final class TestExecutorFactory
    implements GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService> {
        TestExecutorFactory() {
        }

        public ScheduledExecutorService get() {
            ScheduledThreadPoolExecutor realExecutor = new ScheduledThreadPoolExecutor(2);
            BaseSessionPoolTest.this.mockExecutor = (ScheduledExecutorService)Mockito.spy((Object)realExecutor);
            ScheduledFuture mockFuture = (ScheduledFuture)Mockito.mock(ScheduledFuture.class);
            ((ScheduledExecutorService)Mockito.doReturn((Object)mockFuture).when((Object)BaseSessionPoolTest.this.mockExecutor)).scheduleAtFixedRate((Runnable)Mockito.any(Runnable.class), Mockito.anyLong(), Mockito.anyLong(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)));
            return BaseSessionPoolTest.this.mockExecutor;
        }

        public void release(ScheduledExecutorService executor) {
            executor.shutdown();
        }
    }
}

