/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.Identity;
import com.google.cloud.Policy;
import com.google.cloud.Role;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Backup;
import com.google.cloud.spanner.BackupId;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.DatabaseInfo;
import com.google.cloud.spanner.Options;
import com.google.common.truth.Truth;
import com.google.spanner.admin.database.v1.Database;
import java.util.Arrays;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@RunWith(value=JUnit4.class)
public class DatabaseTest {
    private static final String NAME = "projects/test-project/instances/test-instance/databases/database-1";
    private static final Timestamp EARLIEST_VERSION_TIME = Timestamp.now();
    private static final String VERSION_RETENTION_PERIOD = "7d";
    @Mock
    DatabaseAdminClient dbClient;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.dbClient.newBackupBuilder((BackupId)Mockito.any(BackupId.class))).thenAnswer((Answer)new Answer<Backup.Builder>(){

            public Backup.Builder answer(InvocationOnMock invocation) {
                return new Backup.Builder(DatabaseTest.this.dbClient, (BackupId)invocation.getArguments()[0]);
            }
        });
    }

    @Test
    public void backup() {
        Timestamp expireTime = Timestamp.now();
        Database db = this.createDatabase();
        Backup backup = this.dbClient.newBackupBuilder(BackupId.of((String)"test-project", (String)"test-instance", (String)"test-backup")).setExpireTime(expireTime).build();
        db.backup(backup);
        ((DatabaseAdminClient)Mockito.verify((Object)this.dbClient)).createBackup(backup.toBuilder().setDatabase(db.getId()).build());
    }

    @Test
    public void listDatabaseOperations() {
        Database db = this.createDatabase();
        db.listDatabaseOperations();
        ((DatabaseAdminClient)Mockito.verify((Object)this.dbClient)).listDatabaseOperations("test-instance", new Options.ListOption[]{Options.filter((String)"name:databases/database-1")});
    }

    @Test
    public void fromProto() {
        Database db = this.createDatabase();
        Truth.assertThat((String)db.getId().getName()).isEqualTo((Object)NAME);
        Truth.assertThat((Comparable)db.getState()).isEqualTo((Object)DatabaseInfo.State.CREATING);
        Truth.assertThat((String)db.getVersionRetentionPeriod()).isEqualTo((Object)VERSION_RETENTION_PERIOD);
        Truth.assertThat((Comparable)db.getEarliestVersionTime()).isEqualTo((Object)EARLIEST_VERSION_TIME);
    }

    @Test
    public void getIAMPolicy() {
        Database database = new Database(DatabaseId.of((String)"test-project", (String)"test-instance", (String)"test-database"), DatabaseInfo.State.READY, this.dbClient);
        database.getIAMPolicy();
        ((DatabaseAdminClient)Mockito.verify((Object)this.dbClient)).getDatabaseIAMPolicy("test-instance", "test-database");
    }

    @Test
    public void setIAMPolicy() {
        Database database = new Database(DatabaseId.of((String)"test-project", (String)"test-instance", (String)"test-database"), DatabaseInfo.State.READY, this.dbClient);
        Policy policy = Policy.newBuilder().addIdentity(Role.editor(), Identity.user((String)"joe@example.com"), new Identity[0]).build();
        database.setIAMPolicy(policy);
        ((DatabaseAdminClient)Mockito.verify((Object)this.dbClient)).setDatabaseIAMPolicy("test-instance", "test-database", policy);
    }

    @Test
    public void testIAMPermissions() {
        Database database = new Database(DatabaseId.of((String)"test-project", (String)"test-instance", (String)"test-database"), DatabaseInfo.State.READY, this.dbClient);
        List<String> permissions = Arrays.asList("read");
        database.testIAMPermissions(permissions);
        ((DatabaseAdminClient)Mockito.verify((Object)this.dbClient)).testDatabaseIAMPermissions("test-instance", "test-database", permissions);
    }

    private Database createDatabase() {
        com.google.spanner.admin.database.v1.Database proto = com.google.spanner.admin.database.v1.Database.newBuilder().setName(NAME).setState(Database.State.CREATING).setEarliestVersionTime(EARLIEST_VERSION_TIME.toProto()).setVersionRetentionPeriod(VERSION_RETENTION_PERIOD).build();
        return Database.fromProto((com.google.spanner.admin.database.v1.Database)proto, (DatabaseAdminClient)this.dbClient);
    }
}

