/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.grpc.testing.MockGrpcService;
import com.google.cloud.spanner.MockOperationsServiceImpl;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.google.spanner.admin.database.v1.Backup;
import com.google.spanner.admin.database.v1.BackupInfo;
import com.google.spanner.admin.database.v1.CreateBackupMetadata;
import com.google.spanner.admin.database.v1.CreateBackupRequest;
import com.google.spanner.admin.database.v1.CreateDatabaseMetadata;
import com.google.spanner.admin.database.v1.CreateDatabaseRequest;
import com.google.spanner.admin.database.v1.Database;
import com.google.spanner.admin.database.v1.DatabaseAdminGrpc;
import com.google.spanner.admin.database.v1.DeleteBackupRequest;
import com.google.spanner.admin.database.v1.DropDatabaseRequest;
import com.google.spanner.admin.database.v1.GetBackupRequest;
import com.google.spanner.admin.database.v1.GetDatabaseDdlRequest;
import com.google.spanner.admin.database.v1.GetDatabaseDdlResponse;
import com.google.spanner.admin.database.v1.GetDatabaseRequest;
import com.google.spanner.admin.database.v1.ListBackupOperationsRequest;
import com.google.spanner.admin.database.v1.ListBackupOperationsResponse;
import com.google.spanner.admin.database.v1.ListBackupsRequest;
import com.google.spanner.admin.database.v1.ListBackupsResponse;
import com.google.spanner.admin.database.v1.ListDatabaseOperationsRequest;
import com.google.spanner.admin.database.v1.ListDatabaseOperationsResponse;
import com.google.spanner.admin.database.v1.ListDatabasesRequest;
import com.google.spanner.admin.database.v1.ListDatabasesResponse;
import com.google.spanner.admin.database.v1.OperationProgress;
import com.google.spanner.admin.database.v1.OptimizeRestoredDatabaseMetadata;
import com.google.spanner.admin.database.v1.RestoreDatabaseMetadata;
import com.google.spanner.admin.database.v1.RestoreDatabaseRequest;
import com.google.spanner.admin.database.v1.RestoreInfo;
import com.google.spanner.admin.database.v1.RestoreSourceType;
import com.google.spanner.admin.database.v1.UpdateBackupRequest;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MockDatabaseAdminServiceImpl
extends DatabaseAdminGrpc.DatabaseAdminImplBase
implements MockGrpcService {
    private final Queue<AbstractMessage> requests = new ConcurrentLinkedQueue<AbstractMessage>();
    private ConcurrentMap<String, Policy> policies = new ConcurrentHashMap<String, Policy>();
    private static final String EXPIRE_TIME_MASK = "expire_time";
    private static final Random RND = new Random();
    private final Queue<Exception> exceptions = new ConcurrentLinkedQueue<Exception>();
    private volatile CountDownLatch freezeLock = new CountDownLatch(0);
    private final ConcurrentMap<String, MockDatabase> databases = new ConcurrentHashMap<String, MockDatabase>();
    private final ConcurrentMap<String, MockBackup> backups = new ConcurrentHashMap<String, MockBackup>();
    private final ConcurrentMap<String, Set<String>> filterMatches = new ConcurrentHashMap<String, Set<String>>();
    private final MockOperationsServiceImpl operations;
    private long createBackupOperationExecutionTime;
    private long restoreDatabaseOperationExecutionTime;
    private long optimizeDatabaseOperationExecutionTime;
    private MockSpannerServiceImpl.SimulatedExecutionTime createBackupStartupExecutionTime = MockSpannerServiceImpl.SimulatedExecutionTime.none();
    private MockSpannerServiceImpl.SimulatedExecutionTime createBackupResponseExecutionTime = MockSpannerServiceImpl.SimulatedExecutionTime.none();
    private MockSpannerServiceImpl.SimulatedExecutionTime createDatabaseStartupExecutionTime = MockSpannerServiceImpl.SimulatedExecutionTime.none();
    private MockSpannerServiceImpl.SimulatedExecutionTime createDatabaseResponseExecutionTime = MockSpannerServiceImpl.SimulatedExecutionTime.none();
    private MockSpannerServiceImpl.SimulatedExecutionTime restoreDatabaseStartupExecutionTime = MockSpannerServiceImpl.SimulatedExecutionTime.none();
    private MockSpannerServiceImpl.SimulatedExecutionTime restoreDatabaseResponseExecutionTime = MockSpannerServiceImpl.SimulatedExecutionTime.none();

    private com.google.rpc.Status fromException(Exception e) {
        int code = 2;
        if (e instanceof InterruptedException) {
            code = 1;
        }
        return com.google.rpc.Status.newBuilder().setCode(code).setMessage(e.getMessage()).build();
    }

    public MockDatabaseAdminServiceImpl(MockOperationsServiceImpl operations) {
        this.operations = operations;
    }

    public void createDatabase(CreateDatabaseRequest request, StreamObserver<Operation> responseObserver) {
        this.requests.add((AbstractMessage)request);
        try {
            MockDatabase db;
            String name;
            this.createDatabaseStartupExecutionTime.simulateExecutionTime(this.exceptions, false, this.freezeLock);
            String id = request.getCreateStatement().replace("CREATE DATABASE ", "");
            if (id.startsWith("`") && id.endsWith("`")) {
                id = id.substring(1, id.length() - 1);
            }
            if (this.databases.putIfAbsent(name = String.format("%s/databases/%s", request.getParent(), id), db = new MockDatabase(name, (List)request.getExtraStatementsList(), null)) == null) {
                CreateDatabaseMetadata metadata = CreateDatabaseMetadata.newBuilder().setDatabase(name).build();
                Database database = Database.newBuilder().setName(name).setState(db.state).build();
                Operation operation = Operation.newBuilder().setMetadata(Any.pack((Message)metadata)).setResponse(Any.pack((Message)database)).setDone(false).setName(this.operations.generateOperationName(name)).build();
                this.operations.addOperation(operation, new CreateDatabaseCallable(operation.getName(), name));
                this.createDatabaseResponseExecutionTime.simulateExecutionTime(this.exceptions, false, this.freezeLock);
                responseObserver.onNext((Object)operation);
                responseObserver.onCompleted();
            } else {
                responseObserver.onError((Throwable)Status.ALREADY_EXISTS.withDescription(String.format("Database with name %s already exists", name)).asRuntimeException());
            }
        }
        catch (Throwable t) {
            responseObserver.onError(t);
        }
    }

    public void dropDatabase(DropDatabaseRequest request, StreamObserver<Empty> responseObserver) {
        this.requests.add((AbstractMessage)request);
        MockDatabase db = (MockDatabase)this.databases.get(request.getDatabase());
        if (this.databases.remove(request.getDatabase(), db)) {
            responseObserver.onNext((Object)Empty.getDefaultInstance());
            responseObserver.onCompleted();
        } else {
            responseObserver.onError((Throwable)Status.NOT_FOUND.asRuntimeException());
        }
    }

    public void getDatabase(GetDatabaseRequest request, StreamObserver<Database> responseObserver) {
        this.requests.add((AbstractMessage)request);
        MockDatabase db = (MockDatabase)this.databases.get(request.getName());
        if (db != null) {
            responseObserver.onNext((Object)Database.newBuilder().setName(request.getName()).setCreateTime(db.createTime).setState(Database.State.READY).build());
            responseObserver.onCompleted();
        } else {
            responseObserver.onError((Throwable)Status.NOT_FOUND.asRuntimeException());
        }
    }

    public void getDatabaseDdl(GetDatabaseDdlRequest request, StreamObserver<GetDatabaseDdlResponse> responseObserver) {
        this.requests.add((AbstractMessage)request);
        MockDatabase db = (MockDatabase)this.databases.get(request.getDatabase());
        if (db != null) {
            responseObserver.onNext((Object)GetDatabaseDdlResponse.newBuilder().addAllStatements((Iterable)db.ddl).build());
            responseObserver.onCompleted();
        } else {
            responseObserver.onError((Throwable)Status.NOT_FOUND.asRuntimeException());
        }
    }

    public void listDatabases(ListDatabasesRequest request, StreamObserver<ListDatabasesResponse> responseObserver) {
        this.requests.add((AbstractMessage)request);
        ArrayList<Database> dbs = new ArrayList<Database>(this.databases.size());
        for (Map.Entry entry : this.databases.entrySet()) {
            dbs.add(Database.newBuilder().setName((String)entry.getKey()).setCreateTime(((MockDatabase)entry.getValue()).createTime).setState(Database.State.READY).build());
        }
        responseObserver.onNext((Object)ListDatabasesResponse.newBuilder().addAllDatabases(dbs).build());
        responseObserver.onCompleted();
    }

    public void listDatabaseOperations(ListDatabaseOperationsRequest request, StreamObserver<ListDatabaseOperationsResponse> responseObserver) {
        this.requests.add((AbstractMessage)request);
        ListDatabaseOperationsResponse.Builder builder = ListDatabaseOperationsResponse.newBuilder();
        try {
            for (Operation op : this.operations.iterable()) {
                if (!op.getName().matches(".*?/databases\\/.*?/operations/.*?") || !op.getName().startsWith(request.getParent()) || !this.matchesFilter(op, request.getFilter())) continue;
                builder.addOperations(op);
            }
            responseObserver.onNext((Object)builder.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            responseObserver.onError((Throwable)e);
        }
    }

    private boolean matchesFilter(Object obj, String filter) throws Exception {
        if (!Strings.isNullOrEmpty((String)filter)) {
            Set matches = (Set)this.filterMatches.get(filter);
            if (matches != null) {
                String name = (String)obj.getClass().getMethod("getName", new Class[0]).invoke(obj, new Object[0]);
                return matches.contains(name);
            }
            if (obj instanceof Operation) {
                Operation operation = (Operation)obj;
                Pattern pattern = Pattern.compile("(?:\\(metadata.@type:type.googleapis.com/(.*)\\)) AND (?:\\(metadata.(?:name|database):(.*)\\)|\\(name:(.*)/operations/\\))");
                Matcher matcher = pattern.matcher(filter);
                if (matcher.matches()) {
                    Any anyMetadata;
                    String type = matcher.group(1);
                    String objectName = matcher.group(2);
                    if (objectName == null) {
                        objectName = matcher.group(3);
                    }
                    if ((anyMetadata = operation.getMetadata()).getTypeUrl().endsWith(type)) {
                        if (type.equals(CreateBackupMetadata.getDescriptor().getFullName())) {
                            CreateBackupMetadata metadata = (CreateBackupMetadata)operation.getMetadata().unpack(CreateBackupMetadata.class);
                            return metadata.getName().equals(objectName);
                        }
                        if (type.equals(CreateDatabaseMetadata.getDescriptor().getFullName())) {
                            CreateDatabaseMetadata metadata = (CreateDatabaseMetadata)operation.getMetadata().unpack(CreateDatabaseMetadata.class);
                            return metadata.getDatabase().equals(objectName);
                        }
                        if (type.equals(RestoreDatabaseMetadata.getDescriptor().getFullName())) {
                            RestoreDatabaseMetadata metadata = (RestoreDatabaseMetadata)operation.getMetadata().unpack(RestoreDatabaseMetadata.class);
                            return metadata.getName().equals(objectName);
                        }
                    }
                }
            }
            return false;
        }
        return true;
    }

    public void updateDatabaseDdl(UpdateDatabaseDdlRequest request, StreamObserver<Operation> responseObserver) {
        this.requests.add((AbstractMessage)request);
        MockDatabase db = (MockDatabase)this.databases.get(request.getDatabase());
        if (db != null) {
            db.ddl.addAll(request.getStatementsList());
            UpdateDatabaseDdlMetadata metadata = UpdateDatabaseDdlMetadata.newBuilder().setDatabase(request.getDatabase()).addAllStatements((Iterable)request.getStatementsList()).build();
            Operation operation = Operation.newBuilder().setMetadata(Any.pack((Message)metadata)).setResponse(Any.pack((Message)Empty.getDefaultInstance())).setDone(true).setName(this.operations.generateOperationName(request.getDatabase())).build();
            this.operations.addOperation(operation, new UpdateDatabaseDdlCallable(operation.getName()));
            responseObserver.onNext((Object)operation);
            responseObserver.onCompleted();
        } else {
            responseObserver.onError((Throwable)Status.NOT_FOUND.asRuntimeException());
        }
    }

    public void createBackup(CreateBackupRequest request, StreamObserver<Operation> responseObserver) {
        this.requests.add((AbstractMessage)request);
        try {
            this.createBackupStartupExecutionTime.simulateExecutionTime(this.exceptions, false, this.freezeLock);
            String name = String.format("%s/backups/%s", request.getParent(), request.getBackupId());
            MockDatabase db = (MockDatabase)this.databases.get(request.getBackup().getDatabase());
            if (db == null) {
                responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(String.format("Database with name %s not found", request.getBackup().getDatabase())).asRuntimeException());
                return;
            }
            MockBackup bck = new MockBackup(name, request.getBackup(), db);
            if (this.backups.putIfAbsent(name, bck) == null) {
                CreateBackupMetadata metadata = CreateBackupMetadata.newBuilder().setName(name).setDatabase(bck.database).setProgress(OperationProgress.newBuilder().setStartTime(Timestamp.newBuilder().setSeconds(System.currentTimeMillis() / 1000L).build()).setProgressPercent(0)).build();
                Operation operation = Operation.newBuilder().setMetadata(Any.pack((Message)metadata)).setResponse(Any.pack((Message)bck.toProto())).setName(this.operations.generateOperationName(name)).build();
                this.operations.addOperation(operation, new CreateBackupCallable(operation.getName(), name));
                this.createBackupResponseExecutionTime.simulateExecutionTime(this.exceptions, false, this.freezeLock);
                responseObserver.onNext((Object)operation);
                responseObserver.onCompleted();
            } else {
                responseObserver.onError((Throwable)Status.ALREADY_EXISTS.withDescription(String.format("Backup with name %s already exists", name)).asRuntimeException());
            }
        }
        catch (Throwable t) {
            responseObserver.onError(t);
        }
    }

    public void deleteBackup(DeleteBackupRequest request, StreamObserver<Empty> responseObserver) {
        this.requests.add((AbstractMessage)request);
        MockBackup bck = (MockBackup)this.backups.get(request.getName());
        if (this.backups.remove(request.getName(), bck)) {
            responseObserver.onNext((Object)Empty.getDefaultInstance());
            responseObserver.onCompleted();
        } else {
            responseObserver.onError((Throwable)Status.NOT_FOUND.asRuntimeException());
        }
    }

    public void getBackup(GetBackupRequest request, StreamObserver<Backup> responseObserver) {
        this.requests.add((AbstractMessage)request);
        MockBackup bck = (MockBackup)this.backups.get(request.getName());
        if (bck != null) {
            responseObserver.onNext((Object)Backup.newBuilder().setName(request.getName()).setCreateTime(bck.createTime).setDatabase(bck.database).setExpireTime(bck.expireTime).setSizeBytes(bck.size).setState(Backup.State.READY).build());
            responseObserver.onCompleted();
        } else {
            responseObserver.onError((Throwable)Status.NOT_FOUND.asRuntimeException());
        }
    }

    public void listBackups(ListBackupsRequest request, StreamObserver<ListBackupsResponse> responseObserver) {
        this.requests.add((AbstractMessage)request);
        ArrayList<Backup> bcks = new ArrayList<Backup>(this.backups.size());
        try {
            for (Map.Entry entry : this.backups.entrySet()) {
                if (!this.matchesFilter(entry.getValue(), request.getFilter())) continue;
                bcks.add(Backup.newBuilder().setName((String)entry.getKey()).setCreateTime(((MockBackup)entry.getValue()).createTime).setDatabase(((MockBackup)entry.getValue()).database).setExpireTime(((MockBackup)entry.getValue()).expireTime).setSizeBytes(((MockBackup)entry.getValue()).size).setState(Backup.State.READY).build());
            }
            responseObserver.onNext((Object)ListBackupsResponse.newBuilder().addAllBackups(bcks).build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            responseObserver.onError((Throwable)e);
        }
    }

    public void listBackupOperations(ListBackupOperationsRequest request, StreamObserver<ListBackupOperationsResponse> responseObserver) {
        this.requests.add((AbstractMessage)request);
        ListBackupOperationsResponse.Builder builder = ListBackupOperationsResponse.newBuilder();
        try {
            for (Operation op : this.operations.iterable()) {
                if (!op.getName().matches(".*?/backups/.*?/operations/.*?") || !op.getName().startsWith(request.getParent()) || !this.matchesFilter(op, request.getFilter())) continue;
                builder.addOperations(op);
            }
            responseObserver.onNext((Object)builder.build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            responseObserver.onError((Throwable)e);
        }
    }

    public void updateBackup(UpdateBackupRequest request, StreamObserver<Backup> responseObserver) {
        this.requests.add((AbstractMessage)request);
        MockBackup bck = (MockBackup)this.backups.get(request.getBackup().getName());
        if (bck != null) {
            if (request.getUpdateMask().getPathsList().contains((Object)EXPIRE_TIME_MASK)) {
                bck.expireTime = request.getBackup().getExpireTime();
            }
            responseObserver.onNext((Object)Backup.newBuilder().setName(bck.name).setCreateTime(bck.createTime).setDatabase(bck.database).setExpireTime(bck.expireTime).setSizeBytes(bck.size).setState(Backup.State.READY).build());
            responseObserver.onCompleted();
        } else {
            responseObserver.onError((Throwable)Status.NOT_FOUND.asRuntimeException());
        }
    }

    public void restoreDatabase(RestoreDatabaseRequest request, StreamObserver<Operation> responseObserver) {
        this.requests.add((AbstractMessage)request);
        try {
            this.restoreDatabaseStartupExecutionTime.simulateExecutionTime(this.exceptions, false, this.freezeLock);
            MockBackup bck = (MockBackup)this.backups.get(request.getBackup());
            if (bck != null) {
                MockDatabase db;
                String name = String.format("%s/databases/%s", request.getParent(), request.getDatabaseId());
                if (this.databases.putIfAbsent(name, db = new MockDatabase(name, bck.ddl, RestoreInfo.newBuilder().setBackupInfo(bck.toBackupInfo()).setSourceType(RestoreSourceType.BACKUP).build())) == null) {
                    bck.referencingDatabases.add(db.name);
                    Operation optimizeOperation = Operation.newBuilder().setDone(false).setName(this.operations.generateOperationName(name)).setMetadata(Any.pack((Message)OptimizeRestoredDatabaseMetadata.newBuilder().setName(name).setProgress(OperationProgress.newBuilder().setStartTime(this.currentTime()).setProgressPercent(0).build()).build())).setResponse(Any.pack((Message)db.toProto())).build();
                    RestoreDatabaseMetadata metadata = RestoreDatabaseMetadata.newBuilder().setBackupInfo(bck.toBackupInfo()).setName(name).setProgress(OperationProgress.newBuilder().setStartTime(this.currentTime()).setProgressPercent(0).build()).setOptimizeDatabaseOperationName(optimizeOperation.getName()).setSourceType(RestoreSourceType.BACKUP).build();
                    Operation operation = Operation.newBuilder().setMetadata(Any.pack((Message)metadata)).setResponse(Any.pack((Message)db.toProto())).setDone(false).setName(this.operations.generateOperationName(name)).build();
                    this.operations.addOperation(operation, new RestoreDatabaseCallable(operation.getName(), name));
                    this.operations.addOperation(optimizeOperation, new OptimizeDatabaseCallable(optimizeOperation.getName(), operation.getName(), name));
                    this.restoreDatabaseResponseExecutionTime.simulateExecutionTime(this.exceptions, false, this.freezeLock);
                    responseObserver.onNext((Object)operation);
                    responseObserver.onCompleted();
                } else {
                    responseObserver.onError((Throwable)Status.ALREADY_EXISTS.asRuntimeException());
                }
            } else {
                responseObserver.onError((Throwable)Status.NOT_FOUND.asRuntimeException());
            }
        }
        catch (Throwable t) {
            responseObserver.onError(t);
        }
    }

    public void getIamPolicy(GetIamPolicyRequest request, StreamObserver<Policy> responseObserver) {
        this.requests.add((AbstractMessage)request);
        Policy policy = (Policy)this.policies.get(request.getResource());
        if (policy != null) {
            responseObserver.onNext((Object)policy);
        } else {
            responseObserver.onNext((Object)Policy.getDefaultInstance());
        }
        responseObserver.onCompleted();
    }

    public void setIamPolicy(SetIamPolicyRequest request, StreamObserver<Policy> responseObserver) {
        this.requests.add((AbstractMessage)request);
        this.policies.put(request.getResource(), request.getPolicy());
        responseObserver.onNext((Object)request.getPolicy());
        responseObserver.onCompleted();
    }

    public void testIamPermissions(TestIamPermissionsRequest request, StreamObserver<TestIamPermissionsResponse> responseObserver) {
        this.requests.add((AbstractMessage)request);
        responseObserver.onNext((Object)TestIamPermissionsResponse.newBuilder().addAllPermissions((Iterable)request.getPermissionsList()).build());
        responseObserver.onCompleted();
    }

    public List<AbstractMessage> getRequests() {
        return new ArrayList<AbstractMessage>(this.requests);
    }

    public int countRequestsOfType(final Class<? extends AbstractMessage> type) {
        return Collections2.filter(this.getRequests(), (Predicate)new Predicate<AbstractMessage>(){

            public boolean apply(AbstractMessage input) {
                return input.getClass().equals(type);
            }
        }).size();
    }

    public void addResponse(AbstractMessage response) {
        throw new UnsupportedOperationException();
    }

    public void addException(Exception exception) {
        this.exceptions.add(exception);
    }

    public void addFilterMatches(String filter, String ... names) {
        HashSet<String> matches = (HashSet<String>)this.filterMatches.get(filter);
        if (matches == null) {
            matches = new HashSet<String>();
            this.filterMatches.put(filter, matches);
        }
        matches.addAll(Arrays.asList(names));
    }

    public void clearFilterMatches() {
        this.filterMatches.clear();
    }

    public ServerServiceDefinition getServiceDefinition() {
        return this.bindService();
    }

    public void reset() {
        this.requests.clear();
        this.exceptions.clear();
        this.policies.clear();
        this.databases.clear();
        this.backups.clear();
        this.filterMatches.clear();
    }

    public void removeAllExecutionTimes() {
        this.createBackupStartupExecutionTime = MockSpannerServiceImpl.SimulatedExecutionTime.none();
        this.createBackupResponseExecutionTime = MockSpannerServiceImpl.SimulatedExecutionTime.none();
        this.createBackupOperationExecutionTime = 0L;
        this.createDatabaseStartupExecutionTime = MockSpannerServiceImpl.SimulatedExecutionTime.none();
        this.createDatabaseResponseExecutionTime = MockSpannerServiceImpl.SimulatedExecutionTime.none();
        this.restoreDatabaseStartupExecutionTime = MockSpannerServiceImpl.SimulatedExecutionTime.none();
        this.restoreDatabaseResponseExecutionTime = MockSpannerServiceImpl.SimulatedExecutionTime.none();
        this.restoreDatabaseOperationExecutionTime = 0L;
    }

    private Timestamp currentTime() {
        return Timestamp.newBuilder().setSeconds(System.currentTimeMillis() * 1000L).build();
    }

    public void setCreateBackupStartupExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime exec) {
        this.createBackupStartupExecutionTime = exec;
    }

    public void setCreateBackupResponseExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime exec) {
        this.createBackupResponseExecutionTime = exec;
    }

    public void setCreateDatabaseStartupExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime exec) {
        this.createDatabaseStartupExecutionTime = exec;
    }

    public void setCreateDatabaseResponseExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime exec) {
        this.createDatabaseResponseExecutionTime = exec;
    }

    public void setRestoreDatabaseStartupExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime exec) {
        this.restoreDatabaseStartupExecutionTime = exec;
    }

    public void setRestoreDatabaseResponseExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime exec) {
        this.restoreDatabaseResponseExecutionTime = exec;
    }

    private final class OptimizeDatabaseCallable
    implements Callable<Database> {
        private final String operationName;
        private final String restoreOperationName;
        private final String name;

        private OptimizeDatabaseCallable(String operationName, String restoreOperationName, String name) {
            this.operationName = operationName;
            this.restoreOperationName = restoreOperationName;
            this.name = name;
        }

        @Override
        public Database call() throws Exception {
            MockDatabase db = (MockDatabase)MockDatabaseAdminServiceImpl.this.databases.get(this.name);
            Operation operation = MockDatabaseAdminServiceImpl.this.operations.get(this.operationName);
            try {
                Operation restoreOperation = MockDatabaseAdminServiceImpl.this.operations.get(this.restoreOperationName);
                while (!restoreOperation.getDone()) {
                    Thread.sleep(10L);
                    restoreOperation = MockDatabaseAdminServiceImpl.this.operations.get(this.restoreOperationName);
                }
                Thread.sleep(MockDatabaseAdminServiceImpl.this.optimizeDatabaseOperationExecutionTime);
                db.state = Database.State.READY;
                Database proto = db.toProto();
                if (operation != null) {
                    MockDatabaseAdminServiceImpl.this.operations.update(operation.toBuilder().setDone(true).setResponse(Any.pack((Message)proto)).build());
                }
                return proto;
            }
            catch (Exception e) {
                if (operation != null) {
                    Database proto = db.toProto();
                    MockDatabaseAdminServiceImpl.this.operations.update(operation.toBuilder().setDone(true).setError(MockDatabaseAdminServiceImpl.this.fromException(e)).setResponse(Any.pack((Message)proto)).build());
                }
                throw e;
            }
        }
    }

    private final class RestoreDatabaseCallable
    implements Callable<Database> {
        private final String operationName;
        private final String name;

        private RestoreDatabaseCallable(String operationName, String name) {
            this.operationName = operationName;
            this.name = name;
        }

        @Override
        public Database call() throws Exception {
            MockDatabase db = (MockDatabase)MockDatabaseAdminServiceImpl.this.databases.get(this.name);
            db.state = Database.State.READY_OPTIMIZING;
            Database proto = db.toProto();
            Operation operation = MockDatabaseAdminServiceImpl.this.operations.get(this.operationName);
            for (int progress = 1; progress <= 100; ++progress) {
                long sleep = MockDatabaseAdminServiceImpl.this.restoreDatabaseOperationExecutionTime / 100L;
                if (progress == 100) {
                    sleep += MockDatabaseAdminServiceImpl.this.restoreDatabaseOperationExecutionTime % 100L;
                }
                Thread.sleep(sleep);
                if (operation == null) continue;
                RestoreDatabaseMetadata metadata = (RestoreDatabaseMetadata)operation.getMetadata().unpack(RestoreDatabaseMetadata.class);
                metadata = metadata.toBuilder().setProgress(metadata.getProgress().toBuilder().setProgressPercent(progress).build()).build();
                MockDatabaseAdminServiceImpl.this.operations.update(operation.toBuilder().setMetadata(Any.pack((Message)metadata)).setResponse(Any.pack((Message)proto)).build());
            }
            db.state = Database.State.READY_OPTIMIZING;
            proto = db.toProto();
            if (operation != null) {
                RestoreDatabaseMetadata metadata = (RestoreDatabaseMetadata)operation.getMetadata().unpack(RestoreDatabaseMetadata.class);
                metadata = metadata.toBuilder().setProgress(metadata.getProgress().toBuilder().setEndTime(MockDatabaseAdminServiceImpl.this.currentTime()).setProgressPercent(100).build()).build();
                MockDatabaseAdminServiceImpl.this.operations.update(operation.toBuilder().setDone(true).setMetadata(Any.pack((Message)metadata)).setResponse(Any.pack((Message)proto)).build());
            }
            return proto;
        }
    }

    private final class CreateBackupCallable
    implements Callable<Backup> {
        private final String operationName;
        private final String name;

        private CreateBackupCallable(String operationName, String name) {
            this.operationName = operationName;
            this.name = name;
        }

        @Override
        public Backup call() throws Exception {
            MockBackup backup = (MockBackup)MockDatabaseAdminServiceImpl.this.backups.get(this.name);
            Backup proto = backup.toProto();
            Operation operation = MockDatabaseAdminServiceImpl.this.operations.get(this.operationName);
            for (int progress = 1; progress <= 100; ++progress) {
                operation = MockDatabaseAdminServiceImpl.this.operations.get(this.operationName);
                long sleep = MockDatabaseAdminServiceImpl.this.createBackupOperationExecutionTime / 100L;
                if (progress == 100) {
                    sleep += MockDatabaseAdminServiceImpl.this.createBackupOperationExecutionTime % 100L;
                }
                Thread.sleep(sleep);
                if (operation == null) continue;
                CreateBackupMetadata metadata = (CreateBackupMetadata)operation.getMetadata().unpack(CreateBackupMetadata.class);
                metadata = metadata.toBuilder().setProgress(metadata.getProgress().toBuilder().setProgressPercent(progress).build()).build();
                MockDatabaseAdminServiceImpl.this.operations.update(operation.toBuilder().setMetadata(Any.pack((Message)metadata)).setResponse(Any.pack((Message)proto)).build());
            }
            backup.state = Backup.State.READY;
            proto = backup.toProto();
            if (operation != null) {
                CreateBackupMetadata metadata = (CreateBackupMetadata)operation.getMetadata().unpack(CreateBackupMetadata.class);
                metadata = metadata.toBuilder().setProgress(metadata.getProgress().toBuilder().setProgressPercent(100).setEndTime(MockDatabaseAdminServiceImpl.this.currentTime()).build()).build();
                MockDatabaseAdminServiceImpl.this.operations.update(operation.toBuilder().setDone(true).setMetadata(Any.pack((Message)metadata)).setResponse(Any.pack((Message)proto)).build());
            }
            return proto;
        }
    }

    private final class UpdateDatabaseDdlCallable
    implements Callable<Empty> {
        private final String operationName;

        private UpdateDatabaseDdlCallable(String operationName) {
            this.operationName = operationName;
        }

        @Override
        public Empty call() throws Exception {
            Operation operation = MockDatabaseAdminServiceImpl.this.operations.get(this.operationName);
            if (operation != null) {
                UpdateDatabaseDdlMetadata metadata = (UpdateDatabaseDdlMetadata)operation.getMetadata().unpack(UpdateDatabaseDdlMetadata.class);
                ArrayList<Timestamp> commitTimestamps = new ArrayList<Timestamp>(metadata.getStatementsCount());
                for (int i = 0; i < metadata.getStatementsCount(); ++i) {
                    commitTimestamps.add(MockDatabaseAdminServiceImpl.this.currentTime());
                }
                metadata = metadata.toBuilder().addAllCommitTimestamps(commitTimestamps).build();
                MockDatabaseAdminServiceImpl.this.operations.update(operation.toBuilder().setMetadata(Any.pack((Message)metadata)).setDone(true).setResponse(Any.pack((Message)Empty.getDefaultInstance())).build());
            }
            return Empty.getDefaultInstance();
        }
    }

    private final class CreateDatabaseCallable
    implements Callable<Database> {
        private final String operationName;
        private final String name;

        private CreateDatabaseCallable(String operationName, String name) {
            this.operationName = operationName;
            this.name = name;
        }

        @Override
        public Database call() {
            MockDatabase db = (MockDatabase)MockDatabaseAdminServiceImpl.this.databases.get(this.name);
            db.state = Database.State.READY;
            Database proto = db.toProto();
            Operation operation = MockDatabaseAdminServiceImpl.this.operations.get(this.operationName);
            if (operation != null) {
                MockDatabaseAdminServiceImpl.this.operations.update(operation.toBuilder().setDone(true).setResponse(Any.pack((Message)proto)).build());
            }
            return proto;
        }
    }

    static final class MockBackup {
        private final String name;
        private Backup.State state;
        private final Timestamp createTime;
        private final String database;
        private final List<String> ddl = new ArrayList<String>();
        private final List<String> referencingDatabases = new ArrayList<String>();
        private final long size;
        private Timestamp expireTime;

        private MockBackup(String name, Backup backup, MockDatabase database) {
            this.name = name;
            this.state = Backup.State.CREATING;
            this.createTime = Timestamp.newBuilder().setSeconds(System.currentTimeMillis() / 1000L).build();
            this.database = database.name;
            this.ddl.addAll(database.ddl);
            this.size = RND.nextInt(Integer.MAX_VALUE);
            this.expireTime = backup.getExpireTime();
        }

        private Backup toProto() {
            return Backup.newBuilder().setCreateTime(this.createTime).setDatabase(this.database).setExpireTime(this.expireTime).setName(this.name).setSizeBytes(this.size).setState(this.state).addAllReferencingDatabases(this.referencingDatabases).build();
        }

        private BackupInfo toBackupInfo() {
            return BackupInfo.newBuilder().setBackup(this.name).setCreateTime(this.createTime).setSourceDatabase(this.database).build();
        }

        public String getName() {
            return this.name;
        }

        public String getDatabase() {
            return this.database;
        }

        public Timestamp getExpireTime() {
            return this.expireTime;
        }

        public boolean equals(Object o) {
            if (!(o instanceof MockDatabase)) {
                return false;
            }
            return ((MockDatabase)o).name.equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    private static final class MockDatabase {
        private final String name;
        private Database.State state;
        private final Timestamp createTime;
        private final List<String> ddl = new ArrayList<String>();
        private final RestoreInfo restoreInfo;

        private MockDatabase(String name, List<String> ddl, RestoreInfo restoreInfo) {
            this.name = name;
            this.state = Database.State.CREATING;
            this.createTime = Timestamp.newBuilder().setSeconds(System.currentTimeMillis() / 1000L).build();
            this.ddl.addAll(ddl);
            this.restoreInfo = restoreInfo;
        }

        private Database toProto() {
            return Database.newBuilder().setCreateTime(this.createTime).setName(this.name).setRestoreInfo(this.restoreInfo == null ? RestoreInfo.getDefaultInstance() : this.restoreInfo).setState(this.state).build();
        }

        public boolean equals(Object o) {
            if (!(o instanceof MockDatabase)) {
                return false;
            }
            return ((MockDatabase)o).name.equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

