/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Type;
import com.google.common.collect.ContiguousSet;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.ResultSet;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.TypeCode;
import java.util.Arrays;

public class MockSpannerTestUtil {
    static final Statement SELECT1 = Statement.of((String)"SELECT 1 AS COL1");
    private static final ResultSetMetadata SELECT1_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("COL1").setType(com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
    static final ResultSet SELECT1_RESULTSET = ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).setMetadata(SELECT1_METADATA).build();
    static final String TEST_PROJECT = "my-project";
    static final String TEST_INSTANCE = "my-instance";
    static final String TEST_DATABASE = "my-database";
    static final Statement UPDATE_STATEMENT = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE BAZ=2");
    static final Statement INVALID_UPDATE_STATEMENT = Statement.of((String)"UPDATE NON_EXISTENT_TABLE SET BAR=1 WHERE BAZ=2");
    static final Statement UPDATE_ABORTED_STATEMENT = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE BAZ=2 AND THIS_WILL_ABORT=TRUE");
    static final long UPDATE_COUNT = 1L;
    static final String READ_TABLE_NAME = "TestTable";
    static final String EMPTY_READ_TABLE_NAME = "EmptyTestTable";
    static final Iterable<String> READ_COLUMN_NAMES = Arrays.asList("Key", "Value");
    static final Statement READ_ONE_KEY_VALUE_STATEMENT = Statement.of((String)"SELECT Key, Value FROM TestTable WHERE ID=1");
    static final Statement READ_MULTIPLE_KEY_VALUE_STATEMENT = Statement.of((String)"SELECT Key, Value FROM TestTable WHERE 1=1");
    static final Statement READ_ONE_EMPTY_KEY_VALUE_STATEMENT = Statement.of((String)"SELECT Key, Value FROM EmptyTestTable WHERE ID=1");
    static final Statement READ_ALL_EMPTY_KEY_VALUE_STATEMENT = Statement.of((String)"SELECT Key, Value FROM EmptyTestTable WHERE 1=1");
    static final ResultSetMetadata READ_KEY_VALUE_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("Key").setType(com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.STRING).build()).build()).addFields(StructType.Field.newBuilder().setName("Value").setType(com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.STRING).build()).build()).build()).build();
    static final Type READ_TABLE_TYPE = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"Key", (Type)Type.string()), Type.StructField.of((String)"Value", (Type)Type.string())});
    static final ResultSet EMPTY_KEY_VALUE_RESULTSET = ResultSet.newBuilder().addRows(ListValue.newBuilder().build()).setMetadata(READ_KEY_VALUE_METADATA).build();
    static final ResultSet READ_ONE_KEY_VALUE_RESULTSET = ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("k1").build()).addValues(Value.newBuilder().setStringValue("v1").build()).build()).setMetadata(READ_KEY_VALUE_METADATA).build();
    static final ResultSet READ_MULTIPLE_KEY_VALUE_RESULTSET = MockSpannerTestUtil.generateKeyValueResultSet((Iterable<Integer>)ContiguousSet.closed((int)1, (int)3));
    static final ResultSetMetadata READ_FIRST_NAME_SINGERS_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("FirstName").setType(com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.STRING).build()).build()).build()).build();
    static final ResultSet READ_FIRST_NAME_SINGERS_RESULTSET = ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("FirstName").build()).build()).setMetadata(READ_FIRST_NAME_SINGERS_METADATA).build();

    static ResultSet generateKeyValueResultSet(Iterable<Integer> rows) {
        ResultSet.Builder builder = ResultSet.newBuilder();
        for (Integer row : rows) {
            builder.addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("k" + row).build()).addValues(Value.newBuilder().setStringValue("v" + row).build()).build());
        }
        return builder.setMetadata(READ_KEY_VALUE_METADATA).build();
    }
}

