/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.Options;
import com.google.common.truth.Truth;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class OptionsTest {
    @Test
    public void negativeLimitsNotAllowed() {
        try {
            Options.limit((long)-1L);
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void zeroLimitNotAllowed() {
        try {
            Options.limit((long)0L);
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void negativePrefetchChunksNotAllowed() {
        try {
            Options.prefetchChunks((int)-1);
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void zeroPrefetchChunksNotAllowed() {
        try {
            Options.prefetchChunks((int)0);
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void allOptionsPresent() {
        Options options = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.limit((long)10L), Options.prefetchChunks((int)1)});
        Truth.assertThat((Boolean)options.hasLimit()).isTrue();
        Truth.assertThat((Long)options.limit()).isEqualTo((Object)10);
        Truth.assertThat((Boolean)options.hasPrefetchChunks()).isTrue();
        Truth.assertThat((Integer)options.prefetchChunks()).isEqualTo((Object)1);
    }

    @Test
    public void allOptionsAbsent() {
        Options options = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[0]);
        Truth.assertThat((Boolean)options.hasLimit()).isFalse();
        Truth.assertThat((Boolean)options.hasPrefetchChunks()).isFalse();
        Truth.assertThat((Boolean)options.hasFilter()).isFalse();
        Truth.assertThat((Boolean)options.hasPageToken()).isFalse();
        Truth.assertThat((String)options.toString()).isEqualTo((Object)"");
        Truth.assertThat((Boolean)options.equals((Object)options)).isTrue();
        Truth.assertThat((Boolean)options.equals(null)).isFalse();
        Truth.assertThat((Boolean)options.equals((Object)this)).isFalse();
        Truth.assertThat((Integer)options.hashCode()).isEqualTo((Object)31);
    }

    @Test
    public void listOptTest() {
        int pageSize = 3;
        String pageToken = "ptok";
        String filter = "env";
        Options opts = Options.fromListOptions((Options.ListOption[])new Options.ListOption[]{Options.pageSize((int)pageSize), Options.pageToken((String)pageToken), Options.filter((String)filter)});
        Truth.assertThat((String)opts.toString()).isEqualTo((Object)("pageSize: " + Integer.toString(pageSize) + " pageToken: " + pageToken + " filter: " + filter + " "));
        Truth.assertThat((Boolean)opts.hasPageSize()).isTrue();
        Truth.assertThat((Boolean)opts.hasPageToken()).isTrue();
        Truth.assertThat((Boolean)opts.hasFilter()).isTrue();
        Truth.assertThat((Integer)opts.pageSize()).isEqualTo((Object)pageSize);
        Truth.assertThat((String)opts.pageToken()).isEqualTo((Object)pageToken);
        Truth.assertThat((String)opts.filter()).isEqualTo((Object)filter);
        Truth.assertThat((Integer)opts.hashCode()).isEqualTo((Object)108027089);
    }

    @Test
    public void listEquality() {
        Options o1 = Options.fromListOptions((Options.ListOption[])new Options.ListOption[0]);
        Options o2 = Options.fromListOptions((Options.ListOption[])new Options.ListOption[0]);
        Truth.assertThat((Boolean)o1.equals((Object)o2)).isTrue();
        o2 = Options.fromListOptions((Options.ListOption[])new Options.ListOption[]{Options.pageSize((int)1)});
        Truth.assertThat((Boolean)o1.equals((Object)o2)).isFalse();
        Truth.assertThat((Boolean)o2.equals((Object)o1)).isFalse();
        Options o3 = Options.fromListOptions((Options.ListOption[])new Options.ListOption[]{Options.pageSize((int)1)});
        Truth.assertThat((Boolean)o2.equals((Object)o3)).isTrue();
        o3 = Options.fromListOptions((Options.ListOption[])new Options.ListOption[]{Options.pageSize((int)2)});
        Truth.assertThat((Boolean)o2.equals((Object)o3)).isFalse();
        o2 = Options.fromListOptions((Options.ListOption[])new Options.ListOption[]{Options.pageToken((String)"t1")});
        Truth.assertThat((Boolean)o1.equals((Object)o2)).isFalse();
        o3 = Options.fromListOptions((Options.ListOption[])new Options.ListOption[]{Options.pageToken((String)"t1")});
        Truth.assertThat((Boolean)o2.equals((Object)o3)).isTrue();
        o3 = Options.fromListOptions((Options.ListOption[])new Options.ListOption[]{Options.pageToken((String)"t2")});
        Truth.assertThat((Boolean)o2.equals((Object)o3)).isFalse();
        o2 = Options.fromListOptions((Options.ListOption[])new Options.ListOption[]{Options.filter((String)"f1")});
        Truth.assertThat((Boolean)o1.equals((Object)o2)).isFalse();
        o3 = Options.fromListOptions((Options.ListOption[])new Options.ListOption[]{Options.filter((String)"f1")});
        Truth.assertThat((Boolean)o2.equals((Object)o3)).isTrue();
        o3 = Options.fromListOptions((Options.ListOption[])new Options.ListOption[]{Options.filter((String)"f2")});
        Truth.assertThat((Boolean)o2.equals((Object)o3)).isFalse();
    }

    @Test
    public void readOptTest() {
        int limit = 3;
        Options opts = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.limit((long)limit)});
        Truth.assertThat((String)opts.toString()).isEqualTo((Object)("limit: " + Integer.toString(limit) + " "));
        Truth.assertThat((Integer)opts.hashCode()).isEqualTo((Object)964);
    }

    @Test
    public void readEquality() {
        Options o1 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[0]);
        Options o2 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[0]);
        Truth.assertThat((Boolean)o1.equals((Object)o2)).isTrue();
        o2 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.limit((long)1L)});
        Truth.assertThat((Boolean)o1.equals((Object)o2)).isFalse();
        Truth.assertThat((Boolean)o2.equals((Object)o1)).isFalse();
        Options o3 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.limit((long)1L)});
        Truth.assertThat((Boolean)o2.equals((Object)o3)).isTrue();
        o3 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.limit((long)2L)});
        Truth.assertThat((Boolean)o2.equals((Object)o3)).isFalse();
    }

    @Test
    public void queryOptTest() {
        int chunks = 3;
        Options opts = Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[]{Options.prefetchChunks((int)chunks)});
        Truth.assertThat((String)opts.toString()).isEqualTo((Object)("prefetchChunks: " + Integer.toString(chunks) + " "));
        Truth.assertThat((Integer)opts.prefetchChunks()).isEqualTo((Object)chunks);
        Truth.assertThat((Integer)opts.hashCode()).isEqualTo((Object)964);
    }

    @Test
    public void queryEquality() {
        Options o1 = Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[0]);
        Options o2 = Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[0]);
        Truth.assertThat((Boolean)o1.equals((Object)o2)).isTrue();
        o2 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.prefetchChunks((int)1)});
        Truth.assertThat((Boolean)o1.equals((Object)o2)).isFalse();
        Truth.assertThat((Boolean)o2.equals((Object)o1)).isFalse();
        Options o3 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.prefetchChunks((int)1)});
        Truth.assertThat((Boolean)o2.equals((Object)o3)).isTrue();
        o3 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.prefetchChunks((int)2)});
        Truth.assertThat((Boolean)o2.equals((Object)o3)).isFalse();
    }

    @Test
    public void testFromTransactionOptions_toStringNoOptions() {
        Options opts = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]);
        Truth.assertThat((String)opts.toString()).isEqualTo((Object)"");
    }

    @Test
    public void testFromTransactionOptions_toStringWithCommitStats() {
        Options options = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.commitStats()});
        Truth.assertThat((String)options.toString()).contains((CharSequence)"withCommitStats: true");
    }

    @Test
    public void testTransactionOptions_noOptionsAreEqual() {
        Options option1 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]);
        Options option2 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]);
        Assert.assertEquals((Object)option1, (Object)option2);
    }

    @Test
    public void testTransactionOptions_withCommitStatsAreEqual() {
        Options option1 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.commitStats()});
        Options option2 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.commitStats()});
        Assert.assertEquals((Object)option1, (Object)option2);
    }

    @Test
    public void testTransactionOptions_withCommitStatsAndOtherOptionAreNotEqual() {
        Options option1 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.commitStats()});
        Options option2 = Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[]{Options.prefetchChunks((int)10)});
        Assert.assertNotEquals((Object)option1, (Object)option2);
    }

    @Test
    public void testTransactionOptions_noOptionsHashCode() {
        Options option1 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]);
        Options option2 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]);
        Assert.assertEquals((long)option2.hashCode(), (long)option1.hashCode());
    }

    @Test
    public void testTransactionOptions_withCommitStatsHashCode() {
        Options option1 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.commitStats()});
        Options option2 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.commitStats()});
        Assert.assertEquals((long)option2.hashCode(), (long)option1.hashCode());
    }

    @Test
    public void testTransactionOptions_withCommitStatsAndOtherOptionHashCode() {
        Options option1 = Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.commitStats()});
        Options option2 = Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[]{Options.prefetchChunks((int)10)});
        Assert.assertNotEquals((long)option2.hashCode(), (long)option1.hashCode());
    }

    @Test
    public void testFromUpdateOptions() {
        Options opts = Options.fromUpdateOptions((Options.UpdateOption[])new Options.UpdateOption[0]);
        Truth.assertThat((String)opts.toString()).isEqualTo((Object)"");
    }

    @Test
    public void testUpdateOptionsEquality() {
        Options o1 = Options.fromUpdateOptions((Options.UpdateOption[])new Options.UpdateOption[0]);
        Options o2 = Options.fromUpdateOptions((Options.UpdateOption[])new Options.UpdateOption[0]);
        Truth.assertThat((Boolean)o1.equals((Object)o2)).isTrue();
        o2 = Options.fromReadOptions((Options.ReadOption[])new Options.ReadOption[]{Options.prefetchChunks((int)1)});
        Truth.assertThat((Boolean)o1.equals((Object)o2)).isFalse();
    }
}

