/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunner;
import com.google.common.truth.Truth;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ReadWriteTransactionWithInlineBeginTest {
    private static MockSpannerServiceImpl mockSpanner;
    private static Server server;
    private static LocalChannelProvider channelProvider;
    private static final Statement UPDATE_STATEMENT;
    private static final Statement INVALID_UPDATE_STATEMENT;
    private static final Statement INVALID_SELECT_STATEMENT;
    private static final long UPDATE_COUNT = 1L;
    private static final Statement SELECT1;
    private static final ResultSetMetadata SELECT1_METADATA;
    private static final com.google.spanner.v1.ResultSet SELECT1_RESULTSET;
    private Spanner spanner;
    private DatabaseClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(UPDATE_STATEMENT, 1L));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT1, SELECT1_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(INVALID_UPDATE_STATEMENT, Status.INVALID_ARGUMENT.withDescription("invalid statement").asRuntimeException()));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(INVALID_SELECT_STATEMENT, Status.INVALID_ARGUMENT.withDescription("invalid statement").asRuntimeException()));
        String uniqueName = InProcessServerBuilder.generateName();
        server = ((InProcessServerBuilder)InProcessServerBuilder.forName((String)uniqueName).scheduledExecutorService((ScheduledExecutorService)new ScheduledThreadPoolExecutor(1)).addService((BindableService)mockSpanner)).build().start();
        channelProvider = LocalChannelProvider.create((String)uniqueName);
    }

    @AfterClass
    public static void stopServer() throws InterruptedException {
        server.shutdown();
        server.awaitTermination();
    }

    @Before
    public void setUp() throws IOException {
        mockSpanner.reset();
        mockSpanner.removeAllExecutionTimes();
        this.spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).build().getService();
        this.client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
    }

    @After
    public void tearDown() throws Exception {
        this.spanner.close();
    }

    @Test
    public void singleUpdate() {
        Long updateCount = (Long)this.client.readWriteTransaction(new Options.TransactionOption[0]).run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Long>(){

            public Long run(TransactionContext transaction) throws Exception {
                return transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
            }
        });
        Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
        Truth.assertThat((Integer)this.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
        Truth.assertThat((Integer)this.countTransactionsStarted()).isEqualTo((Object)1);
    }

    @Test
    public void singleBatchUpdate() {
        long[] updateCounts = (long[])this.client.readWriteTransaction(new Options.TransactionOption[0]).run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<long[]>(){

            public long[] run(TransactionContext transaction) throws Exception {
                return transaction.batchUpdate(Arrays.asList(UPDATE_STATEMENT, UPDATE_STATEMENT), new Options.UpdateOption[0]);
            }
        });
        Truth.assertThat((long[])updateCounts).isEqualTo((Object)new long[]{1L, 1L});
        Truth.assertThat((Integer)this.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
        Truth.assertThat((Integer)this.countTransactionsStarted()).isEqualTo((Object)1);
    }

    @Test
    public void singleQuery() {
        Long value = (Long)this.client.readWriteTransaction(new Options.TransactionOption[0]).run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Long>(){

            public Long run(TransactionContext transaction) throws Exception {
                try (ResultSet rs = transaction.executeQuery(SELECT1, new Options.QueryOption[0]);){
                    if (rs.next()) {
                        Long l = rs.getLong(0);
                        return l;
                    }
                }
                return 0L;
            }
        });
        Truth.assertThat((Long)value).isEqualTo((Object)1L);
        Truth.assertThat((Integer)this.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
        Truth.assertThat((Integer)this.countTransactionsStarted()).isEqualTo((Object)1);
    }

    @Test
    public void updateAndQuery() {
        long[] res = (long[])this.client.readWriteTransaction(new Options.TransactionOption[0]).run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<long[]>(){

            public long[] run(TransactionContext transaction) throws Exception {
                long updateCount = transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
                long val = 0L;
                try (ResultSet rs = transaction.executeQuery(SELECT1, new Options.QueryOption[0]);){
                    while (rs.next()) {
                        val = rs.getLong(0);
                    }
                }
                return new long[]{updateCount, val};
            }
        });
        Truth.assertThat((long[])res).isEqualTo((Object)new long[]{1L, 1L});
        Truth.assertThat((Integer)this.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
        Truth.assertThat((Integer)this.countTransactionsStarted()).isEqualTo((Object)1);
    }

    @Test
    public void concurrentUpdates() {
        int updates = 100;
        final ExecutorService service = Executors.newFixedThreadPool(8);
        Long updateCount = (Long)this.client.readWriteTransaction(new Options.TransactionOption[0]).run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Long>(){

            public Long run(final TransactionContext transaction) throws Exception {
                ArrayList<Future<Long>> list = new ArrayList<Future<Long>>(100);
                for (int i = 0; i < 100; ++i) {
                    list.add(service.submit(new Callable<Long>(){

                        @Override
                        public Long call() throws Exception {
                            return transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
                        }
                    }));
                }
                long totalUpdateCount = 0L;
                for (Future future : list) {
                    totalUpdateCount += ((Long)future.get()).longValue();
                }
                return totalUpdateCount;
            }
        });
        Truth.assertThat((Long)updateCount).isEqualTo((Object)100L);
        Truth.assertThat((Integer)this.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
        Truth.assertThat((Integer)this.countTransactionsStarted()).isEqualTo((Object)1);
    }

    @Test
    public void concurrentBatchUpdates() {
        int updates = 100;
        final ExecutorService service = Executors.newFixedThreadPool(8);
        Long updateCount = (Long)this.client.readWriteTransaction(new Options.TransactionOption[0]).run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Long>(){

            public Long run(final TransactionContext transaction) throws Exception {
                ArrayList<Future<long[]>> list = new ArrayList<Future<long[]>>(100);
                for (int i = 0; i < 100; ++i) {
                    list.add(service.submit(new Callable<long[]>(){

                        @Override
                        public long[] call() throws Exception {
                            return transaction.batchUpdate(Arrays.asList(UPDATE_STATEMENT, UPDATE_STATEMENT), new Options.UpdateOption[0]);
                        }
                    }));
                }
                long totalUpdateCount = 0L;
                for (Future future : list) {
                    for (long l : (long[])future.get()) {
                        totalUpdateCount += l;
                    }
                }
                return totalUpdateCount;
            }
        });
        Truth.assertThat((Long)updateCount).isEqualTo((Object)200L);
        Truth.assertThat((Integer)this.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
        Truth.assertThat((Integer)this.countTransactionsStarted()).isEqualTo((Object)1);
    }

    @Test
    public void concurrentQueries() {
        int queries = 100;
        final ExecutorService service = Executors.newFixedThreadPool(8);
        Long selectedTotal = (Long)this.client.readWriteTransaction(new Options.TransactionOption[0]).run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Long>(){

            public Long run(final TransactionContext transaction) throws Exception {
                ArrayList<Future<Long>> list = new ArrayList<Future<Long>>(100);
                for (int i = 0; i < 100; ++i) {
                    list.add(service.submit(new Callable<Long>(){

                        @Override
                        public Long call() throws Exception {
                            try (ResultSet rs = transaction.executeQuery(SELECT1, new Options.QueryOption[0]);){
                                if (rs.next()) {
                                    Long l = rs.getLong(0);
                                    return l;
                                }
                            }
                            return 0L;
                        }
                    }));
                }
                long selectedTotal = 0L;
                for (Future future : list) {
                    selectedTotal += ((Long)future.get()).longValue();
                }
                return selectedTotal;
            }
        });
        Truth.assertThat((Long)selectedTotal).isEqualTo((Object)100);
        Truth.assertThat((Integer)this.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
        Truth.assertThat((Integer)this.countTransactionsStarted()).isEqualTo((Object)1);
    }

    @Test
    public void failedUpdate() {
        try {
            this.client.readWriteTransaction(new Options.TransactionOption[0]).run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Long>(){

                public Long run(TransactionContext transaction) throws Exception {
                    return transaction.executeUpdate(INVALID_UPDATE_STATEMENT, new Options.UpdateOption[0]);
                }
            });
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
        }
        Truth.assertThat((Integer)this.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
        Truth.assertThat((Integer)this.countTransactionsStarted()).isEqualTo((Object)1);
    }

    @Test
    public void failedBatchUpdate() {
        try {
            this.client.readWriteTransaction(new Options.TransactionOption[0]).run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<long[]>(){

                public long[] run(TransactionContext transaction) throws Exception {
                    return transaction.batchUpdate(Arrays.asList(INVALID_UPDATE_STATEMENT, UPDATE_STATEMENT), new Options.UpdateOption[0]);
                }
            });
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
        }
        Truth.assertThat((Integer)this.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
        Truth.assertThat((Integer)this.countTransactionsStarted()).isEqualTo((Object)1);
    }

    @Test
    public void failedQuery() {
        try {
            this.client.readWriteTransaction(new Options.TransactionOption[0]).run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Void>(){

                public Void run(TransactionContext transaction) throws Exception {
                    try (ResultSet rs = transaction.executeQuery(INVALID_SELECT_STATEMENT, new Options.QueryOption[0]);){
                        rs.next();
                    }
                    return null;
                }
            });
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
        }
        Truth.assertThat((Integer)this.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
        Truth.assertThat((Integer)this.countTransactionsStarted()).isEqualTo((Object)1);
    }

    @Test
    public void failedUpdateAndThenUpdate() {
        Long updateCount = (Long)this.client.readWriteTransaction(new Options.TransactionOption[0]).run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Long>(){

            public Long run(TransactionContext transaction) throws Exception {
                try {
                    transaction.executeUpdate(INVALID_UPDATE_STATEMENT, new Options.UpdateOption[0]);
                    Assert.fail((String)"Missing expected exception");
                }
                catch (SpannerException e) {
                    Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
                }
                return transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
            }
        });
        Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
        Truth.assertThat((Integer)this.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)1);
        Truth.assertThat((Integer)this.countTransactionsStarted()).isEqualTo((Object)2);
    }

    @Test
    public void failedBatchUpdateAndThenUpdate() {
        Long updateCount = (Long)this.client.readWriteTransaction(new Options.TransactionOption[0]).run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Long>(){

            public Long run(TransactionContext transaction) throws Exception {
                try {
                    transaction.batchUpdate(Arrays.asList(INVALID_UPDATE_STATEMENT, UPDATE_STATEMENT), new Options.UpdateOption[0]);
                    Assert.fail((String)"Missing expected exception");
                }
                catch (SpannerException e) {
                    Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
                }
                return transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
            }
        });
        Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
        Truth.assertThat((Integer)this.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)1);
        Truth.assertThat((Integer)this.countTransactionsStarted()).isEqualTo((Object)2);
    }

    @Test
    public void failedQueryAndThenUpdate() {
        Long updateCount = (Long)this.client.readWriteTransaction(new Options.TransactionOption[0]).run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Long>(){

            public Long run(TransactionContext transaction) throws Exception {
                try (ResultSet rs = transaction.executeQuery(INVALID_SELECT_STATEMENT, new Options.QueryOption[0]);){
                    rs.next();
                    Assert.fail((String)"Missing expected exception");
                }
                catch (SpannerException e) {
                    Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
                }
                return transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
            }
        });
        Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
        Truth.assertThat((Integer)this.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)1);
        Truth.assertThat((Integer)this.countTransactionsStarted()).isEqualTo((Object)2);
    }

    @Test
    public void abortedUpdate() {
        final AtomicInteger attempt = new AtomicInteger();
        Long updateCount = (Long)this.client.readWriteTransaction(new Options.TransactionOption[0]).run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Long>(){

            public Long run(TransactionContext transaction) throws Exception {
                if (attempt.incrementAndGet() == 1) {
                    mockSpanner.abortNextTransaction();
                }
                return transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
            }
        });
        Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
        Truth.assertThat((Integer)attempt.get()).isEqualTo((Object)2);
        Truth.assertThat((Integer)this.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
        Truth.assertThat((Integer)this.countTransactionsStarted()).isEqualTo((Object)2);
    }

    @Test
    public void abortedBatchUpdate() {
        final AtomicInteger attempt = new AtomicInteger();
        long[] updateCounts = (long[])this.client.readWriteTransaction(new Options.TransactionOption[0]).run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<long[]>(){

            public long[] run(TransactionContext transaction) throws Exception {
                if (attempt.incrementAndGet() == 1) {
                    mockSpanner.abortNextTransaction();
                }
                return transaction.batchUpdate(Arrays.asList(UPDATE_STATEMENT, UPDATE_STATEMENT), new Options.UpdateOption[0]);
            }
        });
        Truth.assertThat((long[])updateCounts).isEqualTo((Object)new long[]{1L, 1L});
        Truth.assertThat((Integer)attempt.get()).isEqualTo((Object)2);
        Truth.assertThat((Integer)this.countRequests(BeginTransactionRequest.class)).isEqualTo((Object)0);
        Truth.assertThat((Integer)this.countTransactionsStarted()).isEqualTo((Object)2);
    }

    private int countRequests(Class<? extends AbstractMessage> requestType) {
        int count = 0;
        for (AbstractMessage msg : mockSpanner.getRequests()) {
            if (!msg.getClass().equals(requestType)) continue;
            ++count;
        }
        return count;
    }

    private int countTransactionsStarted() {
        return mockSpanner.getTransactionsStarted().size();
    }

    static {
        UPDATE_STATEMENT = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE BAZ=2");
        INVALID_UPDATE_STATEMENT = Statement.of((String)"UPDATE NON_EXISTENT_TABLE SET BAR=1 WHERE BAZ=2");
        INVALID_SELECT_STATEMENT = Statement.of((String)"SELECT * FROM NON_EXISTENT_TABLE");
        SELECT1 = Statement.of((String)"SELECT 1 AS COL1");
        SELECT1_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("COL1").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
        SELECT1_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).setMetadata(SELECT1_METADATA).build();
    }
}

