/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.client.util.BackOff;
import com.google.cloud.spanner.AbstractResultSet;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerException;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.Message;
import com.google.protobuf.Value;
import com.google.rpc.RetryInfo;
import com.google.spanner.v1.PartialResultSet;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.ProtoUtils;
import io.opencensus.trace.EndSpanOptions;
import io.opencensus.trace.Span;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;

@RunWith(value=JUnit4.class)
public class ResumableStreamIteratorTest {
    Starter starter = (Starter)Mockito.mock(Starter.class);
    AbstractResultSet.ResumableStreamIterator resumableStreamIterator;

    private static StatusRuntimeException statusWithRetryInfo(ErrorCode code) {
        Metadata.Key key = ProtoUtils.keyForProto((Message)RetryInfo.getDefaultInstance());
        Metadata trailers = new Metadata();
        RetryInfo retryInfo = RetryInfo.newBuilder().setRetryDelay(Duration.newBuilder().setNanos((int)TimeUnit.MILLISECONDS.toNanos(1L)).setSeconds(0L)).build();
        trailers.put(key, (Object)retryInfo);
        return code.getGrpcStatus().asRuntimeException(trailers);
    }

    @Before
    public void setUp() {
        this.initWithLimit(Integer.MAX_VALUE);
    }

    private void initWithLimit(int maxBufferSize) {
        this.resumableStreamIterator = new AbstractResultSet.ResumableStreamIterator(maxBufferSize, "", null){

            AbstractResultSet.CloseableIterator<PartialResultSet> startStream(@Nullable ByteString resumeToken) {
                return ResumableStreamIteratorTest.this.starter.startStream(resumeToken);
            }
        };
    }

    @Test
    public void simple() {
        ResultSetStream s1 = (ResultSetStream)Mockito.mock(ResultSetStream.class);
        Mockito.when(this.starter.startStream(null)).thenReturn((Object)new ResultSetIterator(s1));
        Mockito.when((Object)s1.next()).thenReturn((Object)ResumableStreamIteratorTest.resultSet(null, "a")).thenReturn((Object)ResumableStreamIteratorTest.resultSet(null, "b")).thenReturn(null);
        Truth.assertThat(ResumableStreamIteratorTest.consume((Iterator<PartialResultSet>)this.resumableStreamIterator)).containsExactly(new Object[]{"a", "b"}).inOrder();
    }

    @Test
    public void closedSpan() {
        Span span = (Span)Mockito.mock(Span.class);
        Whitebox.setInternalState((Object)this.resumableStreamIterator, (String)"span", (Object)span);
        ResultSetStream s1 = (ResultSetStream)Mockito.mock(ResultSetStream.class);
        Mockito.when(this.starter.startStream(null)).thenReturn((Object)new ResultSetIterator(s1));
        Mockito.when((Object)s1.next()).thenReturn((Object)ResumableStreamIteratorTest.resultSet(ByteString.copyFromUtf8((String)"r1"), "a")).thenReturn((Object)ResumableStreamIteratorTest.resultSet(ByteString.copyFromUtf8((String)"r2"), "b")).thenReturn(null);
        Truth.assertThat(ResumableStreamIteratorTest.consume((Iterator<PartialResultSet>)this.resumableStreamIterator)).containsExactly(new Object[]{"a", "b"}).inOrder();
        this.resumableStreamIterator.close("closed");
        ((Span)Mockito.verify((Object)span)).end(EndSpanOptions.builder().setSampleToLocalSpanStore(true).build());
    }

    @Test
    public void restart() {
        ResultSetStream s1 = (ResultSetStream)Mockito.mock(ResultSetStream.class);
        Mockito.when(this.starter.startStream(null)).thenReturn((Object)new ResultSetIterator(s1));
        Mockito.when((Object)s1.next()).thenReturn((Object)ResumableStreamIteratorTest.resultSet(ByteString.copyFromUtf8((String)"r1"), "a")).thenReturn((Object)ResumableStreamIteratorTest.resultSet(ByteString.copyFromUtf8((String)"r2"), "b")).thenThrow(new Throwable[]{new RetryableException(ErrorCode.UNAVAILABLE, "failed by test")});
        ResultSetStream s2 = (ResultSetStream)Mockito.mock(ResultSetStream.class);
        Mockito.when(this.starter.startStream(ByteString.copyFromUtf8((String)"r2"))).thenReturn((Object)new ResultSetIterator(s2));
        Mockito.when((Object)s2.next()).thenReturn((Object)ResumableStreamIteratorTest.resultSet(ByteString.copyFromUtf8((String)"r3"), "c")).thenReturn((Object)ResumableStreamIteratorTest.resultSet(ByteString.copyFromUtf8((String)"r4"), "d")).thenReturn(null);
        Truth.assertThat(ResumableStreamIteratorTest.consume((Iterator<PartialResultSet>)this.resumableStreamIterator)).containsExactly(new Object[]{"a", "b", "c", "d"}).inOrder();
    }

    @Test
    public void restartWithHoldBack() {
        ResultSetStream s1 = (ResultSetStream)Mockito.mock(ResultSetStream.class);
        Mockito.when(this.starter.startStream(null)).thenReturn((Object)new ResultSetIterator(s1));
        Mockito.when((Object)s1.next()).thenReturn((Object)ResumableStreamIteratorTest.resultSet(ByteString.copyFromUtf8((String)"r1"), "a")).thenReturn((Object)ResumableStreamIteratorTest.resultSet(ByteString.copyFromUtf8((String)"r2"), "b")).thenReturn((Object)ResumableStreamIteratorTest.resultSet(null, "X")).thenReturn((Object)ResumableStreamIteratorTest.resultSet(null, "X")).thenThrow(new Throwable[]{new RetryableException(ErrorCode.UNAVAILABLE, "failed by test")});
        ResultSetStream s2 = (ResultSetStream)Mockito.mock(ResultSetStream.class);
        Mockito.when(this.starter.startStream(ByteString.copyFromUtf8((String)"r2"))).thenReturn((Object)new ResultSetIterator(s2));
        Mockito.when((Object)s2.next()).thenReturn((Object)ResumableStreamIteratorTest.resultSet(ByteString.copyFromUtf8((String)"r3"), "c")).thenReturn((Object)ResumableStreamIteratorTest.resultSet(ByteString.copyFromUtf8((String)"r4"), "d")).thenReturn(null);
        Truth.assertThat(ResumableStreamIteratorTest.consume((Iterator<PartialResultSet>)this.resumableStreamIterator)).containsExactly(new Object[]{"a", "b", "c", "d"}).inOrder();
    }

    @Test
    public void restartWithHoldBackMidStream() {
        ResultSetStream s1 = (ResultSetStream)Mockito.mock(ResultSetStream.class);
        Mockito.when(this.starter.startStream(null)).thenReturn((Object)new ResultSetIterator(s1));
        Mockito.when((Object)s1.next()).thenReturn((Object)ResumableStreamIteratorTest.resultSet(ByteString.copyFromUtf8((String)"r1"), "a")).thenReturn((Object)ResumableStreamIteratorTest.resultSet(null, "b")).thenReturn((Object)ResumableStreamIteratorTest.resultSet(null, "c")).thenReturn((Object)ResumableStreamIteratorTest.resultSet(ByteString.copyFromUtf8((String)"r2"), "d")).thenThrow(new Throwable[]{new RetryableException(ErrorCode.UNAVAILABLE, "failed by test")});
        ResultSetStream s2 = (ResultSetStream)Mockito.mock(ResultSetStream.class);
        Mockito.when(this.starter.startStream(ByteString.copyFromUtf8((String)"r2"))).thenReturn((Object)new ResultSetIterator(s2));
        Mockito.when((Object)s2.next()).thenReturn((Object)ResumableStreamIteratorTest.resultSet(ByteString.copyFromUtf8((String)"r3"), "e")).thenReturn((Object)ResumableStreamIteratorTest.resultSet(null, "f")).thenReturn(null);
        Truth.assertThat(ResumableStreamIteratorTest.consume((Iterator<PartialResultSet>)this.resumableStreamIterator)).containsExactly(new Object[]{"a", "b", "c", "d", "e", "f"}).inOrder();
    }

    @Test
    public void retryableErrorWithoutRetryInfo() throws IOException {
        BackOff backOff = (BackOff)Mockito.mock(BackOff.class);
        Mockito.when((Object)backOff.nextBackOffMillis()).thenReturn((Object)1L);
        Whitebox.setInternalState((Object)this.resumableStreamIterator, (String)"backOff", (Object)backOff);
        ResultSetStream s1 = (ResultSetStream)Mockito.mock(ResultSetStream.class);
        Mockito.when(this.starter.startStream(null)).thenReturn((Object)new ResultSetIterator(s1));
        Mockito.when((Object)s1.next()).thenReturn((Object)ResumableStreamIteratorTest.resultSet(ByteString.copyFromUtf8((String)"r1"), "a")).thenThrow(new Throwable[]{new RetryableException(ErrorCode.UNAVAILABLE, "failed by test", Status.UNAVAILABLE.asRuntimeException())});
        ResultSetStream s2 = (ResultSetStream)Mockito.mock(ResultSetStream.class);
        Mockito.when(this.starter.startStream(ByteString.copyFromUtf8((String)"r1"))).thenReturn((Object)new ResultSetIterator(s2));
        Mockito.when((Object)s2.next()).thenReturn((Object)ResumableStreamIteratorTest.resultSet(ByteString.copyFromUtf8((String)"r2"), "b")).thenReturn(null);
        Truth.assertThat(ResumableStreamIteratorTest.consume((Iterator<PartialResultSet>)this.resumableStreamIterator)).containsExactly(new Object[]{"a", "b"}).inOrder();
        ((BackOff)Mockito.verify((Object)backOff)).nextBackOffMillis();
    }

    @Test
    public void nonRetryableError() {
        ResultSetStream s1 = (ResultSetStream)Mockito.mock(ResultSetStream.class);
        Mockito.when(this.starter.startStream(null)).thenReturn((Object)new ResultSetIterator(s1));
        Mockito.when((Object)s1.next()).thenReturn((Object)ResumableStreamIteratorTest.resultSet(ByteString.copyFromUtf8((String)"r1"), "a")).thenReturn((Object)ResumableStreamIteratorTest.resultSet(ByteString.copyFromUtf8((String)"r2"), "b")).thenReturn((Object)ResumableStreamIteratorTest.resultSet(null, "X")).thenReturn((Object)ResumableStreamIteratorTest.resultSet(null, "X")).thenThrow(new Throwable[]{new NonRetryableException(ErrorCode.FAILED_PRECONDITION, "failed by test")});
        Iterator<String> strings = ResumableStreamIteratorTest.stringIterator((Iterator<PartialResultSet>)this.resumableStreamIterator);
        Truth.assertThat((String)strings.next()).isEqualTo((Object)"a");
        Truth.assertThat((String)strings.next()).isEqualTo((Object)"b");
        try {
            Truth.assertThat((String)strings.next()).isNotEqualTo((Object)"X");
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.FAILED_PRECONDITION);
        }
    }

    @Test
    public void bufferLimitSimple() {
        this.initWithLimit(1);
        ResultSetStream s1 = (ResultSetStream)Mockito.mock(ResultSetStream.class);
        Mockito.when(this.starter.startStream(null)).thenReturn((Object)new ResultSetIterator(s1));
        Mockito.when((Object)s1.next()).thenReturn((Object)ResumableStreamIteratorTest.resultSet(null, "a")).thenReturn((Object)ResumableStreamIteratorTest.resultSet(null, "b")).thenReturn(null);
        Truth.assertThat(ResumableStreamIteratorTest.consume((Iterator<PartialResultSet>)this.resumableStreamIterator)).containsExactly(new Object[]{"a", "b"}).inOrder();
    }

    @Test
    public void bufferLimitSimpleWithRestartTokens() {
        this.initWithLimit(1);
        ResultSetStream s1 = (ResultSetStream)Mockito.mock(ResultSetStream.class);
        Mockito.when(this.starter.startStream(null)).thenReturn((Object)new ResultSetIterator(s1));
        Mockito.when((Object)s1.next()).thenReturn((Object)ResumableStreamIteratorTest.resultSet(ByteString.copyFromUtf8((String)"r1"), "a")).thenReturn((Object)ResumableStreamIteratorTest.resultSet(ByteString.copyFromUtf8((String)"r2"), "b")).thenReturn(null);
        Truth.assertThat(ResumableStreamIteratorTest.consume((Iterator<PartialResultSet>)this.resumableStreamIterator)).containsExactly(new Object[]{"a", "b"}).inOrder();
    }

    @Test
    public void bufferLimitRestart() {
        this.initWithLimit(1);
        ResultSetStream s1 = (ResultSetStream)Mockito.mock(ResultSetStream.class);
        Mockito.when(this.starter.startStream(null)).thenReturn((Object)new ResultSetIterator(s1));
        Mockito.when((Object)s1.next()).thenReturn((Object)ResumableStreamIteratorTest.resultSet(ByteString.copyFromUtf8((String)"r1"), "a")).thenReturn((Object)ResumableStreamIteratorTest.resultSet(ByteString.copyFromUtf8((String)"r2"), "b")).thenThrow(new Throwable[]{new RetryableException(ErrorCode.UNAVAILABLE, "failed by test")});
        ResultSetStream s2 = (ResultSetStream)Mockito.mock(ResultSetStream.class);
        Mockito.when(this.starter.startStream(ByteString.copyFromUtf8((String)"r2"))).thenReturn((Object)new ResultSetIterator(s2));
        Mockito.when((Object)s2.next()).thenReturn((Object)ResumableStreamIteratorTest.resultSet(ByteString.copyFromUtf8((String)"r3"), "c")).thenReturn((Object)ResumableStreamIteratorTest.resultSet(ByteString.copyFromUtf8((String)"r4"), "d")).thenReturn(null);
        Truth.assertThat(ResumableStreamIteratorTest.consume((Iterator<PartialResultSet>)this.resumableStreamIterator)).containsExactly(new Object[]{"a", "b", "c", "d"}).inOrder();
    }

    @Test
    public void bufferLimitRestartWithinLimitAtStartOfResults() {
        this.initWithLimit(1);
        ResultSetStream s1 = (ResultSetStream)Mockito.mock(ResultSetStream.class);
        Mockito.when(this.starter.startStream(null)).thenReturn((Object)new ResultSetIterator(s1));
        Mockito.when((Object)s1.next()).thenReturn((Object)ResumableStreamIteratorTest.resultSet(null, "XXXXXX")).thenThrow(new Throwable[]{new RetryableException(ErrorCode.UNAVAILABLE, "failed by test")});
        ResultSetStream s2 = (ResultSetStream)Mockito.mock(ResultSetStream.class);
        Mockito.when(this.starter.startStream(null)).thenReturn((Object)new ResultSetIterator(s2));
        Mockito.when((Object)s2.next()).thenReturn((Object)ResumableStreamIteratorTest.resultSet(null, "a")).thenReturn((Object)ResumableStreamIteratorTest.resultSet(null, "b")).thenReturn(null);
        Truth.assertThat(ResumableStreamIteratorTest.consume((Iterator<PartialResultSet>)this.resumableStreamIterator)).containsExactly(new Object[]{"a", "b"}).inOrder();
    }

    @Test
    public void bufferLimitRestartWithinLimitMidResults() {
        this.initWithLimit(1);
        ResultSetStream s1 = (ResultSetStream)Mockito.mock(ResultSetStream.class);
        Mockito.when(this.starter.startStream(null)).thenReturn((Object)new ResultSetIterator(s1));
        Mockito.when((Object)s1.next()).thenReturn((Object)ResumableStreamIteratorTest.resultSet(ByteString.copyFromUtf8((String)"r1"), "a")).thenReturn((Object)ResumableStreamIteratorTest.resultSet(null, "XXXXXX")).thenThrow(new Throwable[]{new RetryableException(ErrorCode.UNAVAILABLE, "failed by test")});
        ResultSetStream s2 = (ResultSetStream)Mockito.mock(ResultSetStream.class);
        Mockito.when(this.starter.startStream(ByteString.copyFromUtf8((String)"r1"))).thenReturn((Object)new ResultSetIterator(s2));
        Mockito.when((Object)s2.next()).thenReturn((Object)ResumableStreamIteratorTest.resultSet(null, "b")).thenReturn((Object)ResumableStreamIteratorTest.resultSet(null, "c")).thenReturn(null);
        Truth.assertThat(ResumableStreamIteratorTest.consume((Iterator<PartialResultSet>)this.resumableStreamIterator)).containsExactly(new Object[]{"a", "b", "c"}).inOrder();
    }

    @Test
    public void bufferLimitMissingTokensUnsafeToRetry() {
        this.initWithLimit(1);
        ResultSetStream s1 = (ResultSetStream)Mockito.mock(ResultSetStream.class);
        Mockito.when(this.starter.startStream(null)).thenReturn((Object)new ResultSetIterator(s1));
        Mockito.when((Object)s1.next()).thenReturn((Object)ResumableStreamIteratorTest.resultSet(ByteString.copyFromUtf8((String)"r1"), "a")).thenReturn((Object)ResumableStreamIteratorTest.resultSet(null, "b")).thenReturn((Object)ResumableStreamIteratorTest.resultSet(null, "c")).thenThrow(new Throwable[]{new RetryableException(ErrorCode.UNAVAILABLE, "failed by test")});
        Truth.assertThat(ResumableStreamIteratorTest.consumeAtMost(3, (Iterator<PartialResultSet>)this.resumableStreamIterator)).containsExactly(new Object[]{"a", "b", "c"}).inOrder();
        try {
            this.resumableStreamIterator.next();
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.UNAVAILABLE);
        }
    }

    @Test
    public void bufferLimitMissingTokensSafeToRetry() {
        this.initWithLimit(1);
        ResultSetStream s1 = (ResultSetStream)Mockito.mock(ResultSetStream.class);
        Mockito.when(this.starter.startStream(null)).thenReturn((Object)new ResultSetIterator(s1));
        Mockito.when((Object)s1.next()).thenReturn((Object)ResumableStreamIteratorTest.resultSet(ByteString.copyFromUtf8((String)"r1"), "a")).thenReturn((Object)ResumableStreamIteratorTest.resultSet(null, "b")).thenReturn((Object)ResumableStreamIteratorTest.resultSet(ByteString.copyFromUtf8((String)"r3"), "c")).thenThrow(new Throwable[]{new RetryableException(ErrorCode.UNAVAILABLE, "failed by test")});
        ResultSetStream s2 = (ResultSetStream)Mockito.mock(ResultSetStream.class);
        Mockito.when(this.starter.startStream(ByteString.copyFromUtf8((String)"r3"))).thenReturn((Object)new ResultSetIterator(s2));
        Mockito.when((Object)s2.next()).thenReturn((Object)ResumableStreamIteratorTest.resultSet(null, "d")).thenReturn(null);
        Truth.assertThat(ResumableStreamIteratorTest.consume((Iterator<PartialResultSet>)this.resumableStreamIterator)).containsExactly(new Object[]{"a", "b", "c", "d"}).inOrder();
    }

    static PartialResultSet resultSet(@Nullable ByteString resumeToken, String ... data) {
        PartialResultSet.Builder builder = PartialResultSet.newBuilder();
        if (resumeToken != null) {
            builder.setResumeToken(resumeToken);
        }
        for (String s : data) {
            builder.addValuesBuilder().setStringValue(s);
        }
        return builder.build();
    }

    static Iterator<String> stringIterator(final Iterator<PartialResultSet> iterator) {
        return new AbstractIterator<String>(){
            private final LinkedList<String> buffer = new LinkedList();

            protected String computeNext() {
                block0: while (this.buffer.isEmpty()) {
                    if (!iterator.hasNext()) {
                        this.endOfData();
                        return null;
                    }
                    Iterator iterator2 = ((PartialResultSet)iterator.next()).getValuesList().iterator();
                    while (true) {
                        if (!iterator2.hasNext()) continue block0;
                        Value value = (Value)iterator2.next();
                        this.buffer.add(value.getStringValue());
                    }
                    break;
                }
                return this.buffer.pop();
            }
        };
    }

    static List<String> consume(Iterator<PartialResultSet> iterator) {
        return Lists.newArrayList(ResumableStreamIteratorTest.stringIterator(iterator));
    }

    static List<String> consumeAtMost(int n, Iterator<PartialResultSet> iterator) {
        Iterator<String> stringIterator = ResumableStreamIteratorTest.stringIterator(iterator);
        ArrayList<String> r = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            if (!stringIterator.hasNext()) continue;
            r.add(stringIterator.next());
        }
        return r;
    }

    static class ResultSetIterator
    extends AbstractIterator<PartialResultSet>
    implements AbstractResultSet.CloseableIterator<PartialResultSet> {
        final ResultSetStream stream;

        ResultSetIterator(ResultSetStream stream) {
            this.stream = stream;
        }

        protected PartialResultSet computeNext() {
            PartialResultSet next = this.stream.next();
            if (next == null) {
                this.endOfData();
            }
            return next;
        }

        public void close(@Nullable String message) {
            this.stream.close();
        }

        public boolean isWithBeginTransaction() {
            return false;
        }
    }

    static class NonRetryableException
    extends SpannerException {
        NonRetryableException(ErrorCode code, @Nullable String message) {
            super(SpannerException.DoNotConstructDirectly.ALLOWED, code, false, message, null);
        }
    }

    static class RetryableException
    extends SpannerException {
        RetryableException(ErrorCode code, @Nullable String message) {
            super(SpannerException.DoNotConstructDirectly.ALLOWED, code, true, message, (Throwable)ResumableStreamIteratorTest.statusWithRetryInfo(code));
        }

        RetryableException(ErrorCode code, @Nullable String message, StatusRuntimeException cause) {
            super(SpannerException.DoNotConstructDirectly.ALLOWED, code, true, message, (Throwable)cause);
        }
    }

    static interface ResultSetStream {
        public PartialResultSet next();

        public void close();
    }

    static interface Starter {
        public AbstractResultSet.CloseableIterator<PartialResultSet> startStream(@Nullable ByteString var1);
    }
}

