/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseClientImpl;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.StandardBenchmarkMockServer;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.AuxCounters;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=1, warmups=0)
@Measurement(batchSize=1, iterations=1, timeUnit=TimeUnit.MILLISECONDS)
@Warmup(batchSize=0, iterations=0)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class SelectRandomBenchmark {
    private static final String TEST_PROJECT = "my-project";
    private static final String TEST_INSTANCE = "my-instance";
    private static final String TEST_DATABASE = "my-database";
    private static final int RND_WAIT_TIME_BETWEEN_REQUESTS = 10;
    private static final Random RND = new Random();

    @Benchmark
    public void burstRead(BenchmarkState server) throws Exception {
        int totalQueries = server.maxSessions * 8;
        int parallelThreads = server.maxSessions * 2;
        final DatabaseClient client = server.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        SessionPool pool = ((DatabaseClientImpl)client).pool;
        Truth.assertThat((Integer)pool.totalSessions()).isEqualTo((Object)server.minSessions);
        ListeningScheduledExecutorService service = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newScheduledThreadPool(parallelThreads));
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(totalQueries);
        for (int i = 0; i < totalQueries; ++i) {
            futures.add(service.submit((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Thread.sleep(RND.nextInt(10));
                    try (ResultSet rs = client.singleUse().executeQuery(StandardBenchmarkMockServer.SELECT_RANDOM, new Options.QueryOption[0]);){
                        while (rs.next()) {
                            rs.getCurrentRowAsStruct().toString();
                        }
                        Void void_ = null;
                        return void_;
                    }
                }
            }));
        }
        Futures.allAsList(futures).get();
        service.shutdown();
    }

    @State(value=Scope.Thread)
    @AuxCounters(value=AuxCounters.Type.EVENTS)
    public static class BenchmarkState {
        private StandardBenchmarkMockServer mockServer;
        private Spanner spanner;
        private DatabaseClientImpl client;
        @Param(value={"100"})
        int minSessions;
        @Param(value={"400"})
        int maxSessions;

        @Setup(value=Level.Invocation)
        public void setup() throws Exception {
            this.mockServer = new StandardBenchmarkMockServer();
            TransportChannelProvider channelProvider = this.mockServer.start();
            SpannerOptions options = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(SelectRandomBenchmark.TEST_PROJECT)).setChannelProvider(channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(this.minSessions).setMaxSessions(this.maxSessions).build()).build();
            this.spanner = (Spanner)options.getService();
            this.client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)SelectRandomBenchmark.TEST_PROJECT, (String)SelectRandomBenchmark.TEST_INSTANCE, (String)SelectRandomBenchmark.TEST_DATABASE));
            while (this.client.pool.getNumberOfSessionsInPool() < ((SpannerOptions)this.spanner.getOptions()).getSessionPoolOptions().getMinSessions()) {
                Thread.sleep(1L);
            }
        }

        @TearDown(value=Level.Invocation)
        public void teardown() throws Exception {
            this.spanner.close();
            this.mockServer.shutdown();
        }
    }
}

