/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseClientImpl;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SessionPoolLeakTest {
    private static final StatusRuntimeException FAILED_PRECONDITION = Status.FAILED_PRECONDITION.withDescription("Non-retryable test exception.").asRuntimeException();
    private static MockSpannerServiceImpl mockSpanner;
    private static Server server;
    private static LocalChannelProvider channelProvider;
    private Spanner spanner;
    private DatabaseClient client;
    private SessionPool pool;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        String uniqueName = InProcessServerBuilder.generateName();
        server = ((InProcessServerBuilder)InProcessServerBuilder.forName((String)uniqueName).scheduledExecutorService((ScheduledExecutorService)new ScheduledThreadPoolExecutor(1)).addService((BindableService)mockSpanner)).build().start();
        channelProvider = LocalChannelProvider.create((String)uniqueName);
    }

    @AfterClass
    public static void stopServer() throws InterruptedException {
        server.shutdown();
        server.awaitTermination();
    }

    @Before
    public void setUp() {
        mockSpanner.reset();
        mockSpanner.removeAllExecutionTimes();
        SpannerOptions.Builder builder = (SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance());
        builder.setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(0).setMaxSessions(2).setIncStep(1).build());
        this.spanner = (Spanner)builder.build().getService();
        this.client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
        this.pool = ((DatabaseClientImpl)this.client).pool;
    }

    @After
    public void tearDown() {
        this.spanner.close();
    }

    @Test
    public void testReadWriteTransactionExceptionOnCreateSession() {
        this.readWriteTransactionTest(new Runnable(){

            @Override
            public void run() {
                mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)FAILED_PRECONDITION));
            }
        }, 0);
    }

    @Test
    public void testReadWriteTransactionExceptionOnBegin() {
        this.readWriteTransactionTest(new Runnable(){

            @Override
            public void run() {
                mockSpanner.setBeginTransactionExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)FAILED_PRECONDITION));
            }
        }, 1);
    }

    private void readWriteTransactionTest(Runnable setup, int expectedNumberOfSessionsAfterExecution) {
        MatcherAssert.assertThat((Object)this.pool.getNumberOfSessionsInPool(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)));
        setup.run();
        try {
            this.client.readWriteTransaction(new Options.TransactionOption[0]).run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Void>(){

                public Void run(TransactionContext transaction) {
                    return null;
                }
            });
            Assert.fail((String)"missing FAILED_PRECONDITION exception");
        }
        catch (SpannerException e) {
            MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)ErrorCode.FAILED_PRECONDITION)));
        }
        MatcherAssert.assertThat((Object)this.pool.getNumberOfSessionsInPool(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)expectedNumberOfSessionsAfterExecution)));
    }

    @Test
    public void testTansactionManagerExceptionOnCreateSession() {
        this.transactionManagerTest(new Runnable(){

            @Override
            public void run() {
                mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)FAILED_PRECONDITION));
            }
        }, 0);
    }

    @Test
    public void testTransactionManagerExceptionOnBegin() {
        MatcherAssert.assertThat((Object)this.pool.getNumberOfSessionsInPool(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)));
        mockSpanner.setBeginTransactionExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)FAILED_PRECONDITION));
        try (TransactionManager txManager = this.client.transactionManager(new Options.TransactionOption[0]);){
            txManager.begin();
        }
        MatcherAssert.assertThat((Object)this.pool.getNumberOfSessionsInPool(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1)));
    }

    private void transactionManagerTest(Runnable setup, int expectedNumberOfSessionsAfterExecution) {
        MatcherAssert.assertThat((Object)this.pool.getNumberOfSessionsInPool(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)));
        setup.run();
        try (TransactionManager txManager = this.client.transactionManager(new Options.TransactionOption[0]);){
            txManager.begin();
            Assert.fail((String)"missing FAILED_PRECONDITION exception");
        }
        catch (SpannerException e) {
            MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)ErrorCode.FAILED_PRECONDITION)));
        }
        MatcherAssert.assertThat((Object)this.pool.getNumberOfSessionsInPool(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)expectedNumberOfSessionsAfterExecution)));
    }
}

