/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFunction;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.FailOnOverkillTraceComponentImpl;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TracerTest;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunner;
import com.google.common.truth.Truth;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.inprocess.InProcessServerBuilder;
import io.opencensus.trace.Tracing;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
@Category(value={TracerTest.class})
public class SpanTest {
    private static final String TEST_PROJECT = "my-project";
    private static final String TEST_INSTANCE = "my-instance";
    private static final String TEST_DATABASE = "my-database";
    private static MockSpannerServiceImpl mockSpanner;
    private static Server server;
    private static LocalChannelProvider channelProvider;
    private static final Statement UPDATE_STATEMENT;
    private static final Statement INVALID_UPDATE_STATEMENT;
    private static final long UPDATE_COUNT = 1L;
    private static final Statement SELECT1;
    private static final ResultSetMetadata SELECT1_METADATA;
    private static final com.google.spanner.v1.ResultSet SELECT1_RESULTSET;
    private Spanner spanner;
    private DatabaseClient client;
    private Spanner spannerWithTimeout;
    private DatabaseClient clientWithTimeout;
    private static FailOnOverkillTraceComponentImpl failOnOverkillTraceComponent;
    private static final MockSpannerServiceImpl.SimulatedExecutionTime ONE_SECOND;
    private static final StatusRuntimeException FAILED_PRECONDITION;

    @BeforeClass
    public static void startStaticServer() throws Exception {
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(UPDATE_STATEMENT, 1L));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT1, SELECT1_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(INVALID_UPDATE_STATEMENT, Status.INVALID_ARGUMENT.withDescription("invalid statement").asRuntimeException()));
        String uniqueName = InProcessServerBuilder.generateName();
        server = ((InProcessServerBuilder)InProcessServerBuilder.forName((String)uniqueName).scheduledExecutorService((ScheduledExecutorService)new ScheduledThreadPoolExecutor(1)).addService((BindableService)mockSpanner)).build().start();
        channelProvider = LocalChannelProvider.create((String)uniqueName);
        Field field = Tracing.class.getDeclaredField("traceComponent");
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(null, (Object)failOnOverkillTraceComponent);
    }

    @AfterClass
    public static void stopServer() throws InterruptedException {
        server.shutdown();
        server.awaitTermination();
    }

    @Before
    public void setUp() throws Exception {
        SpannerOptions.Builder builder = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(0).build());
        this.spanner = (Spanner)builder.build().getService();
        this.client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        final RetrySettings retrySettings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1L)).setMaxRetryDelay(Duration.ofMillis((long)1L)).setInitialRpcTimeout(Duration.ofMillis((long)75L)).setMaxRpcTimeout(Duration.ofMillis((long)75L)).setMaxAttempts(3).setTotalTimeout(Duration.ofMillis((long)200L)).build();
        RetrySettings commitRetrySettings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1L)).setMaxRetryDelay(Duration.ofMillis((long)1L)).setInitialRpcTimeout(Duration.ofMillis((long)5000L)).setMaxRpcTimeout(Duration.ofMillis((long)10000L)).setMaxAttempts(1).setTotalTimeout(Duration.ofMillis((long)20000L)).build();
        builder.getSpannerStubSettingsBuilder().applyToAllUnaryMethods(new ApiFunction<UnaryCallSettings.Builder<?, ?>, Void>(){

            public Void apply(UnaryCallSettings.Builder<?, ?> input) {
                input.setRetrySettings(retrySettings);
                return null;
            }
        });
        builder.getSpannerStubSettingsBuilder().executeStreamingSqlSettings().setRetrySettings(retrySettings);
        builder.getSpannerStubSettingsBuilder().commitSettings().setRetrySettings(commitRetrySettings);
        builder.getSpannerStubSettingsBuilder().executeStreamingSqlSettings().setRetrySettings(retrySettings);
        builder.getSpannerStubSettingsBuilder().streamingReadSettings().setRetrySettings(retrySettings);
        this.spannerWithTimeout = (Spanner)builder.build().getService();
        this.clientWithTimeout = this.spannerWithTimeout.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        failOnOverkillTraceComponent.clearSpans();
    }

    @After
    public void tearDown() {
        this.spanner.close();
        mockSpanner.reset();
        mockSpanner.removeAllExecutionTimes();
    }

    @Test
    public void singleUseNonRetryableErrorOnNext() {
        try (ResultSet rs = this.client.singleUse().executeQuery(SELECT1, new Options.QueryOption[0]);){
            mockSpanner.addException((Exception)FAILED_PRECONDITION);
            while (rs.next()) {
                Assert.fail((String)"Expected exception");
            }
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Truth.assertThat((Comparable)ex.getErrorCode()).isEqualTo((Object)ErrorCode.FAILED_PRECONDITION);
        }
    }

    @Test
    public void singleUseExecuteStreamingSqlTimeout() {
        try (ResultSet rs = this.clientWithTimeout.singleUse().executeQuery(SELECT1, new Options.QueryOption[0]);){
            mockSpanner.setExecuteStreamingSqlExecutionTime(ONE_SECOND);
            while (rs.next()) {
                Assert.fail((String)"Expected exception");
            }
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Truth.assertThat((Comparable)ex.getErrorCode()).isEqualTo((Object)ErrorCode.DEADLINE_EXCEEDED);
        }
    }

    @Test
    public void singleUse() {
        try (ResultSet rs = this.client.singleUse().executeQuery(SELECT1, new Options.QueryOption[0]);){
            while (rs.next()) {
            }
        }
        Map<String, Boolean> spans = failOnOverkillTraceComponent.getSpans();
        Truth.assertThat(spans).containsEntry((Object)"CloudSpanner.ReadOnlyTransaction", (Object)true);
        Truth.assertThat(spans).containsEntry((Object)"CloudSpannerOperation.BatchCreateSessions", (Object)true);
        Truth.assertThat(spans).containsEntry((Object)"SessionPool.WaitForSession", (Object)true);
        Truth.assertThat(spans).containsEntry((Object)"CloudSpannerOperation.BatchCreateSessionsRequest", (Object)true);
        Truth.assertThat(spans).containsEntry((Object)"CloudSpannerOperation.ExecuteStreamingQuery", (Object)true);
    }

    @Test
    public void multiUse() {
        try (ReadOnlyTransaction tx = this.client.readOnlyTransaction();
             ResultSet rs = tx.executeQuery(SELECT1, new Options.QueryOption[0]);){
            while (rs.next()) {
            }
        }
        Map<String, Boolean> spans = failOnOverkillTraceComponent.getSpans();
        Truth.assertThat(spans).containsEntry((Object)"CloudSpanner.ReadOnlyTransaction", (Object)true);
        Truth.assertThat(spans).containsEntry((Object)"CloudSpannerOperation.BatchCreateSessions", (Object)true);
        Truth.assertThat(spans).containsEntry((Object)"SessionPool.WaitForSession", (Object)true);
        Truth.assertThat(spans).containsEntry((Object)"CloudSpannerOperation.BatchCreateSessionsRequest", (Object)true);
        Truth.assertThat(spans).containsEntry((Object)"CloudSpannerOperation.ExecuteStreamingQuery", (Object)true);
    }

    @Test
    public void transactionRunner() {
        TransactionRunner runner = this.client.readWriteTransaction(new Options.TransactionOption[0]);
        runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Void>(){

            public Void run(TransactionContext transaction) {
                transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
                return null;
            }
        });
        Map<String, Boolean> spans = failOnOverkillTraceComponent.getSpans();
        Truth.assertThat(spans).containsEntry((Object)"CloudSpanner.ReadWriteTransaction", (Object)true);
        Truth.assertThat(spans).containsEntry((Object)"CloudSpannerOperation.BatchCreateSessions", (Object)true);
        Truth.assertThat(spans).containsEntry((Object)"SessionPool.WaitForSession", (Object)true);
        Truth.assertThat(spans).containsEntry((Object)"CloudSpannerOperation.BatchCreateSessionsRequest", (Object)true);
        Truth.assertThat(spans).containsEntry((Object)"CloudSpannerOperation.Commit", (Object)true);
    }

    @Test
    public void transactionRunnerWithError() {
        TransactionRunner runner = this.client.readWriteTransaction(new Options.TransactionOption[0]);
        try {
            runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Void>(){

                public Void run(TransactionContext transaction) {
                    transaction.executeUpdate(INVALID_UPDATE_STATEMENT, new Options.UpdateOption[0]);
                    return null;
                }
            });
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
        }
        Map<String, Boolean> spans = failOnOverkillTraceComponent.getSpans();
        Truth.assertThat((Integer)spans.size()).isEqualTo((Object)4);
        Truth.assertThat(spans).containsEntry((Object)"CloudSpanner.ReadWriteTransaction", (Object)true);
        Truth.assertThat(spans).containsEntry((Object)"CloudSpannerOperation.BatchCreateSessions", (Object)true);
        Truth.assertThat(spans).containsEntry((Object)"SessionPool.WaitForSession", (Object)true);
        Truth.assertThat(spans).containsEntry((Object)"CloudSpannerOperation.BatchCreateSessionsRequest", (Object)true);
    }

    static {
        UPDATE_STATEMENT = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE BAZ=2");
        INVALID_UPDATE_STATEMENT = Statement.of((String)"UPDATE NON_EXISTENT_TABLE SET BAR=1 WHERE BAZ=2");
        SELECT1 = Statement.of((String)"SELECT 1 AS COL1");
        SELECT1_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("COL1").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
        SELECT1_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).setMetadata(SELECT1_METADATA).build();
        failOnOverkillTraceComponent = new FailOnOverkillTraceComponentImpl();
        ONE_SECOND = MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(1000, 0);
        FAILED_PRECONDITION = Status.FAILED_PRECONDITION.withDescription("Non-retryable test exception.").asRuntimeException();
    }
}

