/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.DatabaseNotFoundException;
import com.google.cloud.spanner.InstanceNotFoundException;
import com.google.cloud.spanner.SessionNotFoundException;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.common.truth.Truth;
import com.google.protobuf.Duration;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.rpc.ResourceInfo;
import com.google.rpc.RetryInfo;
import io.grpc.Context;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.protobuf.lite.ProtoLiteUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class SpannerExceptionFactoryTest {
    static SessionNotFoundException newSessionNotFoundException(String name) {
        return (SessionNotFoundException)SpannerExceptionFactoryTest.newResourceNotFoundException("Session", "type.googleapis.com/google.spanner.v1.Session", name);
    }

    static DatabaseNotFoundException newDatabaseNotFoundException(String name) {
        return (DatabaseNotFoundException)SpannerExceptionFactoryTest.newResourceNotFoundException("Database", "type.googleapis.com/google.spanner.admin.database.v1.Database", name);
    }

    static StatusRuntimeException newStatusDatabaseNotFoundException(String name) {
        return SpannerExceptionFactoryTest.newStatusResourceNotFoundException("Database", "type.googleapis.com/google.spanner.admin.database.v1.Database", name);
    }

    static InstanceNotFoundException newInstanceNotFoundException(String name) {
        return (InstanceNotFoundException)SpannerExceptionFactoryTest.newResourceNotFoundException("Instance", "type.googleapis.com/google.spanner.admin.instance.v1.Instance", name);
    }

    static StatusRuntimeException newStatusResourceNotFoundException(String shortName, String resourceType, String resourceName) {
        ResourceInfo resourceInfo = ResourceInfo.newBuilder().setResourceType(resourceType).setResourceName(resourceName).build();
        Metadata.Key key = Metadata.Key.of((String)(resourceInfo.getDescriptorForType().getFullName() + "-bin"), (Metadata.BinaryMarshaller)ProtoLiteUtils.metadataMarshaller((MessageLite)resourceInfo));
        Metadata trailers = new Metadata();
        trailers.put(key, (Object)resourceInfo);
        String message = String.format("%s not found: %s with id %s not found", shortName, shortName, resourceName);
        return Status.NOT_FOUND.withDescription(message).asRuntimeException(trailers);
    }

    private static SpannerException.ResourceNotFoundException newResourceNotFoundException(String shortName, String resourceType, String resourceName) {
        return (SpannerException.ResourceNotFoundException)SpannerExceptionFactory.newSpannerException((Throwable)SpannerExceptionFactoryTest.newStatusResourceNotFoundException(shortName, resourceType, resourceName));
    }

    @Test
    public void http2InternalErrorIsRetryable() {
        Status status = Status.fromCodeValue((int)Status.Code.INTERNAL.value()).withDescription("HTTP/2 error code: INTERNAL_ERROR");
        SpannerException e = SpannerExceptionFactory.newSpannerException((Throwable)new StatusRuntimeException(status));
        Truth.assertThat((Boolean)e.isRetryable()).isTrue();
    }

    @Test
    public void connectionClosedIsRetryable() {
        Status status = Status.fromCodeValue((int)Status.Code.INTERNAL.value()).withDescription("Connection closed with unknown cause");
        SpannerException e = SpannerExceptionFactory.newSpannerException((Throwable)new StatusRuntimeException(status));
        Truth.assertThat((Boolean)e.isRetryable()).isTrue();
    }

    @Test
    public void resourceExhausted() {
        Status status = Status.fromCodeValue((int)Status.Code.RESOURCE_EXHAUSTED.value()).withDescription("Memory pushback");
        SpannerException e = SpannerExceptionFactory.newSpannerException((Throwable)new StatusRuntimeException(status));
        Truth.assertThat((Boolean)e.isRetryable()).isFalse();
    }

    @Test
    public void resourceExhaustedWithBackoff() {
        Status status = Status.fromCodeValue((int)Status.Code.RESOURCE_EXHAUSTED.value()).withDescription("Memory pushback");
        Metadata trailers = new Metadata();
        Metadata.Key key = ProtoUtils.keyForProto((Message)RetryInfo.getDefaultInstance());
        RetryInfo retryInfo = RetryInfo.newBuilder().setRetryDelay(Duration.newBuilder().setNanos(1000000).setSeconds(1L)).build();
        trailers.put(key, (Object)retryInfo);
        SpannerException e = SpannerExceptionFactory.newSpannerException((Throwable)new StatusRuntimeException(status, trailers));
        Truth.assertThat((Boolean)e.isRetryable()).isTrue();
        Truth.assertThat((Long)e.getRetryDelayInMillis()).isEqualTo((Object)1001);
    }

    @Test
    public void abortWithRetryInfo() {
        Metadata.Key key = ProtoUtils.keyForProto((Message)RetryInfo.getDefaultInstance());
        Status status = Status.fromCodeValue((int)Status.Code.ABORTED.value());
        Metadata trailers = new Metadata();
        RetryInfo retryInfo = RetryInfo.newBuilder().setRetryDelay(Duration.newBuilder().setNanos(1000000).setSeconds(1L)).build();
        trailers.put(key, (Object)retryInfo);
        SpannerException e = SpannerExceptionFactory.newSpannerException((Throwable)new StatusRuntimeException(status, trailers));
        Truth.assertThat((Throwable)e).isInstanceOf(AbortedException.class);
        Truth.assertThat((Long)((AbortedException)((Object)e)).getRetryDelayInMillis()).isEqualTo((Object)1001L);
    }

    @Test
    public void abortWithoutRetryInfo() {
        Status status = Status.fromCodeValue((int)Status.Code.ABORTED.value());
        SpannerException e = SpannerExceptionFactory.newSpannerException((Throwable)new StatusRuntimeException(status));
        Truth.assertThat((Throwable)e).isInstanceOf(AbortedException.class);
        Truth.assertThat((Long)((AbortedException)((Object)e)).getRetryDelayInMillis()).isEqualTo((Object)-1L);
    }

    @Test
    public void abortWithoutDuration() {
        Metadata.Key key = ProtoUtils.keyForProto((Message)RetryInfo.getDefaultInstance());
        Status status = Status.fromCodeValue((int)Status.Code.ABORTED.value());
        Metadata trailers = new Metadata();
        trailers.put(key, (Object)RetryInfo.getDefaultInstance());
        SpannerException e = SpannerExceptionFactory.newSpannerException((Throwable)new StatusRuntimeException(status, trailers));
        Truth.assertThat((Throwable)e).isInstanceOf(AbortedException.class);
        Truth.assertThat((Long)((AbortedException)((Object)e)).getRetryDelayInMillis()).isEqualTo((Object)-1L);
    }

    @Test
    public void nullCancel() {
        Context context = (Context)Mockito.mock(Context.class);
        Mockito.when((Object)context.isCancelled()).thenReturn((Object)true);
        Mockito.when((Object)context.cancellationCause()).thenReturn(null);
        SpannerException spannerException = SpannerExceptionFactory.newSpannerExceptionForCancellation((Context)context, null);
        Truth.assertThat((String)spannerException.getMessage()).isEqualTo((Object)"CANCELLED: Current context was cancelled");
    }

    @Test
    public void sessionNotFound() {
        SessionNotFoundException e = SpannerExceptionFactoryTest.newSessionNotFoundException("projects/p/instances/i/databases/d/sessions/s");
        Truth.assertThat((String)e.getResourceName()).isEqualTo((Object)"projects/p/instances/i/databases/d/sessions/s");
    }

    @Test
    public void databaseNotFound() {
        DatabaseNotFoundException e = SpannerExceptionFactoryTest.newDatabaseNotFoundException("projects/p/instances/i/databases/d");
        Truth.assertThat((String)e.getResourceName()).isEqualTo((Object)"projects/p/instances/i/databases/d");
    }

    @Test
    public void instanceNotFound() {
        InstanceNotFoundException e = SpannerExceptionFactoryTest.newInstanceNotFoundException("projects/p/instances/i");
        Truth.assertThat((String)e.getResourceName()).isEqualTo((Object)"projects/p/instances/i");
    }

    @Test
    public void statusRuntimeExceptionSessionNotFound() {
        SpannerException spannerException = SpannerExceptionFactory.newSpannerException((Throwable)Status.NOT_FOUND.withDescription("NOT_FOUND: Session not found: projects/p/instances/i/databases/d/sessions/s").asRuntimeException(this.createResourceTypeMetadata("type.googleapis.com/google.spanner.v1.Session", "projects/p/instances/i/databases/d/sessions/s")));
        Truth.assertThat((Throwable)spannerException).isInstanceOf(SessionNotFoundException.class);
    }

    @Test
    public void apiExceptionSessionNotFound() {
        SpannerException spannerException = SpannerExceptionFactory.newSpannerException((Throwable)ApiExceptionFactory.createException((String)"NOT_FOUND: Session not found: projects/p/instances/i/databases/d/sessions/s", (Throwable)Status.NOT_FOUND.withDescription("NOT_FOUND: Session not found: projects/p/instances/i/databases/d/sessions/s").asRuntimeException(this.createResourceTypeMetadata("type.googleapis.com/google.spanner.v1.Session", "projects/p/instances/i/databases/d/sessions/s")), (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.NOT_FOUND), (boolean)false));
        Truth.assertThat((Throwable)spannerException).isInstanceOf(SessionNotFoundException.class);
    }

    private Metadata createResourceTypeMetadata(String resourceType, String resourceName) {
        ResourceInfo resourceInfo = ResourceInfo.newBuilder().setResourceType(resourceType).setResourceName(resourceName).build();
        Metadata.Key key = Metadata.Key.of((String)(resourceInfo.getDescriptorForType().getFullName() + "-bin"), (Metadata.BinaryMarshaller)ProtoLiteUtils.metadataMarshaller((MessageLite)resourceInfo));
        Metadata trailers = new Metadata();
        trailers.put(key, (Object)resourceInfo);
        return trailers;
    }
}

