/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerRetryHelper;
import com.google.common.base.Stopwatch;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.Duration;
import com.google.protobuf.Message;
import com.google.rpc.RetryInfo;
import io.grpc.Context;
import io.grpc.Deadline;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.ProtoUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SpannerRetryHelperTest {
    @Test
    public void testCancelledContext() {
        block2: {
            final Context.CancellableContext withCancellation = Context.current().withCancellation();
            final CountDownLatch latch = new CountDownLatch(1);
            final Callable<Integer> callable = new Callable<Integer>(){

                @Override
                public Integer call() {
                    latch.countDown();
                    throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.ABORTED, (String)"test");
                }
            };
            ScheduledExecutorService service = Executors.newScheduledThreadPool(1);
            service.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    latch.await();
                    withCancellation.cancel((Throwable)new InterruptedException());
                    return null;
                }
            });
            try {
                withCancellation.run(new Runnable(){

                    @Override
                    public void run() {
                        SpannerRetryHelper.runTxWithRetriesOnAborted((Callable)callable);
                    }
                });
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException e) {
                if (e.getErrorCode() == ErrorCode.CANCELLED) break block2;
                Assert.fail((String)String.format("unexpected error %s, expected %s", e.getErrorCode().name(), ErrorCode.CANCELLED.name()));
            }
        }
    }

    @Test
    public void testTimedoutContext() {
        block2: {
            ScheduledExecutorService service = Executors.newScheduledThreadPool(1);
            final Callable<Integer> callable = new Callable<Integer>(){

                @Override
                public Integer call() {
                    throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.ABORTED, (String)"test");
                }
            };
            try {
                Context.CancellableContext withDeadline = Context.current().withDeadline(Deadline.after((long)1L, (TimeUnit)TimeUnit.MILLISECONDS), service);
                withDeadline.run(new Runnable(){

                    @Override
                    public void run() {
                        SpannerRetryHelper.runTxWithRetriesOnAborted((Callable)callable);
                    }
                });
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException e) {
                if (e.getErrorCode() == ErrorCode.DEADLINE_EXCEEDED) break block2;
                Assert.fail((String)String.format("unexpected error %s, expected %s", e.getErrorCode().name(), ErrorCode.DEADLINE_EXCEEDED.name()));
            }
        }
    }

    @Test
    public void noException() {
        Callable<Integer> callable = new Callable<Integer>(){

            @Override
            public Integer call() {
                return 2;
            }
        };
        Truth.assertThat((Integer)((Integer)SpannerRetryHelper.runTxWithRetriesOnAborted((Callable)callable))).isEqualTo((Object)2);
    }

    @Test(expected=IllegalStateException.class)
    public void propagateUncheckedException() {
        Callable<Integer> callable = new Callable<Integer>(){

            @Override
            public Integer call() {
                throw new IllegalStateException("test");
            }
        };
        SpannerRetryHelper.runTxWithRetriesOnAborted((Callable)callable);
    }

    @Test
    public void retryOnAborted() {
        final AtomicInteger attempts = new AtomicInteger();
        Callable<Integer> callable = new Callable<Integer>(){

            @Override
            public Integer call() {
                if (attempts.getAndIncrement() == 0) {
                    throw SpannerRetryHelperTest.this.abortedWithRetryInfo((int)TimeUnit.MILLISECONDS.toNanos(1L));
                }
                return 2;
            }
        };
        Truth.assertThat((Integer)((Integer)SpannerRetryHelper.runTxWithRetriesOnAborted((Callable)callable))).isEqualTo((Object)2);
    }

    @Test
    public void retryMultipleTimesOnAborted() {
        final AtomicInteger attempts = new AtomicInteger();
        Callable<Integer> callable = new Callable<Integer>(){

            @Override
            public Integer call() {
                if (attempts.getAndIncrement() < 2) {
                    throw SpannerRetryHelperTest.this.abortedWithRetryInfo((int)TimeUnit.MILLISECONDS.toNanos(1L));
                }
                return 2;
            }
        };
        Truth.assertThat((Integer)((Integer)SpannerRetryHelper.runTxWithRetriesOnAborted((Callable)callable))).isEqualTo((Object)2);
    }

    @Test(expected=IllegalStateException.class)
    public void retryOnAbortedAndThenPropagateUnchecked() {
        final AtomicInteger attempts = new AtomicInteger();
        Callable<Integer> callable = new Callable<Integer>(){

            @Override
            public Integer call() {
                if (attempts.getAndIncrement() == 0) {
                    throw SpannerRetryHelperTest.this.abortedWithRetryInfo((int)TimeUnit.MILLISECONDS.toNanos(1L));
                }
                throw new IllegalStateException("test");
            }
        };
        SpannerRetryHelper.runTxWithRetriesOnAborted((Callable)callable);
    }

    @Test
    public void testExceptionWithRetryInfo() {
        new ThreadFactoryBuilder().setDaemon(true).build().newThread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(Long.MAX_VALUE);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        });
        int RETRY_DELAY_MILLIS = 100;
        Metadata.Key key = ProtoUtils.keyForProto((Message)RetryInfo.getDefaultInstance());
        Status status = Status.fromCodeValue((int)Status.Code.ABORTED.value());
        Metadata trailers = new Metadata();
        RetryInfo retryInfo = RetryInfo.newBuilder().setRetryDelay(Duration.newBuilder().setNanos((int)TimeUnit.NANOSECONDS.convert(100L, TimeUnit.MILLISECONDS)).build()).build();
        trailers.put(key, (Object)retryInfo);
        final SpannerException e = SpannerExceptionFactory.newSpannerException((Throwable)new StatusRuntimeException(status, trailers));
        final AtomicInteger attempts = new AtomicInteger();
        Callable<Integer> callable = new Callable<Integer>(){

            @Override
            public Integer call() {
                if (attempts.getAndIncrement() == 0) {
                    throw e;
                }
                return 2;
            }
        };
        Stopwatch watch = Stopwatch.createStarted();
        Truth.assertThat((Integer)((Integer)SpannerRetryHelper.runTxWithRetriesOnAborted((Callable)callable))).isEqualTo((Object)2);
        long elapsed = watch.elapsed(TimeUnit.MILLISECONDS);
        Truth.assertThat((Long)elapsed).isAtLeast(99);
    }

    private SpannerException abortedWithRetryInfo(int nanos) {
        Metadata.Key key = ProtoUtils.keyForProto((Message)RetryInfo.getDefaultInstance());
        Status status = Status.fromCodeValue((int)Status.Code.ABORTED.value());
        Metadata trailers = new Metadata();
        RetryInfo retryInfo = RetryInfo.newBuilder().setRetryDelay(Duration.newBuilder().setNanos(nanos).setSeconds(0L)).build();
        trailers.put(key, (Object)retryInfo);
        return SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.ABORTED, (String)"test", (Throwable)new StatusRuntimeException(status, trailers));
    }
}

