/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class StructTest {
    @Test
    public void builder() {
        Struct struct = ((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f1").to("x")).set("f2").to(2L)).set("f3").to(Value.bool(null))).build();
        Truth.assertThat((Object)struct.getType()).isEqualTo((Object)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f1", (Type)Type.string()), Type.StructField.of((String)"f2", (Type)Type.int64()), Type.StructField.of((String)"f3", (Type)Type.bool())}));
        Truth.assertThat((Boolean)struct.isNull(0)).isFalse();
        Truth.assertThat((Boolean)struct.isNull(1)).isFalse();
        Truth.assertThat((Boolean)struct.isNull(2)).isTrue();
        Truth.assertThat((String)struct.getString(0)).isEqualTo((Object)"x");
        Truth.assertThat((Long)struct.getLong(1)).isEqualTo((Object)2);
    }

    @Test
    public void duplicateFields() {
        Struct struct = ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("").to("x")).set("").to(Value.int64((long)2L))).build();
        Truth.assertThat((Object)struct.getType()).isEqualTo((Object)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"", (Type)Type.string()), Type.StructField.of((String)"", (Type)Type.int64())}));
        Truth.assertThat((Boolean)struct.isNull(0)).isFalse();
        Truth.assertThat((Boolean)struct.isNull(1)).isFalse();
        Truth.assertThat((String)struct.getString(0)).isEqualTo((Object)"x");
        Truth.assertThat((Long)struct.getLong(1)).isEqualTo((Object)2);
    }

    @Test
    public void unnamedFields() {
        Struct struct = Struct.newBuilder().add(Value.int64((long)2L)).add(Value.int64((long)3L)).build();
        Truth.assertThat((Object)struct.getType()).isEqualTo((Object)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"", (Type)Type.int64()), Type.StructField.of((String)"", (Type)Type.int64())}));
        Truth.assertThat((Long)struct.getLong(0)).isEqualTo((Object)2);
        Truth.assertThat((Long)struct.getLong(1)).isEqualTo((Object)3);
    }

    @Test
    public void structWithStructField() {
        Struct nestedStruct = ((Struct.Builder)Struct.newBuilder().set("f2f1").to(10L)).build();
        Struct struct = ((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f1").to("v1")).set("f2").to(nestedStruct)).set("f3").to(nestedStruct.getType(), null)).build();
        Truth.assertThat((Object)struct.getType()).isEqualTo((Object)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f1", (Type)Type.string()), Type.StructField.of((String)"f2", (Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f2f1", (Type)Type.int64())})), Type.StructField.of((String)"f3", (Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f2f1", (Type)Type.int64())}))}));
        Truth.assertThat((Boolean)struct.isNull(0)).isFalse();
        Truth.assertThat((Boolean)struct.isNull(1)).isFalse();
        Truth.assertThat((Boolean)struct.isNull(2)).isTrue();
        Truth.assertThat((String)struct.getString(0)).isEqualTo((Object)"v1");
        Truth.assertThat((String)struct.getString("f1")).isEqualTo((Object)"v1");
        Truth.assertThat((Object)struct.getStruct(1)).isEqualTo((Object)nestedStruct);
        Truth.assertThat((Object)struct.getStruct("f2")).isEqualTo((Object)nestedStruct);
    }

    @Test
    public void structWithArrayOfStructField() {
        Type elementType = Type.struct(Arrays.asList(Type.StructField.of((String)"ff1", (Type)Type.string()), Type.StructField.of((String)"ff2", (Type)Type.int64())));
        List<Struct> arrayElements = Arrays.asList(((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("ff1").to("v1")).set("ff2").to(1L)).build(), ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("ff1").to("v1")).set("ff2").to(1L)).build());
        Struct struct = ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f1").to("x")).set("f2").toStructArray(elementType, arrayElements)).build();
        Truth.assertThat((Object)struct.getType()).isEqualTo((Object)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f1", (Type)Type.string()), Type.StructField.of((String)"f2", (Type)Type.array((Type)elementType))}));
        Truth.assertThat((Boolean)struct.isNull(0)).isFalse();
        Truth.assertThat((Boolean)struct.isNull(1)).isFalse();
        Truth.assertThat((String)struct.getString(0)).isEqualTo((Object)"x");
        Truth.assertThat((Iterable)struct.getStructList(1)).isEqualTo(arrayElements);
    }

    @Test
    public void equalsAndHashCode() {
        EqualsTester tester = new EqualsTester();
        tester.addEqualityGroup(new Object[]{((Struct.Builder)Struct.newBuilder().set("x").to(1L)).build(), ((Struct.Builder)Struct.newBuilder().set("x").to(Value.int64((long)1L))).build()});
        tester.addEqualityGroup(new Object[]{((Struct.Builder)Struct.newBuilder().set("x").to((Long)null)).build()});
        tester.addEqualityGroup(new Object[]{((Struct.Builder)Struct.newBuilder().set("x").to((String)null)).build()});
        tester.addEqualityGroup(new Object[]{((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("x").to(1L)).set("y").to(2L)).build()});
        tester.addEqualityGroup(new Object[]{((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("x").to(1L)).set("y").to("2")).build()});
        tester.addEqualityGroup(new Object[]{((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("y").to(2L)).set("x").to(1L)).build()});
        tester.addEqualityGroup(new Object[]{Struct.newBuilder().build(), Struct.newBuilder().build()});
        Struct nestedStruct = ((Struct.Builder)Struct.newBuilder().set("f").to(1L)).build();
        Struct structFieldStruct1 = ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("sf").to(nestedStruct)).set("nullsf").to(nestedStruct.getType(), null)).build();
        Struct structFieldStruct2 = ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("sf").to(Value.struct((Struct)nestedStruct))).set("nullsf").to(Value.struct((Type)nestedStruct.getType(), null))).build();
        tester.addEqualityGroup(new Object[]{structFieldStruct1, structFieldStruct2});
        Struct arrayStructFieldStruct1 = ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("arraysf").toStructArray(nestedStruct.getType(), Arrays.asList(null, nestedStruct))).set("nullarraysf").toStructArray(nestedStruct.getType(), null)).build();
        Struct arrayStructFieldStruct2 = ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("arraysf").to(Value.structArray((Type)nestedStruct.getType(), Arrays.asList(null, nestedStruct)))).set("nullarraysf").to(Value.structArray((Type)nestedStruct.getType(), null))).build();
        tester.addEqualityGroup(new Object[]{arrayStructFieldStruct1, arrayStructFieldStruct2});
        Struct duplicateFieldStruct1 = ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f1").to(3L)).set("f1").to(nestedStruct)).build();
        Struct duplicateFieldStruct2 = ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f1").to(Value.int64((long)3L))).set("f1").to(Value.struct((Struct)nestedStruct))).build();
        tester.addEqualityGroup(new Object[]{duplicateFieldStruct1, duplicateFieldStruct2});
        Struct emptyFieldStruct1 = ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("").to(3L)).set("").to(nestedStruct)).build();
        Struct emptyFieldStruct2 = Struct.newBuilder().add(Value.int64((long)3L)).add(Value.struct((Struct)nestedStruct)).build();
        tester.addEqualityGroup(new Object[]{emptyFieldStruct1, emptyFieldStruct2});
        tester.testEquals();
    }

    @Test
    public void serialization() {
        Struct simpleStruct = ((Struct.Builder)Struct.newBuilder().set("x").to(1L)).build();
        SerializableTester.reserializeAndAssert((Object)simpleStruct);
        simpleStruct = ((Struct.Builder)Struct.newBuilder().set("x").to((Long)null)).build();
        SerializableTester.reserializeAndAssert((Object)simpleStruct);
        Struct structFieldStruct = ((Struct.Builder)Struct.newBuilder().set("f1").to(simpleStruct)).build();
        SerializableTester.reserializeAndAssert((Object)structFieldStruct);
        structFieldStruct = ((Struct.Builder)Struct.newBuilder().set("f1").to(simpleStruct.getType(), null)).build();
        SerializableTester.reserializeAndAssert((Object)structFieldStruct);
        Struct arrayStructFieldStruct = ((Struct.Builder)Struct.newBuilder().set("f1").toStructArray(simpleStruct.getType(), new ArrayList())).build();
        SerializableTester.reserializeAndAssert((Object)arrayStructFieldStruct);
        arrayStructFieldStruct = ((Struct.Builder)Struct.newBuilder().set("f1").toStructArray(simpleStruct.getType(), null)).build();
        SerializableTester.reserializeAndAssert((Object)arrayStructFieldStruct);
        SerializableTester.reserializeAndAssert((Object)Struct.newBuilder().build());
        SerializableTester.reserializeAndAssert((Object)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f1").to(3L)).set("f1").to(30L)).build());
        SerializableTester.reserializeAndAssert((Object)Struct.newBuilder().add(Value.int64((long)3L)).add(Value.int64((long)30L)).build());
    }
}

