/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.SpannerMatchers;
import com.google.cloud.spanner.TimestampBound;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import com.google.spanner.v1.TransactionOptions;
import java.util.concurrent.TimeUnit;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TimestampBoundTest {
    private static final long TEST_TIME_SECONDS = 1444662894L;
    private static final String TEST_TIME_ISO = "2015-10-12T15:14:54Z";

    @Test
    public void serialization() {
        SerializableTester.reserializeAndAssert((Object)TimestampBound.strong());
        SerializableTester.reserializeAndAssert((Object)TimestampBound.ofExactStaleness((long)10L, (TimeUnit)TimeUnit.NANOSECONDS));
        SerializableTester.reserializeAndAssert((Object)TimestampBound.ofMaxStaleness((long)100L, (TimeUnit)TimeUnit.DAYS));
        SerializableTester.reserializeAndAssert((Object)TimestampBound.ofMinReadTimestamp((Timestamp)Timestamp.now()));
        SerializableTester.reserializeAndAssert((Object)TimestampBound.ofReadTimestamp((Timestamp)Timestamp.now()));
    }

    @Test
    public void strong() {
        TimestampBound bound = TimestampBound.strong();
        Truth.assertThat((Comparable)bound.getMode()).isEqualTo((Object)TimestampBound.Mode.STRONG);
        Truth.assertThat((String)bound.toString()).isEqualTo((Object)"strong");
        TimestampBoundTest.assertProto(bound, "strong: true");
    }

    @Test
    public void readTimestamp() {
        Timestamp ts = Timestamp.ofTimeSecondsAndNanos((long)1444662894L, (int)0);
        TimestampBound bound = TimestampBound.ofReadTimestamp((Timestamp)ts);
        Truth.assertThat((Comparable)bound.getMode()).isEqualTo((Object)TimestampBound.Mode.READ_TIMESTAMP);
        Truth.assertThat((Comparable)bound.getReadTimestamp()).isEqualTo((Object)ts);
        Truth.assertThat((String)bound.toString()).isEqualTo((Object)"exact_timestamp: 2015-10-12T15:14:54Z");
        TimestampBoundTest.assertProto(bound, "read_timestamp { seconds: 1444662894 }");
    }

    @Test
    public void minReadTimestamp() {
        Timestamp ts = Timestamp.ofTimeSecondsAndNanos((long)1444662894L, (int)0);
        TimestampBound bound = TimestampBound.ofMinReadTimestamp((Timestamp)ts);
        Truth.assertThat((Comparable)bound.getMode()).isEqualTo((Object)TimestampBound.Mode.MIN_READ_TIMESTAMP);
        Truth.assertThat((Comparable)bound.getMinReadTimestamp()).isEqualTo((Object)ts);
        Truth.assertThat((String)bound.toString()).isEqualTo((Object)"min_read_timestamp: 2015-10-12T15:14:54Z");
        TimestampBoundTest.assertProto(bound, "min_read_timestamp { seconds: 1444662894 }");
    }

    @Test
    public void exactStaleness() {
        TimestampBound bound = TimestampBound.ofExactStaleness((long)3140L, (TimeUnit)TimeUnit.MILLISECONDS);
        Truth.assertThat((Comparable)bound.getMode()).isEqualTo((Object)TimestampBound.Mode.EXACT_STALENESS);
        Truth.assertThat((Long)bound.getExactStaleness(TimeUnit.SECONDS)).isEqualTo((Object)3);
        Truth.assertThat((Long)bound.getExactStaleness(TimeUnit.MILLISECONDS)).isEqualTo((Object)3140);
        Truth.assertThat((Long)bound.getExactStaleness(TimeUnit.MICROSECONDS)).isEqualTo((Object)3140000);
        Truth.assertThat((Long)bound.getExactStaleness(TimeUnit.NANOSECONDS)).isEqualTo((Object)3140000000L);
        Truth.assertThat((String)bound.toString()).isEqualTo((Object)"exact_staleness: 3.140s");
        TimestampBoundTest.assertProto(bound, "exact_staleness { seconds: 3 nanos: 140000000 }");
    }

    @Test
    public void exactStalenessNegative() {
        try {
            TimestampBound.ofExactStaleness((long)-1L, (TimeUnit)TimeUnit.SECONDS);
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void maxStaleness() {
        TimestampBound bound = TimestampBound.ofMaxStaleness((long)3140L, (TimeUnit)TimeUnit.MILLISECONDS);
        Truth.assertThat((Comparable)bound.getMode()).isEqualTo((Object)TimestampBound.Mode.MAX_STALENESS);
        Truth.assertThat((Long)bound.getMaxStaleness(TimeUnit.SECONDS)).isEqualTo((Object)3);
        Truth.assertThat((Long)bound.getMaxStaleness(TimeUnit.MILLISECONDS)).isEqualTo((Object)3140);
        Truth.assertThat((Long)bound.getMaxStaleness(TimeUnit.MICROSECONDS)).isEqualTo((Object)3140000);
        Truth.assertThat((Long)bound.getMaxStaleness(TimeUnit.NANOSECONDS)).isEqualTo((Object)3140000000L);
        Truth.assertThat((String)bound.toString()).isEqualTo((Object)"max_staleness: 3.140s");
        TimestampBoundTest.assertProto(bound, "max_staleness { seconds: 3 nanos: 140000000 }");
    }

    @Test
    public void stalenessSourceUnits() {
        long num = 7L;
        for (TimeUnit units : TimeUnit.values()) {
            TimestampBound bound = TimestampBound.ofExactStaleness((long)num, (TimeUnit)units);
            Truth.assertWithMessage((String)units.toString()).that(Long.valueOf(bound.getExactStaleness(TimeUnit.NANOSECONDS))).isEqualTo((Object)units.toNanos(num));
        }
    }

    @Test
    public void maxStalenessNegative() {
        try {
            TimestampBound.ofMaxStaleness((long)-1L, (TimeUnit)TimeUnit.SECONDS);
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void equalsAndHashCode() {
        Timestamp ts = Timestamp.ofTimeSecondsAndNanos((long)1444662894L, (int)0);
        Timestamp ts2 = Timestamp.ofTimeSecondsAndNanos((long)1444662895L, (int)0);
        int staleness = 5;
        EqualsTester tester = new EqualsTester();
        tester.addEqualityGroup(new Object[]{TimestampBound.strong(), TimestampBound.strong()});
        tester.addEqualityGroup(new Object[]{TimestampBound.ofReadTimestamp((Timestamp)ts), TimestampBound.ofReadTimestamp((Timestamp)ts)});
        tester.addEqualityGroup(new Object[]{TimestampBound.ofReadTimestamp((Timestamp)ts2)});
        tester.addEqualityGroup(new Object[]{TimestampBound.ofMinReadTimestamp((Timestamp)ts), TimestampBound.ofMinReadTimestamp((Timestamp)ts)});
        tester.addEqualityGroup(new Object[]{TimestampBound.ofMinReadTimestamp((Timestamp)ts2)});
        tester.addEqualityGroup(new Object[]{TimestampBound.ofExactStaleness((long)staleness, (TimeUnit)TimeUnit.SECONDS), TimestampBound.ofExactStaleness((long)staleness, (TimeUnit)TimeUnit.SECONDS)});
        tester.addEqualityGroup(new Object[]{TimestampBound.ofExactStaleness((long)staleness, (TimeUnit)TimeUnit.MILLISECONDS)});
        tester.addEqualityGroup(new Object[]{TimestampBound.ofMaxStaleness((long)staleness, (TimeUnit)TimeUnit.SECONDS), TimestampBound.ofMaxStaleness((long)staleness, (TimeUnit)TimeUnit.SECONDS)});
        tester.addEqualityGroup(new Object[]{TimestampBound.ofMaxStaleness((long)staleness, (TimeUnit)TimeUnit.MILLISECONDS)});
        tester.testEquals();
    }

    private static void assertProto(TimestampBound bound, String expectedProtoTextFormat) {
        MatcherAssert.assertThat((Object)bound.toProto(), SpannerMatchers.matchesProto(TransactionOptions.ReadOnly.class, expectedProtoTextFormat));
    }
}

