/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.Timestamp;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionManagerImpl;
import com.google.cloud.spanner.TransactionRunnerImpl;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.ResultSet;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.ResultSetStats;
import com.google.spanner.v1.Session;
import com.google.spanner.v1.Transaction;
import io.opencensus.trace.Span;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class TransactionManagerImplTest {
    @Mock
    private SessionImpl session;
    @Mock
    TransactionRunnerImpl.TransactionContextImpl txn;
    private TransactionManagerImpl manager;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.manager = new TransactionManagerImpl(this.session, (Span)Mockito.mock(Span.class), new Options.TransactionOption[0]);
    }

    @Test
    public void beginCalledTwiceFails() {
        Mockito.when((Object)this.session.newTransaction(Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]))).thenReturn((Object)this.txn);
        Truth.assertThat((Object)this.manager.begin()).isEqualTo((Object)this.txn);
        Truth.assertThat((Comparable)this.manager.getState()).isEqualTo((Object)TransactionManager.TransactionState.STARTED);
        try {
            this.manager.begin();
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalStateException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void commitBeforeBeginFails() {
        try {
            this.manager.commit();
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalStateException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void rollbackBeforeBeginFails() {
        try {
            this.manager.rollback();
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalStateException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void resetBeforeBeginFails() {
        try {
            this.manager.resetForRetry();
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalStateException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void transactionRolledBackOnClose() {
        Mockito.when((Object)this.session.newTransaction(Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]))).thenReturn((Object)this.txn);
        Mockito.when((Object)this.txn.isAborted()).thenReturn((Object)false);
        this.manager.begin();
        this.manager.close();
        ((TransactionRunnerImpl.TransactionContextImpl)Mockito.verify((Object)this.txn)).rollback();
    }

    @Test
    public void commitSucceeds() {
        Mockito.when((Object)this.session.newTransaction(Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]))).thenReturn((Object)this.txn);
        Timestamp commitTimestamp = Timestamp.ofTimeMicroseconds((long)1L);
        CommitResponse response = new CommitResponse(commitTimestamp);
        Mockito.when((Object)this.txn.getCommitResponse()).thenReturn((Object)response);
        this.manager.begin();
        this.manager.commit();
        Truth.assertThat((Comparable)this.manager.getState()).isEqualTo((Object)TransactionManager.TransactionState.COMMITTED);
        Truth.assertThat((Comparable)this.manager.getCommitTimestamp()).isEqualTo((Object)commitTimestamp);
    }

    @Test
    public void resetAfterSuccessfulCommitFails() {
        Mockito.when((Object)this.session.newTransaction(Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]))).thenReturn((Object)this.txn);
        this.manager.begin();
        this.manager.commit();
        try {
            this.manager.resetForRetry();
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalStateException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void resetAfterAbortSucceeds() {
        Mockito.when((Object)this.session.newTransaction(Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]))).thenReturn((Object)this.txn);
        this.manager.begin();
        ((TransactionRunnerImpl.TransactionContextImpl)Mockito.doThrow((Throwable)SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.ABORTED, (String)"")).when((Object)this.txn)).commit();
        try {
            this.manager.commit();
            Assert.fail((String)"Expected AbortedException");
        }
        catch (AbortedException e) {
            Truth.assertThat((Comparable)this.manager.getState()).isEqualTo((Object)TransactionManager.TransactionState.ABORTED);
        }
        this.txn = (TransactionRunnerImpl.TransactionContextImpl)Mockito.mock(TransactionRunnerImpl.TransactionContextImpl.class);
        Mockito.when((Object)this.session.newTransaction(Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]))).thenReturn((Object)this.txn);
        Truth.assertThat((Object)this.manager.resetForRetry()).isEqualTo((Object)this.txn);
        Truth.assertThat((Comparable)this.manager.getState()).isEqualTo((Object)TransactionManager.TransactionState.STARTED);
    }

    @Test
    public void resetAfterErrorFails() {
        Mockito.when((Object)this.session.newTransaction(Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]))).thenReturn((Object)this.txn);
        this.manager.begin();
        ((TransactionRunnerImpl.TransactionContextImpl)Mockito.doThrow((Throwable)SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.UNKNOWN, (String)"")).when((Object)this.txn)).commit();
        try {
            this.manager.commit();
            Assert.fail((String)"Expected AbortedException");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.UNKNOWN);
        }
        try {
            this.manager.resetForRetry();
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalStateException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void rollbackAfterCommitFails() {
        Mockito.when((Object)this.session.newTransaction(Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]))).thenReturn((Object)this.txn);
        this.manager.begin();
        this.manager.commit();
        try {
            this.manager.rollback();
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalStateException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void commitAfterRollbackFails() {
        Mockito.when((Object)this.session.newTransaction(Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]))).thenReturn((Object)this.txn);
        this.manager.begin();
        this.manager.rollback();
        try {
            this.manager.commit();
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalStateException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void usesPreparedTransaction() {
        SpannerOptions options = (SpannerOptions)Mockito.mock(SpannerOptions.class);
        Mockito.when((Object)options.getNumChannels()).thenReturn((Object)4);
        GrpcTransportOptions transportOptions = (GrpcTransportOptions)Mockito.mock(GrpcTransportOptions.class);
        Mockito.when((Object)transportOptions.getExecutorFactory()).thenReturn((Object)new TestExecutorFactory());
        Mockito.when((Object)options.getTransportOptions()).thenReturn((Object)transportOptions);
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().setMinSessions(0).setIncStep(1).build();
        Mockito.when((Object)options.getSessionPoolOptions()).thenReturn((Object)sessionPoolOptions);
        Mockito.when((Object)options.getSessionLabels()).thenReturn(Collections.emptyMap());
        SpannerRpc rpc = (SpannerRpc)Mockito.mock(SpannerRpc.class);
        Mockito.when((Object)rpc.asyncDeleteSession(Mockito.anyString(), Mockito.anyMap())).thenReturn((Object)ApiFutures.immediateFuture((Object)Empty.getDefaultInstance()));
        Mockito.when((Object)rpc.batchCreateSessions(Mockito.anyString(), Mockito.eq((int)1), Mockito.anyMap(), Mockito.anyMap())).thenAnswer((Answer)new Answer<List<Session>>(){

            public List<Session> answer(InvocationOnMock invocation) {
                return Arrays.asList(Session.newBuilder().setName((String)invocation.getArguments()[0] + "/sessions/1").setCreateTime(com.google.protobuf.Timestamp.newBuilder().setSeconds(System.currentTimeMillis() * 1000L)).build());
            }
        });
        Mockito.when((Object)rpc.beginTransactionAsync((BeginTransactionRequest)Mockito.any(BeginTransactionRequest.class), Mockito.anyMap())).thenAnswer((Answer)new Answer<ApiFuture<Transaction>>(){

            public ApiFuture<Transaction> answer(InvocationOnMock invocation) {
                return ApiFutures.immediateFuture((Object)Transaction.newBuilder().setId(ByteString.copyFromUtf8((String)UUID.randomUUID().toString())).build());
            }
        });
        Mockito.when((Object)rpc.commitAsync((CommitRequest)Mockito.any(CommitRequest.class), Mockito.anyMap())).thenAnswer((Answer)new Answer<ApiFuture<com.google.spanner.v1.CommitResponse>>(){

            public ApiFuture<com.google.spanner.v1.CommitResponse> answer(InvocationOnMock invocation) throws Throwable {
                return ApiFutures.immediateFuture((Object)com.google.spanner.v1.CommitResponse.newBuilder().setCommitTimestamp(com.google.protobuf.Timestamp.newBuilder().setSeconds(System.currentTimeMillis() * 1000L)).build());
            }
        });
        DatabaseId db = DatabaseId.of((String)"test", (String)"test", (String)"test");
        try (SpannerImpl spanner = new SpannerImpl(rpc, options);){
            DatabaseClient client = spanner.getDatabaseClient(db);
            try (TransactionManager mgr = client.transactionManager(new Options.TransactionOption[0]);){
                mgr.begin();
                mgr.commit();
            }
            ((SpannerRpc)Mockito.verify((Object)rpc, (VerificationMode)Mockito.times((int)1))).beginTransactionAsync((BeginTransactionRequest)Mockito.any(BeginTransactionRequest.class), Mockito.anyMap());
        }
    }

    @Test
    public void inlineBegin() {
        SpannerOptions options = (SpannerOptions)Mockito.mock(SpannerOptions.class);
        Mockito.when((Object)options.getNumChannels()).thenReturn((Object)4);
        GrpcTransportOptions transportOptions = (GrpcTransportOptions)Mockito.mock(GrpcTransportOptions.class);
        Mockito.when((Object)transportOptions.getExecutorFactory()).thenReturn((Object)new TestExecutorFactory());
        Mockito.when((Object)options.getTransportOptions()).thenReturn((Object)transportOptions);
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().setMinSessions(0).setIncStep(1).build();
        Mockito.when((Object)options.getSessionPoolOptions()).thenReturn((Object)sessionPoolOptions);
        Mockito.when((Object)options.getSessionLabels()).thenReturn(Collections.emptyMap());
        Mockito.when((Object)options.getDefaultQueryOptions((DatabaseId)Mockito.any(DatabaseId.class))).thenReturn((Object)ExecuteSqlRequest.QueryOptions.getDefaultInstance());
        SpannerRpc rpc = (SpannerRpc)Mockito.mock(SpannerRpc.class);
        Mockito.when((Object)rpc.asyncDeleteSession(Mockito.anyString(), Mockito.anyMap())).thenReturn((Object)ApiFutures.immediateFuture((Object)Empty.getDefaultInstance()));
        Mockito.when((Object)rpc.batchCreateSessions(Mockito.anyString(), Mockito.eq((int)1), Mockito.anyMap(), Mockito.anyMap())).thenAnswer((Answer)new Answer<List<Session>>(){

            public List<Session> answer(InvocationOnMock invocation) throws Throwable {
                return Arrays.asList(Session.newBuilder().setName((String)invocation.getArguments()[0] + "/sessions/1").setCreateTime(com.google.protobuf.Timestamp.newBuilder().setSeconds(System.currentTimeMillis() * 1000L)).build());
            }
        });
        Mockito.when((Object)rpc.beginTransactionAsync((BeginTransactionRequest)Mockito.any(BeginTransactionRequest.class), Mockito.anyMap())).thenAnswer((Answer)new Answer<ApiFuture<Transaction>>(){

            public ApiFuture<Transaction> answer(InvocationOnMock invocation) throws Throwable {
                return ApiFutures.immediateFuture((Object)Transaction.newBuilder().setId(ByteString.copyFromUtf8((String)UUID.randomUUID().toString())).build());
            }
        });
        final AtomicInteger transactionsStarted = new AtomicInteger();
        Mockito.when((Object)rpc.executeQuery((ExecuteSqlRequest)Mockito.any(ExecuteSqlRequest.class), Mockito.anyMap())).thenAnswer((Answer)new Answer<ResultSet>(){

            public ResultSet answer(InvocationOnMock invocation) throws Throwable {
                ResultSet.Builder builder = ResultSet.newBuilder().setStats(ResultSetStats.newBuilder().setRowCountExact(1L).build());
                ExecuteSqlRequest request = (ExecuteSqlRequest)invocation.getArgumentAt(0, ExecuteSqlRequest.class);
                if (request.getTransaction() != null && request.getTransaction().hasBegin()) {
                    transactionsStarted.incrementAndGet();
                    builder.setMetadata(ResultSetMetadata.newBuilder().setTransaction(Transaction.newBuilder().setId(ByteString.copyFromUtf8((String)"test-tx")).build()).build());
                }
                return builder.build();
            }
        });
        Mockito.when((Object)rpc.commitAsync((CommitRequest)Mockito.any(CommitRequest.class), Mockito.anyMap())).thenAnswer((Answer)new Answer<ApiFuture<com.google.spanner.v1.CommitResponse>>(){

            public ApiFuture<com.google.spanner.v1.CommitResponse> answer(InvocationOnMock invocation) throws Throwable {
                return ApiFutures.immediateFuture((Object)com.google.spanner.v1.CommitResponse.newBuilder().setCommitTimestamp(com.google.protobuf.Timestamp.newBuilder().setSeconds(System.currentTimeMillis() * 1000L)).build());
            }
        });
        DatabaseId db = DatabaseId.of((String)"test", (String)"test", (String)"test");
        try (SpannerImpl spanner = new SpannerImpl(rpc, options);){
            DatabaseClient client = spanner.getDatabaseClient(db);
            try (TransactionManager mgr = client.transactionManager(new Options.TransactionOption[0]);){
                TransactionContext tx = mgr.begin();
                while (true) {
                    try {
                        tx.executeUpdate(Statement.of((String)"UPDATE FOO SET BAR=1"), new Options.UpdateOption[0]);
                        tx.executeUpdate(Statement.of((String)"UPDATE FOO SET BAZ=2"), new Options.UpdateOption[0]);
                        mgr.commit();
                    }
                    catch (AbortedException e) {
                        tx = mgr.resetForRetry();
                        continue;
                    }
                    break;
                }
            }
            ((SpannerRpc)Mockito.verify((Object)rpc, (VerificationMode)Mockito.never())).beginTransaction((BeginTransactionRequest)Mockito.any(BeginTransactionRequest.class), Mockito.anyMap());
            ((SpannerRpc)Mockito.verify((Object)rpc, (VerificationMode)Mockito.times((int)2))).executeQuery((ExecuteSqlRequest)Mockito.any(ExecuteSqlRequest.class), Mockito.anyMap());
            Truth.assertThat((Integer)transactionsStarted.get()).isEqualTo((Object)1);
        }
    }

    private static final class TestExecutorFactory
    implements GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService> {
        private TestExecutorFactory() {
        }

        public ScheduledExecutorService get() {
            return Executors.newSingleThreadScheduledExecutor();
        }

        public void release(ScheduledExecutorService exec) {
            exec.shutdown();
        }
    }
}

