/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.admin.database.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.spanner.admin.database.v1.DatabaseAdminClient;
import com.google.cloud.spanner.admin.database.v1.DatabaseAdminSettings;
import com.google.cloud.spanner.admin.database.v1.MockDatabaseAdmin;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.google.spanner.admin.database.v1.Backup;
import com.google.spanner.admin.database.v1.BackupName;
import com.google.spanner.admin.database.v1.CreateBackupRequest;
import com.google.spanner.admin.database.v1.CreateDatabaseRequest;
import com.google.spanner.admin.database.v1.CryptoKeyVersionName;
import com.google.spanner.admin.database.v1.Database;
import com.google.spanner.admin.database.v1.DatabaseName;
import com.google.spanner.admin.database.v1.DeleteBackupRequest;
import com.google.spanner.admin.database.v1.DropDatabaseRequest;
import com.google.spanner.admin.database.v1.EncryptionConfig;
import com.google.spanner.admin.database.v1.EncryptionInfo;
import com.google.spanner.admin.database.v1.GetBackupRequest;
import com.google.spanner.admin.database.v1.GetDatabaseDdlRequest;
import com.google.spanner.admin.database.v1.GetDatabaseDdlResponse;
import com.google.spanner.admin.database.v1.GetDatabaseRequest;
import com.google.spanner.admin.database.v1.InstanceName;
import com.google.spanner.admin.database.v1.ListBackupOperationsRequest;
import com.google.spanner.admin.database.v1.ListBackupOperationsResponse;
import com.google.spanner.admin.database.v1.ListBackupsRequest;
import com.google.spanner.admin.database.v1.ListBackupsResponse;
import com.google.spanner.admin.database.v1.ListDatabaseOperationsRequest;
import com.google.spanner.admin.database.v1.ListDatabaseOperationsResponse;
import com.google.spanner.admin.database.v1.ListDatabasesRequest;
import com.google.spanner.admin.database.v1.ListDatabasesResponse;
import com.google.spanner.admin.database.v1.RestoreDatabaseRequest;
import com.google.spanner.admin.database.v1.RestoreInfo;
import com.google.spanner.admin.database.v1.UpdateBackupRequest;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class DatabaseAdminClientTest {
    private static MockServiceHelper mockServiceHelper;
    private static MockDatabaseAdmin mockDatabaseAdmin;
    private DatabaseAdminClient client;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockDatabaseAdmin = new MockDatabaseAdmin();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockDatabaseAdmin));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        DatabaseAdminSettings settings = ((DatabaseAdminSettings.Builder)((DatabaseAdminSettings.Builder)DatabaseAdminSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = DatabaseAdminClient.create((DatabaseAdminSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listDatabasesTest() throws Exception {
        Database responsesElement = Database.newBuilder().build();
        ListDatabasesResponse expectedResponse = ListDatabasesResponse.newBuilder().setNextPageToken("").addAllDatabases(Arrays.asList(responsesElement)).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        DatabaseAdminClient.ListDatabasesPagedResponse pagedListResponse = this.client.listDatabases(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDatabasesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListDatabasesRequest actualRequest = (ListDatabasesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listDatabasesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            this.client.listDatabases(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDatabasesTest2() throws Exception {
        Database responsesElement = Database.newBuilder().build();
        ListDatabasesResponse expectedResponse = ListDatabasesResponse.newBuilder().setNextPageToken("").addAllDatabases(Arrays.asList(responsesElement)).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        DatabaseAdminClient.ListDatabasesPagedResponse pagedListResponse = this.client.listDatabases(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDatabasesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListDatabasesRequest actualRequest = (ListDatabasesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listDatabasesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            String parent = "parent-995424086";
            this.client.listDatabases(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createDatabaseTest() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setRestoreInfo(RestoreInfo.newBuilder().build()).setEncryptionConfig(EncryptionConfig.newBuilder().build()).addAllEncryptionInfo(new ArrayList()).setVersionRetentionPeriod("versionRetentionPeriod-629783929").setEarliestVersionTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createDatabaseTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)resultOperation);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        String createStatement = "createStatement744686547";
        Database actualResponse = (Database)this.client.createDatabaseAsync(parent, createStatement).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateDatabaseRequest actualRequest = (CreateDatabaseRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)createStatement, (Object)actualRequest.getCreateStatement());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createDatabaseExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            String createStatement = "createStatement744686547";
            this.client.createDatabaseAsync(parent, createStatement).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createDatabaseTest2() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setRestoreInfo(RestoreInfo.newBuilder().build()).setEncryptionConfig(EncryptionConfig.newBuilder().build()).addAllEncryptionInfo(new ArrayList()).setVersionRetentionPeriod("versionRetentionPeriod-629783929").setEarliestVersionTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createDatabaseTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        String createStatement = "createStatement744686547";
        Database actualResponse = (Database)this.client.createDatabaseAsync(parent, createStatement).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateDatabaseRequest actualRequest = (CreateDatabaseRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)createStatement, (Object)actualRequest.getCreateStatement());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createDatabaseExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            String parent = "parent-995424086";
            String createStatement = "createStatement744686547";
            this.client.createDatabaseAsync(parent, createStatement).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void getDatabaseTest() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setRestoreInfo(RestoreInfo.newBuilder().build()).setEncryptionConfig(EncryptionConfig.newBuilder().build()).addAllEncryptionInfo(new ArrayList()).setVersionRetentionPeriod("versionRetentionPeriod-629783929").setEarliestVersionTime(Timestamp.newBuilder().build()).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        DatabaseName name = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        Database actualResponse = this.client.getDatabase(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetDatabaseRequest actualRequest = (GetDatabaseRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getDatabaseExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            DatabaseName name = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
            this.client.getDatabase(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDatabaseTest2() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setRestoreInfo(RestoreInfo.newBuilder().build()).setEncryptionConfig(EncryptionConfig.newBuilder().build()).addAllEncryptionInfo(new ArrayList()).setVersionRetentionPeriod("versionRetentionPeriod-629783929").setEarliestVersionTime(Timestamp.newBuilder().build()).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Database actualResponse = this.client.getDatabase(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetDatabaseRequest actualRequest = (GetDatabaseRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getDatabaseExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            String name = "name3373707";
            this.client.getDatabase(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateDatabaseDdlTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("updateDatabaseDdlTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)resultOperation);
        DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        ArrayList statements = new ArrayList();
        this.client.updateDatabaseDdlAsync(database, statements).get();
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateDatabaseDdlRequest actualRequest = (UpdateDatabaseDdlRequest)actualRequests.get(0);
        Assert.assertEquals((Object)database.toString(), (Object)actualRequest.getDatabase());
        Assert.assertEquals(statements, (Object)actualRequest.getStatementsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateDatabaseDdlExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
            ArrayList statements = new ArrayList();
            this.client.updateDatabaseDdlAsync(database, statements).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateDatabaseDdlTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("updateDatabaseDdlTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)resultOperation);
        String database = "database1789464955";
        ArrayList statements = new ArrayList();
        this.client.updateDatabaseDdlAsync(database, statements).get();
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateDatabaseDdlRequest actualRequest = (UpdateDatabaseDdlRequest)actualRequests.get(0);
        Assert.assertEquals((Object)database, (Object)actualRequest.getDatabase());
        Assert.assertEquals(statements, (Object)actualRequest.getStatementsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateDatabaseDdlExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            String database = "database1789464955";
            ArrayList statements = new ArrayList();
            this.client.updateDatabaseDdlAsync(database, statements).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void dropDatabaseTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        this.client.dropDatabase(database);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DropDatabaseRequest actualRequest = (DropDatabaseRequest)actualRequests.get(0);
        Assert.assertEquals((Object)database.toString(), (Object)actualRequest.getDatabase());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void dropDatabaseExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
            this.client.dropDatabase(database);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void dropDatabaseTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        String database = "database1789464955";
        this.client.dropDatabase(database);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DropDatabaseRequest actualRequest = (DropDatabaseRequest)actualRequests.get(0);
        Assert.assertEquals((Object)database, (Object)actualRequest.getDatabase());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void dropDatabaseExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            String database = "database1789464955";
            this.client.dropDatabase(database);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDatabaseDdlTest() throws Exception {
        GetDatabaseDdlResponse expectedResponse = GetDatabaseDdlResponse.newBuilder().addAllStatements(new ArrayList()).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        GetDatabaseDdlResponse actualResponse = this.client.getDatabaseDdl(database);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetDatabaseDdlRequest actualRequest = (GetDatabaseDdlRequest)actualRequests.get(0);
        Assert.assertEquals((Object)database.toString(), (Object)actualRequest.getDatabase());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getDatabaseDdlExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
            this.client.getDatabaseDdl(database);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDatabaseDdlTest2() throws Exception {
        GetDatabaseDdlResponse expectedResponse = GetDatabaseDdlResponse.newBuilder().addAllStatements(new ArrayList()).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        String database = "database1789464955";
        GetDatabaseDdlResponse actualResponse = this.client.getDatabaseDdl(database);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetDatabaseDdlRequest actualRequest = (GetDatabaseDdlRequest)actualRequests.get(0);
        Assert.assertEquals((Object)database, (Object)actualRequest.getDatabase());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getDatabaseDdlExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            String database = "database1789464955";
            this.client.getDatabaseDdl(database);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        CryptoKeyVersionName resource = CryptoKeyVersionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[KEY_RING]", (String)"[CRYPTO_KEY]", (String)"[CRYPTO_KEY_VERSION]");
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = this.client.setIamPolicy((ResourceName)resource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetIamPolicyRequest actualRequest = (SetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource.toString(), (Object)actualRequest.getResource());
        Assert.assertEquals((Object)policy, (Object)actualRequest.getPolicy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            CryptoKeyVersionName resource = CryptoKeyVersionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[KEY_RING]", (String)"[CRYPTO_KEY]", (String)"[CRYPTO_KEY_VERSION]");
            Policy policy = Policy.newBuilder().build();
            this.client.setIamPolicy((ResourceName)resource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest2() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        String resource = "resource-341064690";
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = this.client.setIamPolicy(resource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetIamPolicyRequest actualRequest = (SetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource, (Object)actualRequest.getResource());
        Assert.assertEquals((Object)policy, (Object)actualRequest.getPolicy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setIamPolicyExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            String resource = "resource-341064690";
            Policy policy = Policy.newBuilder().build();
            this.client.setIamPolicy(resource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        CryptoKeyVersionName resource = CryptoKeyVersionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[KEY_RING]", (String)"[CRYPTO_KEY]", (String)"[CRYPTO_KEY_VERSION]");
        Policy actualResponse = this.client.getIamPolicy((ResourceName)resource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIamPolicyRequest actualRequest = (GetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource.toString(), (Object)actualRequest.getResource());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            CryptoKeyVersionName resource = CryptoKeyVersionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[KEY_RING]", (String)"[CRYPTO_KEY]", (String)"[CRYPTO_KEY_VERSION]");
            this.client.getIamPolicy((ResourceName)resource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest2() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        String resource = "resource-341064690";
        Policy actualResponse = this.client.getIamPolicy(resource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIamPolicyRequest actualRequest = (GetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource, (Object)actualRequest.getResource());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIamPolicyExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            String resource = "resource-341064690";
            this.client.getIamPolicy(resource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        CryptoKeyVersionName resource = CryptoKeyVersionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[KEY_RING]", (String)"[CRYPTO_KEY]", (String)"[CRYPTO_KEY_VERSION]");
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = this.client.testIamPermissions((ResourceName)resource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TestIamPermissionsRequest actualRequest = (TestIamPermissionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource.toString(), (Object)actualRequest.getResource());
        Assert.assertEquals(permissions, (Object)actualRequest.getPermissionsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void testIamPermissionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            CryptoKeyVersionName resource = CryptoKeyVersionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[KEY_RING]", (String)"[CRYPTO_KEY]", (String)"[CRYPTO_KEY_VERSION]");
            ArrayList permissions = new ArrayList();
            this.client.testIamPermissions((ResourceName)resource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest2() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        String resource = "resource-341064690";
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = this.client.testIamPermissions(resource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TestIamPermissionsRequest actualRequest = (TestIamPermissionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource, (Object)actualRequest.getResource());
        Assert.assertEquals(permissions, (Object)actualRequest.getPermissionsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void testIamPermissionsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            String resource = "resource-341064690";
            ArrayList permissions = new ArrayList();
            this.client.testIamPermissions(resource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createBackupTest() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setDatabase(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setVersionTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setName(BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]").toString()).setCreateTime(Timestamp.newBuilder().build()).setSizeBytes(-1796325715L).addAllReferencingDatabases(new ArrayList()).setEncryptionInfo(EncryptionInfo.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createBackupTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)resultOperation);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        Backup backup = Backup.newBuilder().build();
        String backupId = "backupId2121930365";
        Backup actualResponse = (Backup)this.client.createBackupAsync(parent, backup, backupId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateBackupRequest actualRequest = (CreateBackupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)backup, (Object)actualRequest.getBackup());
        Assert.assertEquals((Object)backupId, (Object)actualRequest.getBackupId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createBackupExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            Backup backup = Backup.newBuilder().build();
            String backupId = "backupId2121930365";
            this.client.createBackupAsync(parent, backup, backupId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createBackupTest2() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setDatabase(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setVersionTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setName(BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]").toString()).setCreateTime(Timestamp.newBuilder().build()).setSizeBytes(-1796325715L).addAllReferencingDatabases(new ArrayList()).setEncryptionInfo(EncryptionInfo.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createBackupTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Backup backup = Backup.newBuilder().build();
        String backupId = "backupId2121930365";
        Backup actualResponse = (Backup)this.client.createBackupAsync(parent, backup, backupId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateBackupRequest actualRequest = (CreateBackupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)backup, (Object)actualRequest.getBackup());
        Assert.assertEquals((Object)backupId, (Object)actualRequest.getBackupId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createBackupExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            String parent = "parent-995424086";
            Backup backup = Backup.newBuilder().build();
            String backupId = "backupId2121930365";
            this.client.createBackupAsync(parent, backup, backupId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void getBackupTest() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setDatabase(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setVersionTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setName(BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]").toString()).setCreateTime(Timestamp.newBuilder().build()).setSizeBytes(-1796325715L).addAllReferencingDatabases(new ArrayList()).setEncryptionInfo(EncryptionInfo.newBuilder().build()).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        BackupName name = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]");
        Backup actualResponse = this.client.getBackup(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetBackupRequest actualRequest = (GetBackupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getBackupExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            BackupName name = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]");
            this.client.getBackup(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getBackupTest2() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setDatabase(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setVersionTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setName(BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]").toString()).setCreateTime(Timestamp.newBuilder().build()).setSizeBytes(-1796325715L).addAllReferencingDatabases(new ArrayList()).setEncryptionInfo(EncryptionInfo.newBuilder().build()).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Backup actualResponse = this.client.getBackup(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetBackupRequest actualRequest = (GetBackupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getBackupExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            String name = "name3373707";
            this.client.getBackup(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateBackupTest() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setDatabase(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setVersionTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setName(BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]").toString()).setCreateTime(Timestamp.newBuilder().build()).setSizeBytes(-1796325715L).addAllReferencingDatabases(new ArrayList()).setEncryptionInfo(EncryptionInfo.newBuilder().build()).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        Backup backup = Backup.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Backup actualResponse = this.client.updateBackup(backup, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateBackupRequest actualRequest = (UpdateBackupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)backup, (Object)actualRequest.getBackup());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateBackupExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            Backup backup = Backup.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateBackup(backup, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteBackupTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        BackupName name = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]");
        this.client.deleteBackup(name);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteBackupRequest actualRequest = (DeleteBackupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteBackupExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            BackupName name = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]");
            this.client.deleteBackup(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteBackupTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteBackup(name);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteBackupRequest actualRequest = (DeleteBackupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteBackupExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            String name = "name3373707";
            this.client.deleteBackup(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listBackupsTest() throws Exception {
        Backup responsesElement = Backup.newBuilder().build();
        ListBackupsResponse expectedResponse = ListBackupsResponse.newBuilder().setNextPageToken("").addAllBackups(Arrays.asList(responsesElement)).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        DatabaseAdminClient.ListBackupsPagedResponse pagedListResponse = this.client.listBackups(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getBackupsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListBackupsRequest actualRequest = (ListBackupsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listBackupsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            this.client.listBackups(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listBackupsTest2() throws Exception {
        Backup responsesElement = Backup.newBuilder().build();
        ListBackupsResponse expectedResponse = ListBackupsResponse.newBuilder().setNextPageToken("").addAllBackups(Arrays.asList(responsesElement)).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        DatabaseAdminClient.ListBackupsPagedResponse pagedListResponse = this.client.listBackups(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getBackupsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListBackupsRequest actualRequest = (ListBackupsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listBackupsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            String parent = "parent-995424086";
            this.client.listBackups(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void restoreDatabaseTest() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setRestoreInfo(RestoreInfo.newBuilder().build()).setEncryptionConfig(EncryptionConfig.newBuilder().build()).addAllEncryptionInfo(new ArrayList()).setVersionRetentionPeriod("versionRetentionPeriod-629783929").setEarliestVersionTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("restoreDatabaseTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)resultOperation);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        String databaseId = "databaseId1688905718";
        BackupName backup = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]");
        Database actualResponse = (Database)this.client.restoreDatabaseAsync(parent, databaseId, backup).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RestoreDatabaseRequest actualRequest = (RestoreDatabaseRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)databaseId, (Object)actualRequest.getDatabaseId());
        Assert.assertEquals((Object)backup.toString(), (Object)actualRequest.getBackup());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void restoreDatabaseExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            String databaseId = "databaseId1688905718";
            BackupName backup = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]");
            this.client.restoreDatabaseAsync(parent, databaseId, backup).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void restoreDatabaseTest2() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setRestoreInfo(RestoreInfo.newBuilder().build()).setEncryptionConfig(EncryptionConfig.newBuilder().build()).addAllEncryptionInfo(new ArrayList()).setVersionRetentionPeriod("versionRetentionPeriod-629783929").setEarliestVersionTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("restoreDatabaseTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)resultOperation);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        String databaseId = "databaseId1688905718";
        String backup = "backup-1396673086";
        Database actualResponse = (Database)this.client.restoreDatabaseAsync(parent, databaseId, backup).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RestoreDatabaseRequest actualRequest = (RestoreDatabaseRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)databaseId, (Object)actualRequest.getDatabaseId());
        Assert.assertEquals((Object)backup, (Object)actualRequest.getBackup());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void restoreDatabaseExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            String databaseId = "databaseId1688905718";
            String backup = "backup-1396673086";
            this.client.restoreDatabaseAsync(parent, databaseId, backup).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void restoreDatabaseTest3() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setRestoreInfo(RestoreInfo.newBuilder().build()).setEncryptionConfig(EncryptionConfig.newBuilder().build()).addAllEncryptionInfo(new ArrayList()).setVersionRetentionPeriod("versionRetentionPeriod-629783929").setEarliestVersionTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("restoreDatabaseTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        String databaseId = "databaseId1688905718";
        BackupName backup = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]");
        Database actualResponse = (Database)this.client.restoreDatabaseAsync(parent, databaseId, backup).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RestoreDatabaseRequest actualRequest = (RestoreDatabaseRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)databaseId, (Object)actualRequest.getDatabaseId());
        Assert.assertEquals((Object)backup.toString(), (Object)actualRequest.getBackup());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void restoreDatabaseExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            String parent = "parent-995424086";
            String databaseId = "databaseId1688905718";
            BackupName backup = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]");
            this.client.restoreDatabaseAsync(parent, databaseId, backup).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void restoreDatabaseTest4() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setRestoreInfo(RestoreInfo.newBuilder().build()).setEncryptionConfig(EncryptionConfig.newBuilder().build()).addAllEncryptionInfo(new ArrayList()).setVersionRetentionPeriod("versionRetentionPeriod-629783929").setEarliestVersionTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("restoreDatabaseTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        String databaseId = "databaseId1688905718";
        String backup = "backup-1396673086";
        Database actualResponse = (Database)this.client.restoreDatabaseAsync(parent, databaseId, backup).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RestoreDatabaseRequest actualRequest = (RestoreDatabaseRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)databaseId, (Object)actualRequest.getDatabaseId());
        Assert.assertEquals((Object)backup, (Object)actualRequest.getBackup());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void restoreDatabaseExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            String parent = "parent-995424086";
            String databaseId = "databaseId1688905718";
            String backup = "backup-1396673086";
            this.client.restoreDatabaseAsync(parent, databaseId, backup).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void listDatabaseOperationsTest() throws Exception {
        Operation responsesElement = Operation.newBuilder().build();
        ListDatabaseOperationsResponse expectedResponse = ListDatabaseOperationsResponse.newBuilder().setNextPageToken("").addAllOperations(Arrays.asList(responsesElement)).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        DatabaseAdminClient.ListDatabaseOperationsPagedResponse pagedListResponse = this.client.listDatabaseOperations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOperationsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListDatabaseOperationsRequest actualRequest = (ListDatabaseOperationsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listDatabaseOperationsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            this.client.listDatabaseOperations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDatabaseOperationsTest2() throws Exception {
        Operation responsesElement = Operation.newBuilder().build();
        ListDatabaseOperationsResponse expectedResponse = ListDatabaseOperationsResponse.newBuilder().setNextPageToken("").addAllOperations(Arrays.asList(responsesElement)).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        DatabaseAdminClient.ListDatabaseOperationsPagedResponse pagedListResponse = this.client.listDatabaseOperations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOperationsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListDatabaseOperationsRequest actualRequest = (ListDatabaseOperationsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listDatabaseOperationsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            String parent = "parent-995424086";
            this.client.listDatabaseOperations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listBackupOperationsTest() throws Exception {
        Operation responsesElement = Operation.newBuilder().build();
        ListBackupOperationsResponse expectedResponse = ListBackupOperationsResponse.newBuilder().setNextPageToken("").addAllOperations(Arrays.asList(responsesElement)).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        DatabaseAdminClient.ListBackupOperationsPagedResponse pagedListResponse = this.client.listBackupOperations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOperationsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListBackupOperationsRequest actualRequest = (ListBackupOperationsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listBackupOperationsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            this.client.listBackupOperations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listBackupOperationsTest2() throws Exception {
        Operation responsesElement = Operation.newBuilder().build();
        ListBackupOperationsResponse expectedResponse = ListBackupOperationsResponse.newBuilder().setNextPageToken("").addAllOperations(Arrays.asList(responsesElement)).build();
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        DatabaseAdminClient.ListBackupOperationsPagedResponse pagedListResponse = this.client.listBackupOperations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOperationsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListBackupOperationsRequest actualRequest = (ListBackupOperationsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listBackupOperationsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDatabaseAdmin.addException((Exception)((Object)exception));
        try {
            String parent = "parent-995424086";
            this.client.listBackupOperations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

