/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.admin.instance.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.spanner.admin.instance.v1.InstanceAdminClient;
import com.google.cloud.spanner.admin.instance.v1.InstanceAdminSettings;
import com.google.cloud.spanner.admin.instance.v1.MockInstanceAdmin;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.spanner.admin.instance.v1.CreateInstanceRequest;
import com.google.spanner.admin.instance.v1.DeleteInstanceRequest;
import com.google.spanner.admin.instance.v1.GetInstanceConfigRequest;
import com.google.spanner.admin.instance.v1.GetInstanceRequest;
import com.google.spanner.admin.instance.v1.Instance;
import com.google.spanner.admin.instance.v1.InstanceConfig;
import com.google.spanner.admin.instance.v1.InstanceConfigName;
import com.google.spanner.admin.instance.v1.InstanceName;
import com.google.spanner.admin.instance.v1.ListInstanceConfigsRequest;
import com.google.spanner.admin.instance.v1.ListInstanceConfigsResponse;
import com.google.spanner.admin.instance.v1.ListInstancesRequest;
import com.google.spanner.admin.instance.v1.ListInstancesResponse;
import com.google.spanner.admin.instance.v1.ProjectName;
import com.google.spanner.admin.instance.v1.UpdateInstanceRequest;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class InstanceAdminClientTest {
    private static MockServiceHelper mockServiceHelper;
    private InstanceAdminClient client;
    private static MockInstanceAdmin mockInstanceAdmin;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockInstanceAdmin = new MockInstanceAdmin();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockInstanceAdmin));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        InstanceAdminSettings settings = ((InstanceAdminSettings.Builder)((InstanceAdminSettings.Builder)InstanceAdminSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = InstanceAdminClient.create((InstanceAdminSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listInstanceConfigsTest() throws Exception {
        InstanceConfig responsesElement = InstanceConfig.newBuilder().build();
        ListInstanceConfigsResponse expectedResponse = ListInstanceConfigsResponse.newBuilder().setNextPageToken("").addAllInstanceConfigs(Arrays.asList(responsesElement)).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        InstanceAdminClient.ListInstanceConfigsPagedResponse pagedListResponse = this.client.listInstanceConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInstanceConfigsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListInstanceConfigsRequest actualRequest = (ListInstanceConfigsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listInstanceConfigsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)((Object)exception));
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            this.client.listInstanceConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInstanceConfigsTest2() throws Exception {
        InstanceConfig responsesElement = InstanceConfig.newBuilder().build();
        ListInstanceConfigsResponse expectedResponse = ListInstanceConfigsResponse.newBuilder().setNextPageToken("").addAllInstanceConfigs(Arrays.asList(responsesElement)).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        InstanceAdminClient.ListInstanceConfigsPagedResponse pagedListResponse = this.client.listInstanceConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInstanceConfigsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListInstanceConfigsRequest actualRequest = (ListInstanceConfigsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listInstanceConfigsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)((Object)exception));
        try {
            String parent = "parent-995424086";
            this.client.listInstanceConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInstanceConfigTest() throws Exception {
        InstanceConfig expectedResponse = InstanceConfig.newBuilder().setName(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").addAllReplicas(new ArrayList()).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        InstanceConfigName name = InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]");
        InstanceConfig actualResponse = this.client.getInstanceConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetInstanceConfigRequest actualRequest = (GetInstanceConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getInstanceConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)((Object)exception));
        try {
            InstanceConfigName name = InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]");
            this.client.getInstanceConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInstanceConfigTest2() throws Exception {
        InstanceConfig expectedResponse = InstanceConfig.newBuilder().setName(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").addAllReplicas(new ArrayList()).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        InstanceConfig actualResponse = this.client.getInstanceConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetInstanceConfigRequest actualRequest = (GetInstanceConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getInstanceConfigExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)((Object)exception));
        try {
            String name = "name3373707";
            this.client.getInstanceConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInstancesTest() throws Exception {
        Instance responsesElement = Instance.newBuilder().build();
        ListInstancesResponse expectedResponse = ListInstancesResponse.newBuilder().setNextPageToken("").addAllInstances(Arrays.asList(responsesElement)).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        InstanceAdminClient.ListInstancesPagedResponse pagedListResponse = this.client.listInstances(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInstancesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListInstancesRequest actualRequest = (ListInstancesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listInstancesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)((Object)exception));
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            this.client.listInstances(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInstancesTest2() throws Exception {
        Instance responsesElement = Instance.newBuilder().build();
        ListInstancesResponse expectedResponse = ListInstancesResponse.newBuilder().setNextPageToken("").addAllInstances(Arrays.asList(responsesElement)).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        InstanceAdminClient.ListInstancesPagedResponse pagedListResponse = this.client.listInstances(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInstancesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListInstancesRequest actualRequest = (ListInstancesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listInstancesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)((Object)exception));
        try {
            String parent = "parent-995424086";
            this.client.listInstances(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInstanceTest() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").setNodeCount(1539922066).putAllLabels(new HashMap()).addAllEndpointUris(new ArrayList()).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        Instance actualResponse = this.client.getInstance(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetInstanceRequest actualRequest = (GetInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getInstanceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)((Object)exception));
        try {
            InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            this.client.getInstance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInstanceTest2() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").setNodeCount(1539922066).putAllLabels(new HashMap()).addAllEndpointUris(new ArrayList()).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Instance actualResponse = this.client.getInstance(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetInstanceRequest actualRequest = (GetInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getInstanceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)((Object)exception));
        try {
            String name = "name3373707";
            this.client.getInstance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createInstanceTest() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").setNodeCount(1539922066).putAllLabels(new HashMap()).addAllEndpointUris(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("createInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockInstanceAdmin.addResponse((AbstractMessage)resultOperation);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        String instanceId = "instanceId902024336";
        Instance instance = Instance.newBuilder().build();
        Instance actualResponse = (Instance)this.client.createInstanceAsync(parent, instanceId, instance).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateInstanceRequest actualRequest = (CreateInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)instanceId, (Object)actualRequest.getInstanceId());
        Assert.assertEquals((Object)instance, (Object)actualRequest.getInstance());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createInstanceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)((Object)exception));
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            String instanceId = "instanceId902024336";
            Instance instance = Instance.newBuilder().build();
            this.client.createInstanceAsync(parent, instanceId, instance).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createInstanceTest2() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").setNodeCount(1539922066).putAllLabels(new HashMap()).addAllEndpointUris(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("createInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockInstanceAdmin.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        String instanceId = "instanceId902024336";
        Instance instance = Instance.newBuilder().build();
        Instance actualResponse = (Instance)this.client.createInstanceAsync(parent, instanceId, instance).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateInstanceRequest actualRequest = (CreateInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)instanceId, (Object)actualRequest.getInstanceId());
        Assert.assertEquals((Object)instance, (Object)actualRequest.getInstance());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createInstanceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)((Object)exception));
        try {
            String parent = "parent-995424086";
            String instanceId = "instanceId902024336";
            Instance instance = Instance.newBuilder().build();
            this.client.createInstanceAsync(parent, instanceId, instance).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateInstanceTest() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").setNodeCount(1539922066).putAllLabels(new HashMap()).addAllEndpointUris(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("updateInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockInstanceAdmin.addResponse((AbstractMessage)resultOperation);
        Instance instance = Instance.newBuilder().build();
        FieldMask fieldMask = FieldMask.newBuilder().build();
        Instance actualResponse = (Instance)this.client.updateInstanceAsync(instance, fieldMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateInstanceRequest actualRequest = (UpdateInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)instance, (Object)actualRequest.getInstance());
        Assert.assertEquals((Object)fieldMask, (Object)actualRequest.getFieldMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateInstanceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)((Object)exception));
        try {
            Instance instance = Instance.newBuilder().build();
            FieldMask fieldMask = FieldMask.newBuilder().build();
            this.client.updateInstanceAsync(instance, fieldMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteInstanceTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        this.client.deleteInstance(name);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteInstanceRequest actualRequest = (DeleteInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteInstanceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)((Object)exception));
        try {
            InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            this.client.deleteInstance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteInstanceTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteInstance(name);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteInstanceRequest actualRequest = (DeleteInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteInstanceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)((Object)exception));
        try {
            String name = "name3373707";
            this.client.deleteInstance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        ProjectName resource = ProjectName.of((String)"[PROJECT]");
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = this.client.setIamPolicy((ResourceName)resource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetIamPolicyRequest actualRequest = (SetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource.toString(), (Object)actualRequest.getResource());
        Assert.assertEquals((Object)policy, (Object)actualRequest.getPolicy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)((Object)exception));
        try {
            ProjectName resource = ProjectName.of((String)"[PROJECT]");
            Policy policy = Policy.newBuilder().build();
            this.client.setIamPolicy((ResourceName)resource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest2() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String resource = "resource-341064690";
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = this.client.setIamPolicy(resource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetIamPolicyRequest actualRequest = (SetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource, (Object)actualRequest.getResource());
        Assert.assertEquals((Object)policy, (Object)actualRequest.getPolicy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setIamPolicyExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)((Object)exception));
        try {
            String resource = "resource-341064690";
            Policy policy = Policy.newBuilder().build();
            this.client.setIamPolicy(resource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        ProjectName resource = ProjectName.of((String)"[PROJECT]");
        Policy actualResponse = this.client.getIamPolicy((ResourceName)resource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIamPolicyRequest actualRequest = (GetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource.toString(), (Object)actualRequest.getResource());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)((Object)exception));
        try {
            ProjectName resource = ProjectName.of((String)"[PROJECT]");
            this.client.getIamPolicy((ResourceName)resource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest2() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String resource = "resource-341064690";
        Policy actualResponse = this.client.getIamPolicy(resource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIamPolicyRequest actualRequest = (GetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource, (Object)actualRequest.getResource());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIamPolicyExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)((Object)exception));
        try {
            String resource = "resource-341064690";
            this.client.getIamPolicy(resource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        ProjectName resource = ProjectName.of((String)"[PROJECT]");
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = this.client.testIamPermissions((ResourceName)resource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TestIamPermissionsRequest actualRequest = (TestIamPermissionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource.toString(), (Object)actualRequest.getResource());
        Assert.assertEquals(permissions, (Object)actualRequest.getPermissionsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void testIamPermissionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)((Object)exception));
        try {
            ProjectName resource = ProjectName.of((String)"[PROJECT]");
            ArrayList permissions = new ArrayList();
            this.client.testIamPermissions((ResourceName)resource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest2() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String resource = "resource-341064690";
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = this.client.testIamPermissions(resource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TestIamPermissionsRequest actualRequest = (TestIamPermissionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource, (Object)actualRequest.getResource());
        Assert.assertEquals(permissions, (Object)actualRequest.getPermissionsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void testIamPermissionsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)((Object)exception));
        try {
            String resource = "resource-341064690";
            ArrayList permissions = new ArrayList();
            this.client.testIamPermissions(resource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

