/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.StatementExecutionInterceptor;
import com.google.cloud.spanner.connection.TransactionRetryListener;
import com.google.cloud.spanner.connection.it.ITTransactionRetryTest;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AbortedTest
extends AbstractMockServerTest {
    @Test
    public void testCommitAborted() {
        for (int i = 0; i < 2; ++i) {
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT_COUNT_STATEMENT, SELECT_COUNT_RESULTSET_BEFORE_INSERT));
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(INSERT_STATEMENT, 1L));
            ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new ITTransactionRetryTest.CountTransactionRetryListener());){
                try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST WHERE ID=1"), new Options.QueryOption[0]);){
                    MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                    MatcherAssert.assertThat((Object)rs.getLong("C"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0L)));
                    MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
                }
                connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test aborted')"));
                interceptor.setProbability(1.0);
                interceptor.setOnlyInjectOnce(true);
                connection.commit();
                mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT_COUNT_STATEMENT, SELECT_COUNT_RESULTSET_AFTER_INSERT));
                rs = connection.executeQuery(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST WHERE ID=1"), new Options.QueryOption[0]);
                var6_8 = null;
                try {
                    MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                    MatcherAssert.assertThat((Object)rs.getLong("C"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
                    MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
                    continue;
                }
                catch (Throwable throwable) {
                    var6_8 = throwable;
                    throw throwable;
                }
                finally {
                    if (rs != null) {
                        if (var6_8 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable) {
                                var6_8.addSuppressed(throwable);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testAbortedDuringRetryOfFailedQuery() {
        Statement invalidStatement = Statement.of((String)"SELECT * FROM FOO");
        StatusRuntimeException notFound = Status.NOT_FOUND.withDescription("Table not found").asRuntimeException();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(invalidStatement, notFound));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(this.createAbortFirstRetryListener(invalidStatement, notFound));){
            connection.execute(INSERT_STATEMENT);
            try (ResultSet rs = connection.executeQuery(invalidStatement, new Options.QueryOption[0]);){
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException e) {
                Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
            }
            mockSpanner.abortNextStatement();
            connection.commit();
        }
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(CommitRequest.class)).isEqualTo((Object)2);
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class)).isEqualTo((Object)6);
    }

    @Test
    public void testAbortedDuringRetryOfFailedUpdate() {
        Statement invalidStatement = Statement.of((String)"INSERT INTO FOO");
        StatusRuntimeException notFound = Status.NOT_FOUND.withDescription("Table not found").asRuntimeException();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(invalidStatement, notFound));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(this.createAbortFirstRetryListener(invalidStatement, notFound));){
            connection.execute(INSERT_STATEMENT);
            try {
                connection.execute(invalidStatement);
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException e) {
                Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
            }
            mockSpanner.abortNextStatement();
            connection.commit();
        }
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(CommitRequest.class)).isEqualTo((Object)2);
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class)).isEqualTo((Object)6);
    }

    @Test
    public void testAbortedDuringRetryOfFailedBatchUpdate() {
        Statement invalidStatement = Statement.of((String)"INSERT INTO FOO");
        StatusRuntimeException notFound = Status.NOT_FOUND.withDescription("Table not found").asRuntimeException();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(invalidStatement, notFound));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(this.createAbortFirstRetryListener(invalidStatement, notFound));){
            connection.execute(INSERT_STATEMENT);
            try {
                connection.executeBatchUpdate(Arrays.asList(invalidStatement));
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException e) {
                Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
            }
            mockSpanner.abortNextStatement();
            connection.commit();
        }
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(CommitRequest.class)).isEqualTo((Object)2);
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class)).isEqualTo((Object)3);
    }

    @Test
    public void testAbortedDuringRetryOfFailedQueryAsFirstStatement() {
        Statement invalidStatement = Statement.of((String)"SELECT * FROM FOO");
        StatusRuntimeException notFound = Status.NOT_FOUND.withDescription("Table not found").asRuntimeException();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(invalidStatement, notFound));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(this.createAbortRetryListener(2, invalidStatement, notFound));){
            try (ResultSet rs = connection.executeQuery(invalidStatement, new Options.QueryOption[0]);){
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException e) {
                Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
            }
            connection.executeUpdate(INSERT_STATEMENT);
            mockSpanner.abortNextStatement();
            connection.commit();
        }
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(CommitRequest.class)).isEqualTo((Object)2);
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class)).isEqualTo((Object)8);
    }

    @Test
    public void testAbortedDuringRetryOfFailedUpdateAsFirstStatement() {
        Statement invalidStatement = Statement.of((String)"INSERT INTO FOO");
        StatusRuntimeException notFound = Status.NOT_FOUND.withDescription("Table not found").asRuntimeException();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(invalidStatement, notFound));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(this.createAbortRetryListener(2, invalidStatement, notFound));){
            try {
                connection.execute(invalidStatement);
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException e) {
                Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
            }
            connection.execute(INSERT_STATEMENT);
            mockSpanner.abortNextStatement();
            connection.commit();
        }
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(CommitRequest.class)).isEqualTo((Object)2);
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class)).isEqualTo((Object)8);
    }

    @Test
    public void testAbortedDuringRetryOfFailedBatchUpdateAsFirstStatement() {
        Statement invalidStatement = Statement.of((String)"INSERT INTO FOO");
        StatusRuntimeException notFound = Status.NOT_FOUND.withDescription("Table not found").asRuntimeException();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(invalidStatement, notFound));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(this.createAbortFirstRetryListener(invalidStatement, notFound));){
            try {
                connection.executeBatchUpdate(Arrays.asList(invalidStatement));
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException e) {
                Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
            }
            connection.execute(INSERT_STATEMENT);
            mockSpanner.abortNextStatement();
            connection.commit();
        }
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(CommitRequest.class)).isEqualTo((Object)2);
        Truth.assertThat((Integer)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class)).isEqualTo((Object)6);
    }

    ITAbstractSpannerTest.ITConnection createConnection(TransactionRetryListener listener) {
        ITAbstractSpannerTest.ITConnection connection = super.createConnection((List<StatementExecutionInterceptor>)ImmutableList.of(), (List<TransactionRetryListener>)ImmutableList.of((Object)listener));
        connection.setAutocommit(false);
        return connection;
    }

    TransactionRetryListener createAbortFirstRetryListener(Statement invalidStatement, StatusRuntimeException statementException) {
        return this.createAbortRetryListener(0, invalidStatement, statementException);
    }

    TransactionRetryListener createAbortRetryListener(final int onAttempt, final Statement invalidStatement, final StatusRuntimeException statementException) {
        return new TransactionRetryListener(){

            public void retryStarting(Timestamp transactionStarted, long transactionId, int retryAttempt) {
                if (retryAttempt == onAttempt) {
                    AbstractMockServerTest.mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(invalidStatement, AbstractMockServerTest.mockSpanner.createAbortedException(ByteString.copyFromUtf8((String)"some-transaction"))));
                } else {
                    AbstractMockServerTest.mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(invalidStatement, statementException));
                }
            }

            public void retryFinished(Timestamp transactionStarted, long transactionId, int retryAttempt, TransactionRetryListener.RetryResult result) {
            }
        };
    }
}

