/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.ClientSideStatementImpl;
import com.google.cloud.spanner.connection.ClientSideStatementValueConverters;
import com.google.cloud.spanner.connection.ReadOnlyStalenessConverterTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AutocommitDmlModeConverterTest {
    @Test
    public void testConvert() throws ClientSideStatementImpl.CompileException {
        String allowedValues = ReadOnlyStalenessConverterTest.getAllowedValues(ClientSideStatementValueConverters.AutocommitDmlModeConverter.class);
        MatcherAssert.assertThat((Object)allowedValues, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ClientSideStatementValueConverters.AutocommitDmlModeConverter converter = new ClientSideStatementValueConverters.AutocommitDmlModeConverter(allowedValues);
        MatcherAssert.assertThat((Object)converter.convert("transactional"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)AutocommitDmlMode.TRANSACTIONAL)));
        MatcherAssert.assertThat((Object)converter.convert("TRANSACTIONAL"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)AutocommitDmlMode.TRANSACTIONAL)));
        MatcherAssert.assertThat((Object)converter.convert("Transactional"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)AutocommitDmlMode.TRANSACTIONAL)));
        MatcherAssert.assertThat((Object)converter.convert("partitioned_non_atomic"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)AutocommitDmlMode.PARTITIONED_NON_ATOMIC)));
        MatcherAssert.assertThat((Object)converter.convert("Partitioned_Non_Atomic"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)AutocommitDmlMode.PARTITIONED_NON_ATOMIC)));
        MatcherAssert.assertThat((Object)converter.convert("PARTITIONED_NON_ATOMIC"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)AutocommitDmlMode.PARTITIONED_NON_ATOMIC)));
        MatcherAssert.assertThat((Object)converter.convert(""), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert(" "), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("random string"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

