/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.connection.AbstractSqlScriptVerifier;
import com.google.cloud.spanner.connection.ClientSideStatementImpl;
import com.google.cloud.spanner.connection.ClientSideStatements;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ConnectionImplTest;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.connection.SqlScriptVerifier;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.AfterClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ClientSideStatementsTest {
    private static final String SCRIPT_FILE = "src/test/resources/com/google/cloud/spanner/connection/ClientSideStatementsTest.sql";
    private static PrintWriter writer;

    @Test
    public void testExecuteClientSideStatementsScript() throws Exception {
        SqlScriptVerifier verifier = new SqlScriptVerifier(new TestConnectionProvider());
        verifier.verifyStatementsInFile("ClientSideStatementsTest.sql", this.getClass());
    }

    static void generateTestScript() throws Exception {
        try {
            ClientSideStatementsTest.openLog();
            ClientSideStatements statements = ClientSideStatements.INSTANCE;
            for (ClientSideStatementImpl statement : statements.getCompiledStatements()) {
                ClientSideStatementsTest.generateTestStatements(statement);
            }
        }
        finally {
            ClientSideStatementsTest.closeLog();
        }
    }

    private static void log(List<String> pre, String sql) {
        ClientSideStatementsTest.writeLog("NEW_CONNECTION");
        for (String prerequisite : pre) {
            ClientSideStatementsTest.writeLog(prerequisite);
        }
        ClientSideStatementsTest.writeLog(sql);
    }

    private static void log(List<String> pre, String statement, ErrorCode error) {
        ClientSideStatementsTest.log(pre, "@EXPECT EXCEPTION " + error.name() + "\n" + statement);
    }

    private static void writeLog(String statement) {
        writer.println(statement + ";");
    }

    private static void openLog() {
        try {
            writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(SCRIPT_FILE, false), "UTF8"), true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @AfterClass
    public static void closeLog() {
        if (writer != null) {
            writer.close();
        }
    }

    private static void generateTestStatements(ClientSideStatementImpl statement) {
        for (String sql : statement.getExampleStatements()) {
            String[] replacements;
            ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), sql);
            ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.upper(sql));
            ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.lower(sql));
            ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.withLeadingSpaces(sql));
            ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.withLeadingTabs(sql));
            ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.withLeadingLinefeeds(sql));
            ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.withTrailingSpaces(sql));
            ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.withTrailingTabs(sql));
            ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.withTrailingLinefeeds(sql));
            ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.withSpaces(sql));
            ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.withTabs(sql));
            ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.withLinefeeds(sql));
            ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.withInvalidPrefix(sql), ErrorCode.INVALID_ARGUMENT);
            ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.withInvalidSuffix(sql), ErrorCode.INVALID_ARGUMENT);
            for (String replacement : replacements = new String[]{"%", "_", "&", "$", "@", "!", "*", "(", ")", "-", "+", "-#", "/", "\\", "?", "-/", "/#", "/-"}) {
                ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.withPrefix(replacement, sql), ErrorCode.INVALID_ARGUMENT);
                ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.withSuffix(replacement, sql), ErrorCode.INVALID_ARGUMENT);
                ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.replaceLastSpaceWith(replacement, sql), ErrorCode.INVALID_ARGUMENT);
            }
        }
    }

    private static String upper(String statement) {
        return statement.toUpperCase();
    }

    private static String lower(String statement) {
        return statement.toLowerCase();
    }

    private static String withLeadingSpaces(String statement) {
        return "   " + statement;
    }

    private static String withLeadingTabs(String statement) {
        return "\t\t\t" + statement;
    }

    private static String withLeadingLinefeeds(String statement) {
        return "\n\n\n" + statement;
    }

    private static String withTrailingSpaces(String statement) {
        return statement + "  ";
    }

    private static String withTrailingTabs(String statement) {
        return statement + "\t\t";
    }

    private static String withTrailingLinefeeds(String statement) {
        return statement + "\n\n";
    }

    private static String withSpaces(String statement) {
        return statement.replaceAll(" ", "   ");
    }

    private static String withTabs(String statement) {
        return statement.replaceAll(" ", "\t");
    }

    private static String withLinefeeds(String statement) {
        Matcher matcher = Pattern.compile("(.*)('.*')").matcher(statement);
        if (matcher.matches()) {
            return matcher.group(1).replaceAll(" ", "\n") + matcher.group(2);
        }
        return statement.replaceAll(" ", "\n");
    }

    private static String withInvalidPrefix(String statement) {
        return "foo " + statement;
    }

    private static String withInvalidSuffix(String statement) {
        return statement + " bar";
    }

    private static String withPrefix(String prefix, String statement) {
        return prefix + statement;
    }

    private static String withSuffix(String suffix, String statement) {
        return statement + suffix;
    }

    private static String replaceLastSpaceWith(String replacement, String statement) {
        if (statement.lastIndexOf(32) > -1) {
            return statement.substring(0, statement.lastIndexOf(32)) + replacement + statement.substring(statement.lastIndexOf(32) + 1);
        }
        return statement + replacement;
    }

    static class TestConnectionProvider
    implements AbstractSqlScriptVerifier.GenericConnectionProvider {
        TestConnectionProvider() {
        }

        @Override
        public AbstractSqlScriptVerifier.GenericConnection getConnection() {
            return SqlScriptVerifier.SpannerGenericConnection.of((Connection)ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database").build()));
        }
    }
}

