/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.ConnectionImpl;
import com.google.cloud.spanner.connection.ConnectionStatementExecutor;
import com.google.cloud.spanner.connection.ConnectionStatementExecutorImpl;
import com.google.cloud.spanner.connection.ReadOnlyStalenessUtil;
import com.google.cloud.spanner.connection.StatementParser;
import com.google.cloud.spanner.connection.TransactionMode;
import com.google.protobuf.Duration;
import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ConnectionStatementWithOneParameterTest {
    private final StatementParser parser = StatementParser.INSTANCE;

    @Test
    public void testExecuteSetAutcommit() {
        StatementParser.ParsedStatement subject = this.parser.parse(Statement.of((String)"set autocommit = true"));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
        Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)executor.statementSetAutocommit((Boolean)Matchers.any(Boolean.class))).thenCallRealMethod();
        for (Boolean mode : new Boolean[]{Boolean.FALSE, Boolean.TRUE}) {
            subject.getClientSideStatement().execute((ConnectionStatementExecutor)executor, String.format("set autocommit = %s", mode));
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).setAutocommit(mode.booleanValue());
        }
    }

    @Test
    public void testExecuteSetReadOnly() {
        StatementParser.ParsedStatement subject = this.parser.parse(Statement.of((String)"set readonly = true"));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
        Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)executor.statementSetReadOnly((Boolean)Matchers.any(Boolean.class))).thenCallRealMethod();
        for (Boolean mode : new Boolean[]{Boolean.FALSE, Boolean.TRUE}) {
            subject.getClientSideStatement().execute((ConnectionStatementExecutor)executor, String.format("set readonly = %s", Boolean.toString(mode)));
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).setReadOnly(mode.booleanValue());
        }
    }

    @Test
    public void testExecuteSetAutcommitDmlMode() {
        StatementParser.ParsedStatement subject = this.parser.parse(Statement.of((String)"set autocommit_dml_mode='foo'"));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
        Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)executor.statementSetAutocommitDmlMode((AutocommitDmlMode)Matchers.any(AutocommitDmlMode.class))).thenCallRealMethod();
        for (AutocommitDmlMode mode : AutocommitDmlMode.values()) {
            subject.getClientSideStatement().execute((ConnectionStatementExecutor)executor, String.format("set autocommit_dml_mode='%s'", mode.name()));
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).setAutocommitDmlMode(mode);
        }
    }

    @Test
    public void testExecuteSetStatementTimeout() {
        ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
        Mockito.when((Object)executor.statementSetStatementTimeout((Duration)Matchers.any(Duration.class))).thenCallRealMethod();
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
        for (TimeUnit unit : ReadOnlyStalenessUtil.SUPPORTED_UNITS) {
            for (Long val : new Long[]{1L, 100L, 999L}) {
                StatementParser.ParsedStatement subject = this.parser.parse(Statement.of((String)String.format("set statement_timeout='%d%s'", val, ReadOnlyStalenessUtil.getTimeUnitAbbreviation((TimeUnit)unit))));
                subject.getClientSideStatement().execute((ConnectionStatementExecutor)executor, String.format("set statement_timeout='%d%s'", val, ReadOnlyStalenessUtil.getTimeUnitAbbreviation((TimeUnit)unit)));
                ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).setStatementTimeout(val.longValue(), unit);
            }
        }
        StatementParser.ParsedStatement subject = this.parser.parse(Statement.of((String)String.format("set statement_timeout=null", new Object[0])));
        subject.getClientSideStatement().execute((ConnectionStatementExecutor)executor, String.format("set statement_timeout=null", new Object[0]));
        ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).clearStatementTimeout();
    }

    @Test
    public void testExecuteSetReadOnlyStaleness() {
        StatementParser.ParsedStatement subject = this.parser.parse(Statement.of((String)"set read_only_staleness='foo'"));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
        Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)executor.statementSetReadOnlyStaleness((TimestampBound)Matchers.any(TimestampBound.class))).thenCallRealMethod();
        for (TimestampBound val : new TimestampBound[]{TimestampBound.strong(), TimestampBound.ofReadTimestamp((Timestamp)Timestamp.now()), TimestampBound.ofMinReadTimestamp((Timestamp)Timestamp.now()), TimestampBound.ofExactStaleness((long)1000L, (TimeUnit)TimeUnit.SECONDS), TimestampBound.ofMaxStaleness((long)2000L, (TimeUnit)TimeUnit.MICROSECONDS)}) {
            subject.getClientSideStatement().execute((ConnectionStatementExecutor)executor, String.format("set read_only_staleness='%s'", this.timestampBoundToString(val)));
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).setReadOnlyStaleness(val);
        }
    }

    private String timestampBoundToString(TimestampBound staleness) {
        switch (staleness.getMode()) {
            case STRONG: {
                return "strong";
            }
            case READ_TIMESTAMP: {
                return "read_timestamp " + staleness.getReadTimestamp().toString();
            }
            case MIN_READ_TIMESTAMP: {
                return "min_read_timestamp " + staleness.getMinReadTimestamp().toString();
            }
            case EXACT_STALENESS: {
                return "exact_staleness " + staleness.getExactStaleness(TimeUnit.SECONDS) + "s";
            }
            case MAX_STALENESS: {
                return "max_staleness " + staleness.getMaxStaleness(TimeUnit.MICROSECONDS) + "us";
            }
        }
        throw new IllegalStateException("Unknown mode: " + staleness.getMode());
    }

    @Test
    public void testExecuteSetOptimizerVersion() {
        StatementParser.ParsedStatement subject = this.parser.parse(Statement.of((String)"set optimizer_version='foo'"));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
        Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)executor.statementSetOptimizerVersion((String)Matchers.any(String.class))).thenCallRealMethod();
        for (String version : new String[]{"1", "200", "", "LATEST"}) {
            subject.getClientSideStatement().execute((ConnectionStatementExecutor)executor, String.format("set optimizer_version='%s'", version));
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).setOptimizerVersion(version);
        }
    }

    @Test
    public void testExecuteSetTransaction() {
        StatementParser.ParsedStatement subject = this.parser.parse(Statement.of((String)"set transaction read_only"));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
        Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)executor.statementSetTransactionMode((TransactionMode)Matchers.any(TransactionMode.class))).thenCallRealMethod();
        for (TransactionMode mode : TransactionMode.values()) {
            subject.getClientSideStatement().execute((ConnectionStatementExecutor)executor, String.format("set transaction %s", mode.getStatementString()));
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).setTransactionMode(mode);
        }
    }
}

