/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.protobuf.AbstractMessage;
import com.google.spanner.v1.BatchCreateSessionsRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
public class ConnectionTest {

    public static class ConnectionMaxSessionsTest
    extends AbstractMockServerTest {
        @AfterClass
        public static void reset() {
            mockSpanner.reset();
        }

        @Override
        protected String getBaseUrl() {
            return super.getBaseUrl() + ";maxSessions=1";
        }

        @Test
        public void testMaxSessions() throws InterruptedException, TimeoutException, ExecutionException {
            try (ITAbstractSpannerTest.ITConnection connection1 = this.createConnection();
                 ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
                connection1.beginTransactionAsync();
                connection2.beginTransactionAsync();
                ApiFuture count1 = connection1.executeUpdateAsync(INSERT_STATEMENT);
                ApiFuture count2 = connection2.executeUpdateAsync(INSERT_STATEMENT);
                ApiFuture commit1 = connection1.commitAsync();
                ApiFuture commit2 = connection2.commitAsync();
                Truth.assertThat((Boolean)(count1.isDone() && count2.isDone() ? 1 : 0)).isFalse();
                Truth.assertThat((Boolean)(commit1.isDone() && commit2.isDone() ? 1 : 0)).isFalse();
                ApiFutures.allAsList(Arrays.asList(commit1, commit2)).get(5L, TimeUnit.SECONDS);
                Truth.assertThat((Boolean)count1.isDone()).isTrue();
                Truth.assertThat((Boolean)count2.isDone()).isTrue();
            }
            Truth.assertThat((Integer)mockSpanner.numSessionsCreated()).isEqualTo((Object)1);
        }
    }

    public static class ConnectionMinSessionsTest
    extends AbstractMockServerTest {
        @AfterClass
        public static void reset() {
            mockSpanner.reset();
        }

        @Override
        protected String getBaseUrl() {
            return super.getBaseUrl() + ";minSessions=1";
        }

        @Test
        public void testMinSessions() throws InterruptedException, TimeoutException {
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                mockSpanner.waitForRequestsToContain((Predicate<? super AbstractMessage>)new Predicate<AbstractMessage>(){

                    public boolean apply(AbstractMessage input) {
                        return input instanceof BatchCreateSessionsRequest && ((BatchCreateSessionsRequest)input).getSessionCount() == 1;
                    }
                }, 5000L);
            }
        }
    }

    public static class DefaultConnectionOptionsTest
    extends AbstractMockServerTest {
        @Test
        public void testDefaultOptimizerVersion() {
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();
                 ResultSet rs = connection.executeQuery(Statement.of((String)"SHOW VARIABLE OPTIMIZER_VERSION"), new Options.QueryOption[0]);){
                Truth.assertThat((Boolean)rs.next()).isTrue();
                Truth.assertThat((String)rs.getString("OPTIMIZER_VERSION")).isEqualTo((Object)"");
                Truth.assertThat((Boolean)rs.next()).isFalse();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void testUseOptimizerVersionFromEnvironment() {
            try {
                SpannerOptions.useEnvironment((SpannerOptions.SpannerEnvironment)new SpannerOptions.SpannerEnvironment(){

                    public String getOptimizerVersion() {
                        return "20";
                    }
                });
                try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                    ExecuteSqlRequest request;
                    try (ResultSet rs = connection.executeQuery(SELECT_COUNT_STATEMENT, new Options.QueryOption[0]);){
                        Truth.assertThat((Boolean)rs.next()).isTrue();
                        Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)0L);
                        Truth.assertThat((Boolean)rs.next()).isFalse();
                        request = this.getLastExecuteSqlRequest();
                        Truth.assertThat((String)request.getQueryOptions().getOptimizerVersion()).isEqualTo((Object)"20");
                    }
                    connection.execute(Statement.of((String)"SET OPTIMIZER_VERSION='30'"));
                    rs = connection.executeQuery(SELECT_COUNT_STATEMENT, new Options.QueryOption[0]);
                    var4_6 = null;
                    try {
                        Truth.assertThat((Boolean)rs.next()).isTrue();
                        Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)0L);
                        Truth.assertThat((Boolean)rs.next()).isFalse();
                        request = this.getLastExecuteSqlRequest();
                        Truth.assertThat((String)request.getQueryOptions().getOptimizerVersion()).isEqualTo((Object)"30");
                    }
                    catch (Throwable request2) {
                        var4_6 = request2;
                        throw request2;
                    }
                    finally {
                        if (rs != null) {
                            if (var4_6 != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable request2) {
                                    var4_6.addSuppressed(request2);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                    rs = connection.executeQuery(Statement.newBuilder((String)SELECT_COUNT_STATEMENT.getSql()).withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("user-defined-version").build()).build(), new Options.QueryOption[0]);
                    var4_6 = null;
                    try {
                        Truth.assertThat((Boolean)rs.next()).isTrue();
                        Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)0L);
                        Truth.assertThat((Boolean)rs.next()).isFalse();
                        request = this.getLastExecuteSqlRequest();
                        Truth.assertThat((String)request.getQueryOptions().getOptimizerVersion()).isEqualTo((Object)"user-defined-version");
                    }
                    catch (Throwable throwable) {
                        var4_6 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (rs != null) {
                            if (var4_6 != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable) {
                                    var4_6.addSuppressed(throwable);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                }
            }
            finally {
                SpannerOptions.useDefaultEnvironment();
            }
        }

        @Test
        public void testExecuteInvalidBatchUpdate() {
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                try {
                    connection.executeBatchUpdate((Iterable)ImmutableList.of((Object)INSERT_STATEMENT, (Object)SELECT_RANDOM_STATEMENT));
                    Assert.fail((String)"Missing expected exception");
                }
                catch (SpannerException e) {
                    Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
                }
            }
        }

        @Test
        public void testQueryAborted() {
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                connection.setRetryAbortsInternally(false);
                Boolean[] booleanArray = new Boolean[]{true, false};
                int n = booleanArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean abort = booleanArray[i];
                    try {
                        if (abort) {
                            mockSpanner.abortNextStatement();
                        }
                        connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);
                        Truth.assertThat((Boolean)abort).isFalse();
                        connection.commit();
                        continue;
                    }
                    catch (AbortedException e) {
                        Truth.assertThat((Boolean)abort).isTrue();
                        connection.rollback();
                    }
                }
            }
        }

        @Test
        public void testUpdateAborted() {
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                connection.setRetryAbortsInternally(false);
                Boolean[] booleanArray = new Boolean[]{true, false};
                int n = booleanArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean abort = booleanArray[i];
                    try {
                        if (abort) {
                            mockSpanner.abortNextStatement();
                        }
                        connection.executeUpdate(INSERT_STATEMENT);
                        Truth.assertThat((Boolean)abort).isFalse();
                        connection.commit();
                        continue;
                    }
                    catch (AbortedException e) {
                        Truth.assertThat((Boolean)abort).isTrue();
                        connection.rollback();
                    }
                }
            }
        }

        @Test
        public void testBatchUpdateAborted() {
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                connection.setRetryAbortsInternally(false);
                Boolean[] booleanArray = new Boolean[]{true, false};
                int n = booleanArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean abort = booleanArray[i];
                    try {
                        if (abort) {
                            mockSpanner.abortNextStatement();
                        }
                        connection.executeBatchUpdate((Iterable)ImmutableList.of((Object)INSERT_STATEMENT, (Object)INSERT_STATEMENT));
                        Truth.assertThat((Boolean)abort).isFalse();
                        connection.commit();
                        continue;
                    }
                    catch (AbortedException e) {
                        Truth.assertThat((Boolean)abort).isTrue();
                        connection.rollback();
                    }
                }
            }
        }
    }
}

