/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerException;
import com.google.common.base.Preconditions;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public final class SpannerExceptionMatcher
extends BaseMatcher<SpannerException> {
    private final ErrorCode errorCode;
    private final String message;

    public static SpannerExceptionMatcher matchCode(ErrorCode errorCode) {
        Preconditions.checkNotNull((Object)errorCode);
        return new SpannerExceptionMatcher(errorCode, null);
    }

    public static SpannerExceptionMatcher matchCodeAndMessage(ErrorCode errorCode, String message) {
        Preconditions.checkNotNull((Object)errorCode);
        Preconditions.checkNotNull((Object)message);
        return new SpannerExceptionMatcher(errorCode, message);
    }

    private SpannerExceptionMatcher(ErrorCode errorCode, String message) {
        this.errorCode = errorCode;
        this.message = message;
    }

    public boolean matches(Object item) {
        if (item instanceof SpannerException) {
            SpannerException exception = (SpannerException)((Object)item);
            if (this.message == null) {
                return exception.getErrorCode().equals((Object)this.errorCode);
            }
            return exception.getErrorCode().equals((Object)this.errorCode) && exception.getMessage().equals(this.errorCode.name() + ": " + this.message);
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText(SpannerException.class.getName() + " with code " + this.errorCode.name());
        if (this.message != null) {
            description.appendText(" - " + SpannerException.class.getName() + " with message " + this.message);
        }
    }
}

