/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ConnectionImpl;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.connection.SpannerPool;
import com.google.common.base.Ticker;
import com.google.common.testing.FakeTicker;
import com.google.common.truth.Truth;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class SpannerPoolTest {
    private static final String URI = "cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database";
    private ConnectionImpl connection1 = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
    private ConnectionImpl connection2 = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
    private ConnectionImpl connection3 = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
    private String credentials1 = "credentials1";
    private String credentials2 = "credentials2";
    private ConnectionOptions options1 = (ConnectionOptions)Mockito.mock(ConnectionOptions.class);
    private ConnectionOptions options2 = (ConnectionOptions)Mockito.mock(ConnectionOptions.class);
    private ConnectionOptions options3 = (ConnectionOptions)Mockito.mock(ConnectionOptions.class);
    private ConnectionOptions options4 = (ConnectionOptions)Mockito.mock(ConnectionOptions.class);
    private ConnectionOptions options5 = (ConnectionOptions)Mockito.mock(ConnectionOptions.class);
    private ConnectionOptions options6 = (ConnectionOptions)Mockito.mock(ConnectionOptions.class);
    private static Logger log = Logger.getLogger(SpannerPool.class.getName());
    private static OutputStream logCapturingStream;
    private static StreamHandler customLogHandler;
    private static boolean useParentHandlers;
    private static final long TEST_AUTOMATIC_CLOSE_TIMEOUT_MILLIS = 60000L;
    private static final long TEST_AUTOMATIC_CLOSE_TIMEOUT_NANOS;
    private static final long MILLISECOND;

    private SpannerPool createSubjectAndMocks() {
        return this.createSubjectAndMocks(0L, Ticker.systemTicker());
    }

    private SpannerPool createSubjectAndMocks(long closeSpannerAfterMillisecondsUnused, Ticker ticker) {
        SpannerPool pool = new SpannerPool(closeSpannerAfterMillisecondsUnused, ticker){

            Spanner createSpanner(SpannerPool.SpannerPoolKey key, ConnectionOptions options) {
                return (Spanner)Mockito.mock(Spanner.class);
            }
        };
        Mockito.when((Object)this.options1.getCredentialsUrl()).thenReturn((Object)this.credentials1);
        Mockito.when((Object)this.options1.getProjectId()).thenReturn((Object)"test-project-1");
        Mockito.when((Object)this.options2.getCredentialsUrl()).thenReturn((Object)this.credentials2);
        Mockito.when((Object)this.options2.getProjectId()).thenReturn((Object)"test-project-1");
        Mockito.when((Object)this.options3.getCredentialsUrl()).thenReturn((Object)this.credentials1);
        Mockito.when((Object)this.options3.getProjectId()).thenReturn((Object)"test-project-2");
        Mockito.when((Object)this.options4.getCredentialsUrl()).thenReturn((Object)this.credentials2);
        Mockito.when((Object)this.options4.getProjectId()).thenReturn((Object)"test-project-2");
        Mockito.when((Object)this.options5.getProjectId()).thenReturn((Object)"test-project-3");
        Mockito.when((Object)this.options6.getProjectId()).thenReturn((Object)"test-project-3");
        return pool;
    }

    @AfterClass
    public static void closeSpannerPool() {
        SpannerPool.closeSpannerPool();
    }

    @Test
    public void testGetSpanner() {
        SpannerPool pool = this.createSubjectAndMocks();
        Spanner spanner1 = pool.getSpanner(this.options1, this.connection1);
        Spanner spanner2 = pool.getSpanner(this.options1, this.connection2);
        Truth.assertThat((Object)spanner1).isEqualTo((Object)spanner2);
        spanner1 = pool.getSpanner(this.options2, this.connection1);
        spanner2 = pool.getSpanner(this.options2, this.connection2);
        Truth.assertThat((Object)spanner1).isEqualTo((Object)spanner2);
        spanner1 = pool.getSpanner(this.options3, this.connection1);
        spanner2 = pool.getSpanner(this.options3, this.connection2);
        Truth.assertThat((Object)spanner1).isEqualTo((Object)spanner2);
        spanner1 = pool.getSpanner(this.options4, this.connection1);
        spanner2 = pool.getSpanner(this.options4, this.connection2);
        Truth.assertThat((Object)spanner1).isEqualTo((Object)spanner2);
        spanner1 = pool.getSpanner(this.options5, this.connection1);
        spanner2 = pool.getSpanner(this.options6, this.connection2);
        Truth.assertThat((Object)spanner1).isEqualTo((Object)spanner2);
        spanner1 = pool.getSpanner(this.options1, this.connection1);
        spanner2 = pool.getSpanner(this.options2, this.connection2);
        Truth.assertThat((Object)spanner1).isNotEqualTo((Object)spanner2);
        spanner1 = pool.getSpanner(this.options1, this.connection1);
        spanner2 = pool.getSpanner(this.options3, this.connection2);
        Truth.assertThat((Object)spanner1).isNotEqualTo((Object)spanner2);
        spanner1 = pool.getSpanner(this.options1, this.connection1);
        spanner2 = pool.getSpanner(this.options4, this.connection2);
        Truth.assertThat((Object)spanner1).isNotEqualTo((Object)spanner2);
        spanner1 = pool.getSpanner(this.options2, this.connection1);
        spanner2 = pool.getSpanner(this.options3, this.connection2);
        Truth.assertThat((Object)spanner1).isNotEqualTo((Object)spanner2);
        spanner1 = pool.getSpanner(this.options2, this.connection1);
        spanner2 = pool.getSpanner(this.options4, this.connection2);
        Truth.assertThat((Object)spanner1).isNotEqualTo((Object)spanner2);
        spanner1 = pool.getSpanner(this.options3, this.connection1);
        spanner2 = pool.getSpanner(this.options4, this.connection2);
        Truth.assertThat((Object)spanner1).isNotEqualTo((Object)spanner2);
    }

    @Test
    public void testRemoveConnection() {
        SpannerPool pool = this.createSubjectAndMocks();
        Spanner spanner1 = pool.getSpanner(this.options1, this.connection1);
        Spanner spanner2 = pool.getSpanner(this.options1, this.connection2);
        Truth.assertThat((Object)spanner1).isEqualTo((Object)spanner2);
        pool.removeConnection(this.options1, this.connection1);
        spanner1 = pool.getSpanner(this.options1, this.connection1);
        Truth.assertThat((Object)spanner1).isEqualTo((Object)spanner2);
        pool.removeConnection(this.options1, this.connection1);
        pool.removeConnection(this.options1, this.connection2);
        spanner1 = pool.getSpanner(this.options1, this.connection1);
        Truth.assertThat((Object)spanner1).isEqualTo((Object)spanner2);
        pool.removeConnection(this.options1, this.connection1);
    }

    private void attachLogCapturer() {
        logCapturingStream = new ByteArrayOutputStream();
        Handler[] handlers = new Handler[]{};
        for (Logger currentLogger = log; handlers.length == 0 && currentLogger != null; currentLogger = currentLogger.getParent()) {
            handlers = currentLogger.getHandlers();
        }
        if (handlers.length == 0) {
            throw new IllegalStateException("no handlers found for logger");
        }
        customLogHandler = new StreamHandler(logCapturingStream, handlers[0].getFormatter());
        useParentHandlers = log.getUseParentHandlers();
        log.setUseParentHandlers(false);
        log.addHandler(customLogHandler);
    }

    private String getTestCapturedLog() {
        customLogHandler.flush();
        return logCapturingStream.toString();
    }

    @AfterClass
    public static void resetUseParentHandlers() {
        if (useParentHandlers) {
            log.setUseParentHandlers(true);
        }
    }

    @Test
    public void testRemoveConnectionOptionsNotRegistered() {
        this.attachLogCapturer();
        String expectedLogPart = "There is no Spanner registered for ConnectionOptions";
        SpannerPool pool = this.createSubjectAndMocks();
        pool.getSpanner(this.options1, this.connection1);
        pool.removeConnection(this.options2, this.connection1);
        String capturedLog = this.getTestCapturedLog();
        Truth.assertThat((Boolean)capturedLog.contains("There is no Spanner registered for ConnectionOptions")).isTrue();
    }

    @Test
    public void testRemoveConnectionConnectionNotRegistered() {
        this.attachLogCapturer();
        String expectedLogPart = "There are no connections registered for ConnectionOptions";
        SpannerPool pool = this.createSubjectAndMocks();
        pool.getSpanner(this.options1, this.connection1);
        pool.removeConnection(this.options1, this.connection2);
        String capturedLog = this.getTestCapturedLog();
        Truth.assertThat((Boolean)capturedLog.contains("There are no connections registered for ConnectionOptions")).isTrue();
    }

    @Test
    public void testRemoveConnectionConnectionAlreadyRemoved() {
        this.attachLogCapturer();
        String expectedLogPart = "There are no connections registered for ConnectionOptions";
        SpannerPool pool = this.createSubjectAndMocks();
        pool.getSpanner(this.options1, this.connection1);
        pool.removeConnection(this.options1, this.connection1);
        pool.removeConnection(this.options1, this.connection1);
        String capturedLog = this.getTestCapturedLog();
        Truth.assertThat((Boolean)capturedLog.contains("There are no connections registered for ConnectionOptions")).isTrue();
    }

    @Test
    public void testCloseSpanner() {
        SpannerPool pool = this.createSubjectAndMocks();
        Spanner spanner = pool.getSpanner(this.options1, this.connection1);
        boolean exception = false;
        try {
            pool.checkAndCloseSpanners();
        }
        catch (SpannerException e) {
            exception = e.getErrorCode() == ErrorCode.FAILED_PRECONDITION;
        }
        Truth.assertThat((Boolean)exception).isTrue();
        pool.removeConnection(this.options1, this.connection1);
        pool.checkAndCloseSpanners();
        ((Spanner)Mockito.verify((Object)spanner)).close();
        String expectedLogPart = "WARNING: There is/are 1 connection(s) still open. Close all connections before stopping the application";
        Spanner spanner2 = pool.getSpanner(this.options1, this.connection1);
        pool.checkAndCloseSpanners(SpannerPool.CheckAndCloseSpannersMode.WARN);
        String capturedLog = this.getTestCapturedLog();
        Truth.assertThat((Boolean)capturedLog.contains("WARNING: There is/are 1 connection(s) still open. Close all connections before stopping the application")).isTrue();
        ((Spanner)Mockito.verify((Object)spanner2, (VerificationMode)Mockito.never())).close();
        pool.removeConnection(this.options1, this.connection1);
        pool.checkAndCloseSpanners(SpannerPool.CheckAndCloseSpannersMode.WARN);
        ((Spanner)Mockito.verify((Object)spanner2)).close();
    }

    @Test
    public void testLeakedConnection() {
        ConnectionOptions options = ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setSessionPoolOptions(SessionPoolOptions.newBuilder().setMinSessions(0).build()).setUri(URI).build();
        Connection connection = options.getConnection();
        try {
            ConnectionOptions.closeSpanner();
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.FAILED_PRECONDITION);
        }
        String capturedLog = this.getTestCapturedLog();
        Truth.assertThat((Boolean)capturedLog.contains(ConnectionImpl.LeakedConnectionException.class.getName())).isTrue();
        Truth.assertThat((Boolean)capturedLog.contains("testLeakedConnection")).isTrue();
        connection.close();
    }

    @Test
    public void testCloseUnusedSpanners() {
        SpannerPool pool = this.createSubjectAndMocks();
        Spanner spanner1 = pool.getSpanner(this.options1, this.connection1);
        Spanner spanner2 = pool.getSpanner(this.options1, this.connection2);
        Truth.assertThat((Object)spanner1).isEqualTo((Object)spanner2);
        pool.closeUnusedSpanners(-1L);
        ((Spanner)Mockito.verify((Object)spanner1, (VerificationMode)Mockito.never())).close();
        pool.removeConnection(this.options1, this.connection1);
        pool.closeUnusedSpanners(-1L);
        ((Spanner)Mockito.verify((Object)spanner1, (VerificationMode)Mockito.never())).close();
        pool.removeConnection(this.options1, this.connection2);
        pool.closeUnusedSpanners(-1L);
        ((Spanner)Mockito.verify((Object)spanner1)).close();
        spanner1 = pool.getSpanner(this.options1, this.connection1);
        spanner2 = pool.getSpanner(this.options2, this.connection2);
        Spanner spanner3 = pool.getSpanner(this.options2, this.connection3);
        Truth.assertThat((Object)spanner1).isNotEqualTo((Object)spanner2);
        Truth.assertThat((Object)spanner2).isEqualTo((Object)spanner3);
        pool.closeUnusedSpanners(-1L);
        ((Spanner)Mockito.verify((Object)spanner1, (VerificationMode)Mockito.never())).close();
        ((Spanner)Mockito.verify((Object)spanner2, (VerificationMode)Mockito.never())).close();
        ((Spanner)Mockito.verify((Object)spanner3, (VerificationMode)Mockito.never())).close();
        pool.removeConnection(this.options1, this.connection1);
        pool.closeUnusedSpanners(-1L);
        ((Spanner)Mockito.verify((Object)spanner1)).close();
        ((Spanner)Mockito.verify((Object)spanner2, (VerificationMode)Mockito.never())).close();
        ((Spanner)Mockito.verify((Object)spanner3, (VerificationMode)Mockito.never())).close();
        pool.removeConnection(this.options2, this.connection2);
        pool.closeUnusedSpanners(-1L);
        ((Spanner)Mockito.verify((Object)spanner1)).close();
        ((Spanner)Mockito.verify((Object)spanner2, (VerificationMode)Mockito.never())).close();
        ((Spanner)Mockito.verify((Object)spanner3, (VerificationMode)Mockito.never())).close();
        pool.removeConnection(this.options2, this.connection3);
        pool.closeUnusedSpanners(-1L);
        ((Spanner)Mockito.verify((Object)spanner1)).close();
        ((Spanner)Mockito.verify((Object)spanner2)).close();
        ((Spanner)Mockito.verify((Object)spanner3)).close();
    }

    @Test
    public void testAutomaticCloser() throws InterruptedException {
        FakeTicker ticker = new FakeTicker();
        SpannerPool pool = this.createSubjectAndMocks(60000L, (Ticker)ticker);
        Spanner spanner1 = pool.getSpanner(this.options1, this.connection1);
        Spanner spanner2 = pool.getSpanner(this.options1, this.connection2);
        Truth.assertThat((Object)spanner1).isEqualTo((Object)spanner2);
        ticker.advance(TEST_AUTOMATIC_CLOSE_TIMEOUT_NANOS + MILLISECOND);
        pool.closeUnusedSpanners(60000L);
        ((Spanner)Mockito.verify((Object)spanner1, (VerificationMode)Mockito.never())).close();
        pool.removeConnection(this.options1, this.connection1);
        ticker.advance(TEST_AUTOMATIC_CLOSE_TIMEOUT_NANOS + MILLISECOND);
        pool.closeUnusedSpanners(60000L);
        ((Spanner)Mockito.verify((Object)spanner1, (VerificationMode)Mockito.never())).close();
        pool.removeConnection(this.options1, this.connection2);
        ticker.advance(TEST_AUTOMATIC_CLOSE_TIMEOUT_NANOS + MILLISECOND);
        pool.closeUnusedSpanners(60000L);
        ((Spanner)Mockito.verify((Object)spanner1)).close();
        spanner1 = pool.getSpanner(this.options1, this.connection1);
        spanner2 = pool.getSpanner(this.options2, this.connection2);
        Spanner spanner3 = pool.getSpanner(this.options2, this.connection3);
        Truth.assertThat((Object)spanner1).isNotEqualTo((Object)spanner2);
        Truth.assertThat((Object)spanner2).isEqualTo((Object)spanner3);
        ticker.advance(TEST_AUTOMATIC_CLOSE_TIMEOUT_NANOS + MILLISECOND);
        pool.closeUnusedSpanners(60000L);
        ((Spanner)Mockito.verify((Object)spanner1, (VerificationMode)Mockito.never())).close();
        ((Spanner)Mockito.verify((Object)spanner2, (VerificationMode)Mockito.never())).close();
        ((Spanner)Mockito.verify((Object)spanner3, (VerificationMode)Mockito.never())).close();
        pool.removeConnection(this.options1, this.connection1);
        ticker.advance(TEST_AUTOMATIC_CLOSE_TIMEOUT_NANOS + MILLISECOND);
        pool.closeUnusedSpanners(60000L);
        ((Spanner)Mockito.verify((Object)spanner1)).close();
        ((Spanner)Mockito.verify((Object)spanner2, (VerificationMode)Mockito.never())).close();
        ((Spanner)Mockito.verify((Object)spanner3, (VerificationMode)Mockito.never())).close();
        pool.removeConnection(this.options2, this.connection2);
        ticker.advance(TEST_AUTOMATIC_CLOSE_TIMEOUT_NANOS + MILLISECOND);
        pool.closeUnusedSpanners(60000L);
        ((Spanner)Mockito.verify((Object)spanner1)).close();
        ((Spanner)Mockito.verify((Object)spanner2, (VerificationMode)Mockito.never())).close();
        ((Spanner)Mockito.verify((Object)spanner3, (VerificationMode)Mockito.never())).close();
        pool.removeConnection(this.options2, this.connection3);
        ticker.advance(TEST_AUTOMATIC_CLOSE_TIMEOUT_NANOS + MILLISECOND);
        pool.closeUnusedSpanners(60000L);
        ((Spanner)Mockito.verify((Object)spanner1)).close();
        ((Spanner)Mockito.verify((Object)spanner2)).close();
        ((Spanner)Mockito.verify((Object)spanner3)).close();
    }

    @Test
    public void testSpannerPoolKeyEquality() {
        ConnectionOptions options1 = ConnectionOptions.newBuilder().setUri("cloudspanner://localhost:9010/projects/p1/instances/i/databases/d?minSessions=200;maxSessions=400;numChannels=8;usePlainText=true;userAgent=test-agent").setCredentials((Credentials)Mockito.mock(Credentials.class)).build();
        ConnectionOptions options2 = ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/p/instances/i/databases/d?minSessions=100;maxSessions=400").setCredentials((Credentials)NoCredentials.getInstance()).build();
        ConnectionOptions options3 = ConnectionOptions.newBuilder().setUri("cloudspanner:/projects/p/instances/i/databases/d").setCredentials((Credentials)NoCredentials.getInstance()).build();
        SpannerPool.SpannerPoolKey key1 = SpannerPool.SpannerPoolKey.of((ConnectionOptions)options1);
        SpannerPool.SpannerPoolKey key2 = SpannerPool.SpannerPoolKey.of((ConnectionOptions)options2);
        SpannerPool.SpannerPoolKey key3 = SpannerPool.SpannerPoolKey.of((ConnectionOptions)options3);
        Assert.assertFalse((boolean)key1.equals((Object)key2));
        Assert.assertTrue((boolean)key2.equals((Object)key3));
        Assert.assertFalse((boolean)key1.equals((Object)key3));
        Assert.assertFalse((boolean)key1.equals(new Object()));
    }

    static {
        TEST_AUTOMATIC_CLOSE_TIMEOUT_NANOS = TimeUnit.NANOSECONDS.convert(60000L, TimeUnit.MILLISECONDS);
        MILLISECOND = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MILLISECONDS);
    }
}

