/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.ClientSideStatementImpl;
import com.google.cloud.spanner.connection.ClientSideStatements;
import com.google.cloud.spanner.connection.StatementParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Pattern;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class StatementParserTest {
    public static final String COPYRIGHT_PATTERN = "\\/\\*\n \\* Copyright \\d{4} Google LLC\n \\*\n \\* Licensed under the Apache License, Version 2.0 \\(the \"License\"\\);\n \\* you may not use this file except in compliance with the License.\n \\* You may obtain a copy of the License at\n \\*\n \\*       http://www.apache.org/licenses/LICENSE-2.0\n \\*\n \\* Unless required by applicable law or agreed to in writing, software\n \\* distributed under the License is distributed on an \"AS IS\" BASIS,\n \\* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n \\* See the License for the specific language governing permissions and\n \\* limitations under the License.\n \\*\\/\n";
    private final StatementParser parser = StatementParser.INSTANCE;
    private static final Pattern EXPECT_PATTERN = Pattern.compile("(?is)\\s*(?:@EXPECT)\\s+'(.*)'");

    @Test
    public void testRemoveComments() {
        List<String> statements = this.readStatementsFromFile("CommentsTest.sql");
        String currentlyExpected = "";
        for (String statement : statements) {
            String sql = statement.trim();
            if (sql.startsWith("@EXPECT")) {
                java.util.regex.Matcher matcher = EXPECT_PATTERN.matcher(sql);
                if (matcher.matches()) {
                    currentlyExpected = matcher.group(1);
                    continue;
                }
                throw new IllegalArgumentException("Unknown @EXPECT statement: " + sql);
            }
            MatcherAssert.assertThat((Object)StatementParser.removeCommentsAndTrim((String)statement), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)currentlyExpected)));
        }
        MatcherAssert.assertThat((Object)StatementParser.removeCommentsAndTrim((String)""), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"")));
        MatcherAssert.assertThat((Object)StatementParser.removeCommentsAndTrim((String)"SELECT * FROM FOO"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"SELECT * FROM FOO")));
        MatcherAssert.assertThat((Object)StatementParser.removeCommentsAndTrim((String)"-- This is a one line comment\nSELECT * FROM FOO"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"SELECT * FROM FOO")));
        MatcherAssert.assertThat((Object)StatementParser.removeCommentsAndTrim((String)"/* This is a simple multi line comment */\nSELECT * FROM FOO"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"SELECT * FROM FOO")));
        MatcherAssert.assertThat((Object)StatementParser.removeCommentsAndTrim((String)"/* This is a \nmulti line comment */\nSELECT * FROM FOO"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"SELECT * FROM FOO")));
        MatcherAssert.assertThat((Object)StatementParser.removeCommentsAndTrim((String)"/* This\nis\na\nmulti\nline\ncomment */\nSELECT * FROM FOO"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"SELECT * FROM FOO")));
    }

    @Test
    public void testStatementWithCommentContainingSlash() {
        String sql = "/*\n * Script for testing invalid/unrecognized statements\n */\n\n-- MERGE into test comment MERGE -- \n@EXPECT EXCEPTION INVALID_ARGUMENT 'INVALID_ARGUMENT: Unknown statement'\nMERGE INTO Singers s\n/*** test ****/USING (VALUES (1, 'John', 'Doe')) v\nON v.column1 = s.SingerId\nWHEN NOT MATCHED \n  INSERT VALUES (v.column1, v.column2, v.column3)\nWHEN MATCHED\n  UPDATE SET FirstName = v.column2,\n             LastName = v.column3;";
        String sqlWithoutComments = "@EXPECT EXCEPTION INVALID_ARGUMENT 'INVALID_ARGUMENT: Unknown statement'\nMERGE INTO Singers s\nUSING (VALUES (1, 'John', 'Doe')) v\nON v.column1 = s.SingerId\nWHEN NOT MATCHED \n  INSERT VALUES (v.column1, v.column2, v.column3)\nWHEN MATCHED\n  UPDATE SET FirstName = v.column2,\n             LastName = v.column3";
        StatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)sql));
        MatcherAssert.assertThat((Object)statement.getSqlWithoutComments(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)sqlWithoutComments)));
    }

    @Test
    public void testStatementWithCommentContainingSlashAndNoAsteriskOnNewLine() {
        String sql = "/*\n * Script for testing invalid/unrecognized statements\n foo bar baz */\n\n-- MERGE INTO test comment MERGE\n@EXPECT EXCEPTION INVALID_ARGUMENT 'INVALID_ARGUMENT: Unknown statement'\nMERGE INTO Singers s\nUSING (VALUES (1, 'John', 'Doe')) v\nON v.column1 = s.SingerId\n-- test again --\nWHEN NOT MATCHED \n  INSERT VALUES (v.column1, v.column2, v.column3)\nWHEN MATCHED\n  UPDATE SET FirstName = v.column2,\n             LastName = v.column3;";
        String sqlWithoutComments = "@EXPECT EXCEPTION INVALID_ARGUMENT 'INVALID_ARGUMENT: Unknown statement'\nMERGE INTO Singers s\nUSING (VALUES (1, 'John', 'Doe')) v\nON v.column1 = s.SingerId\n\nWHEN NOT MATCHED \n  INSERT VALUES (v.column1, v.column2, v.column3)\nWHEN MATCHED\n  UPDATE SET FirstName = v.column2,\n             LastName = v.column3";
        StatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)sql));
        MatcherAssert.assertThat((Object)statement.getSqlWithoutComments(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)sqlWithoutComments)));
    }

    @Test
    public void testStatementWithHashTagSingleLineComment() {
        MatcherAssert.assertThat((Object)this.parser.parse(Statement.of((String)"# this is a comment\nselect * from foo")).getSqlWithoutComments(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"select * from foo")));
        MatcherAssert.assertThat((Object)this.parser.parse(Statement.of((String)"select * from foo\n#this is a comment")).getSqlWithoutComments(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"select * from foo")));
        MatcherAssert.assertThat((Object)this.parser.parse(Statement.of((String)"select *\nfrom foo # this is a comment\nwhere bar=1")).getSqlWithoutComments(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"select *\nfrom foo \nwhere bar=1")));
    }

    @Test
    public void testIsDdlStatement() {
        Assert.assertFalse((boolean)this.parser.isDdlStatement(""));
        Assert.assertFalse((boolean)this.parser.isDdlStatement("random text"));
        Assert.assertFalse((boolean)this.parser.isDdlStatement("CREATETABLE"));
        Assert.assertFalse((boolean)this.parser.isDdlStatement("CCREATE TABLE"));
        Assert.assertFalse((boolean)this.parser.isDdlStatement("SELECT 1"));
        Assert.assertFalse((boolean)this.parser.isDdlStatement("SELECT FOO FROM BAR"));
        Assert.assertFalse((boolean)this.parser.isDdlStatement("INSERT INTO FOO (ID, NAME) VALUES (1, 'NAME')"));
        Assert.assertFalse((boolean)this.parser.isDdlStatement("UPDATE FOO SET NAME='NAME' WHERE ID=1"));
        Assert.assertFalse((boolean)this.parser.isDdlStatement("DELETE FROM FOO"));
        Assert.assertTrue((boolean)this.parser.isDdlStatement("CREATE TABLE FOO (ID INT64, NAME STRING(100)) PRIMARY KEY (ID)"));
        Assert.assertTrue((boolean)this.parser.isDdlStatement("alter table foo add Description string(100)"));
        Assert.assertTrue((boolean)this.parser.isDdlStatement("drop table foo"));
        Assert.assertTrue((boolean)this.parser.isDdlStatement("Create index BAR on foo (name)"));
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"\t\tCREATE\n\t   TABLE   FOO (ID INT64, NAME STRING(100)) PRIMARY KEY (ID)")).isDdl());
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"\n\n\nCREATE TABLE   FOO (ID INT64, NAME STRING(100)) PRIMARY KEY (ID)")).isDdl());
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"-- this is a comment\nCREATE TABLE   FOO (ID INT64, NAME STRING(100)) PRIMARY KEY (ID)")).isDdl());
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"/* multi line comment\n* with more information on the next line\n*/\nCREATE TABLE   FOO (ID INT64, NAME STRING(100)) PRIMARY KEY (ID)")).isDdl());
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"/** java doc comment\n* with more information on the next line\n*/\nCREATE TABLE   FOO (ID INT64, NAME STRING(100)) PRIMARY KEY (ID)")).isDdl());
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"-- SELECT in a single line comment \nCREATE TABLE   FOO (ID INT64, NAME STRING(100)) PRIMARY KEY (ID)")).isDdl());
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"/* SELECT in a multi line comment\n* with more information on the next line\n*/\nCREATE TABLE   FOO (ID INT64, NAME STRING(100)) PRIMARY KEY (ID)")).isDdl());
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"/** SELECT in a java doc comment\n* with more information on the next line\n*/\nCREATE TABLE   FOO (ID INT64, NAME STRING(100)) PRIMARY KEY (ID)")).isDdl());
    }

    @Test
    public void testIsQuery() {
        Assert.assertFalse((boolean)this.parser.isQuery(""));
        Assert.assertFalse((boolean)this.parser.isQuery("random text"));
        Assert.assertFalse((boolean)this.parser.isQuery("SELECT1"));
        Assert.assertFalse((boolean)this.parser.isQuery("SSELECT 1"));
        Assert.assertTrue((boolean)this.parser.isQuery("SELECT 1"));
        Assert.assertTrue((boolean)this.parser.isQuery("select 1"));
        Assert.assertTrue((boolean)this.parser.isQuery("SELECT foo FROM bar WHERE id=@id"));
        Assert.assertFalse((boolean)this.parser.isQuery("INSERT INTO FOO (ID, NAME) VALUES (1, 'NAME')"));
        Assert.assertFalse((boolean)this.parser.isQuery("UPDATE FOO SET NAME='NAME' WHERE ID=1"));
        Assert.assertFalse((boolean)this.parser.isQuery("DELETE FROM FOO"));
        Assert.assertFalse((boolean)this.parser.isQuery("CREATE TABLE FOO (ID INT64, NAME STRING(100)) PRIMARY KEY (ID)"));
        Assert.assertFalse((boolean)this.parser.isQuery("alter table foo add Description string(100)"));
        Assert.assertFalse((boolean)this.parser.isQuery("drop table foo"));
        Assert.assertFalse((boolean)this.parser.isQuery("Create index BAR on foo (name)"));
        Assert.assertTrue((boolean)this.parser.isQuery("select * from foo"));
        Assert.assertFalse((boolean)this.parser.isQuery("INSERT INTO FOO (ID, NAME) SELECT ID+1, NAME FROM FOO"));
        Assert.assertTrue((boolean)this.parser.isQuery("WITH subQ1 AS (SELECT SchoolID FROM Roster),\n     subQ2 AS (SELECT OpponentID FROM PlayerStats)\nSELECT * FROM subQ1\nUNION ALL\nSELECT * FROM subQ2"));
        Assert.assertTrue((boolean)this.parser.isQuery("with subQ1 AS (SELECT SchoolID FROM Roster),\n     subQ2 AS (SELECT OpponentID FROM PlayerStats)\nselect * FROM subQ1\nUNION ALL\nSELECT * FROM subQ2"));
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"-- this is a comment\nwith foo as (select * from bar)\nselect * from foo")).isQuery());
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"-- this is a comment\nselect * from foo")).isQuery());
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"/* multi line comment\n* with more information on the next line\n*/\nSELECT ID, NAME\nFROM\tTEST\n\tWHERE ID=1")).isQuery());
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"/** java doc comment\n* with more information on the next line\n*/\nselect max(id) from test")).isQuery());
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"-- INSERT in a single line comment \n    select 1")).isQuery());
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"/* UPDATE in a multi line comment\n* with more information on the next line\n*/\nSELECT 1")).isQuery());
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"/** DELETE in a java doc comment\n* with more information on the next line\n*/\n\n\n\n -- UPDATE test\nSELECT 1")).isQuery());
    }

    @Test
    public void testQueryHints() {
        Assert.assertTrue((boolean)this.parser.isQuery("@{JOIN_METHOD=HASH_JOIN} SELECT * FROM PersonsTable"));
        Assert.assertTrue((boolean)this.parser.isQuery("@ {JOIN_METHOD=HASH_JOIN} SELECT * FROM PersonsTable"));
        Assert.assertTrue((boolean)this.parser.isQuery("@{ JOIN_METHOD=HASH_JOIN} SELECT * FROM PersonsTable"));
        Assert.assertTrue((boolean)this.parser.isQuery("@{JOIN_METHOD=HASH_JOIN } SELECT * FROM PersonsTable"));
        Assert.assertTrue((boolean)this.parser.isQuery("@{JOIN_METHOD=HASH_JOIN}\nSELECT * FROM PersonsTable"));
        Assert.assertTrue((boolean)this.parser.isQuery("@{\nJOIN_METHOD =  HASH_JOIN   \t}\n\t SELECT * FROM PersonsTable"));
        Assert.assertTrue((boolean)this.parser.isQuery("@{JOIN_METHOD=HASH_JOIN}\n -- Single line comment\nSELECT * FROM PersonsTable"));
        Assert.assertTrue((boolean)this.parser.isQuery("@{JOIN_METHOD=HASH_JOIN}\n /* Multi line comment\n with more comments\n */SELECT * FROM PersonsTable"));
        Assert.assertTrue((boolean)this.parser.isQuery("@{JOIN_METHOD=HASH_JOIN} WITH subQ1 AS (SELECT SchoolID FROM Roster),\n     subQ2 AS (SELECT OpponentID FROM PlayerStats)\nSELECT * FROM subQ1\nUNION ALL\nSELECT * FROM subQ2"));
        Assert.assertTrue((boolean)StatementParser.INSTANCE.isQuery("@{FORCE_INDEX=index_name} @{JOIN_METHOD=HASH_JOIN} SELECT * FROM tbl"));
        Assert.assertTrue((boolean)StatementParser.INSTANCE.isQuery("@{FORCE_INDEX=index_name} @{JOIN_METHOD=HASH_JOIN} Select * FROM tbl"));
        Assert.assertTrue((boolean)StatementParser.INSTANCE.isQuery("@{FORCE_INDEX=index_name}\n@{JOIN_METHOD=HASH_JOIN}\nWITH subQ1 AS (SELECT SchoolID FROM Roster),\n     subQ2 AS (SELECT OpponentID FROM PlayerStats)\nSELECT * FROM subQ1\nUNION ALL\nSELECT * FROM subQ2"));
        Assert.assertFalse((boolean)this.parser.isQuery("@{JOIN_METHOD=HASH_JOIN SELECT * FROM PersonsTable"));
        Assert.assertFalse((boolean)this.parser.isQuery("@JOIN_METHOD=HASH_JOIN} SELECT * FROM PersonsTable"));
        Assert.assertFalse((boolean)this.parser.isQuery("@JOIN_METHOD=HASH_JOIN SELECT * FROM PersonsTable"));
        Assert.assertFalse((boolean)StatementParser.INSTANCE.isQuery("@{FORCE_INDEX=index_name} @{JOIN_METHOD=HASH_JOIN} UPDATE tbl set FOO=1 WHERE ID=2"));
    }

    @Test
    public void testIsUpdate_InsertStatements() {
        Assert.assertFalse((boolean)this.parser.isUpdateStatement(""));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("random text"));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("INSERTINTO FOO (ID) VALUES (1)"));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("IINSERT INTO FOO (ID) VALUES (1)"));
        Assert.assertTrue((boolean)this.parser.isUpdateStatement("INSERT INTO FOO (ID) VALUES (1)"));
        Assert.assertTrue((boolean)this.parser.isUpdateStatement("insert into foo (id) values (1)"));
        Assert.assertTrue((boolean)this.parser.isUpdateStatement("INSERT into Foo (id)\nSELECT id FROM bar WHERE id=@id"));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("SELECT 1"));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("SELECT NAME FROM FOO WHERE ID=1"));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("CREATE TABLE FOO (ID INT64, NAME STRING(100)) PRIMARY KEY (ID)"));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("alter table foo add Description string(100)"));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("drop table foo"));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("Create index BAR on foo (name)"));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("select * from foo"));
        Assert.assertTrue((boolean)this.parser.isUpdateStatement("INSERT INTO FOO (ID, NAME) SELECT ID+1, NAME FROM FOO"));
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"-- this is a comment\ninsert into foo (id) values (1)")).isUpdate());
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"/* multi line comment\n* with more information on the next line\n*/\nINSERT INTO FOO\n(ID)\tVALUES\n\t(1)")).isUpdate());
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"/** java doc comment\n* with more information on the next line\n*/\nInsert intO foo (id) select 1")).isUpdate());
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"-- SELECT in a single line comment \n    insert into foo (id) values (1)")).isUpdate());
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"/* CREATE in a multi line comment\n* with more information on the next line\n*/\nINSERT INTO FOO (ID) VALUES (1)")).isUpdate());
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"/** DROP in a java doc comment\n* with more information on the next line\n*/\n\n\n\n -- SELECT test\ninsert into foo (id) values (1)")).isUpdate());
    }

    @Test
    public void testIsUpdate_UpdateStatements() {
        Assert.assertFalse((boolean)this.parser.isUpdateStatement(""));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("random text"));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("UPDATEFOO SET NAME='foo' WHERE ID=1"));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("UUPDATE FOO SET NAME='foo' WHERE ID=1"));
        Assert.assertTrue((boolean)this.parser.isUpdateStatement("UPDATE FOO SET NAME='foo' WHERE ID=1"));
        Assert.assertTrue((boolean)this.parser.isUpdateStatement("update foo set name='foo' where id=1"));
        Assert.assertTrue((boolean)this.parser.isUpdateStatement("update foo set name=\n(SELECT name FROM bar WHERE id=@id)"));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("SELECT 1"));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("SELECT NAME FROM FOO WHERE ID=1"));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("CREATE TABLE FOO (ID INT64, NAME STRING(100)) PRIMARY KEY (ID)"));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("alter table foo add Description string(100)"));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("drop table foo"));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("Create index BAR on foo (name)"));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("select * from foo"));
        Assert.assertTrue((boolean)this.parser.isUpdateStatement("UPDATE FOO SET NAME=(SELECT NAME FROM FOO) WHERE ID=(SELECT ID+1 FROM FOO)"));
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"-- this is a comment\nupdate foo set name='foo' where id=@id")).isUpdate());
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"/* multi line comment\n* with more information on the next line\n*/\nUPDATE FOO\nSET NAME=\t'foo'\n\tWHERE ID=1")).isUpdate());
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"/** java doc comment\n* with more information on the next line\n*/\nUPDATE FOO SET NAME=(select 'bar')")).isUpdate());
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"-- SELECT in a single line comment \n    update foo set name='bar'")).isUpdate());
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"/* CREATE in a multi line comment\n* with more information on the next line\n*/\nUPDATE FOO SET NAME='BAR'")).isUpdate());
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"/** DROP in a java doc comment\n* with more information on the next line\n*/\n\n\n\n -- SELECT test\nupdate foo set bar='foo'")).isUpdate());
    }

    @Test
    public void testIsUpdate_DeleteStatements() {
        Assert.assertFalse((boolean)this.parser.isUpdateStatement(""));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("random text"));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("DELETEFROM FOO WHERE ID=1"));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("DDELETE FROM FOO WHERE ID=1"));
        Assert.assertTrue((boolean)this.parser.isUpdateStatement("DELETE FROM FOO WHERE ID=1"));
        Assert.assertTrue((boolean)this.parser.isUpdateStatement("delete from foo where id=1"));
        Assert.assertTrue((boolean)this.parser.isUpdateStatement("delete from foo where name=\n(SELECT name FROM bar WHERE id=@id)"));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("SELECT 1"));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("SELECT NAME FROM FOO WHERE ID=1"));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("CREATE TABLE FOO (ID INT64, NAME STRING(100)) PRIMARY KEY (ID)"));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("alter table foo add Description string(100)"));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("drop table foo"));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("Create index BAR on foo (name)"));
        Assert.assertFalse((boolean)this.parser.isUpdateStatement("select * from foo"));
        Assert.assertTrue((boolean)this.parser.isUpdateStatement("UPDATE FOO SET NAME=(SELECT NAME FROM FOO) WHERE ID=(SELECT ID+1 FROM FOO)"));
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"-- this is a comment\ndelete from foo  where id=@id")).isUpdate());
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"/* multi line comment\n* with more information on the next line\n*/\nDELETE FROM FOO\n\n\tWHERE ID=1")).isUpdate());
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"/** java doc comment\n* with more information on the next line\n*/\nDELETE FROM FOO WHERE NAME=(select 'bar')")).isUpdate());
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"-- SELECT in a single line comment \n    delete from foo where name='bar'")).isUpdate());
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"/* CREATE in a multi line comment\n* with more information on the next line\n*/\nDELETE FROM FOO WHERE NAME='BAR'")).isUpdate());
        Assert.assertTrue((boolean)this.parser.parse(Statement.of((String)"/** DROP in a java doc comment\n* with more information on the next line\n*/\n\n\n\n -- SELECT test\ndelete from foo where bar='foo'")).isUpdate());
    }

    @Test
    public void testParseStatementsWithNoParameters() throws ClientSideStatementImpl.CompileException {
        for (ClientSideStatementImpl statement : this.getAllStatements()) {
            if (statement.getSetStatement() != null) continue;
            for (String testStatement : statement.getExampleStatements()) {
                this.testParseStatement(testStatement, statement.getClass());
            }
        }
    }

    @Test
    public void testParseStatementsWithOneParameterAtTheEnd() throws ClientSideStatementImpl.CompileException {
        for (ClientSideStatementImpl statement : this.getAllStatements()) {
            if (statement.getSetStatement() == null) continue;
            for (String testStatement : statement.getExampleStatements()) {
                this.testParseStatementWithOneParameterAtTheEnd(testStatement, statement.getClass());
            }
        }
    }

    private Set<ClientSideStatementImpl> getAllStatements() throws ClientSideStatementImpl.CompileException {
        return ClientSideStatements.INSTANCE.getCompiledStatements();
    }

    private <T extends ClientSideStatementImpl> void assertParsing(String value, Class<T> statementClass) {
        MatcherAssert.assertThat(this.parse(value), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(statementClass)));
    }

    private <T extends ClientSideStatementImpl> void testParseStatement(String statement, Class<T> statementClass) {
        MatcherAssert.assertThat((String)("\"" + statement + "\" should be " + statementClass.getName()), this.parse(statement), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(statementClass)));
        this.assertParsing(this.upper(statement), statementClass);
        this.assertParsing(this.lower(statement), statementClass);
        this.assertParsing(this.withSpaces(statement), statementClass);
        this.assertParsing(this.withTabs(statement), statementClass);
        this.assertParsing(this.withLinefeeds(statement), statementClass);
        this.assertParsing(this.withLeadingSpaces(statement), statementClass);
        this.assertParsing(this.withLeadingTabs(statement), statementClass);
        this.assertParsing(this.withLeadingLinefeeds(statement), statementClass);
        this.assertParsing(this.withTrailingSpaces(statement), statementClass);
        this.assertParsing(this.withTrailingTabs(statement), statementClass);
        this.assertParsing(this.withTrailingLinefeeds(statement), statementClass);
        MatcherAssert.assertThat(this.parse(this.withInvalidPrefix(statement)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat(this.parse(this.withInvalidSuffix(statement)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertNull(this.parse(this.withPrefix("%", statement)));
        Assert.assertNull(this.parse(this.withPrefix("_", statement)));
        Assert.assertNull(this.parse(this.withPrefix("&", statement)));
        Assert.assertNull(this.parse(this.withPrefix("$", statement)));
        Assert.assertNull(this.parse(this.withPrefix("@", statement)));
        Assert.assertNull(this.parse(this.withPrefix("!", statement)));
        Assert.assertNull(this.parse(this.withPrefix("*", statement)));
        Assert.assertNull(this.parse(this.withPrefix("(", statement)));
        Assert.assertNull(this.parse(this.withPrefix(")", statement)));
        MatcherAssert.assertThat((String)(this.withSuffix("%", statement) + " is not a valid statement"), this.parse(this.withSuffix("%", statement)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertNull(this.parse(this.withSuffix("_", statement)));
        Assert.assertNull(this.parse(this.withSuffix("&", statement)));
        Assert.assertNull(this.parse(this.withSuffix("$", statement)));
        Assert.assertNull(this.parse(this.withSuffix("@", statement)));
        Assert.assertNull(this.parse(this.withSuffix("!", statement)));
        Assert.assertNull(this.parse(this.withSuffix("*", statement)));
        Assert.assertNull(this.parse(this.withSuffix("(", statement)));
        Assert.assertNull(this.parse(this.withSuffix(")", statement)));
    }

    private <T extends ClientSideStatementImpl> void testParseStatementWithOneParameterAtTheEnd(String statement, Class<T> statementClass) {
        MatcherAssert.assertThat((String)("\"" + statement + "\" should be " + statementClass.getName()), this.parse(statement), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(statementClass)));
        this.assertParsing(this.upper(statement), statementClass);
        this.assertParsing(this.lower(statement), statementClass);
        this.assertParsing(this.withSpaces(statement), statementClass);
        this.assertParsing(this.withTabs(statement), statementClass);
        this.assertParsing(this.withLinefeeds(statement), statementClass);
        this.assertParsing(this.withLeadingSpaces(statement), statementClass);
        this.assertParsing(this.withLeadingTabs(statement), statementClass);
        this.assertParsing(this.withLeadingLinefeeds(statement), statementClass);
        this.assertParsing(this.withTrailingSpaces(statement), statementClass);
        this.assertParsing(this.withTrailingTabs(statement), statementClass);
        this.assertParsing(this.withTrailingLinefeeds(statement), statementClass);
        Assert.assertNull(this.parse(this.withInvalidPrefix(statement)));
        this.assertParsing(this.withInvalidSuffix(statement), statementClass);
        Assert.assertNull(this.parse(this.withPrefix("%", statement)));
        Assert.assertNull(this.parse(this.withPrefix("_", statement)));
        Assert.assertNull(this.parse(this.withPrefix("&", statement)));
        Assert.assertNull(this.parse(this.withPrefix("$", statement)));
        Assert.assertNull(this.parse(this.withPrefix("@", statement)));
        Assert.assertNull(this.parse(this.withPrefix("!", statement)));
        Assert.assertNull(this.parse(this.withPrefix("*", statement)));
        Assert.assertNull(this.parse(this.withPrefix("(", statement)));
        Assert.assertNull(this.parse(this.withPrefix(")", statement)));
        this.assertParsing(this.withSuffix("%", statement), statementClass);
        this.assertParsing(this.withSuffix("_", statement), statementClass);
        this.assertParsing(this.withSuffix("&", statement), statementClass);
        this.assertParsing(this.withSuffix("$", statement), statementClass);
        this.assertParsing(this.withSuffix("@", statement), statementClass);
        this.assertParsing(this.withSuffix("!", statement), statementClass);
        this.assertParsing(this.withSuffix("*", statement), statementClass);
        this.assertParsing(this.withSuffix("(", statement), statementClass);
        this.assertParsing(this.withSuffix(")", statement), statementClass);
    }

    private <T extends ClientSideStatementImpl> Class<T> parse(String statement) {
        ClientSideStatementImpl optional = this.parser.parseClientSideStatement(statement);
        return optional != null ? optional.getClass() : null;
    }

    private String upper(String statement) {
        return statement.toUpperCase();
    }

    private String lower(String statement) {
        return statement.toLowerCase();
    }

    private String withLeadingSpaces(String statement) {
        return "   " + statement;
    }

    private String withLeadingTabs(String statement) {
        return "\t\t\t" + statement;
    }

    private String withLeadingLinefeeds(String statement) {
        return "\n\n\n" + statement;
    }

    private String withTrailingSpaces(String statement) {
        return statement + "  ";
    }

    private String withTrailingTabs(String statement) {
        return statement + "\t\t";
    }

    private String withTrailingLinefeeds(String statement) {
        return statement + "\n\n";
    }

    private String withSpaces(String statement) {
        return statement.replaceAll(" ", "   ");
    }

    private String withTabs(String statement) {
        return statement.replaceAll(" ", "\t");
    }

    private String withLinefeeds(String statement) {
        return statement.replaceAll(" ", "\n");
    }

    private String withInvalidPrefix(String statement) {
        return "foo " + statement;
    }

    private String withInvalidSuffix(String statement) {
        return statement + " bar";
    }

    private String withPrefix(String prefix, String statement) {
        return prefix + statement;
    }

    private String withSuffix(String suffix, String statement) {
        return statement + suffix;
    }

    private List<String> readStatementsFromFile(String filename) {
        File file = new File(this.getClass().getResource(filename).getFile());
        StringBuilder builder = new StringBuilder();
        try (Scanner scanner = new Scanner(file);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                builder.append(line).append("\n");
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        String script = builder.toString().replaceAll(COPYRIGHT_PATTERN, "");
        String[] array = script.split(";");
        ArrayList<String> res = new ArrayList<String>(array.length);
        for (String statement : array) {
            if (statement == null || statement.trim().length() <= 0) continue;
            res.add(statement);
        }
        return res;
    }
}

