/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.connection.ClientSideStatementImpl;
import com.google.cloud.spanner.connection.ClientSideStatementValueConverters;
import com.google.cloud.spanner.connection.ReadOnlyStalenessConverterTest;
import com.google.cloud.spanner.connection.TransactionMode;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TransactionModeConverterTest {
    @Test
    public void testConvert() throws ClientSideStatementImpl.CompileException {
        String allowedValues = ReadOnlyStalenessConverterTest.getAllowedValues(ClientSideStatementValueConverters.TransactionModeConverter.class);
        MatcherAssert.assertThat((Object)allowedValues, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ClientSideStatementValueConverters.TransactionModeConverter converter = new ClientSideStatementValueConverters.TransactionModeConverter(allowedValues);
        MatcherAssert.assertThat((Object)converter.convert("read write"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TransactionMode.READ_WRITE_TRANSACTION)));
        MatcherAssert.assertThat((Object)converter.convert("READ WRITE"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TransactionMode.READ_WRITE_TRANSACTION)));
        MatcherAssert.assertThat((Object)converter.convert("Read Write"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TransactionMode.READ_WRITE_TRANSACTION)));
        MatcherAssert.assertThat((Object)converter.convert("read   write"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TransactionMode.READ_WRITE_TRANSACTION)));
        MatcherAssert.assertThat((Object)converter.convert("READ\nWRITE"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TransactionMode.READ_WRITE_TRANSACTION)));
        MatcherAssert.assertThat((Object)converter.convert("Read\tWrite"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TransactionMode.READ_WRITE_TRANSACTION)));
        MatcherAssert.assertThat((Object)converter.convert("read only"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TransactionMode.READ_ONLY_TRANSACTION)));
        MatcherAssert.assertThat((Object)converter.convert("READ ONLY"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TransactionMode.READ_ONLY_TRANSACTION)));
        MatcherAssert.assertThat((Object)converter.convert("Read Only"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TransactionMode.READ_ONLY_TRANSACTION)));
        MatcherAssert.assertThat((Object)converter.convert("read   only"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TransactionMode.READ_ONLY_TRANSACTION)));
        MatcherAssert.assertThat((Object)converter.convert("READ\nONLY"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TransactionMode.READ_ONLY_TRANSACTION)));
        MatcherAssert.assertThat((Object)converter.convert("Read\tOnly"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TransactionMode.READ_ONLY_TRANSACTION)));
        MatcherAssert.assertThat((Object)converter.convert(""), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert(" "), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("random string"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("read_write"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("Read_Write"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("READ_WRITE"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("read_only"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("Read_Only"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("READ_ONLY"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

