/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.api.gax.grpc.GrpcInterceptorProvider;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.Page;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Backup;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.cloud.spanner.testing.RemoteSpannerHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.truth.Truth;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITDatabaseAdminTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private DatabaseAdminClient dbAdminClient;
    private RemoteSpannerHelper testHelper;
    private List<Database> dbs = new ArrayList<Database>();

    @Before
    public void setUp() {
        this.testHelper = env.getTestHelper();
        this.dbAdminClient = this.testHelper.getClient().getDatabaseAdminClient();
    }

    @After
    public void tearDown() {
        for (Database db : this.dbs) {
            db.drop();
        }
        this.dbs.clear();
    }

    @Test
    public void databaseOperations() throws Exception {
        String dbId = this.testHelper.getUniqueDatabaseId();
        String instanceId = this.testHelper.getInstanceId().getInstance();
        String statement1 = "CREATE TABLE T (\n  K STRING(MAX),\n) PRIMARY KEY(K)";
        OperationFuture op = this.dbAdminClient.createDatabase(instanceId, dbId, (Iterable)ImmutableList.of((Object)statement1));
        Database db = (Database)op.get();
        this.dbs.add(db);
        Truth.assertThat((String)db.getId().getDatabase()).isEqualTo((Object)dbId);
        db = this.dbAdminClient.getDatabase(instanceId, dbId);
        Truth.assertThat((String)db.getId().getDatabase()).isEqualTo((Object)dbId);
        boolean foundDb = false;
        for (Database dbInList : (Database[])Iterators.toArray(this.dbAdminClient.listDatabases(instanceId, new Options.ListOption[0]).iterateAll().iterator(), Database.class)) {
            if (!dbInList.getId().getDatabase().equals(dbId)) continue;
            foundDb = true;
            break;
        }
        Truth.assertThat((Boolean)foundDb).isTrue();
        String statement2 = "CREATE TABLE T2 (\n  K2 STRING(MAX),\n) PRIMARY KEY(K2)";
        OperationFuture op2 = this.dbAdminClient.updateDatabaseDdl(instanceId, dbId, (Iterable)ImmutableList.of((Object)statement2), null);
        op2.get();
        List statementsInDb = this.dbAdminClient.getDatabaseDdl(instanceId, dbId);
        Truth.assertThat((Iterable)statementsInDb).containsExactly(new Object[]{statement1, statement2});
        this.dbAdminClient.dropDatabase(instanceId, dbId);
        this.dbs.clear();
        try {
            db = this.dbAdminClient.getDatabase(this.testHelper.getInstanceId().getInstance(), dbId);
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Truth.assertThat((Comparable)ex.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
        }
    }

    @Test
    public void updateDdlRetry() throws Exception {
        String dbId = this.testHelper.getUniqueDatabaseId();
        String instanceId = this.testHelper.getInstanceId().getInstance();
        String statement1 = "CREATE TABLE T (\n  K STRING(MAX),\n) PRIMARY KEY(K)";
        OperationFuture op = this.dbAdminClient.createDatabase(instanceId, dbId, (Iterable)ImmutableList.of((Object)statement1));
        Database db = (Database)op.get();
        this.dbs.add(db);
        String statement2 = "CREATE TABLE T2 (\n  K2 STRING(MAX),\n) PRIMARY KEY(K2)";
        OperationFuture op1 = this.dbAdminClient.updateDatabaseDdl(instanceId, dbId, (Iterable)ImmutableList.of((Object)statement2), "myop");
        OperationFuture op2 = this.dbAdminClient.updateDatabaseDdl(instanceId, dbId, (Iterable)ImmutableList.of((Object)statement2), "myop");
        op1.get();
        op2.get();
        Truth.assertThat((Object)op1.getMetadata().get()).isEqualTo(op2.getMetadata().get());
    }

    @Test
    public void databaseOperationsViaEntity() throws Exception {
        String dbId = this.testHelper.getUniqueDatabaseId();
        String instanceId = this.testHelper.getInstanceId().getInstance();
        String statement1 = "CREATE TABLE T (\n  K STRING(MAX),\n) PRIMARY KEY(K)";
        OperationFuture op = this.dbAdminClient.createDatabase(instanceId, dbId, (Iterable)ImmutableList.of((Object)statement1));
        Database db = (Database)op.get();
        this.dbs.add(db);
        Truth.assertThat((String)db.getId().getDatabase()).isEqualTo((Object)dbId);
        db = db.reload();
        Truth.assertThat((String)db.getId().getDatabase()).isEqualTo((Object)dbId);
        String statement2 = "CREATE TABLE T2 (\n  K2 STRING(MAX),\n) PRIMARY KEY(K2)";
        OperationFuture op2 = db.updateDdl((Iterable)ImmutableList.of((Object)statement2), null);
        op2.get();
        Iterable statementsInDb = db.getDdl();
        Truth.assertThat((Iterable)statementsInDb).containsExactly(new Object[]{statement1, statement2});
        db.drop();
        this.dbs.clear();
        try {
            db.reload();
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Truth.assertThat((Comparable)ex.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
        }
    }

    @Test
    public void listPagination() throws Exception {
        ImmutableList dbIds = ImmutableList.of((Object)this.testHelper.getUniqueDatabaseId(), (Object)this.testHelper.getUniqueDatabaseId(), (Object)this.testHelper.getUniqueDatabaseId());
        String instanceId = this.testHelper.getInstanceId().getInstance();
        for (String dbId : dbIds) {
            this.dbs.add((Database)this.dbAdminClient.createDatabase(instanceId, dbId, (Iterable)ImmutableList.of()).get());
        }
        ArrayList<String> dbIdsGot = new ArrayList<String>();
        for (Page page = this.dbAdminClient.listDatabases(instanceId, new Options.ListOption[]{Options.pageSize((int)1)}); page != null && page.getValues().iterator().hasNext(); page = page.getNextPage()) {
            Database db = (Database)Iterables.getOnlyElement((Iterable)page.getValues());
            dbIdsGot.add(db.getId().getDatabase());
        }
        Truth.assertThat(dbIdsGot).containsAtLeastElementsIn((Iterable)dbIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRetryNonIdempotentRpcsReturningLongRunningOperations() throws Exception {
        Assume.assumeFalse((String)"Querying long-running operations is not supported on the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        ArrayList<Object> databases = new ArrayList<Object>();
        ArrayList<Object> backups = new ArrayList<Object>();
        try {
            Object backupId;
            Timestamp initialDbCreateTime;
            Object client;
            String initialDatabaseId;
            InjectErrorInterceptorProvider createDbInterceptor = new InjectErrorInterceptorProvider("CreateDatabase");
            SpannerOptions options = this.testHelper.getOptions().toBuilder().setInterceptorProvider((GrpcInterceptorProvider)createDbInterceptor).build();
            try (Spanner spanner = (Spanner)options.getService();){
                initialDatabaseId = this.testHelper.getUniqueDatabaseId();
                client = spanner.getDatabaseAdminClient();
                OperationFuture op = client.createDatabase(this.testHelper.getInstanceId().getInstance(), initialDatabaseId, Collections.emptyList());
                databases.add(op.get());
                initialDbCreateTime = ((Database)op.get()).getCreateTime();
                Truth.assertThat((Integer)createDbInterceptor.methodCount.get()).isEqualTo((Object)1);
                Truth.assertThat((Integer)createDbInterceptor.getOperationCount.get()).isAtLeast((Comparable)Integer.valueOf(1));
            }
            InjectErrorInterceptorProvider injectErrorInterceptorProvider = new InjectErrorInterceptorProvider("CreateBackup");
            options = this.testHelper.getOptions().toBuilder().setInterceptorProvider((GrpcInterceptorProvider)injectErrorInterceptorProvider).build();
            Spanner spanner = (Spanner)options.getService();
            client = null;
            try {
                String databaseId = ((Database)databases.get(0)).getId().getDatabase();
                backupId = String.format("test-bck-%08d", new Random().nextInt(100000000));
                DatabaseAdminClient client2 = spanner.getDatabaseAdminClient();
                OperationFuture op = client2.createBackup(this.testHelper.getInstanceId().getInstance(), (String)backupId, databaseId, Timestamp.ofTimeSecondsAndNanos((long)(Timestamp.now().getSeconds() + TimeUnit.SECONDS.convert(7L, TimeUnit.DAYS)), (int)0));
                backups.add(op.get());
                Truth.assertThat((Integer)createDbInterceptor.methodCount.get()).isEqualTo((Object)1);
                Truth.assertThat((Integer)createDbInterceptor.getOperationCount.get()).isAtLeast((Comparable)Integer.valueOf(1));
            }
            catch (Throwable databaseId) {
                client = databaseId;
                throw databaseId;
            }
            finally {
                if (spanner != null) {
                    if (client != null) {
                        try {
                            spanner.close();
                        }
                        catch (Throwable databaseId) {
                            ((Throwable)client).addSuppressed(databaseId);
                        }
                    } else {
                        spanner.close();
                    }
                }
            }
            int attempts = 0;
            while (true) {
                InjectErrorInterceptorProvider restoreBackupInterceptor = new InjectErrorInterceptorProvider("RestoreBackup");
                options = this.testHelper.getOptions().toBuilder().setInterceptorProvider((GrpcInterceptorProvider)restoreBackupInterceptor).build();
                try {
                    Spanner spanner2 = (Spanner)options.getService();
                    backupId = null;
                    try {
                        String backupId2 = ((Backup)backups.get(0)).getId().getBackup();
                        String restoredDbId = this.testHelper.getUniqueDatabaseId();
                        DatabaseAdminClient client3 = spanner2.getDatabaseAdminClient();
                        OperationFuture op = client3.restoreDatabase(this.testHelper.getInstanceId().getInstance(), backupId2, this.testHelper.getInstanceId().getInstance(), restoredDbId);
                        databases.add(op.get());
                        Truth.assertThat((Integer)createDbInterceptor.methodCount.get()).isEqualTo((Object)1);
                        Truth.assertThat((Integer)createDbInterceptor.getOperationCount.get()).isAtLeast((Comparable)Integer.valueOf(1));
                    }
                    catch (Throwable backupId2) {
                        backupId = backupId2;
                        throw backupId2;
                    }
                    finally {
                        if (spanner2 != null) {
                            if (backupId != null) {
                                try {
                                    spanner2.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)backupId).addSuppressed(throwable);
                                }
                            } else {
                                spanner2.close();
                            }
                        }
                    }
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof SpannerException && ((SpannerException)e.getCause()).getErrorCode() == ErrorCode.FAILED_PRECONDITION && e.getCause().getMessage().contains("Please retry the operation once the pending restores complete")) {
                        if (++attempts == 10) break;
                        Thread.sleep(60000L);
                        continue;
                    }
                    throw e;
                }
                break;
            }
            createDbInterceptor = new InjectErrorInterceptorProvider("CreateDatabase");
            options = this.testHelper.getOptions().toBuilder().setInterceptorProvider((GrpcInterceptorProvider)createDbInterceptor).build();
            try (Spanner spanner3 = (Spanner)options.getService();){
                DatabaseAdminClient client4 = spanner3.getDatabaseAdminClient();
                client4.dropDatabase(this.testHelper.getInstanceId().getInstance(), initialDatabaseId);
                OperationFuture op = client4.createDatabase(this.testHelper.getInstanceId().getInstance(), initialDatabaseId, Collections.emptyList());
                Timestamp secondCreationTime = ((Database)op.get()).getCreateTime();
                Truth.assertThat((Comparable)secondCreationTime).isAtLeast((Comparable)initialDbCreateTime);
                Truth.assertThat((Integer)createDbInterceptor.methodCount.get()).isEqualTo((Object)1);
                Truth.assertThat((Integer)createDbInterceptor.getOperationCount.get()).isAtLeast((Comparable)Integer.valueOf(1));
            }
        }
        finally {
            DatabaseAdminClient client = this.testHelper.getClient().getDatabaseAdminClient();
            for (Database database : databases) {
                client.dropDatabase(database.getId().getInstanceId().getInstance(), database.getId().getDatabase());
            }
            for (Backup backup : backups) {
                client.deleteBackup(backup.getInstanceId().getInstance(), backup.getId().getBackup());
            }
        }
    }

    private static final class InjectErrorInterceptorProvider
    implements GrpcInterceptorProvider {
        final AtomicBoolean injectError = new AtomicBoolean(true);
        final AtomicInteger getOperationCount = new AtomicInteger();
        final AtomicInteger methodCount = new AtomicInteger();
        final String methodName;

        private InjectErrorInterceptorProvider(String methodName) {
            this.methodName = methodName;
        }

        public List<ClientInterceptor> getInterceptors() {
            ClientInterceptor interceptor = new ClientInterceptor(){

                public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                    if (method.getFullMethodName().contains("GetOperation")) {
                        InjectErrorInterceptorProvider.this.getOperationCount.incrementAndGet();
                    }
                    if (!method.getFullMethodName().contains(InjectErrorInterceptorProvider.this.methodName)) {
                        return next.newCall(method, callOptions);
                    }
                    InjectErrorInterceptorProvider.this.methodCount.incrementAndGet();
                    final AtomicBoolean errorInjected = new AtomicBoolean();
                    final ClientCall clientCall = next.newCall(method, callOptions);
                    return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(clientCall){

                        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                            super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                                public void onMessage(RespT message) {
                                    if (InjectErrorInterceptorProvider.this.injectError.getAndSet(false)) {
                                        errorInjected.set(true);
                                        clientCall.cancel("Cancelling call for injected error", null);
                                    } else {
                                        super.onMessage(message);
                                    }
                                }

                                public void onClose(Status status, Metadata metadata) {
                                    if (errorInjected.get()) {
                                        status = Status.UNAVAILABLE.augmentDescription("INJECTED BY TEST");
                                    }
                                    super.onClose(status, metadata);
                                }
                            }, headers);
                        }
                    };
                }
            };
            return Collections.singletonList(interceptor);
        }
    }
}

