/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.api.client.util.ExponentialBackOff;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.DatabaseNotFoundException;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.InstanceNotFoundException;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.common.truth.Truth;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITDatabaseTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();

    @Test
    public void badDdl() {
        try {
            env.getTestHelper().createTestDatabase(new String[]{"CREATE TABLE T ( Illegal Way To Define A Table )"});
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Truth.assertThat((Comparable)ex.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
            Truth.assertThat((String)ex.getMessage()).contains((CharSequence)"Syntax error on line 1");
        }
    }

    @Test
    public void databaseDeletedTest() throws Exception {
        Assume.assumeFalse((String)"Emulator does not return ResourceInfo for Database not found errors", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        Database db = env.getTestHelper().createTestDatabase(new String[0]);
        DatabaseClient client = env.getTestHelper().getClient().getDatabaseClient(db.getId());
        try (ResultSet rs = client.singleUse().executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);){
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
        db.drop();
        ExponentialBackOff backoff = new ExponentialBackOff.Builder().setInitialIntervalMillis(1000).setMaxElapsedTimeMillis(35000).setMaxIntervalMillis(5000).build();
        DatabaseNotFoundException notFoundException = null;
        long millis = 0L;
        while ((millis = backoff.nextBackOffMillis()) != -1L) {
            Thread.sleep(millis);
            try {
                ResultSet rs = client.singleUse().executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);
                Throwable throwable = null;
                try {
                    rs.next();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rs == null) continue;
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    rs.close();
                }
            }
            catch (DatabaseNotFoundException e) {
                notFoundException = e;
                break;
            }
        }
        Truth.assertThat(notFoundException).isNotNull();
        OperationFuture op = env.getTestHelper().getClient().getDatabaseAdminClient().createDatabase(db.getId().getInstanceId().getInstance(), db.getId().getDatabase(), Collections.emptyList());
        Database newDb = (Database)op.get();
        try (ResultSet rs2 = client.singleUse().executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);){
            rs2.next();
            Assert.fail((String)"Missing expected DatabaseNotFoundException");
        }
        catch (DatabaseNotFoundException rs2) {
            // empty catch block
        }
        DatabaseClient newClient = env.getTestHelper().getClient().getDatabaseClient(newDb.getId());
        try (ResultSet rs = newClient.singleUse().executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);){
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void instanceNotFound() {
        Assume.assumeFalse((String)"Emulator does not return ResourceInfo for Instance not found errors", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        InstanceId testId = env.getTestHelper().getInstanceId();
        InstanceId nonExistingInstanceId = InstanceId.of((String)testId.getProject(), (String)(testId.getInstance() + "-na"));
        DatabaseClient client = env.getTestHelper().getClient().getDatabaseClient(DatabaseId.of((InstanceId)nonExistingInstanceId, (String)"some-db"));
        try (ResultSet rs = client.singleUse().executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);){
            rs.next();
            Assert.fail((String)"missing expected exception");
        }
        catch (InstanceNotFoundException e) {
            Truth.assertThat((String)e.getResourceName()).isEqualTo((Object)nonExistingInstanceId.getName());
        }
    }
}

