/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.api.core.ApiFunction;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.testing.RemoteSpannerHelper;
import com.google.common.base.Stopwatch;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import io.grpc.ManagedChannelBuilder;
import io.grpc.alts.ComputeEngineChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.channel.ChannelDuplexHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelFactory;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITDirectPathFallback {
    private static final int MIN_COMPLETE_READ_CALLS = 40;
    private static final int NUM_RPCS_TO_SEND = 20;
    private static final String DP_IPV6_PREFIX = "2001:4860:8040";
    private static final String DP_IPV4_PREFIX = "34.126";
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private AtomicBoolean blackholeDpAddr = new AtomicBoolean();
    private AtomicInteger numBlocked = new AtomicInteger();
    private AtomicInteger numDpAddrRead = new AtomicInteger();
    private boolean isDpAddr;
    private ChannelFactory<NioSocketChannel> channelFactory = new MyChannelFactory();
    private EventLoopGroup eventLoopGroup = new NioEventLoopGroup();
    private RemoteSpannerHelper testHelper;
    private static final String TABLE_NAME = "TestTable";
    private static final List<String> ALL_COLUMNS = Arrays.asList("Key", "StringValue");
    private static Database db;
    private static DatabaseClient client;
    private static final String DIRECT_PATH_ENDPOINT = "aa423245250f2bbf.sandbox.googleapis.com:443";
    private static final String ATTEMPT_DIRECT_PATH = "spanner.attempt_directpath";

    @Before
    public void setup() throws IOException, Throwable {
        TruthJUnit.assume().withMessage("DirectPath integration tests can only run against DirectPathEnv").that(Boolean.valueOf(Boolean.getBoolean(ATTEMPT_DIRECT_PATH))).isTrue();
        SpannerOptions.Builder builder = env.getTestHelper().getOptions().toBuilder();
        builder.setChannelProvider((TransportChannelProvider)InstantiatingGrpcChannelProvider.newBuilder().setAttemptDirectPath(true).setEndpoint(DIRECT_PATH_ENDPOINT).setPoolSize(1).setChannelConfigurator((ApiFunction)new ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder>(){

            public ManagedChannelBuilder apply(ManagedChannelBuilder builder) {
                ITDirectPathFallback.this.injectNettyChannelHandler(builder);
                builder.keepAliveTime(1L, TimeUnit.SECONDS);
                builder.keepAliveTimeout(1L, TimeUnit.SECONDS);
                return builder;
            }
        }).build());
        builder.setCredentials(FixedCredentialsProvider.create((Credentials)ComputeEngineCredentials.create()).getCredentials());
        this.testHelper = RemoteSpannerHelper.create((SpannerOptions)builder.build(), (InstanceId)env.getTestHelper().getInstanceId());
        db = this.testHelper.createTestDatabase(new String[]{"CREATE TABLE TestTable (  Key                STRING(MAX) NOT NULL,  StringValue        STRING(MAX),) PRIMARY KEY (Key)"});
        client = this.testHelper.getDatabaseClient(db);
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        for (int i = 0; i < 3; ++i) {
            mutations.add(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)TABLE_NAME).set("Key").to("k" + i)).set("StringValue").to("v" + i)).build());
        }
        client.write(mutations);
    }

    @After
    public void teardown() {
        if (this.testHelper != null) {
            this.testHelper.cleanUp();
            this.testHelper.getClient().close();
        }
        if (this.eventLoopGroup != null) {
            this.eventLoopGroup.shutdownGracefully();
        }
    }

    @Test
    public void testFallback() throws InterruptedException, TimeoutException {
        Truth.assertWithMessage((String)"Failed to observe RPCs over DirectPath").that(Boolean.valueOf(this.exerciseDirectPath())).isTrue();
        this.blackholeDpAddr.set(true);
        client.singleUse(TimestampBound.strong()).readRow(TABLE_NAME, Key.of((Object[])new Object[]{"k0"}), ALL_COLUMNS);
        Truth.assertWithMessage((String)"Failed to detect any IPv6 traffic in blackhole").that(Integer.valueOf(this.numBlocked.get())).isGreaterThan((Comparable)Integer.valueOf(0));
        this.blackholeDpAddr.set(false);
        Truth.assertWithMessage((String)"Failed to upgrade back to DirectPath").that(Boolean.valueOf(this.exerciseDirectPath())).isTrue();
    }

    private boolean exerciseDirectPath() throws InterruptedException, TimeoutException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.numDpAddrRead.set(0);
        boolean seenEnough = false;
        while (!seenEnough && stopwatch.elapsed(TimeUnit.MINUTES) < 2L) {
            for (int i = 0; i < 20; ++i) {
                client.singleUse(TimestampBound.strong()).readRow(TABLE_NAME, Key.of((Object[])new Object[]{"k0"}), ALL_COLUMNS);
            }
            Thread.sleep(100L);
            seenEnough = this.numDpAddrRead.get() >= 40;
        }
        return seenEnough;
    }

    private void injectNettyChannelHandler(ManagedChannelBuilder<?> channelBuilder) {
        try {
            Field delegateField = ComputeEngineChannelBuilder.class.getDeclaredField("delegate");
            delegateField.setAccessible(true);
            ComputeEngineChannelBuilder gceChannelBuilder = (ComputeEngineChannelBuilder)channelBuilder;
            Object delegateChannelBuilder = delegateField.get(gceChannelBuilder);
            NettyChannelBuilder nettyChannelBuilder = (NettyChannelBuilder)delegateChannelBuilder;
            nettyChannelBuilder.channelFactory(this.channelFactory);
            nettyChannelBuilder.eventLoopGroup(this.eventLoopGroup);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Failed to inject the netty ChannelHandler", e);
        }
    }

    private class MyChannelHandler
    extends ChannelDuplexHandler {
        private MyChannelHandler() {
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            if (remoteAddress instanceof InetSocketAddress) {
                InetAddress inetAddress = ((InetSocketAddress)remoteAddress).getAddress();
                String addr = inetAddress.getHostAddress();
                ITDirectPathFallback.this.isDpAddr = addr.startsWith(ITDirectPathFallback.DP_IPV6_PREFIX) || addr.startsWith(ITDirectPathFallback.DP_IPV4_PREFIX);
            }
            if (!ITDirectPathFallback.this.isDpAddr || !ITDirectPathFallback.this.blackholeDpAddr.get()) {
                super.connect(ctx, remoteAddress, localAddress, promise);
            } else {
                promise.setFailure((Throwable)new IOException("fake error"));
            }
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            boolean dropCall;
            boolean bl = dropCall = ITDirectPathFallback.this.isDpAddr && ITDirectPathFallback.this.blackholeDpAddr.get();
            if (dropCall) {
                ITDirectPathFallback.this.numBlocked.incrementAndGet();
                ReferenceCountUtil.release((Object)msg);
            } else {
                super.channelRead(ctx, msg);
            }
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            boolean dropCall;
            boolean bl = dropCall = ITDirectPathFallback.this.isDpAddr && ITDirectPathFallback.this.blackholeDpAddr.get();
            if (dropCall) {
                ITDirectPathFallback.this.numBlocked.incrementAndGet();
            } else {
                if (ITDirectPathFallback.this.isDpAddr) {
                    ITDirectPathFallback.this.numDpAddrRead.incrementAndGet();
                }
                super.channelReadComplete(ctx);
            }
        }
    }

    private class MyChannelFactory
    implements ChannelFactory<NioSocketChannel> {
        private MyChannelFactory() {
        }

        public NioSocketChannel newChannel() {
            NioSocketChannel channel = new NioSocketChannel();
            channel.pipeline().addLast(new ChannelHandler[]{new MyChannelHandler()});
            return channel;
        }
    }
}

