/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.grpc.testing.MockStreamObserver;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.spanner.v1.MockSpanner;
import com.google.cloud.spanner.v1.SpannerClient;
import com.google.cloud.spanner.v1.SpannerSettings;
import com.google.common.collect.Lists;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import com.google.spanner.v1.BatchCreateSessionsRequest;
import com.google.spanner.v1.BatchCreateSessionsResponse;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.CommitResponse;
import com.google.spanner.v1.CreateSessionRequest;
import com.google.spanner.v1.DatabaseName;
import com.google.spanner.v1.DeleteSessionRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteBatchDmlResponse;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.GetSessionRequest;
import com.google.spanner.v1.KeySet;
import com.google.spanner.v1.ListSessionsRequest;
import com.google.spanner.v1.ListSessionsResponse;
import com.google.spanner.v1.PartialResultSet;
import com.google.spanner.v1.PartitionOptions;
import com.google.spanner.v1.PartitionQueryRequest;
import com.google.spanner.v1.PartitionReadRequest;
import com.google.spanner.v1.PartitionResponse;
import com.google.spanner.v1.ReadRequest;
import com.google.spanner.v1.ResultSet;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.ResultSetStats;
import com.google.spanner.v1.RollbackRequest;
import com.google.spanner.v1.Session;
import com.google.spanner.v1.SessionName;
import com.google.spanner.v1.Transaction;
import com.google.spanner.v1.TransactionOptions;
import com.google.spanner.v1.TransactionSelector;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SpannerClientTest {
    private static MockServiceHelper mockServiceHelper;
    private SpannerClient client;
    private static MockSpanner mockSpanner;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockSpanner = new MockSpanner();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockSpanner));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        SpannerSettings settings = ((SpannerSettings.Builder)((SpannerSettings.Builder)SpannerSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = SpannerClient.create((SpannerSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createSessionTest() throws Exception {
        Session expectedResponse = Session.newBuilder().setName(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setApproximateLastUseTime(Timestamp.newBuilder().build()).build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        Session actualResponse = this.client.createSession(database);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSessionRequest actualRequest = (CreateSessionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)database.toString(), (Object)actualRequest.getDatabase());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSessionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
            this.client.createSession(database);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSessionTest2() throws Exception {
        Session expectedResponse = Session.newBuilder().setName(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setApproximateLastUseTime(Timestamp.newBuilder().build()).build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        String database = "database1789464955";
        Session actualResponse = this.client.createSession(database);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSessionRequest actualRequest = (CreateSessionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)database, (Object)actualRequest.getDatabase());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSessionExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            String database = "database1789464955";
            this.client.createSession(database);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchCreateSessionsTest() throws Exception {
        BatchCreateSessionsResponse expectedResponse = BatchCreateSessionsResponse.newBuilder().addAllSession(new ArrayList()).build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        int sessionCount = 185691686;
        BatchCreateSessionsResponse actualResponse = this.client.batchCreateSessions(database, sessionCount);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchCreateSessionsRequest actualRequest = (BatchCreateSessionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)database.toString(), (Object)actualRequest.getDatabase());
        Assert.assertEquals((long)sessionCount, (long)actualRequest.getSessionCount());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchCreateSessionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
            int sessionCount = 185691686;
            this.client.batchCreateSessions(database, sessionCount);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchCreateSessionsTest2() throws Exception {
        BatchCreateSessionsResponse expectedResponse = BatchCreateSessionsResponse.newBuilder().addAllSession(new ArrayList()).build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        String database = "database1789464955";
        int sessionCount = 185691686;
        BatchCreateSessionsResponse actualResponse = this.client.batchCreateSessions(database, sessionCount);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchCreateSessionsRequest actualRequest = (BatchCreateSessionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)database, (Object)actualRequest.getDatabase());
        Assert.assertEquals((long)sessionCount, (long)actualRequest.getSessionCount());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchCreateSessionsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            String database = "database1789464955";
            int sessionCount = 185691686;
            this.client.batchCreateSessions(database, sessionCount);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSessionTest() throws Exception {
        Session expectedResponse = Session.newBuilder().setName(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setApproximateLastUseTime(Timestamp.newBuilder().build()).build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        SessionName name = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
        Session actualResponse = this.client.getSession(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSessionRequest actualRequest = (GetSessionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSessionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            SessionName name = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
            this.client.getSession(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSessionTest2() throws Exception {
        Session expectedResponse = Session.newBuilder().setName(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setApproximateLastUseTime(Timestamp.newBuilder().build()).build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Session actualResponse = this.client.getSession(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSessionRequest actualRequest = (GetSessionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSessionExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            String name = "name3373707";
            this.client.getSession(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSessionsTest() throws Exception {
        Session responsesElement = Session.newBuilder().build();
        ListSessionsResponse expectedResponse = ListSessionsResponse.newBuilder().setNextPageToken("").addAllSessions(Arrays.asList(responsesElement)).build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        SpannerClient.ListSessionsPagedResponse pagedListResponse = this.client.listSessions(database);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSessionsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSessionsRequest actualRequest = (ListSessionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)database.toString(), (Object)actualRequest.getDatabase());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSessionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
            this.client.listSessions(database);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSessionsTest2() throws Exception {
        Session responsesElement = Session.newBuilder().build();
        ListSessionsResponse expectedResponse = ListSessionsResponse.newBuilder().setNextPageToken("").addAllSessions(Arrays.asList(responsesElement)).build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        String database = "database1789464955";
        SpannerClient.ListSessionsPagedResponse pagedListResponse = this.client.listSessions(database);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSessionsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSessionsRequest actualRequest = (ListSessionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)database, (Object)actualRequest.getDatabase());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSessionsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            String database = "database1789464955";
            this.client.listSessions(database);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSessionTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        SessionName name = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
        this.client.deleteSession(name);
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteSessionRequest actualRequest = (DeleteSessionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteSessionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            SessionName name = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
            this.client.deleteSession(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSessionTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteSession(name);
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteSessionRequest actualRequest = (DeleteSessionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteSessionExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            String name = "name3373707";
            this.client.deleteSession(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void executeSqlTest() throws Exception {
        ResultSet expectedResponse = ResultSet.newBuilder().setMetadata(ResultSetMetadata.newBuilder().build()).addAllRows(new ArrayList()).setStats(ResultSetStats.newBuilder().build()).build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        ExecuteSqlRequest request = ExecuteSqlRequest.newBuilder().setSession(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).setTransaction(TransactionSelector.newBuilder().build()).setSql("sql114126").setParams(Struct.newBuilder().build()).putAllParamTypes(new HashMap()).setResumeToken(ByteString.EMPTY).setPartitionToken(ByteString.EMPTY).setSeqno(109325920L).setQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().build()).build();
        ResultSet actualResponse = this.client.executeSql(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ExecuteSqlRequest actualRequest = (ExecuteSqlRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getSession(), (Object)actualRequest.getSession());
        Assert.assertEquals((Object)request.getTransaction(), (Object)actualRequest.getTransaction());
        Assert.assertEquals((Object)request.getSql(), (Object)actualRequest.getSql());
        Assert.assertEquals((Object)request.getParams(), (Object)actualRequest.getParams());
        Assert.assertEquals((Object)request.getParamTypesMap(), (Object)actualRequest.getParamTypesMap());
        Assert.assertEquals((Object)request.getResumeToken(), (Object)actualRequest.getResumeToken());
        Assert.assertEquals((Object)request.getQueryMode(), (Object)actualRequest.getQueryMode());
        Assert.assertEquals((Object)request.getPartitionToken(), (Object)actualRequest.getPartitionToken());
        Assert.assertEquals((long)request.getSeqno(), (long)actualRequest.getSeqno());
        Assert.assertEquals((Object)request.getQueryOptions(), (Object)actualRequest.getQueryOptions());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void executeSqlExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            ExecuteSqlRequest request = ExecuteSqlRequest.newBuilder().setSession(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).setTransaction(TransactionSelector.newBuilder().build()).setSql("sql114126").setParams(Struct.newBuilder().build()).putAllParamTypes(new HashMap()).setResumeToken(ByteString.EMPTY).setPartitionToken(ByteString.EMPTY).setSeqno(109325920L).setQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().build()).build();
            this.client.executeSql(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void executeStreamingSqlTest() throws Exception {
        PartialResultSet expectedResponse = PartialResultSet.newBuilder().setMetadata(ResultSetMetadata.newBuilder().build()).addAllValues(new ArrayList()).setChunkedValue(true).setResumeToken(ByteString.EMPTY).setStats(ResultSetStats.newBuilder().build()).build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        ExecuteSqlRequest request = ExecuteSqlRequest.newBuilder().setSession(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).setTransaction(TransactionSelector.newBuilder().build()).setSql("sql114126").setParams(Struct.newBuilder().build()).putAllParamTypes(new HashMap()).setResumeToken(ByteString.EMPTY).setPartitionToken(ByteString.EMPTY).setSeqno(109325920L).setQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().build()).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.executeStreamingSqlCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        List actualResponses = (List)responseObserver.future().get();
        Assert.assertEquals((long)1L, (long)actualResponses.size());
        Assert.assertEquals((Object)expectedResponse, actualResponses.get(0));
    }

    @Test
    public void executeStreamingSqlExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        ExecuteSqlRequest request = ExecuteSqlRequest.newBuilder().setSession(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).setTransaction(TransactionSelector.newBuilder().build()).setSql("sql114126").setParams(Struct.newBuilder().build()).putAllParamTypes(new HashMap()).setResumeToken(ByteString.EMPTY).setPartitionToken(ByteString.EMPTY).setSeqno(109325920L).setQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().build()).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.executeStreamingSqlCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        try {
            List actualResponses = (List)responseObserver.future().get();
            Assert.fail((String)"No exception thrown");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidArgumentException));
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void executeBatchDmlTest() throws Exception {
        ExecuteBatchDmlResponse expectedResponse = ExecuteBatchDmlResponse.newBuilder().addAllResultSets(new ArrayList()).setStatus(com.google.rpc.Status.newBuilder().build()).build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        ExecuteBatchDmlRequest request = ExecuteBatchDmlRequest.newBuilder().setSession(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).setTransaction(TransactionSelector.newBuilder().build()).addAllStatements(new ArrayList()).setSeqno(109325920L).build();
        ExecuteBatchDmlResponse actualResponse = this.client.executeBatchDml(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ExecuteBatchDmlRequest actualRequest = (ExecuteBatchDmlRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getSession(), (Object)actualRequest.getSession());
        Assert.assertEquals((Object)request.getTransaction(), (Object)actualRequest.getTransaction());
        Assert.assertEquals((Object)request.getStatementsList(), (Object)actualRequest.getStatementsList());
        Assert.assertEquals((long)request.getSeqno(), (long)actualRequest.getSeqno());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void executeBatchDmlExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            ExecuteBatchDmlRequest request = ExecuteBatchDmlRequest.newBuilder().setSession(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).setTransaction(TransactionSelector.newBuilder().build()).addAllStatements(new ArrayList()).setSeqno(109325920L).build();
            this.client.executeBatchDml(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void readTest() throws Exception {
        ResultSet expectedResponse = ResultSet.newBuilder().setMetadata(ResultSetMetadata.newBuilder().build()).addAllRows(new ArrayList()).setStats(ResultSetStats.newBuilder().build()).build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        ReadRequest request = ReadRequest.newBuilder().setSession(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).setTransaction(TransactionSelector.newBuilder().build()).setTable("table110115790").setIndex("index100346066").addAllColumns(new ArrayList()).setKeySet(KeySet.newBuilder().build()).setLimit(102976443L).setResumeToken(ByteString.EMPTY).setPartitionToken(ByteString.EMPTY).build();
        ResultSet actualResponse = this.client.read(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ReadRequest actualRequest = (ReadRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getSession(), (Object)actualRequest.getSession());
        Assert.assertEquals((Object)request.getTransaction(), (Object)actualRequest.getTransaction());
        Assert.assertEquals((Object)request.getTable(), (Object)actualRequest.getTable());
        Assert.assertEquals((Object)request.getIndex(), (Object)actualRequest.getIndex());
        Assert.assertEquals((Object)request.getColumnsList(), (Object)actualRequest.getColumnsList());
        Assert.assertEquals((Object)request.getKeySet(), (Object)actualRequest.getKeySet());
        Assert.assertEquals((long)request.getLimit(), (long)actualRequest.getLimit());
        Assert.assertEquals((Object)request.getResumeToken(), (Object)actualRequest.getResumeToken());
        Assert.assertEquals((Object)request.getPartitionToken(), (Object)actualRequest.getPartitionToken());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void readExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            ReadRequest request = ReadRequest.newBuilder().setSession(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).setTransaction(TransactionSelector.newBuilder().build()).setTable("table110115790").setIndex("index100346066").addAllColumns(new ArrayList()).setKeySet(KeySet.newBuilder().build()).setLimit(102976443L).setResumeToken(ByteString.EMPTY).setPartitionToken(ByteString.EMPTY).build();
            this.client.read(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void streamingReadTest() throws Exception {
        PartialResultSet expectedResponse = PartialResultSet.newBuilder().setMetadata(ResultSetMetadata.newBuilder().build()).addAllValues(new ArrayList()).setChunkedValue(true).setResumeToken(ByteString.EMPTY).setStats(ResultSetStats.newBuilder().build()).build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        ReadRequest request = ReadRequest.newBuilder().setSession(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).setTransaction(TransactionSelector.newBuilder().build()).setTable("table110115790").setIndex("index100346066").addAllColumns(new ArrayList()).setKeySet(KeySet.newBuilder().build()).setLimit(102976443L).setResumeToken(ByteString.EMPTY).setPartitionToken(ByteString.EMPTY).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.streamingReadCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        List actualResponses = (List)responseObserver.future().get();
        Assert.assertEquals((long)1L, (long)actualResponses.size());
        Assert.assertEquals((Object)expectedResponse, actualResponses.get(0));
    }

    @Test
    public void streamingReadExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        ReadRequest request = ReadRequest.newBuilder().setSession(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).setTransaction(TransactionSelector.newBuilder().build()).setTable("table110115790").setIndex("index100346066").addAllColumns(new ArrayList()).setKeySet(KeySet.newBuilder().build()).setLimit(102976443L).setResumeToken(ByteString.EMPTY).setPartitionToken(ByteString.EMPTY).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.streamingReadCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        try {
            List actualResponses = (List)responseObserver.future().get();
            Assert.fail((String)"No exception thrown");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidArgumentException));
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void beginTransactionTest() throws Exception {
        Transaction expectedResponse = Transaction.newBuilder().setId(ByteString.EMPTY).setReadTimestamp(Timestamp.newBuilder().build()).build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        SessionName session = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
        TransactionOptions options = TransactionOptions.newBuilder().build();
        Transaction actualResponse = this.client.beginTransaction(session, options);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BeginTransactionRequest actualRequest = (BeginTransactionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)session.toString(), (Object)actualRequest.getSession());
        Assert.assertEquals((Object)options, (Object)actualRequest.getOptions());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void beginTransactionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            SessionName session = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
            TransactionOptions options = TransactionOptions.newBuilder().build();
            this.client.beginTransaction(session, options);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void beginTransactionTest2() throws Exception {
        Transaction expectedResponse = Transaction.newBuilder().setId(ByteString.EMPTY).setReadTimestamp(Timestamp.newBuilder().build()).build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        String session = "session1984987798";
        TransactionOptions options = TransactionOptions.newBuilder().build();
        Transaction actualResponse = this.client.beginTransaction(session, options);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BeginTransactionRequest actualRequest = (BeginTransactionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)session, (Object)actualRequest.getSession());
        Assert.assertEquals((Object)options, (Object)actualRequest.getOptions());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void beginTransactionExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            String session = "session1984987798";
            TransactionOptions options = TransactionOptions.newBuilder().build();
            this.client.beginTransaction(session, options);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void commitTest() throws Exception {
        CommitResponse expectedResponse = CommitResponse.newBuilder().setCommitTimestamp(Timestamp.newBuilder().build()).setCommitStats(CommitResponse.CommitStats.newBuilder().build()).build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        SessionName session = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
        ByteString transactionId = ByteString.EMPTY;
        ArrayList mutations = new ArrayList();
        CommitResponse actualResponse = this.client.commit(session, transactionId, mutations);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CommitRequest actualRequest = (CommitRequest)actualRequests.get(0);
        Assert.assertEquals((Object)session.toString(), (Object)actualRequest.getSession());
        Assert.assertEquals((Object)transactionId, (Object)actualRequest.getTransactionId());
        Assert.assertEquals(mutations, (Object)actualRequest.getMutationsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void commitExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            SessionName session = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
            ByteString transactionId = ByteString.EMPTY;
            ArrayList mutations = new ArrayList();
            this.client.commit(session, transactionId, mutations);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void commitTest2() throws Exception {
        CommitResponse expectedResponse = CommitResponse.newBuilder().setCommitTimestamp(Timestamp.newBuilder().build()).setCommitStats(CommitResponse.CommitStats.newBuilder().build()).build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        SessionName session = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
        TransactionOptions singleUseTransaction = TransactionOptions.newBuilder().build();
        ArrayList mutations = new ArrayList();
        CommitResponse actualResponse = this.client.commit(session, singleUseTransaction, mutations);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CommitRequest actualRequest = (CommitRequest)actualRequests.get(0);
        Assert.assertEquals((Object)session.toString(), (Object)actualRequest.getSession());
        Assert.assertEquals((Object)singleUseTransaction, (Object)actualRequest.getSingleUseTransaction());
        Assert.assertEquals(mutations, (Object)actualRequest.getMutationsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void commitExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            SessionName session = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
            TransactionOptions singleUseTransaction = TransactionOptions.newBuilder().build();
            ArrayList mutations = new ArrayList();
            this.client.commit(session, singleUseTransaction, mutations);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void commitTest3() throws Exception {
        CommitResponse expectedResponse = CommitResponse.newBuilder().setCommitTimestamp(Timestamp.newBuilder().build()).setCommitStats(CommitResponse.CommitStats.newBuilder().build()).build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        String session = "session1984987798";
        ByteString transactionId = ByteString.EMPTY;
        ArrayList mutations = new ArrayList();
        CommitResponse actualResponse = this.client.commit(session, transactionId, mutations);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CommitRequest actualRequest = (CommitRequest)actualRequests.get(0);
        Assert.assertEquals((Object)session, (Object)actualRequest.getSession());
        Assert.assertEquals((Object)transactionId, (Object)actualRequest.getTransactionId());
        Assert.assertEquals(mutations, (Object)actualRequest.getMutationsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void commitExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            String session = "session1984987798";
            ByteString transactionId = ByteString.EMPTY;
            ArrayList mutations = new ArrayList();
            this.client.commit(session, transactionId, mutations);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void commitTest4() throws Exception {
        CommitResponse expectedResponse = CommitResponse.newBuilder().setCommitTimestamp(Timestamp.newBuilder().build()).setCommitStats(CommitResponse.CommitStats.newBuilder().build()).build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        String session = "session1984987798";
        TransactionOptions singleUseTransaction = TransactionOptions.newBuilder().build();
        ArrayList mutations = new ArrayList();
        CommitResponse actualResponse = this.client.commit(session, singleUseTransaction, mutations);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CommitRequest actualRequest = (CommitRequest)actualRequests.get(0);
        Assert.assertEquals((Object)session, (Object)actualRequest.getSession());
        Assert.assertEquals((Object)singleUseTransaction, (Object)actualRequest.getSingleUseTransaction());
        Assert.assertEquals(mutations, (Object)actualRequest.getMutationsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void commitExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            String session = "session1984987798";
            TransactionOptions singleUseTransaction = TransactionOptions.newBuilder().build();
            ArrayList mutations = new ArrayList();
            this.client.commit(session, singleUseTransaction, mutations);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void rollbackTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        SessionName session = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
        ByteString transactionId = ByteString.EMPTY;
        this.client.rollback(session, transactionId);
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RollbackRequest actualRequest = (RollbackRequest)actualRequests.get(0);
        Assert.assertEquals((Object)session.toString(), (Object)actualRequest.getSession());
        Assert.assertEquals((Object)transactionId, (Object)actualRequest.getTransactionId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void rollbackExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            SessionName session = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
            ByteString transactionId = ByteString.EMPTY;
            this.client.rollback(session, transactionId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void rollbackTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        String session = "session1984987798";
        ByteString transactionId = ByteString.EMPTY;
        this.client.rollback(session, transactionId);
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RollbackRequest actualRequest = (RollbackRequest)actualRequests.get(0);
        Assert.assertEquals((Object)session, (Object)actualRequest.getSession());
        Assert.assertEquals((Object)transactionId, (Object)actualRequest.getTransactionId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void rollbackExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            String session = "session1984987798";
            ByteString transactionId = ByteString.EMPTY;
            this.client.rollback(session, transactionId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void partitionQueryTest() throws Exception {
        PartitionResponse expectedResponse = PartitionResponse.newBuilder().addAllPartitions(new ArrayList()).setTransaction(Transaction.newBuilder().build()).build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        PartitionQueryRequest request = PartitionQueryRequest.newBuilder().setSession(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).setTransaction(TransactionSelector.newBuilder().build()).setSql("sql114126").setParams(Struct.newBuilder().build()).putAllParamTypes(new HashMap()).setPartitionOptions(PartitionOptions.newBuilder().build()).build();
        PartitionResponse actualResponse = this.client.partitionQuery(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        PartitionQueryRequest actualRequest = (PartitionQueryRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getSession(), (Object)actualRequest.getSession());
        Assert.assertEquals((Object)request.getTransaction(), (Object)actualRequest.getTransaction());
        Assert.assertEquals((Object)request.getSql(), (Object)actualRequest.getSql());
        Assert.assertEquals((Object)request.getParams(), (Object)actualRequest.getParams());
        Assert.assertEquals((Object)request.getParamTypesMap(), (Object)actualRequest.getParamTypesMap());
        Assert.assertEquals((Object)request.getPartitionOptions(), (Object)actualRequest.getPartitionOptions());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void partitionQueryExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            PartitionQueryRequest request = PartitionQueryRequest.newBuilder().setSession(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).setTransaction(TransactionSelector.newBuilder().build()).setSql("sql114126").setParams(Struct.newBuilder().build()).putAllParamTypes(new HashMap()).setPartitionOptions(PartitionOptions.newBuilder().build()).build();
            this.client.partitionQuery(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void partitionReadTest() throws Exception {
        PartitionResponse expectedResponse = PartitionResponse.newBuilder().addAllPartitions(new ArrayList()).setTransaction(Transaction.newBuilder().build()).build();
        mockSpanner.addResponse((AbstractMessage)expectedResponse);
        PartitionReadRequest request = PartitionReadRequest.newBuilder().setSession(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).setTransaction(TransactionSelector.newBuilder().build()).setTable("table110115790").setIndex("index100346066").addAllColumns(new ArrayList()).setKeySet(KeySet.newBuilder().build()).setPartitionOptions(PartitionOptions.newBuilder().build()).build();
        PartitionResponse actualResponse = this.client.partitionRead(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSpanner.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        PartitionReadRequest actualRequest = (PartitionReadRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getSession(), (Object)actualRequest.getSession());
        Assert.assertEquals((Object)request.getTransaction(), (Object)actualRequest.getTransaction());
        Assert.assertEquals((Object)request.getTable(), (Object)actualRequest.getTable());
        Assert.assertEquals((Object)request.getIndex(), (Object)actualRequest.getIndex());
        Assert.assertEquals((Object)request.getColumnsList(), (Object)actualRequest.getColumnsList());
        Assert.assertEquals((Object)request.getKeySet(), (Object)actualRequest.getKeySet());
        Assert.assertEquals((Object)request.getPartitionOptions(), (Object)actualRequest.getPartitionOptions());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void partitionReadExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSpanner.addException((Exception)((Object)exception));
        try {
            PartitionReadRequest request = PartitionReadRequest.newBuilder().setSession(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).setTransaction(TransactionSelector.newBuilder().build()).setTable("table110115790").setIndex("index100346066").addAllColumns(new ArrayList()).setKeySet(KeySet.newBuilder().build()).setPartitionOptions(PartitionOptions.newBuilder().build()).build();
            this.client.partitionRead(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

